/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.isc.iscb.formplugin.util.OpenApiServiceUtil;
import kd.isc.iscb.platform.core.api.ApiUtil;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.connector.server.ConnectorCallback;
import kd.isc.iscb.util.misc.NetUtil;

public class ApiTestFormUtil {
    private static final String APP_ISCB = "/kapi/app/iscb/";
    private static final String APP_ISCB_VERSION2 = "/kapi/v2/iscb/route/";

    public static void openTestForm(IFormView view, DynamicObject api, String prefix, Map<String, Object> inputs, DynamicObject link) {
        FormShowParameter p = new FormShowParameter();
        p.setFormId("isc_api_test");
        Map<String, Object> params = ApiTestFormUtil.buildTestParams(api, inputs, prefix, link);
        p.setCustomParams(params);
        p.setCaption(ResManager.loadKDString((String)"API\u6d4b\u8bd5", (String)"ApiTestFormUtil_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        p.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(p);
    }

    private static Map<String, Object> buildTestParams(DynamicObject api, Map<String, Object> inputs, String prefix, DynamicObject link) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", api.getString("name"));
        String param = JSON.toJSONString(inputs, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    ");
        params.put("param", param);
        params.put("url", ApiTestFormUtil.getFullUrl(api, prefix));
        params.put("link_id", link.getPkValue());
        params.put("url_editable", api.get("auth_required"));
        params.put("not_publish", api.getBoolean("not_publish"));
        params.put("isVersion2", ApiUtil.isVersion2Api((DynamicObject)api));
        params.put("apiEntityType", api.getDataEntityType().getName());
        params.put("apiPkValue", api.getPkValue());
        params.put("apiNumber", api.getString("number"));
        return params;
    }

    private static String getFullUrl(DynamicObject api, String prefix) {
        String relativePath = ApiUtil.isVersion2Api((DynamicObject)api) ? APP_ISCB_VERSION2 : APP_ISCB;
        String urlStart = UrlService.getDomainContextUrl().replace("localhost", NetUtil.getLocalAddress());
        String url = OpenApiServiceUtil.formatUrl(urlStart) + relativePath + prefix + api.getString("number");
        if (api.getBoolean("auth_required")) {
            url = url + (url.contains("?") ? "&" : "?") + "caller=";
        }
        return url;
    }

    public static String getAccessToken(DynamicObject link) {
        String userId = RequestContext.get().getUserId();
        DynamicObject user = BusinessDataServiceHelper.loadHead((Object)userId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_user"));
        Map loginInfo = ConnectorUtil.getThirdLoginInfo((DynamicObject)link, (DynamicObject)user);
        loginInfo.put("ierp_server_url", UrlService.getDomainContextUrl());
        ConnectorCallback.clearTokenCache();
        return ConnectorCallback.getAccessToken((Map)loginInfo);
    }
}

