/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.hub.HubTriggerEventChecker;
import kd.isc.iscb.formplugin.mq.AbstractMqFormPlugin;
import kd.isc.iscb.formplugin.util.DataSchemaUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ScriptCommonUtil;
import kd.isc.iscb.platform.core.api.ApiEventTriggerUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class CallApiByEvtFormPlugin
extends AbstractMqFormPlugin
implements CellClickListener {
    private static final String REMARK = "remark";
    private static final String META_NUMBER = "isc_call_api_by_evt";
    private static final String AUTO_FILL = "auto_fill";
    private static final String SELECTORS = "selectors";
    private static final String METASCHEMA = "metaschema";
    private static final String METASCHEMA_ID = "metaschema_id";
    private static final String FIELD = "field";
    private static final String DESCRIPTION = "description";
    private static final String DATA_TYPE = "data_type";
    private static final String EVENTS = "events";
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final int TIMEOUT = 5000;
    private static final String BATCH_ADD = "batch_add";
    private static final String PROPROW = "$row";
    private static final String PROPTYPE = "$type";
    private static final String OPERATION = "operation";
    private static final String FULL_NUMBER = "full_number";
    private static final String NAME = "name";
    private static final String EDIT_SCRIPT_BTN = "edit_script_btn";
    private static final String FORMAT_SCRIPT = "format_script";
    private static final String FORMAT_SCRIPT_TAG = "format_script_tag";

    @Override
    public void click(EventObject evt) {
        Control srcControl;
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Control && EDIT_SCRIPT_BTN.equals((srcControl = (Control)src).getKey())) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(REMARK, this.getModel().getValue(FORMAT_SCRIPT));
            params.put("script", this.getModel().getValue(FORMAT_SCRIPT_TAG));
            params.put(FIELD, FORMAT_SCRIPT);
            params.put("plugin_name", this.getView().getEntityId());
            params.put("id", this.getView().getModel().getValue("id"));
            ScriptCommonUtil.showEditor(this, ResManager.loadKDString((String)"\u811a\u672c\u7f16\u8f91", (String)"CallApiByEvtFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "get_evt_script");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long id = D.l((Object)this.getModel().getValue(METASCHEMA_ID));
        this.initEventCombo(id);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{EDIT_SCRIPT_BTN});
        EntryGrid selectors = (EntryGrid)this.getView().getControl(SELECTORS);
        selectors.addCellClickListener((CellClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        try {
            if ("save".equalsIgnoreCase(operationKey)) {
                if (!this.checkEnable(META_NUMBER, args)) {
                    HubTriggerEventChecker.checkActions(this.getView(), args, D.l((Object)this.getModel().getValue(METASCHEMA_ID)), this.getModel().getValue(EVENTS));
                }
            } else if ("enable".equalsIgnoreCase(operationKey) || "disable".equalsIgnoreCase(operationKey)) {
                long id = D.l((Object)this.getModel().getValue("id"));
                if (id <= 0L) {
                    throw new IscBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e", (String)"CallApiByEvtFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
                this.handleAttachOrDetachEvents(operationKey, id);
            }
        }
        catch (Exception e) {
            args.setCancel(true);
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void handleAttachOrDetachEvents(String operationKey, long id) {
        if ("enable".equalsIgnoreCase(operationKey)) {
            DynamicObject apiEvtTrigger = BusinessDataServiceHelper.loadSingle((Object)id, (String)META_NUMBER);
            ApiEventTriggerUtil.attachEvents((DynamicObject)apiEvtTrigger);
        } else if ("disable".equalsIgnoreCase(operationKey)) {
            DynamicObject apiEvtTrigger = BusinessDataServiceHelper.loadSingle((Object)id, (String)META_NUMBER);
            ApiEventTriggerUtil.detachEvents((DynamicObject)apiEvtTrigger);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals(METASCHEMA)) {
            long id = D.l((Object)this.getModel().getValue(METASCHEMA_ID));
            this.initEventCombo(id);
        } else if (name.equals(FIELD) && (changeSet = e.getChangeSet()).length == 1) {
            DynamicObject row = this.getModel().getEntryRowEntity(SELECTORS, changeSet[0].getRowIndex());
            if (D.s((Object)changeSet[0].getNewValue()) == null) {
                row.set(DESCRIPTION, null);
                row.set(DATA_TYPE, null);
                this.getView().updateView(SELECTORS);
            }
        }
    }

    private void initEventCombo(long metaSchemaId) {
        if (metaSchemaId != 0L) {
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metaSchemaId, (String)ISC_METADATA_SCHEMA);
            ComboEdit eventCombo = (ComboEdit)this.getView().getControl(EVENTS);
            eventCombo.setComboItems(this.getEventComboItems(meta));
        }
    }

    private List<ComboItem> getEventComboItems(DynamicObject meta) {
        DynamicObjectCollection events = meta.getDynamicObjectCollection("event_entryentity");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(events.size());
        for (DynamicObject event : events) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(event.getString("event_label") + '(' + event.getString("event_number") + ')'));
            item.setValue(event.getString("event_number"));
            items.add(item);
        }
        return items;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        try {
            if (evt.getOperateKey().equals(AUTO_FILL)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(AUTO_FILL, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u81ea\u52a8\u586b\u5145\u4f1a\u6e05\u9664\u5df2\u6709\u5b57\u6bb5\uff0c\u662f\u5426\u786e\u8ba4\u6267\u884c\uff1f", (String)"CallApiByEvtFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if (result == MessageBoxResult.Yes && AUTO_FILL.equals(event.getCallBackId())) {
            long metaId = D.l((Object)this.getModel().getValue(METASCHEMA_ID));
            if (metaId != 0L) {
                DynamicObjectCollection selectors = this.getModel().getDataEntity(true).getDynamicObjectCollection(SELECTORS);
                selectors.clear();
                List<Map<String, Object>> fields = DataSchemaUtil.getAllFields(metaId);
                this.resetEntry(fields, selectors);
                this.getView().updateView(SELECTORS);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6e90\u96c6\u6210\u5bf9\u8c61!", (String)"CallApiByEvtFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void resetEntry(List<Map<String, Object>> flatData, DynamicObjectCollection entries) {
        for (Map<String, Object> data : flatData) {
            DynamicObject object = entries.addNew();
            object.set(FIELD, data.get(FIELD));
            object.set(DATA_TYPE, data.get(DATA_TYPE));
            object.set(DESCRIPTION, data.get(DESCRIPTION));
        }
    }

    @Override
    protected void disableStatus(DynamicObject entity) {
        ApiEventTriggerUtil.detachEvents((DynamicObject)entity);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        long metaSchemaId = this.getModel().getDataEntity().getLong(METASCHEMA_ID);
        if (metaSchemaId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u5bf9\u8c61", (String)"CallApiByEvtFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        String fieldKey = cellClickEvent.getFieldKey();
        if (FIELD.equals(fieldKey)) {
            this.openPropertyWin(cellClickEvent, metaSchemaId, fieldKey);
        }
    }

    private void openPropertyWin(CellClickEvent cellClickEvent, long metaSchemaId, String fieldKey) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", metaSchemaId);
        param.put(PROPROW, cellClickEvent.getRow());
        if (FIELD.equals(fieldKey)) {
            param.put(OPERATION, BATCH_ADD);
            param.put(PROPTYPE, FIELD);
            FormOpener.showForm(this, "isc_meta_property_tree", ResManager.loadKDString((String)"\u9009\u62e9\u5bf9\u8c61\u5c5e\u6027", (String)"CallApiByEvtFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "get_property");
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map params;
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        if (action.equals("get_property")) {
            Object returnData = closedCallBackEvent.getReturnData();
            this.setSelectors(returnData);
        } else if ("get_evt_script".equals(closedCallBackEvent.getActionId()) && (params = (Map)closedCallBackEvent.getReturnData()) != null) {
            if ("new_tab".equals(params.get("operate"))) {
                String caption = (String)params.get("caption");
                String actionId = (String)params.get("actionId");
                ScriptCommonUtil.showTabEditor(this, caption, params, actionId);
            } else {
                this.getModel().setValue(FORMAT_SCRIPT, params.get(REMARK));
                this.getModel().setValue(FORMAT_SCRIPT_TAG, params.get("script"));
                this.getView().updateView(FORMAT_SCRIPT);
                this.getView().updateView(FORMAT_SCRIPT_TAG);
            }
        }
    }

    private void setSelectors(Object returnData) {
        if (returnData instanceof List) {
            DynamicObjectCollection selectors = this.getModel().getDataEntity(true).getDynamicObjectCollection(SELECTORS);
            List dataList = (List)returnData;
            if (dataList.size() > 0) {
                this.updateSelectorEntryByDataList(selectors, dataList);
                this.getView().updateView(SELECTORS);
            }
        }
    }

    private void updateSelectorEntryByDataList(DynamicObjectCollection selectors, List<Map<String, Object>> dataList) {
        Object rowValue = dataList.get(0).get(PROPROW);
        if (rowValue != null) {
            int index = D.i((Object)rowValue);
            Set<String> fieldSet = this.getExistedFieldSet(selectors);
            if (dataList.size() == 1) {
                this.updateOneRecord(dataList, index, fieldSet);
            } else {
                DynamicObject entry = this.getModel().getEntryRowEntity(SELECTORS, index);
                if (StringUtil.isEmpty((String)entry.getString(FIELD))) {
                    selectors.remove(index);
                }
                this.updateSelectors(selectors, dataList, fieldSet);
            }
        }
    }

    private void updateOneRecord(List<Map<String, Object>> dataList, int index, Set<String> fieldSet) {
        Map<String, Object> dataMap = dataList.get(0);
        Object field = dataMap.get(FULL_NUMBER);
        if (!fieldSet.contains(field)) {
            DynamicObject entry = this.getModel().getEntryRowEntity(SELECTORS, index);
            entry.set(FIELD, field);
            entry.set(DATA_TYPE, dataMap.get(DATA_TYPE));
            entry.set(DESCRIPTION, dataMap.get(NAME));
        } else {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u5df2\u5b58\u5728\uff01", (String)"CallApiByEvtFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), field));
        }
    }

    private void updateSelectors(DynamicObjectCollection selectors, List<Map<String, Object>> dataList, Set<String> fieldSet) {
        for (Map<String, Object> dataMap : dataList) {
            Object field = dataMap.get(FULL_NUMBER);
            if (fieldSet.contains(field)) continue;
            DynamicObject entry = selectors.addNew();
            entry.set(FIELD, field);
            entry.set(DATA_TYPE, dataMap.get(DATA_TYPE));
            entry.set(DESCRIPTION, dataMap.get(NAME));
        }
    }

    private Set<String> getExistedFieldSet(DynamicObjectCollection selectors) {
        HashSet<String> fieldSet = new HashSet<String>();
        for (DynamicObject selector : selectors) {
            String field = D.s((Object)selector.get(FIELD));
            if (field == null) continue;
            fieldSet.add(field);
        }
        return fieldSet;
    }
}

