/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.sql.Timestamp;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.isc.iscb.formplugin.mq.AbstractMqFormPlugin;
import kd.isc.iscb.formplugin.util.ArtificialF7Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ScriptCommonUtil;
import kd.isc.iscb.platform.core.api.ApiTimerTriggerUtil;
import kd.isc.iscb.platform.core.api.TimerParam;
import kd.isc.iscb.platform.core.dc.DataCopyTaskUtil;
import kd.isc.iscb.platform.core.util.TimerJobUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.feature.tool.date.TimeSpan;

public class CallApiByTimerFormPlugin
extends AbstractMqFormPlugin {
    private static final String END_TIME = "end_time";
    private static final String START_TIME = "start_time";
    private static final String CRON_EXPR = "cron_expr";
    private static final String REMARK = "remark";
    private static final String EDIT_SCRIPT_BTN = "edit_script_btn";
    private static final String FORMAT_SCRIPT = "format_script";
    private static final String FORMAT_SCRIPT_TAG = "format_script_tag";
    private static final String INTERVAL = "interval";
    private static final String EXE_JOB_USER = "exe_job_user";
    private static final String BOS_USER = "bos_user";
    private static final String USER_SELECT = "user_select";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{EDIT_SCRIPT_BTN, EXE_JOB_USER, CRON_EXPR});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setDataChanged(false);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("get_timer_script".equals(e.getActionId())) {
            Map params = (Map)e.getReturnData();
            if (params != null) {
                if ("new_tab".equals(params.get("operate"))) {
                    String caption = (String)params.get("caption");
                    String actionId = (String)params.get("actionId");
                    ScriptCommonUtil.showTabEditor(this, caption, params, actionId);
                } else {
                    this.getModel().setValue(FORMAT_SCRIPT, params.get(REMARK));
                    this.getModel().setValue(FORMAT_SCRIPT_TAG, params.get("script"));
                    this.getView().updateView();
                }
            }
        } else if (USER_SELECT.equals(e.getActionId())) {
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)e.getReturnData();
            ArtificialF7Util.setValue(this.getView(), lsrc, EXE_JOB_USER);
        } else if (CRON_EXPR.equals(e.getActionId())) {
            Object returnData = e.getReturnData();
            if (returnData == null) {
                return;
            }
            this.getModel().setValue(CRON_EXPR, ((Map)returnData).get(CRON_EXPR));
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Control) {
            Control srcControl = (Control)src;
            if (EDIT_SCRIPT_BTN.equals(srcControl.getKey())) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(REMARK, this.getModel().getValue(FORMAT_SCRIPT));
                params.put("script", this.getModel().getValue(FORMAT_SCRIPT_TAG));
                params.put("field", FORMAT_SCRIPT);
                params.put("plugin_name", this.getView().getEntityId());
                params.put("id", this.getView().getModel().getValue("id"));
                ScriptCommonUtil.showEditor(this, ResManager.loadKDString((String)"\u811a\u672c\u7f16\u8f91", (String)"CallApiByTimerFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "get_timer_script");
            } else if (EXE_JOB_USER.equals(srcControl.getKey())) {
                this.showPersonForm();
            } else if (CRON_EXPR.equals(srcControl.getKey())) {
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                params.put(CRON_EXPR, this.getModel().getValue(CRON_EXPR));
                params.put(END_TIME, D.t((Object)this.getModel().getValue(END_TIME)));
                params.put(START_TIME, D.t((Object)this.getModel().getValue(START_TIME)));
                FormOpener.showForm(this, "isc_cron_expression", "", params, CRON_EXPR);
            }
        }
    }

    private void showPersonForm() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)BOS_USER, (boolean)false, (int)0);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, USER_SELECT));
        String user = (String)this.getModel().getValue(EXE_JOB_USER);
        parameter.setSelectedRow((Object)TimerJobUtil.getUserIdByNumber((String)user));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        if (INTERVAL.equals(property.getName())) {
            String interval = (String)e.getChangeSet()[0].getNewValue();
            if (!"0".equals(interval)) {
                TimeSpan timeSpan = this.getTimeSpan();
                this.getModel().setValue(CRON_EXPR, (Object)DataCopyTaskUtil.buildCron((String)interval, (TimeSpan)timeSpan));
            }
            this.getView().setEnable(Boolean.valueOf("0".equals(interval)), new String[]{CRON_EXPR});
        }
    }

    private TimeSpan getTimeSpan() {
        Date start = (Date)this.getModel().getValue(START_TIME);
        if (start == null) {
            start = new Timestamp(System.currentTimeMillis() - 86400000L);
        }
        return DataCopyTaskUtil.getTimeSpan((long)start.getTime());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        try {
            if ("save".equalsIgnoreCase(operationKey)) {
                this.checkTimeField();
                this.checkEnable("isc_call_api_by_timer", args);
            } else if ("enable".equalsIgnoreCase(operationKey) || "disable".equalsIgnoreCase(operationKey)) {
                this.handleSchedule(operationKey);
            }
        }
        catch (Exception e) {
            args.setCancel(true);
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void checkTimeField() {
        Timestamp startTime = D.t((Object)this.getModel().getValue(START_TIME));
        Timestamp endTime = D.t((Object)this.getModel().getValue(END_TIME));
        if (endTime.before(startTime)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u8981\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4", (String)"CallApiByTimerFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void handleSchedule(String operationKey) {
        long id = D.l((Object)this.getModel().getValue("id"));
        if (id <= 0L) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e", (String)"CallApiByTimerFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        if ("enable".equalsIgnoreCase(operationKey)) {
            this.innerHandleEnable(id);
        } else {
            ApiTimerTriggerUtil.disableTrigger((String)D.s((Object)id));
        }
    }

    private void innerHandleEnable(long id) {
        Timestamp startTime = D.t((Object)this.getModel().getValue(START_TIME));
        Timestamp endTime = D.t((Object)this.getModel().getValue(END_TIME));
        String interval = D.s((Object)this.getModel().getValue(INTERVAL));
        String cronExpr = D.s((Object)this.getModel().getValue(CRON_EXPR));
        TimerParam timerParam = new TimerParam(cronExpr, startTime, endTime, interval);
        ApiTimerTriggerUtil.enableTrigger((String)D.s((Object)id), (String)D.s((Object)this.getModel().getValue("name")), (String)D.s((Object)this.getModel().getValue(EXE_JOB_USER)), (TimerParam)timerParam);
    }

    @Override
    protected void disableStatus(DynamicObject entity) {
        ApiTimerTriggerUtil.disableTrigger((String)D.s((Object)entity.getPkValue()));
    }
}

