/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.mvc.bill.BillView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.AbstractApiFormPlugin;
import kd.isc.iscb.formplugin.apic.DataCopySchemaAPIFormPlugin;
import kd.isc.iscb.formplugin.apic.Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.cache.data.DataCopyTrigger;
import kd.isc.iscb.platform.core.connector.apic.doc.ExportDocForDataCopyTriggerAPI;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportTriggerApiToXml;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.platform.core.util.DataTypeUtil;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.dt.D;

public class DataCopyTriggerAPIFormPlugin
extends AbstractApiFormPlugin {
    private static final String GEN_PDF = "gen_pdf";
    private static final String EXECUTION_TYPE = "execution_type";
    private static final String API_TEST = "api_test";
    private static final String PARAM_VIEW = "param_example";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{API_TEST});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (!"trigger".equals(property) && !EXECUTION_TYPE.equals(property)) {
            return;
        }
        long triggerId = D.l((Object)this.getModel().getValue("trigger_id"));
        Object type = this.getModel().getValue(EXECUTION_TYPE);
        if (type != null) {
            type = "_" + type;
        }
        if (triggerId > 0L) {
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_data_copy_trigger", (String)"data_copy");
            this.getModel().setValue("data_copy", trigger.get("data_copy_id"));
            DynamicObject dataCopy = BusinessDataServiceHelper.loadSingle((Object)trigger.get("data_copy_id"), (String)"isc_data_copy", (String)"data_source");
            this.getModel().setValue("group", dataCopy.get("data_source_id"));
            if (type != null) {
                this.getModel().setValue("number", (Object)(trigger.getString("number").replaceAll("[^0-9a-zA-Z_-]", "_") + type));
                this.getModel().setValue("name", (Object)(trigger.getString("name") + type));
            }
            this.viewParamAndResult(D.l((Object)trigger.getPkValue()));
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        BillView source;
        BillShowParameter formShowParameter;
        BillOperationStatus billStatus;
        super.afterBindData(e);
        if (e.getSource() instanceof BillView && (billStatus = (formShowParameter = (BillShowParameter)(source = (BillView)e.getSource()).getFormShowParameter()).getBillStatus()) == BillOperationStatus.VIEW) {
            this.viewParams();
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            this.viewParams();
        }
    }

    private void viewParams() {
        DynamicObject trigger = (DynamicObject)this.getModel().getValue("trigger");
        if (trigger != null) {
            long id = D.l((Object)trigger.getPkValue());
            this.viewParamAndResult(id);
        }
    }

    private void viewParamAndResult(long schema_id) {
        if (schema_id > 0L) {
            String type = D.s((Object)this.getModel().getValue(EXECUTION_TYPE));
            DynamicObject dynamicObject = DataCopyTrigger.get((long)schema_id);
            DynamicObject schema = DataCopySchema.get((long)D.l((Object)dynamicObject.getDynamicObject("data_copy").getPkValue()));
            DynamicObject srcMeta = BusinessDataServiceHelper.loadSingle((Object)schema.getDynamicObject("source_schema").getPkValue(), (String)"isc_metadata_schema");
            DynamicObjectCollection param_entity = this.getModel().getDataEntity().getDynamicObjectCollection("param_entryentity");
            if ("EXECUTE".equals(type)) {
                this.setExecuteParams(dynamicObject, param_entity);
            } else if (DataCopySchemaAPIFormPlugin.setParams(type, schema, srcMeta, param_entity)) {
                return;
            }
            this.getModel().getDataEntity(true).set("param_entryentity", (Object)param_entity);
            this.getView().updateView("param_entryentity");
            DynamicObjectCollection result_entity = this.getModel().getDataEntity().getDynamicObjectCollection("result_entryentity");
            result_entity.clear();
            this.fullResult(result_entity, "data", ResManager.loadKDString((String)"\u4efb\u52a1ID", (String)"DataCopyTriggerAPIFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getModel().getDataEntity(true).set("result_entryentity", (Object)result_entity);
            this.getView().updateView("result_entryentity");
            DynamicObject api = this.getModel().getDataEntity();
            String res = Util.getJson(api, type, schema, 1L);
            Markdown mk = (Markdown)this.getView().getControl("json_expr");
            mk.setText("```json \n" + res + " \n");
        }
    }

    private void setExecuteParams(DynamicObject dynamicObject, DynamicObjectCollection param_entity) {
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("params_entryentity");
        if (collection.size() > 0) {
            param_entity.clear();
            for (DynamicObject object : collection) {
                DynamicObject aNew = param_entity.addNew();
                aNew.set("param_field", object.get("params_name"));
                aNew.set("param_type", (Object)ApiToXmlUtil.translateType((String)D.s((Object)object.get("params_data_type"))));
                aNew.set("param_remark", object.get("params_remark"));
            }
        }
    }

    private void fullResult(DynamicObjectCollection result_entity, String field, String content) {
        DynamicObject aNew = result_entity.addNew();
        aNew.set("res_field", (Object)field);
        aNew.set("res_remark", (Object)content);
    }

    @Override
    protected Map<String, Object> getTestInputParams(DynamicObject api) {
        String type = api.getString(EXECUTION_TYPE);
        if ("EXECUTE".equals(type)) {
            DynamicObject dynamicObject = DataCopyTrigger.get((long)D.l((Object)api.get("trigger_id")));
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("params_entryentity");
            HashMap<String, Object> map = new HashMap<String, Object>(collection.size());
            for (DynamicObject object : collection) {
                map.put(object.getString("params_name"), DataTypeUtil.getDefaultValue((String)object.getString("params_data_type")));
            }
            return map;
        }
        DynamicObject dataCopy = BusinessDataServiceHelper.loadSingle((Object)api.get("data_copy_id"), (String)"isc_data_copy");
        return Util.getDataCopyInputParams(type, dataCopy);
    }

    @Override
    protected void generateXml(List<Object> successPkIds, IFormView view) {
        DynamicObject[] triggerApis;
        for (DynamicObject api : triggerApis = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"isc_apic_by_dc_trigger"))) {
            try {
                new ExportTriggerApiToXml(api).export(view);
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }

    @Override
    protected void generatePdf(List<Object> successPkIds, IFormView view) {
        DynamicObject[] triggerApis;
        for (DynamicObject triggerApi : triggerApis = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"isc_apic_by_dc_trigger"))) {
            try {
                String filePath = ExportDocForDataCopyTriggerAPI.generateDoc((DynamicObject)triggerApi);
                ExportAndImportFormUtil.download((IFormView)view, (String)filePath, (String)(ExportAndImportFormUtil.getDownloadFileName((DynamicObject)triggerApi) + ".pdf"));
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }
}

