/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.AbstractApiFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.api.parsers.model.ApiModel;
import kd.isc.iscb.platform.core.api.parsers.model.ApiParam;
import kd.isc.iscb.platform.core.apic.ExternalApiMeta;
import kd.isc.iscb.platform.core.apic.IscApicUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportExternalApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.external.CommonApiDocBuilder;
import kd.isc.iscb.platform.core.connector.apic.doc.external.ExportExternalApiDocUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.external.Pdf;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.dt.D;

public class ExternalApiFormPlugin
extends AbstractApiFormPlugin {
    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDataByOperInfo();
        if (D.l((Object)this.getModel().getValue("id")) <= 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        }
        this.getModel().setValue("is_publish", (Object)(!this.getModel().getDataEntity().getBoolean("not_publish") ? 1 : 0));
    }

    private void initDataByOperInfo() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object apiModelString = formShowParameter.getCustomParam("apiModelString");
        if (apiModelString != null) {
            ApiModel apiModel = (ApiModel)JSON.parseObject((String)D.s((Object)apiModelString), ApiModel.class);
            DynamicObject obj = this.getModel().getDataEntity(true);
            obj.set("number", (Object)apiModel.getNumber());
            obj.set("name", (Object)apiModel.getName());
            obj.set("service", (Object)apiModel.getService());
            obj.set("description", (Object)apiModel.getDescription());
            obj.set("omit_empty_params", (Object)Boolean.TRUE);
            this.setInputEntries(apiModel, obj);
            this.setOutputEntries(apiModel, obj);
            formShowParameter.setCustomParam("apiModelString", null);
            this.getView().updateView();
        }
    }

    private void setOutputEntries(ApiModel apiModel, DynamicObject obj) {
        DynamicObjectCollection outputs = obj.getDynamicObjectCollection("outputs");
        outputs.clear();
        List outputApiParams = apiModel.getOutputs();
        this.innerSetOutputs("", outputs, outputApiParams);
        obj.set("outputs", (Object)outputs);
    }

    private void innerSetOutputs(String prefix, DynamicObjectCollection outputs, List<ApiParam> outputApiParams) {
        if (outputApiParams != null) {
            for (ApiParam outputApiParam : outputApiParams) {
                DynamicObject item = outputs.addNew();
                String fieldName = prefix + outputApiParam.getName();
                item.set("output_field", (Object)fieldName);
                item.set("output_data_type", (Object)outputApiParam.getIscFieldType().getTypeName());
                item.set("output_is_array", (Object)outputApiParam.isArray());
                item.set("output_description", (Object)outputApiParam.getDesc());
                if (outputApiParam.getChildParams() == null) continue;
                this.innerSetOutputs(fieldName + ".", outputs, outputApiParam.getChildParams());
            }
        }
    }

    private void setInputEntries(ApiModel apiModel, DynamicObject obj) {
        DynamicObjectCollection inputs = obj.getDynamicObjectCollection("inputs");
        inputs.clear();
        List inputApiParams = apiModel.getInputs();
        this.innerSetInputs("", inputs, inputApiParams);
        obj.set("inputs", (Object)inputs);
    }

    private void innerSetInputs(String prefix, DynamicObjectCollection inputs, List<ApiParam> inputApiParams) {
        if (inputApiParams != null) {
            for (ApiParam inputApiParam : inputApiParams) {
                DynamicObject item = inputs.addNew();
                String fieldName = prefix + inputApiParam.getName();
                item.set("input_field", (Object)fieldName);
                item.set("input_data_type", (Object)inputApiParam.getIscFieldType().getTypeName());
                item.set("input_is_array", (Object)inputApiParam.isArray());
                item.set("required", (Object)inputApiParam.isRequired());
                item.set("input_description", (Object)inputApiParam.getDesc());
                if (inputApiParam.getChildParams() == null) continue;
                this.innerSetInputs(fieldName + ".", inputs, inputApiParam.getChildParams());
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save) {
            DynamicObject tmp;
            try {
                tmp = BusinessDataServiceHelper.newDynamicObject((String)"isc_apic_script");
                tmp.set("inputs", (Object)this.getModel().getEntryEntity("inputs"));
                IscApicUtil.getInputSchema((DynamicObject)tmp);
            }
            catch (Exception err) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u5206\u5f55\u6821\u9a8c\u9519\u8bef\uff1a%s", (String)"ExternalApiFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), err.getMessage()));
                e.setCancel(true);
                return;
            }
            try {
                tmp = BusinessDataServiceHelper.newDynamicObject((String)"isc_apic_script");
                tmp.set("outputs", (Object)this.getModel().getEntryEntity("outputs"));
                IscApicUtil.getOutputSchema((DynamicObject)this.getModel().getDataEntity());
            }
            catch (Exception err) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u8f93\u51fa\u5206\u5f55\u6821\u9a8c\u9519\u8bef\uff1a%s", (String)"ExternalApiFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), err.getMessage()));
                e.setCancel(true);
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        this.afterDoOperationExt(evt);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        this.confirmCallBackExt(evt);
    }

    @Override
    protected Map<String, Object> getTestInputParams(DynamicObject api) {
        ExternalApiMeta meta = ExternalApiMeta.get((long)D.l((Object)api.getPkValue()));
        return CommonApiDocBuilder.getInstance().parseParam(meta.getInputs());
    }

    @Override
    protected void generateXml(List<Object> successPkIds, IFormView view) {
        DynamicObject[] externalApis;
        for (DynamicObject api : externalApis = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"isc_apic_for_external_api"))) {
            try {
                new ExportExternalApiToXml(api).export(view);
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }

    @Override
    protected void generatePdf(List<Object> successPkIds, IFormView view) {
        for (Object id : successPkIds) {
            try {
                Pdf pdf = ExportExternalApiDocUtil.generateExternalDoc((long)D.l((Object)id));
                DynamicObject api = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_apic_for_external_api");
                ExportAndImportFormUtil.download((IFormView)view, (String)pdf.getPath(), (String)(ExportAndImportFormUtil.getDownloadFileName((DynamicObject)api) + ".pdf"));
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }
}

