/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.AbstractApiFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.OpenApiServiceUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.ExportDocForMicroServiceAPI;
import kd.isc.iscb.platform.core.util.DataTypeUtil;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.dt.D;

public class MicroServiceApiFormPlugin
extends AbstractApiFormPlugin {
    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setValue("is_publish", (Object)(!this.getModel().getDataEntity().getBoolean("not_publish") ? 1 : 0));
    }

    @Override
    protected Map<String, Object> getTestInputParams(DynamicObject api) {
        return MicroServiceApiFormPlugin.getParams(api.getDynamicObjectCollection("inputs"));
    }

    private static Map<String, Object> getParams(DynamicObjectCollection inputs) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(inputs.size());
        for (DynamicObject input : inputs) {
            String field = D.s((Object)input.get("input_field"));
            String type = D.s((Object)input.get("input_data_type"));
            params.put(field, DataTypeUtil.getDefaultValue((String)type));
        }
        return params;
    }

    @Override
    protected void generateXml(List<Object> successPkIds, IFormView view) {
    }

    @Override
    protected void generatePdf(List<Object> successPkIds, IFormView view) {
        DynamicObject[] microServiceApis;
        for (DynamicObject microService : microServiceApis = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"isc_apic_mservice"))) {
            try {
                Assert.isTrue((boolean)OpenApiServiceUtil.isValid(microService.getString("number")), (String)OpenApiServiceUtil.getApiNumberPatternTips());
                String filePath = ExportDocForMicroServiceAPI.generateDoc((DynamicObject)microService);
                ExportAndImportFormUtil.download((IFormView)view, (String)filePath, (String)(ExportAndImportFormUtil.getDownloadFileName((DynamicObject)microService) + ".pdf"));
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }
}

