/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.apic.AbstractApiListPlugin;
import kd.isc.iscb.formplugin.apic.ApiRecordLog;
import kd.isc.iscb.formplugin.util.FormOpener;

public class ScriptApiListPlugin
extends AbstractApiListPlugin {
    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate && ("save".equals(operateKey = (operate = (AbstractOperate)source).getOperateKey()) || "enable".equals(operateKey) || "disable".equals(operateKey) || "delete".equals(operateKey))) {
            this.checkPreset(args);
        }
    }

    private void checkPreset(BeforeDoOperationEventArgs args) {
        Object[] primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues();
        DynamicObject[] scripts = BusinessDataServiceHelper.load((String)"isc_apic_script", (String)"preset", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues).and("preset", "=", (Object)"1")});
        if (scripts.length > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u542f\u7528/\u7981\u7528/\u5220\u9664\u64cd\u4f5c\u3002", (String)"ScriptApiListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if ("turn_on_logging".equals(operateKey)) {
            this.turnLoggingOnOrOff(evt, ApiRecordLog.TURN_ON);
        } else if ("turn_off_logging".equals(operateKey)) {
            this.turnLoggingOnOrOff(evt, ApiRecordLog.TURN_OFF);
        } else if ("import_by_wsdl_file".equalsIgnoreCase(operateKey)) {
            FormOpener.showForm((AbstractFormPlugin)this, "isc_import_wsdl", null, new HashMap<String, Object>(), null);
        } else if ("import_by_wsdl_url".equalsIgnoreCase(operateKey)) {
            FormOpener.showForm((AbstractFormPlugin)this, "isc_import_wsdl_url", null, new HashMap<String, Object>(), "receive_wsdl_data");
        }
    }

    private void turnLoggingOnOrOff(AfterDoOperationEventArgs evt, ApiRecordLog record) {
        List ids = evt.getOperationResult().getSuccessPkIds();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"isc_apic_script");
        QFilter filter = new QFilter("id", "in", (Object)ids).and("record_log", "!=", (Object)record.getCode());
        Map scriptMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)entityType, (QFilter[])new QFilter[]{filter});
        if (scriptMap.size() < 1) {
            return;
        }
        Collection scripts = scriptMap.values();
        for (DynamicObject script : scripts) {
            script.set("record_log", (Object)record.getCode());
            script.set("modifier", (Object)RequestContext.get().getCurrUserId());
            script.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        }
        SaveServiceHelper.update((DynamicObject[])scripts.toArray(new DynamicObject[0]));
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u8bb0\u5f55API\u8c03\u7528\u65e5\u5fd7\u5f00\u5173\uff1a\u5df2%s", (String)"ScriptApiListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), record.getName()));
    }

    @Override
    public void modifyCategory(AfterDoOperationEventArgs evt) {
        List successPkIds = evt.getOperationResult().getSuccessPkIds();
        QFilter filter = new QFilter("id", "in", (Object)successPkIds).and("preset", "=", (Object)"1");
        boolean exists = QueryServiceHelper.exists((String)"isc_apic_script", (QFilter[])new QFilter[]{filter});
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u4e2d\u5305\u542b\u9884\u7f6e\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u5206\u7c7b\u64cd\u4f5c\u3002", (String)"ScriptApiListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            super.modifyCategory(evt);
        }
    }
}

