/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.AbstractApiFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.apic.doc.ExportDocForVCAPI;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportVCApiToXml;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.dt.D;

public class VCAPIFormPlugin
extends AbstractApiFormPlugin {
    private static final String ISC_VALUE_CONVER_RULE = "isc_value_conver_rule";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String BTN_API_TEST = "api_test";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_API_TEST});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String prop = e.getProperty().getName();
        long id = D.l((Object)this.getModel().getValue("value_conver_rule_id"));
        if (id != 0L && "value_conver_rule".equals(prop)) {
            DynamicObject vc = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_VALUE_CONVER_RULE, (String)"source_data_source");
            this.getModel().setValue("group", vc.get("source_data_source.id"));
            this.getModel().setValue(NUMBER, (Object)vc.getString(NUMBER).replaceAll("[^0-9a-zA-Z_-]", "_"));
            this.getModel().setValue(NAME, (Object)vc.getString(NAME));
        }
    }

    @Override
    protected Map<String, Object> getTestInputParams(DynamicObject api) {
        LinkedHashMap<String, Object> input = new LinkedHashMap<String, Object>();
        input.put(VALUE, api.get(VALUE));
        return input;
    }

    @Override
    protected void generateXml(List<Object> successPkIds, IFormView view) {
        DynamicObject[] vcApis;
        for (DynamicObject api : vcApis = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"isc_apic_by_vc"))) {
            try {
                new ExportVCApiToXml(api).export(view);
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }

    @Override
    protected void generatePdf(List<Object> successPkIds, IFormView view) {
        for (Object id : successPkIds) {
            DynamicObject vcApi = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_apic_by_vc");
            try {
                String filePath = ExportDocForVCAPI.generateDoc((DynamicObject)vcApi);
                ExportAndImportFormUtil.download((IFormView)view, (String)filePath, (String)(ExportAndImportFormUtil.getDownloadFileName((DynamicObject)vcApi) + ".pdf"));
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }
}

