/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic.webapi;

import com.alibaba.fastjson.JSON;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.container.Tab;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.apic.webapi.PostParamModel;
import kd.isc.iscb.formplugin.apic.webapi.ReqHandler;
import kd.isc.iscb.formplugin.apic.webapi.RespHandler;
import kd.isc.iscb.formplugin.apic.webapi.UrlParamHandler;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.api.quick.CurlGenerator;
import kd.isc.iscb.platform.core.api.quick.HttpItem;
import kd.isc.iscb.platform.core.api.quick.IscHttpFuncGenerator;
import kd.isc.iscb.platform.core.api.quick.UrlItem;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.platform.core.api.webapi.FormatType;
import kd.isc.iscb.platform.core.api.webapi.WebApi;
import kd.isc.iscb.platform.core.api.webapi.WebReqBody;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Json2;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class ApiPostFormPlugin
extends AbstractFormPlugin
implements Const {
    public static final String IS_SHOW_REQ_BODY_TEXT = "is_show_req_body_text";
    public static final String IS_SHOW_REQ_HEAD_TEXT = "is_show_req_head_text";
    public static final String IS_SHOW_REQ_URL_TEXT = "is_show_req_url_text";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String log = (String)this.getView().getFormShowParameter().getCustomParam("log");
        if (StringUtil.isEmpty((String)log)) {
            DynamicObjectCollection web_req_bodys = this.getModel().getDataEntity(true).getDynamicObjectCollection("web_req_header");
            web_req_bodys.clear();
            this.createContentTypeHeader(web_req_bodys, "application/json");
            this.activeReqHead();
        } else {
            this.restorePage(log);
            this.activeReqBody();
            this.activeRespScript();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void restorePage(String log) {
        Map logMap = (Map)Json.toObject((String)log);
        DataEntityPropertyCollection properties = this.getModel().getDataEntity().getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            Object prop_value = logMap.get(property.getName());
            if (property instanceof EntryProp) {
                DynamicObjectCollection objectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(property.getName());
                objectCollection.clear();
                ArrayList list = (ArrayList)prop_value;
                for (Map map : list) {
                    DynamicObject object = objectCollection.addNew();
                    for (IDataEntityProperty iDataEntityProperty : object.getDataEntityType().getProperties()) {
                        object.set(iDataEntityProperty.getName(), map.get(iDataEntityProperty.getName()));
                    }
                }
                continue;
            }
            this.getModel().setValue(property.getName(), prop_value);
        }
    }

    private void activeRespScript() {
        Tab tabCtrl = (Tab)this.getView().getControl("tabap");
        tabCtrl.activeTab("resp_script");
    }

    private void activeReqHead() {
        Tab tabCtrl = (Tab)this.getView().getControl("tabauth");
        tabCtrl.activeTab("req_head");
    }

    private void activeReqBody() {
        Tab tabCtrl = (Tab)this.getView().getControl("tabauth");
        tabCtrl.activeTab("req_body");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        String name = e.getProperty().getName();
        DynamicObject obj = this.getModel().getDataEntity(true);
        if ("body_type".equals(name) || "body_type_copy".equals(name)) {
            String newValue2 = D.s((Object)e.getChangeSet()[0].getNewValue());
            this.updateReqHeaderContentTypeValue(obj, newValue2);
            this.updateReqHeaderMultiLines(obj, newValue2);
            if ("none".equals(newValue2)) {
                this.clearReqBodyText();
                this.clearReqBody(obj);
                obj.set("is_multipart", (Object)false);
            }
            obj.set("body_type", (Object)newValue2);
            obj.set("body_type_copy", (Object)newValue2);
            this.getView().updateView("body_type");
            this.getView().updateView("body_type_copy");
        } else if ("method".equalsIgnoreCase(name)) {
            String newValue3 = D.s((Object)e.getChangeSet()[0].getNewValue());
            if ("GET".equalsIgnoreCase(newValue3)) {
                this.updateReqHeaderContentTypeValue(obj, "none");
                this.clearReqBody(obj);
                this.clearReqBodyText();
                this.getModel().setValue("body_type", (Object)"none");
                this.getModel().setValue("body_type_copy", (Object)"none");
            }
        } else if ("url".equalsIgnoreCase(name) && (newValue = D.s((Object)e.getChangeSet()[0].getNewValue())) != null && newValue.contains("?")) {
            obj.set("url", (Object)newValue.substring(0, newValue.indexOf("?")));
            UrlItem urlItem = new UrlItem(newValue);
            obj.set("web_url_params", (Object)UrlParamHandler.initParams(urlItem.getQueryParamMap(), obj));
            this.getView().updateView("web_url_params");
            this.getView().updateView("url");
        }
    }

    public void clearReqBody(DynamicObject obj) {
        DynamicObjectCollection collection = obj.getDynamicObjectCollection("web_req_body");
        collection.clear();
        this.getView().updateView("web_req_body");
    }

    public void updateReqHeaderMultiLines(DynamicObject obj, String newValue) {
        List<Map<String, String>> pairs = new PostParamModel(obj.getString("req_head_text")).getPairList();
        for (Map<String, String> pair : pairs) {
            for (Map.Entry<String, String> entry : pair.entrySet()) {
                if (!"Content-Type".equalsIgnoreCase(entry.getKey())) continue;
                pair.put(entry.getKey(), newValue);
            }
        }
        String headerString = PostParamModel.parseMutiLines(pairs);
        this.getModel().setValue("req_head_text", (Object)headerString);
    }

    public void updateReqHeaderContentTypeValue(DynamicObject obj, String newValue) {
        boolean isHasContentType = false;
        DynamicObjectCollection collection = obj.getDynamicObjectCollection("web_req_header");
        for (DynamicObject object : collection) {
            if (!"Content-Type".equalsIgnoreCase(object.getString("req_h_param_name"))) continue;
            isHasContentType = true;
            object.set("req_h_param_value", (Object)newValue);
        }
        if (!isHasContentType) {
            this.createContentTypeHeader(collection, "application/json");
        }
        this.getView().updateView("web_req_header");
    }

    public void switchReqBody(DynamicObject obj) {
        boolean v = obj.getBoolean(IS_SHOW_REQ_BODY_TEXT);
        if (v) {
            String rawType = obj.getString("body_type");
            if ("none".equals(rawType) || rawType.equals("multipart/form-data")) {
                this.clearReqBodyText();
            } else {
                this.refreshReqBodyText(obj);
            }
        } else {
            this.refreshReqBodyEntry(obj);
        }
    }

    public void clearReqBodyText() {
        this.getModel().setValue("req_body_text", null);
    }

    public void refreshReqBodyText(DynamicObject obj) {
        DynamicObjectCollection collection = obj.getDynamicObjectCollection("web_req_body");
        Map exampleParamMap = new WebReqBody(collection).getExampleParamMap();
        String jsonString = Json.toString((Object)exampleParamMap, (boolean)true);
        String script = this.getFormatType(this.getReqContentType()).genScript(jsonString);
        String dataScript = "var data = " + jsonString + ";\nreturn " + script + ";";
        this.getModel().setValue("req_body_text", Script.compile((String)dataScript).eval());
    }

    public void refreshReqBodyEntry(DynamicObject obj) {
        String reqBodyText = obj.getString("req_body_text");
        try {
            FormatType formatType = this.getReqFormatType();
            Map parse = formatType.parse(reqBodyText);
            obj.set("web_req_body", (Object)ReqHandler.initReqBody(Json.toString((Object)parse, (boolean)true), obj));
            this.getView().updateView("web_req_body");
        }
        catch (Throwable e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u6587\u672c\u5207\u6362\u5206\u5f55\u5f02\u5e38\uff0c\u53d6\u6d88\u5207\u6362\u64cd\u4f5c", (String)"ApiPostFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public FormatType getReqFormatType() {
        String contentType = this.getReqContentType();
        return this.getFormatType(contentType);
    }

    public FormatType getRespFormatType() {
        String contentType = this.getRespContentType();
        return this.getFormatType(contentType);
    }

    public void switchReqHead(DynamicObject obj) {
        boolean v = obj.getBoolean(IS_SHOW_REQ_HEAD_TEXT);
        if (v) {
            DynamicObjectCollection collection = obj.getDynamicObjectCollection("web_req_header");
            String pairsText = new PostParamModel(collection, "req_h_param_name", "req_h_param_value").toString();
            this.getModel().setValue("req_head_text", (Object)pairsText);
        } else {
            this.refreshReqHeaderEntry(obj);
        }
    }

    public void refreshReqHeaderEntry(DynamicObject obj) {
        DynamicObjectCollection collection = obj.getDynamicObjectCollection("web_req_header");
        String reqHeadText = obj.getString("req_head_text");
        List<Map<String, String>> pairs = new PostParamModel(reqHeadText).getPairList();
        DynamicObjectCollection headers = obj.getDynamicObjectCollection("web_req_header");
        headers.clear();
        boolean isHasContentType = false;
        for (Map<String, String> pair : pairs) {
            for (Map.Entry<String, String> entry : pair.entrySet()) {
                DynamicObject item = collection.addNew();
                String headName = entry.getKey();
                String headVal = entry.getValue();
                if ("Content-Type".equalsIgnoreCase(headName)) {
                    isHasContentType = true;
                }
                item.set("req_h_param_name", (Object)headName);
                item.set("req_h_param_desc", (Object)headName);
                item.set("req_h_param_value", (Object)headVal);
            }
        }
        if (!isHasContentType) {
            this.createContentTypeHeader(collection, "application/json");
        }
        this.getView().updateView("web_req_header");
    }

    public void createContentTypeHeader(DynamicObjectCollection collection, String contentType) {
        DynamicObject item = new DynamicObject(collection.getDynamicObjectType());
        item.set("req_h_param_name", (Object)"Content-Type");
        item.set("req_h_param_desc", (Object)"Content-Type");
        item.set("req_h_param_value", (Object)contentType);
        item.set("id", (Object)IDService.get().genLongId());
        item.set("seq", (Object)1);
        collection.add(0, item);
    }

    public void switchUrlParams(DynamicObject obj) {
        boolean v = obj.getBoolean(IS_SHOW_REQ_URL_TEXT);
        if (v) {
            DynamicObjectCollection collection = obj.getDynamicObjectCollection("web_url_params");
            String pairsText = new PostParamModel(collection, "url_param_name", "url_param_value").toString();
            this.getModel().setValue("req_url_text", (Object)pairsText);
        } else {
            this.refreshUrlParamsEntry(obj);
        }
    }

    public void refreshUrlParamsEntry(DynamicObject obj) {
        DynamicObjectCollection collection = obj.getDynamicObjectCollection("web_url_params");
        collection.clear();
        String reqUrlText = obj.getString("req_url_text");
        List<Map<String, String>> pairs = new PostParamModel(reqUrlText).getPairList();
        DynamicObjectCollection urlParams = obj.getDynamicObjectCollection("web_url_params");
        urlParams.clear();
        for (Map<String, String> pair : pairs) {
            for (Map.Entry<String, String> entry : pair.entrySet()) {
                DynamicObject param = urlParams.addNew();
                String paramName = entry.getKey();
                String paramVal = entry.getValue();
                try {
                    Object eval = Script.compileSimpleScript((String)paramVal).eval();
                    if (eval instanceof List) {
                        param.set("url_param_is_array", (Object)true);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                param.set("url_param_name", (Object)paramName);
                param.set("url_param_desc", (Object)paramName);
                param.set("url_param_value", (Object)paramVal);
            }
        }
        this.getView().updateView("web_url_params");
    }

    private HttpItem buildHttpItem() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        String url = obj.getString("url");
        if (obj.getBoolean(IS_SHOW_REQ_URL_TEXT)) {
            this.refreshUrlParamsEntry(obj);
        }
        if (obj.getBoolean(IS_SHOW_REQ_HEAD_TEXT)) {
            this.refreshReqHeaderEntry(obj);
        }
        if (!obj.getBoolean(IS_SHOW_REQ_BODY_TEXT)) {
            this.refreshReqBodyText(obj);
        }
        String httpMethod = obj.getString("method");
        WebApi webApi = new WebApi(httpMethod, url, obj);
        return webApi.generateTestHttpItem(obj.getString("req_body_text"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        DynamicObject obj = this.getModel().getDataEntity(true);
        try {
            if ("send".equals(operateKey)) {
                this.sendRequest();
            } else if ("switch_resp_body".equals(operateKey)) {
                this.getModel().setValue("is_show_resp_body_text", (Object)(!D.x((Object)this.getModel().getValue("is_show_resp_body_text")) ? 1 : 0));
            } else if ("switch_req_url".equals(operateKey)) {
                this.getModel().setValue(IS_SHOW_REQ_URL_TEXT, (Object)(!D.x((Object)this.getModel().getValue(IS_SHOW_REQ_URL_TEXT)) ? 1 : 0));
                this.switchUrlParams(obj);
            } else if ("switch_req_head".equals(operateKey)) {
                this.getModel().setValue(IS_SHOW_REQ_HEAD_TEXT, (Object)(!D.x((Object)this.getModel().getValue(IS_SHOW_REQ_HEAD_TEXT)) ? 1 : 0));
                this.switchReqHead(obj);
            } else if ("switch_req_body".equals(operateKey)) {
                this.getModel().setValue(IS_SHOW_REQ_BODY_TEXT, (Object)(!D.x((Object)this.getModel().getValue(IS_SHOW_REQ_BODY_TEXT)) ? 1 : 0));
                this.switchReqBody(obj);
            } else if ("release".equals(operateKey)) {
                this.releaseWebApi(obj);
            } else if ("conn_type".equals(operateKey)) {
                this.releaseConnType(obj);
            } else if ("log".equals(operateKey)) {
                FormOpener.showList(this, "isc_api_post_log", new QFilter("id", ">", (Object)0));
            } else if ("pretty".equals(operateKey)) {
                this.prettyBody(obj);
            } else if ("new".equals(operateKey)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", UUID.randomUUID().toString());
                FormOpener.showTabForm(this, "isc_api_post_test", "", params, null);
            }
        }
        catch (Throwable e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    public void prettyBody(DynamicObject obj) {
        String req_body_text = D.s((Object)obj.getString("req_body_text"));
        if (req_body_text != null) {
            String body_type = obj.getString("body_type");
            if ("application/json".equals(body_type)) {
                String prettyString = JSON.toJSONString((Object)Json.toObject((String)req_body_text), (boolean)true);
                this.getModel().setValue("req_body_text", (Object)prettyString);
            } else if ("application/xml".equals(body_type)) {
                Object prettyObject = Script.compileSimpleScript((String)("String.PrettyXml(String.parseXml('" + req_body_text + "'))")).eval();
                this.getModel().setValue("req_body_text", prettyObject);
            }
        }
    }

    public void releaseConnType(DynamicObject obj) {
        String curl = obj.getString("curl");
        if (StringUtil.isEmpty((String)curl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u9001\u8bf7\u6c42\u751f\u6210curl\u547d\u4ee4\u540e\u624d\u53ef\u53d1\u5e03\u8fde\u63a5\u7c7b\u578b", (String)"ApiPostFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("apiModelString", JSON.toJSONString((Object)new HttpItem(curl.replace("\r\n", "\n"))));
            FormOpener.showTabForm(this, "isc_conn_guide", null, params, "");
        }
    }

    public void releaseWebApi(DynamicObject obj) {
        String curl = obj.getString("curl");
        if (StringUtil.isEmpty((String)curl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u9001\u8bf7\u6c42\u751f\u6210curl\u547d\u4ee4\u540e\u624d\u53ef\u53d1\u5e03WebApi", (String)"ApiPostFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            HttpItem model = new HttpItem(curl);
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put("apiModelString", JSON.toJSONString((Object)model));
            FormOpener.showAddNew(this, "isc_apic_webapi", params);
        }
    }

    public void sendRequest() {
        try {
            String url = this.getModel().getDataEntity().getString("url");
            if (StringUtil.isEmpty((String)url)) {
                this.getView().showTipNotification("Request Url is Empty");
                return;
            }
            HttpItem httpItem = this.buildHttpItem();
            String scriptString = new IscHttpFuncGenerator().generate(httpItem, false);
            this.getModel().setValue("script", (Object)scriptString);
            this.getModel().setValue("curl", (Object)new CurlGenerator().generate(httpItem));
            Map eval = (Map)Script.compile((String)scriptString).eval();
            this.setRespData(eval);
            this.saveSuccessLog(eval);
        }
        catch (Throwable e) {
            this.saveSuccessLog(new HashMap<String, Object>());
            this.activeRespBodyEntry();
            this.getModel().setValue("resp_body_json", (Object)ShowStackTraceUtil.getErrorMsg(e));
            this.getModel().setValue("is_show_resp_body_text", (Object)true);
        }
        this.getView().showSuccessNotification("Success");
    }

    private void saveSuccessLog(Map<String, Object> eval) {
        DynamicObject obj = this.getModel().getDataEntity();
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"isc_api_post_log");
        log.set("id", (Object)IDService.get().genLongId());
        String url = obj.getString("url");
        log.set("url", (Object)url);
        log.set("method", obj.get("method"));
        log.set("creator", (Object)RequestContext.get().getCurrUserId());
        log.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        log.set("status", eval.get("responseCode"));
        HashMap<String, Object> props = new HashMap<String, Object>();
        this.buildApiModel(obj, props);
        log.set("api_model_tag", (Object)Json.toString(props, (boolean)true));
        log.set("api_model", (Object)StringUtil.trim((String)url, (int)500));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    private void buildApiModel(DynamicObject object, Map<String, Object> props) {
        DataEntityPropertyCollection properties = object.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (property instanceof EntryProp) {
                DynamicObjectCollection collection = (DynamicObjectCollection)object.get(name);
                ArrayList<HashMap<String, Object>> lists = new ArrayList<HashMap<String, Object>>(collection.size());
                for (DynamicObject obj : collection) {
                    HashMap<String, Object> col = new HashMap<String, Object>();
                    this.buildApiModel(obj, col);
                    lists.add(col);
                }
                props.put(name, lists);
                continue;
            }
            props.put(name, object.get(name));
        }
        if (D.x((Object)props.get("is_url_pwd"))) {
            props.remove("url_param_value");
        }
        if (D.x((Object)props.get("is_head_pwd"))) {
            props.remove("req_h_param_value");
        }
        if (D.x((Object)props.get("is_body_pwd"))) {
            props.remove("req_b_param_example");
        }
    }

    private void activeRespBodyEntry() {
        Tab tabCtrl = (Tab)this.getView().getControl("tabap");
        tabCtrl.activeTab("resp_body");
    }

    private void setRespData(Map<String, Object> eval) {
        this.setRespBody(eval);
        this.setRespHeader(eval);
        this.setRespCookie(eval);
    }

    private void setRespCookie(Map<String, Object> eval) {
        DynamicObjectCollection respBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("web_resp_cookie");
        respBody.clear();
        Map cookies = (Map)eval.get("cookies");
        for (Map.Entry entry : cookies.entrySet()) {
            DynamicObject object = respBody.addNew();
            object.set("resp_h_cookie_key", entry.getKey());
            object.set("resp_h_cookie_value", entry.getValue());
            object.set("id", (Object)IDService.get().genLongId());
        }
        this.getView().updateView("web_resp_cookie");
    }

    private void setRespHeader(Map<String, Object> eval) {
        DynamicObjectCollection respBody = this.getModel().getDataEntity(true).getDynamicObjectCollection("web_resp_header");
        respBody.clear();
        Map headers = (Map)eval.get("headers");
        for (Map.Entry entry : headers.entrySet()) {
            DynamicObject object = respBody.addNew();
            object.set("resp_h_header_key", entry.getKey());
            object.set("resp_h_header_value", entry.getValue());
            object.set("id", (Object)IDService.get().genLongId());
        }
        this.getView().updateView("web_resp_header");
    }

    private void setRespBody(Map<String, Object> eval) {
        DynamicObject obj = this.getModel().getDataEntity(true);
        String result = D.s((Object)eval.get("result"));
        try {
            FormatType formatType = this.getRespFormatType();
            Map parse = formatType.parse(result);
            DynamicObjectCollection dynamicObjects = RespHandler.initRespBody(Json.toString((Object)parse, (boolean)true), obj);
            if (dynamicObjects.size() == 0) {
                this.getModel().setValue("is_show_resp_body_text", (Object)true);
            }
            obj.set("web_resp_body", (Object)dynamicObjects);
            this.getView().updateView("web_resp_body");
            this.getModel().setValue("resp_body_json", (Object)Json2.toString((Object)Json.toObject((String)result)));
            this.activeRespBodyEntry();
        }
        catch (Throwable e) {
            this.getModel().setValue("resp_body_json", (Object)result);
        }
    }

    public FormatType getFormatType(String content_type) {
        FormatType formatType = StringUtil.isEmpty((String)content_type) ? FormatType.JSON : FormatType.getFormatTypeByContentType((String)content_type);
        return formatType;
    }

    public String getReqContentType() {
        DynamicObjectCollection web_req_header = this.getModel().getDataEntity(true).getDynamicObjectCollection("web_req_header");
        String content_type = "";
        for (DynamicObject object : web_req_header) {
            if (!"Content-Type".equalsIgnoreCase(object.getString("req_h_param_name"))) continue;
            content_type = object.getString("req_h_param_value");
        }
        return content_type;
    }

    public String getRespContentType() {
        DynamicObjectCollection web_resp_header = this.getModel().getDataEntity(true).getDynamicObjectCollection("web_resp_header");
        String content_type = "";
        for (DynamicObject object : web_resp_header) {
            if (!"Content-Type".equalsIgnoreCase(object.getString("resp_h_header_key"))) continue;
            content_type = object.getString("resp_h_header_value");
        }
        return content_type;
    }
}

