/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic.webapi;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.IDService;
import kd.isc.iscb.platform.core.api.parsers.model.IscFieldType;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.platform.core.api.webapi.Util;

public class RespHandler
implements Const {
    public static DynamicObjectCollection initRespBody(String text, DynamicObject obj) {
        Map dataMap = Util.getDataMap((String)text);
        return RespHandler.initRespBody(dataMap, obj);
    }

    public static DynamicObjectCollection initRespBody(Map<String, Object> dataMap, DynamicObject obj) {
        DynamicObjectCollection respBody = obj.getDynamicObjectCollection("web_resp_body");
        respBody.clear();
        if (dataMap != null) {
            for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                RespHandler.newRespBodyParamEntry(respBody, entry.getKey(), entry.getValue(), 0L);
            }
        }
        return respBody;
    }

    private static void newRespBodyParamEntry(DynamicObjectCollection respBody, String name, Object value, long pid) {
        DynamicObject bodyParam = RespHandler.addNewResp(respBody, name, pid);
        if (value instanceof List) {
            RespHandler.handleListValueResp((List)value, respBody, bodyParam);
        } else if (value instanceof Map) {
            RespHandler.handleMapValueResp((Map)value, respBody, bodyParam);
        } else {
            RespHandler.handleBaseValueResp(value, bodyParam);
        }
    }

    private static void handleBaseValueResp(Object value, DynamicObject bodyParam) {
        bodyParam.set("resp_b_param_example", value);
        bodyParam.set("resp_b_param_type", (Object)Util.getIscFieldTypeFromValue((Object)value).getTypeName());
    }

    private static void handleMapValueResp(Map<String, Object> value, DynamicObjectCollection respBody, DynamicObject bodyParam) {
        bodyParam.set("resp_b_param_type", (Object)IscFieldType.STRUCT.getTypeName());
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            RespHandler.newRespBodyParamEntry(respBody, entry.getKey(), entry.getValue(), bodyParam.getLong("id"));
        }
    }

    private static void handleListValueResp(List value, DynamicObjectCollection respBody, DynamicObject bodyParam) {
        bodyParam.set("resp_b_param_is_array", (Object)Boolean.TRUE);
        if (!value.isEmpty()) {
            Object o = value.get(0);
            if (o instanceof Map) {
                RespHandler.handleMapValueResp((Map)o, respBody, bodyParam);
            } else {
                bodyParam.set("resp_b_param_type", (Object)Util.getIscFieldTypeFromValue(o).getTypeName());
            }
        } else {
            bodyParam.set("resp_b_param_type", (Object)IscFieldType.UNKNOWN.getTypeName());
        }
    }

    private static DynamicObject addNewResp(DynamicObjectCollection respBody, String name, long pid) {
        DynamicObject bodyParam = respBody.addNew();
        bodyParam.set("id", (Object)IDService.get().genLongId());
        bodyParam.set("pid", (Object)pid);
        bodyParam.set("resp_b_param_name", (Object)name);
        bodyParam.set("resp_b_param_desc", (Object)name);
        bodyParam.set("resp_b_param_required", (Object)Boolean.FALSE);
        return bodyParam;
    }
}

