/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.Modify;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.apic.ApiCommonUtil;
import kd.isc.iscb.formplugin.apic.webapi.ReqHandler;
import kd.isc.iscb.formplugin.apic.webapi.ReqHeadHandler;
import kd.isc.iscb.formplugin.apic.webapi.RespHandler;
import kd.isc.iscb.formplugin.apic.webapi.SwaggerHandler;
import kd.isc.iscb.formplugin.apic.webapi.UrlParamHandler;
import kd.isc.iscb.formplugin.apic.webapi.WebApiFormUtil;
import kd.isc.iscb.formplugin.sf.ScriptTextUtil;
import kd.isc.iscb.formplugin.sf.ServiceFlowFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ResourceIsolateUtil;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.api.parsers.model.SwaggerModel;
import kd.isc.iscb.platform.core.api.quick.HttpItem;
import kd.isc.iscb.platform.core.api.quick.UrlItem;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.platform.core.api.webapi.Util;
import kd.isc.iscb.platform.core.api.webapi.WebApi;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.cache.data.DataSource;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.connector.webapi.SessionCache;
import kd.isc.iscb.platform.core.connector.webapi.WebApiConnectionFactory;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class WebApiFormPlugin
extends AbstractFormPlugin
implements Const,
CellClickListener,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(WebApiFormPlugin.class);
    private static final String SET_URL_PARAM = "SET_URL_PARAM";
    private static final String SET_HEAD_PARAM = "SET_HEAD_PARAM";
    private static final String SET_BODY_PARAM = "SET_BODY_PARAM";
    private static final String ISC_CONN_VARIABLES = "isc_conn_variables";
    private static final String VAR_NAME = "var_name";
    private static final String VAR_DESC = "var_desc";
    private static final String VAR_TYPE = "var_type";
    private static final String GEN_REQ_MODEL = "gen_req_model";
    private static final String GEN_RESP_MODEL = "gen_resp_model";
    private static final String IMPORT_URL_PARAM = "import_url_param";
    private static final String IMPORT_HEAD_PARAM = "import_head_param";
    private static final String IN_DIGEST = "in_digest";
    private static final String OUT_DIGEST = "out_digest";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid urlPrams = (EntryGrid)this.getView().getControl("web_url_params");
        urlPrams.addCellClickListener((CellClickListener)this);
        EntryGrid reqHeader = (EntryGrid)this.getView().getControl("web_req_header");
        reqHeader.addCellClickListener((CellClickListener)this);
        EntryGrid reqBody = (EntryGrid)this.getView().getControl("web_req_body");
        reqBody.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{IN_DIGEST, OUT_DIGEST});
        BasedataEdit baseentity = (BasedataEdit)this.getView().getControl("group");
        baseentity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"select_params"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        String key = ((Control)src).getKey();
        if (IN_DIGEST.equals(key) || OUT_DIGEST.equals(key)) {
            ScriptTextUtil.openDigestScriptForm(this.getModel().getValue(key), this, key, key);
        } else if (src instanceof Button && "select_params".equals(((Button)src).getKey())) {
            long groupId = D.l((Object)this.getModel().getValue("group_id"));
            if (groupId > 0L) {
                FormOpener.showForm(this, ISC_CONN_VARIABLES, ResManager.loadKDString((String)"\u9009\u62e9\u53d8\u91cf", (String)"WebApiFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getCnVars(), "urlPath_select");
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u518d\u9009\u62e9\u53d8\u91cf\u3002", (String)"WebApiFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if ("group".equals(property)) {
            this.initUrlPrefixAndType(this.getNewDatasourceId(e));
        }
    }

    private long getNewDatasourceId(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (newValue instanceof DynamicObject) {
            return D.l((Object)((DynamicObject)newValue).getPkValue());
        }
        return D.l((Object)newValue);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        try {
            String property = e.getProperty().getName();
            ChangeData[] changeSet = e.getChangeSet();
            if ("script_mode".equals(property)) {
                this.initInvokeScriptAdvc();
            } else if ("need_format_result".equals(property)) {
                this.resetRespBody(e);
            } else if (changeSet.length == 1 && "res_ref".equals(property)) {
                int rowIndex = changeSet[0].getRowIndex();
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("resources", rowIndex);
                if (rowEntity.get("res_ref") != null && StringUtil.isEmpty((String)D.s((Object)rowEntity.get("res_alias")))) {
                    rowEntity.set("res_alias", (Object)ServiceFlowFormPlugin.getRandVarName());
                }
                this.getView().updateView("resources");
            } else if ("is_multipart".equals(property)) {
                this.resetContentTypeHeaderItem();
                WebApiFormUtil.initRequestBodyTypeCombo(this);
            }
        }
        catch (Exception ex) {
            FormOpener.showErrorMessage(this.getView(), ex);
        }
    }

    private void resetContentTypeHeaderItem() {
        DynamicObjectCollection headers = this.getModel().getDataEntity(true).getDynamicObjectCollection("web_req_header");
        DynamicObject item = this.findContentTypeInHeaders(headers);
        if (item == null) {
            item = headers.addNew();
            item.set("req_h_param_name", (Object)"Content-Type");
            item.set("req_h_param_desc", (Object)"Content-Type");
        }
        item.set("req_h_param_value", (Object)(WebApiFormUtil.isMultipart(this) ? Util.generateMultipartContentType((String)Util.newBoundary()) : "application/json"));
        this.getView().updateView("web_req_header");
    }

    private DynamicObject findContentTypeInHeaders(DynamicObjectCollection headers) {
        for (int i = headers.size() - 1; i >= 0; --i) {
            DynamicObject item = (DynamicObject)headers.get(i);
            String headName = D.s((Object)item.get("req_h_param_name"));
            if (!"Content-Type".equalsIgnoreCase(headName)) continue;
            return item;
        }
        return null;
    }

    private void resetRespBody(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        boolean newValue = D.x((Object)changeData.getNewValue());
        boolean oldValue = D.x((Object)changeData.getOldValue());
        if (oldValue && !newValue) {
            this.getModel().deleteEntryData("web_resp_body");
            this.getView().updateView("web_resp_body");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initUrlPrefixAndType(long newDsId) {
        if (newDsId > 0L) {
            DataSource dataSource = DataSource.get((long)newDsId);
            long dbLink = dataSource.getDbLink();
            if (dbLink <= 0L) throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e3a\u5f53\u524d\u7684\u6570\u636e\u6e90\u914d\u7f6e\u4e00\u4e2aWebApi\u8fde\u63a5\u3002", (String)"WebApiListPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            DynamicObject cn = ConnectionConfig.getConfig((long)dbLink);
            this.getModel().setValue("url_prefix", (Object)this.getUrlPrefix(cn));
            ConnectionFactory factory = DatabaseType.find((String)cn.getString("database_type"));
            if (factory instanceof WebApiConnectionFactory) {
                this.getModel().setValue("conn_type", (Object)Util.queryConnTypeByConn((DynamicObject)cn));
                return;
            } else {
                String tips = ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u8fde\u63a5\u7c7b\u578b\u4e3aWebApi\u7c7b\u7684\u6570\u636e\u6e90", (String)"WebApiFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
            }
            return;
        } else {
            this.getModel().setValue("conn_type", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if (operate instanceof Save) {
            String method = D.s((Object)this.getModel().getValue("method"));
            if ("post".equalsIgnoreCase(method) && !this.isContentTypeValid()) {
                args.setCancel(true);
                return;
            }
            if (this.checkEnable(args, "save_disable_webapi", ResManager.loadKDString((String)"WebAPI\u7981\u7528\u540e\u624d\u80fd\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"WebApiFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]))) {
                return;
            }
            try {
                Format.parse((String)D.s((Object)this.getModel().getValue("url_path")), new HashMap());
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"WebApiFormPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ShowStackTraceUtil.getErrorMsg(e));
                args.setCancel(true);
                return;
            }
            if (WebApiFormUtil.checkMultipart(this)) {
                args.setCancel(true);
                return;
            }
            this.setScriptTag();
            this.handleScriptFunctions(args);
        } else if ("modify".equals(operationKey)) {
            this.checkEnable(args, "modify_disable_webapi", ResManager.loadKDString((String)"WebAPI\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"WebApiFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void handleScriptFunctions(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection resources = this.getModel().getEntryEntity("resources");
        if (!D.x((Object)this.getModel().getValue("script_mode"))) {
            resources.clear();
        } else {
            for (int i = 0; i < resources.size(); ++i) {
                DynamicObject resource = (DynamicObject)resources.get(i);
                String res_alias = resource.getString("res_alias");
                if (!CommonUtil.isIllegalString((String)res_alias)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f9d\u8d56\u8d44\u6e90\u5206\u5f55\u7b2c %1$s \u884c\u522b\u540d\u547d\u540d\u4e0d\u89c4\u8303\uff0c\u53ea\u5141\u8bb8\u4ee5\u5b57\u6bcd\u3001\u6570\u5b57\u6216\u4e0b\u5212\u7ebf\u4f5c\u4e3a\u5143\u7d20, \u4e0d\u5141\u8bb8\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u66f4\u4e0d\u5141\u8bb8\u4f7f\u7528\u5176\u4ed6\u7279\u6b8a\u5b57\u7b26'%2$s'", (String)"WebApiFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), i + 1, res_alias));
                args.setCancel(true);
                return;
            }
        }
    }

    private boolean checkEnable(BeforeDoOperationEventArgs args, String callBackID, String tips) {
        DynamicObject schema;
        Object apiId = this.getModel().getValue("id");
        if (apiId != null && Long.parseLong(apiId.toString()) != 0L && (schema = BusinessDataServiceHelper.loadSingle((Object)apiId, (String)"isc_apic_webapi", (String)"enable")).getInt("enable") == 1) {
            args.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackID, (IFormPlugin)this);
            this.getView().showConfirm(tips, MessageBoxOptions.YesNo, confirmCallBacks);
            return true;
        }
        return false;
    }

    private boolean isContentTypeValid() {
        String contentType = this.getContentType();
        if (contentType == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u4e2d\u5fc5\u987b\u5305\u542bContent-Type\uff0c\u4e14\u53c2\u6570\u503c\u5e94\u4f7f\u7528\u5e38\u91cf\u8d4b\u503c", (String)"WebApiFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (contentType.startsWith("$")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u4e2d\u7684Content-Type\u53c2\u6570\u503c\u5e94\u4f7f\u7528\u5e38\u91cf\u8d4b\u503c", (String)"WebApiFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!this.isValid(contentType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"WebAPI\u767b\u8bb0\u53ea\u652f\u6301application/x-www-form-urlencoded\u3001application/json\u3001text/xml\u3001multipart/form-data\u683c\u5f0f\u7684Content-Type", (String)"WebApiFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isValid(String contentType) {
        return contentType.contains("json") || contentType.contains("x-www-form-urlencoded") || contentType.contains("xml") || contentType.contains("multipart/form-data");
    }

    private String getContentType() {
        DynamicObjectCollection headers = this.getModel().getDataEntity(true).getDynamicObjectCollection("web_req_header");
        for (DynamicObject header : headers) {
            if (!"content-type".equalsIgnoreCase(header.getString("req_h_param_name"))) continue;
            return D.s((Object)header.get("req_h_param_value"));
        }
        return null;
    }

    private void setScriptTag() {
        DynamicObject obj = this.getModel().getDataEntity(true);
        boolean isScriptMode = D.x((Object)obj.get("script_mode"));
        CodeEdit invokeTap = (CodeEdit)this.getView().getControl("invoke_tap");
        String newInvokeScript = D.s((Object)invokeTap.getText());
        if (isScriptMode && newInvokeScript != null) {
            this.getModel().setValue("invoke_script_tag", (Object)newInvokeScript);
        } else {
            WebApi webApi = new WebApi(obj);
            this.getModel().setValue("invoke_script_tag", (Object)webApi.getInvokeScript());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initDataSource();
        ResourceIsolateUtil.setSourceApp(this.getView(), this.getModel());
    }

    private void initDataSource() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object source_id = formShowParameter.getCustomParam("source_id");
        if (source_id != null) {
            DynamicObject source = BusinessDataServiceHelper.loadSingle((Object)source_id, (String)"isc_data_source");
            this.getModel().setValue("group", (Object)source);
            Object conn_id = formShowParameter.getCustomParam("conn_id");
            if (conn_id != null) {
                this.getModel().setValue("conn_type", (Object)BusinessDataServiceHelper.loadSingle((Object)conn_id, (String)"isc_connection_type"));
            }
        }
    }

    private void initDataBySwagger() {
        String swaggerString;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object operation_data = formShowParameter.getCustomParam(swaggerString = "SwaggerString");
        if (operation_data != null && this.isAddNew()) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            SwaggerModel swaggerModel = (SwaggerModel)JSON.parseObject((String)D.s((Object)operation_data), (TypeReference)new TypeReference<SwaggerModel>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            UrlItem urlItem = swaggerModel.getUrlItem();
            obj.set("number", (Object)swaggerModel.getNumber());
            obj.set("name", (Object)swaggerModel.getName());
            obj.set("url_path", (Object)urlItem.getPath());
            obj.set("url_prefix", (Object)urlItem.getUrlPrefix());
            obj.set("method", (Object)swaggerModel.getMethod());
            obj.set("is_multipart", (Object)false);
            obj.set("web_url_params", (Object)SwaggerHandler.initUrlParams(swaggerModel.getUrlParams(), obj));
            obj.set("web_req_header", (Object)SwaggerHandler.initHeaders(swaggerModel.getHeaders(), obj));
            obj.set("web_req_body", (Object)SwaggerHandler.initRequestBody(swaggerModel.getRequestBody(), obj));
            DynamicObjectCollection value = SwaggerHandler.initResponseBody(swaggerModel.getResponses(), obj);
            if (value.size() > 0) {
                obj.set("need_format_result", (Object)true);
                obj.set("web_resp_body", (Object)value);
            }
            formShowParameter.setCustomParam(swaggerString, null);
            this.getView().updateView();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        try {
            this.initDataByOperInfo();
            this.initDataBySwagger();
            this.initTestBtn();
            this.initInvokeScriptAdvc();
            this.setModifyBtnVisible();
            this.getModel().setValue("is_publish", (Object)(!this.getModel().getDataEntity().getBoolean("not_publish") ? 1 : 0));
            long dsId = D.l((Object)this.getModel().getValue("group_id"));
            this.initUrlPrefixAndType(dsId);
            WebApiFormUtil.initRequestBodyTypeCombo(this);
        }
        catch (Exception ex) {
            FormOpener.showErrorMessage(this.getView(), ex);
        }
    }

    private void setModifyBtnVisible() {
        if (this.isAddNewOrEdit()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_enable"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"invoke_tap"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_enable"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"invoke_tap"});
        }
    }

    private boolean isAddNewOrEdit() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        return status == OperationStatus.ADDNEW || status == OperationStatus.EDIT;
    }

    private void initInvokeScriptAdvc() {
        this.getView().setVisible(Boolean.valueOf(D.x((Object)this.getModel().getValue("script_mode"))), new String[]{"advc_req_script"});
        CodeEdit invokeTap = (CodeEdit)this.getView().getControl("invoke_tap");
        String oldText = D.s((Object)invokeTap.getText());
        String newText = D.s((Object)this.getModel().getValue("invoke_script_tag"));
        if (oldText == null && newText != null) {
            invokeTap.setText(newText);
        }
    }

    private void initTestBtn() {
        if (Util.isDebugMode()) {
            BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            if (billShowParameter.getBillStatus().equals((Object)BillOperationStatus.EDIT)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_test", "btn_gen_code"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btn_test", "btn_gen_code"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_test", "btn_gen_code"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        try {
            this.doOperation(args);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            this.resetBtnVisible(args);
        }
    }

    private void resetBtnVisible(AfterDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"invoke_tap"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_test", "btn_gen_code", "btn_enable"});
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().cacheFormShowParameter();
        } else if (args.getSource() instanceof Modify) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify", "btn_enable"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"invoke_tap"});
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().cacheFormShowParameter();
        }
    }

    private void doOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("test".equals(operateKey)) {
            DynamicObject api = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("id"), (String)"isc_apic_webapi", (String)"enable");
            if (!api.getBoolean("enable")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528API\u540e\u518d\u6267\u884c\u6d4b\u8bd5\u3002", (String)"WebApiFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("webapi", this.getModel().getValue("id"));
            FormOpener.showForm(this, "isc_webapi_test", ResManager.loadKDString((String)"API\u6d4b\u8bd5", (String)"WebApiFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, null);
        } else if ("clear_result".equals(operateKey)) {
            CodeEdit result = (CodeEdit)this.getView().getControl("result");
            result.setText("");
        } else if ("format_result".equals(operateKey)) {
            CodeEdit result = (CodeEdit)this.getView().getControl("result");
            String text = result.getText();
            String formatStr = JSON.toJSONString((Object)Script.parseJson((String)text), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
            result.setText(formatStr);
        } else if ("parse_result".equals(operateKey)) {
            CodeEdit result = (CodeEdit)this.getView().getControl("result");
            String text = result.getText();
            DynamicObject obj = this.getModel().getDataEntity(true);
            obj.set("web_resp_body", (Object)RespHandler.initRespBody(text, obj));
            this.getView().updateView("web_resp_body");
            Tab tabCtrl = (Tab)this.getView().getControl("tabap1");
            tabCtrl.activeTab("resp_param_tab");
        } else if ("gen_code".equals(operateKey)) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            WebApi webApi = new WebApi(obj);
            HttpItem httpItem = webApi.generateHttpItemByExampleData();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("httpItemStr", JSON.toJSONString((Object)httpItem));
            FormOpener.showForm(this, "isc_code_snippet", ResManager.loadKDString((String)"\u4ee3\u7801\u7247\u6bb5", (String)"WebApiFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        } else if ("reset_script".equals(operateKey)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("reset_script", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u751f\u6210\u811a\u672c\u4f1a\u4e22\u5931\u4e2a\u4eba\u4fee\u6539\u90e8\u5206\uff0c\u8bf7\u6ce8\u610f\u505a\u597d\u5907\u4efd\uff0c\u786e\u5b9a\u91cd\u65b0\u751f\u6210\u5417\uff1f", (String)"WebApiFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        } else if ("show_log".equals(operateKey)) {
            ApiCommonUtil.openLog(this, args);
        } else if (GEN_REQ_MODEL.equals(operateKey)) {
            FormOpener.showForm(this, "isc_data_content", ResManager.loadKDString((String)"\u5bfc\u5165\u8bf7\u6c42\u6a21\u578b\uff08json\u683c\u5f0f\uff09", (String)"WebApiFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new HashMap<String, Object>(), GEN_REQ_MODEL);
        } else if (GEN_RESP_MODEL.equals(operateKey)) {
            FormOpener.showForm(this, "isc_data_content", ResManager.loadKDString((String)"\u5bfc\u5165\u54cd\u5e94\u6a21\u578b\uff08json\u683c\u5f0f\uff09", (String)"WebApiFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new HashMap<String, Object>(), GEN_RESP_MODEL);
        } else if (IMPORT_URL_PARAM.equals(operateKey)) {
            FormOpener.showForm(this, "isc_data_content", ResManager.loadKDString((String)"\u5bfc\u5165URL\u53c2\u6570\u6a21\u578b\uff08json\u683c\u5f0f\uff09", (String)"WebApiFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new HashMap<String, Object>(), IMPORT_URL_PARAM);
        } else if (IMPORT_HEAD_PARAM.equals(operateKey)) {
            FormOpener.showForm(this, "isc_data_content", ResManager.loadKDString((String)"\u5bfc\u5165\u8bf7\u6c42\u5934\u6a21\u578b\uff08json\u683c\u5f0f\uff09", (String)"WebApiFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new HashMap<String, Object>(), IMPORT_HEAD_PARAM);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        try {
            OperationResult result;
            String callback = evt.getCallBackId();
            if ("reset_script".equals(callback)) {
                this.resetScript();
            } else if ("modify_disable_webapi".equals(callback)) {
                OperationResult result2 = this.getView().invokeOperation("disable");
                if (result2.isSuccess()) {
                    this.getView().invokeOperation("modify");
                }
            } else if ("save_disable_webapi".equals(callback) && (result = this.getView().invokeOperation("disable")).isSuccess()) {
                this.getView().showMessage(ResManager.loadKDString((String)"WebAPI\u5df2\u7981\u7528\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u4fdd\u5b58\u3002", (String)"WebApiFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void resetScript() {
        CodeEdit invokeTap = (CodeEdit)this.getView().getControl("invoke_tap");
        DynamicObject obj = this.getModel().getDataEntity(true);
        WebApi webApi = new WebApi(obj);
        String invokeScript = webApi.getInvokeScript();
        this.getModel().setValue("invoke_script_tag", (Object)invokeScript);
        invokeTap.setText(invokeScript);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u91cd\u65b0\u751f\u6210\u8bf7\u6c42\u811a\u672c\u3002", (String)"WebApiFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private void initDataByOperInfo() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object operation_data = formShowParameter.getCustomParam("apiModelString");
        if (operation_data != null && this.isAddNew()) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            HttpItem httpItem = (HttpItem)JSON.parseObject((String)D.s((Object)operation_data), (TypeReference)new TypeReference<HttpItem>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            UrlItem urlItem = httpItem.getUrlItem();
            String path = urlItem.getPath();
            int i = path.lastIndexOf(47);
            if (i >= 0) {
                String number = path.substring(i + 1);
                obj.set("number", (Object)number);
                obj.set("name", (Object)number);
            }
            obj.set("url_path", (Object)path);
            obj.set("url_prefix", (Object)urlItem.getUrlPrefix());
            obj.set("method", (Object)httpItem.getHttpMethod());
            obj.set("is_multipart", (Object)httpItem.bodyIsFormData());
            obj.set("web_req_header", (Object)ReqHeadHandler.initHeaders(httpItem.getHeaders(), obj));
            obj.set("web_url_params", (Object)UrlParamHandler.initParams(urlItem.getQueryParamMap(), obj));
            obj.set("web_req_body", ReqHandler.initReqBody(httpItem, obj));
            DynamicObjectCollection value = RespHandler.initRespBody(httpItem.getResp(), obj);
            if (value.size() > 0) {
                obj.set("need_format_result", (Object)true);
                obj.set("web_resp_body", (Object)value);
            }
            formShowParameter.setCustomParam("apiModelString", null);
            this.getView().updateView();
        }
    }

    private boolean isAddNew() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        return status == OperationStatus.ADDNEW;
    }

    private String getUrlPrefix(DynamicObject cn) {
        String http_protocal = D.s((Object)cn.get("http_protocal"));
        if (http_protocal == null) {
            http_protocal = "http";
        }
        return http_protocal + "://" + cn.getString("server_ip") + ":" + this.getPort(cn, http_protocal);
    }

    private int getPort(DynamicObject cn, String http_protocal) {
        int port = D.i((Object)cn.get("server_port"));
        if (port <= 0) {
            port = "https".equals(http_protocal) ? 443 : 80;
        }
        return port;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if ("url_param_value".equals(fieldKey)) {
            this.selectParam(cellClickEvent, SET_URL_PARAM);
        } else if ("req_h_param_value".equals(fieldKey)) {
            this.selectParam(cellClickEvent, SET_HEAD_PARAM);
        } else if ("req_b_param_value".equals(fieldKey)) {
            this.selectParam(cellClickEvent, SET_BODY_PARAM);
        }
    }

    private void selectParam(CellClickEvent cellClickEvent, String callback) {
        long groupId = D.l((Object)this.getModel().getValue("group_id"));
        if (groupId > 0L) {
            FormOpener.showForm(this, ISC_CONN_VARIABLES, ResManager.loadKDString((String)"\u9009\u62e9\u53d8\u91cf", (String)"WebApiFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.makeVarListParam(cellClickEvent), callback);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u518d\u9009\u62e9\u53d8\u91cf\u3002", (String)"WebApiFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, Object> makeVarListParam(CellClickEvent cellClickEvent) {
        Map<String, Object> param = this.getCnVars();
        param.put("$row", cellClickEvent.getRow());
        return param;
    }

    private Map<String, Object> getCnVars() {
        DynamicObject connType = this.getModel().getDataEntity().getDynamicObject("conn_type");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("conn_type", connType.getString("number"));
        if (this.getView().getFormShowParameter().getCustomParam("webRespBodyStr") != null) {
            param.put("webRespBodyStr", this.getView().getFormShowParameter().getCustomParam("webRespBodyStr"));
        } else {
            try {
                ConnectionWrapper cn;
                WebApiConnectionFactory factory;
                DynamicObject cfg;
                Object loginInfo;
                long ds_id = this.getModel().getDataEntity().getLong("group_id");
                DataSource dataSource = DataSource.get((long)ds_id);
                long dbLink = dataSource.getDbLink();
                if (dbLink > 0L && (loginInfo = SessionCache.getLoginInfo((DynamicObject)(cfg = ConnectionConfig.getConfig((long)dbLink)), (Script)(factory = (WebApiConnectionFactory)(cn = ConnectionManager.getConnection((long)cfg.getLong("id"))).getFactory()).getLoginScript(), (Map)factory.getExtensions())) instanceof Map) {
                    param.put("webRespBodyStr", Json.toString((Object)loginInfo, (boolean)true));
                }
            }
            catch (Throwable e) {
                LOG.warn("\u83b7\u53d6\u8fde\u63a5\u914d\u7f6esession\u5931\u8d25", e);
            }
        }
        return param;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (action.equals(SET_URL_PARAM)) {
            this.setCell(evt, "web_url_params", "url_param_value", "url_param_desc");
        } else if (action.equals(SET_BODY_PARAM)) {
            this.setCell(evt, "web_req_body", "req_b_param_value", "req_b_param_desc");
        } else if (action.equals(SET_HEAD_PARAM)) {
            this.setCell(evt, "web_req_header", "req_h_param_value", "req_h_param_desc");
        } else if (action.equals(GEN_REQ_MODEL)) {
            this.setReqBody(evt);
        } else if (action.equals(GEN_RESP_MODEL)) {
            this.setRespBody(evt);
        } else if (action.equals(IMPORT_HEAD_PARAM)) {
            this.setHeadParam(evt);
        } else if (action.equals(IMPORT_URL_PARAM)) {
            this.setUrlParam(evt);
        } else if (IN_DIGEST.equals(action) || OUT_DIGEST.equals(action)) {
            ScriptTextUtil.retryScriptFormCallBack(evt, this, this.getModel(), action);
        } else if ("urlPath_select".equals(action)) {
            this.setUrlPathParam(evt);
        }
    }

    private void setUrlPathParam(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData instanceof Map) {
            String newValue;
            Map rowData = (Map)returnData;
            String varName = D.s(rowData.get(VAR_NAME));
            String url_path = D.s((Object)this.getModel().getValue("url_path"));
            StringBuilder s = new StringBuilder();
            if (url_path != null) {
                s.append(url_path);
            }
            if (varName != null) {
                s.append("#{").append(varName).append("}");
            }
            if ((newValue = s.toString()).length() > 255) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"url\u4fe1\u606f\u8d85\u957f\uff0c\u672c\u6b21\u63d2\u5165\u53d8\u91cf\u64cd\u4f5c\u5df2\u5ffd\u7565\u3002", (String)"WebApiFormPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setValue("url_path", (Object)StringUtil.trim((String)newValue, (int)255));
            }
        }
    }

    private void setUrlParam(ClosedCallBackEvent evt) {
        String dataStr = D.s((Object)evt.getReturnData());
        if (dataStr != null) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            obj.set("web_url_params", (Object)UrlParamHandler.initParams(dataStr, obj));
            this.getView().updateView("web_url_params");
        }
    }

    private void setHeadParam(ClosedCallBackEvent evt) {
        String dataStr = D.s((Object)evt.getReturnData());
        if (dataStr != null) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            obj.set("web_req_header", (Object)ReqHeadHandler.initHeaders(dataStr, obj));
            this.getView().updateView("web_req_header");
        }
    }

    private void setRespBody(ClosedCallBackEvent evt) {
        String respData = D.s((Object)evt.getReturnData());
        if (respData != null) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            obj.set("web_resp_body", (Object)RespHandler.initRespBody(respData, obj));
            this.getView().updateView("web_resp_body");
        }
    }

    private void setReqBody(ClosedCallBackEvent evt) {
        String reqData = D.s((Object)evt.getReturnData());
        if (reqData != null) {
            DynamicObject obj = this.getModel().getDataEntity(true);
            obj.set("web_req_body", (Object)ReqHandler.initReqBody(reqData, obj));
            this.getView().updateView("web_req_body");
        }
    }

    private void setCell(ClosedCallBackEvent evt, String entryName, String varName, String varDesc) {
        Object returnData = evt.getReturnData();
        if (returnData instanceof Map) {
            Map mapData = (Map)returnData;
            DynamicObject row = this.getModel().getEntryRowEntity(entryName, D.i(mapData.get("$row")));
            row.set(varName, mapData.get(VAR_NAME));
            row.set(varDesc, mapData.get(VAR_DESC));
            this.getView().updateView(entryName);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("group".equals(fieldKey)) {
            List<Long> webApiLinkIds = WebApiFormPlugin.getWebApiLinks();
            Set<Long> webApiDataSourceIds = WebApiFormPlugin.getWebApiDataSources(webApiLinkIds);
            QFilter qFilter = new QFilter("id", "in", webApiDataSourceIds);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String source_app = D.s((Object)this.getView().getFormShowParameter().getCustomParam("source_app"));
            if (source_app != null) {
                showParameter.getCustomParams().put("source_app", source_app);
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public static List<Long> getWebApiLinks() {
        DynamicObjectCollection links = QueryServiceHelper.query((String)"isc_database_link", (String)"id,database_type", null);
        ArrayList<Long> linkIds = new ArrayList<Long>();
        for (DynamicObject link : links) {
            String databaseType = link.getString("database_type");
            ConnectionFactory factory = DatabaseType.find((String)databaseType);
            if (!(factory instanceof WebApiConnectionFactory)) continue;
            linkIds.add(D.l((Object)link.get("id")));
        }
        return linkIds;
    }

    public static Set<Long> getWebApiDataSources(List linkIds) {
        QFilter dblinkFilter = new QFilter("dblink", "in", (Object)linkIds);
        DynamicObjectCollection dataSources = QueryServiceHelper.query((String)"isc_data_source", (String)"id", (QFilter[])new QFilter[]{dblinkFilter});
        LinkedHashSet<Long> dataSourceIds = new LinkedHashSet<Long>();
        for (DynamicObject dataSource : dataSources) {
            dataSourceIds.add(D.l((Object)dataSource.get("id")));
        }
        return dataSourceIds;
    }
}

