/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.common;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.platform.core.util.TimeUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import org.quartz.CronExpression;

public class CronExpressionFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String SECOND = "second";
    private static final String MINUTE = "minute";
    private static final String HOUR = "hour";
    private static final String DAY = "day";
    private static final String MONTH = "month";
    private static final String WEEK = "week";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String cron = (String)this.getView().getFormShowParameter().getCustomParam("cron_expr");
        if (!StringUtil.isEmpty((String)cron) && CronExpression.isValidExpression((String)cron)) {
            String[] split = cron.replaceAll(" {2,}", " ").split(" ");
            this.getModel().setValue(SECOND, (Object)split[0]);
            this.getModel().setValue(MINUTE, (Object)split[1]);
            this.getModel().setValue(HOUR, (Object)split[2]);
            this.getModel().setValue(DAY, (Object)split[3]);
            this.getModel().setValue(MONTH, (Object)split[4]);
            this.getModel().setValue(WEEK, (Object)split[5]);
        }
        this.showRecent20Plans();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        params.put("cron_expr", this.buildCron());
        this.getView().returnDataToParent((Object)params);
    }

    private String buildCron() {
        String cronExpression = this.getExpression();
        if (CronExpression.isValidExpression((String)cronExpression)) {
            return cronExpression;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u8868\u683c\u5185\u586b\u5199\u5185\u5bb9\u89e3\u6790\u7684cron\u8868\u8fbe\u5f0f\u975e\u6cd5\uff0c\u65e0\u6cd5\u8fd4\u56decron\u8868\u8fbe\u5f0f\u3002", (String)"CronExpressionFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private String getExpression() {
        return String.valueOf(this.getModel().getValue(SECOND)) + ' ' + this.getModel().getValue(MINUTE) + ' ' + this.getModel().getValue(HOUR) + ' ' + this.getModel().getValue(DAY) + ' ' + this.getModel().getValue(MONTH) + ' ' + this.getModel().getValue(WEEK);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.showRecent20Plans();
    }

    private void showRecent20Plans() {
        String expression = this.getExpression();
        String recent20PlansDesc = CronExpression.isValidExpression((String)expression) ? this.getRecent20PlansDesc(expression) : String.format(ResManager.loadKDString((String)"\u8868\u683c\u5185\u586b\u5199\u5185\u5bb9\u89e3\u6790\u7684Cron\u8868\u8fbe\u5f0f:%s\u975e\u6cd5\uff0c\u65e0\u6cd5\u8ba1\u7b97\uff0c\u8bf7\u53c2\u8003\u4e0a\u65b9tips\u89c4\u5219\u66f4\u6539...", (String)"CronExpressionFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), expression);
        CodeEdit codeEdit = (CodeEdit)this.getView().getControl("desc");
        codeEdit.setText(recent20PlansDesc);
    }

    private String getRecent20PlansDesc(String cron) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = this.getStartDate();
            for (int i = 1; i <= 20; ++i) {
                CronExpression cronExe = new CronExpression(cron);
                date = cronExe.getNextValidTimeAfter(date);
                this.checkDateIsExpired(date, i, sdf);
                sb.append(ResManager.loadKDString((String)"\u7b2c", (String)"CronExpressionFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(i).append(ResManager.loadKDString((String)"\u6b21\uff1a", (String)"CronExpressionFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(TimeUtil.getInteTime((Date)date, (SimpleDateFormat)sdf)).append('\n');
            }
        }
        catch (Exception e) {
            sb.append(StringUtil.getCascadeMessage((Throwable)e));
        }
        return sb.toString();
    }

    private Date getStartDate() {
        Timestamp start = D.t((Object)this.getView().getFormShowParameter().getCustomParam("start_time"));
        if (start == null || start.getTime() < System.currentTimeMillis()) {
            return new Date();
        }
        return start;
    }

    private void checkDateIsExpired(Date date, int i, SimpleDateFormat sdf) {
        Timestamp end_time = D.t((Object)this.getView().getFormShowParameter().getCustomParam("end_time"));
        if (end_time == null) {
            return;
        }
        if (end_time.getTime() > 0L && date.getTime() > end_time.getTime()) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u8c03\u5ea6\u8ba1\u5212\u8ba1\u7b97\uff0c\u7b2c%1$s\u6b21\u6267\u884c\u65f6\u95f4\u662f%2$s,\n\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4%3$s\uff0c\u5f53\u524d\u4efb\u52a1\u5c06\u5728\u6267\u884c%4$s\u6b21\u540e\u505c\u6b62\u3002", (String)"CronExpressionFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), i, TimeUtil.getInteTime((Date)date, (SimpleDateFormat)sdf), TimeUtil.getInteTime((Date)D.t((Object)end_time), (SimpleDateFormat)sdf), i - 1));
        }
    }
}

