/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.connector.HttpConnectionFactory;
import kd.isc.iscb.platform.core.network.CheckNetWorkThread;
import kd.isc.iscb.platform.core.network.CheckNetworkThreadPool;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class CheckNetworkFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String OP_SPEED_TEST = "speed_test";
    private static final String OP_CHECK_CURL = "check_curl";
    private static final String OP_CHECK_TELNET = "check_telnet";
    private static final String OP_CHECK_PING = "check_ping";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String BTN_CURL = "btncurl";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    private static final String COUNT = "count";
    private static final String CHECK_RESULT = "check_result";
    private static final String BTN_SPEED_TEST = "btn_speed_test";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(PROGRESSBARAP);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object dblink = this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject cfg = BusinessDataServiceHelper.loadSingle((Object)dblink, (String)"isc_database_link", (String)"server_ip,server_port,http_protocal,database_type,web_app");
        this.getModel().setValue("ip", (Object)cfg.getString("server_ip"));
        this.getModel().setValue("port", (Object)cfg.getString("server_port"));
        String databaseType = cfg.getString("database_type");
        this.initSpeedTestBtnVisible(databaseType);
        ConnectionFactory factory = DatabaseType.get((String)databaseType);
        if (factory instanceof HttpConnectionFactory) {
            this.getModel().setValue("url", (Object)((HttpConnectionFactory)factory).getHttpURL(cfg));
        }
    }

    private void initSpeedTestBtnVisible(String databaseType) {
        if ("eas".equals(databaseType) || "ierp".equals(databaseType) || "db_proxy".equals(databaseType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_SPEED_TEST});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SPEED_TEST});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (OP_CHECK_PING.equals(operateKey) || OP_CHECK_TELNET.equals(operateKey) || OP_CHECK_CURL.equals(operateKey) || OP_SPEED_TEST.equals(operateKey)) {
            try {
                this.handleCommand(args);
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u7f51\u7edc\u68c0\u67e5\u51fa\u9519", (String)"CheckNetworkFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ShowStackTraceUtil.getErrorMsg(e));
            }
        }
    }

    private void handleCommand(AfterDoOperationEventArgs args) {
        String ip = D.s((Object)this.getModel().getValue("ip"));
        String url = D.s((Object)this.getModel().getValue("url"));
        int port = D.i((Object)this.getModel().getValue("port"));
        long dblinkId = D.l((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        String operateKey = args.getOperateKey();
        this.frontCheck(ip, url, port, operateKey, dblinkId);
        this.reset();
        IPageCache pageCache = this.getPageCache();
        CheckNetworkThreadPool.start((CheckNetWorkThread)new CheckNetWorkThread(ip, port, url, pageCache, operateKey, dblinkId));
    }

    private void frontCheck(String ip, String url, int port, String operateKey, long dbLinkId) {
        if (OP_CHECK_PING.equals(operateKey)) {
            if (StringUtil.isEmpty((String)ip)) {
                throw new IscBizException(ResManager.loadKDString((String)"ip\u6216\u57df\u540d\u4e3a\u7a7a", (String)"CheckNetworkFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        } else if (OP_CHECK_TELNET.equals(operateKey)) {
            if (StringUtil.isEmpty((String)ip)) {
                throw new IscBizException(ResManager.loadKDString((String)"ip\u6216\u57df\u540d\u4e3a\u7a7a", (String)"CheckNetworkFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            if (port <= 0) {
                throw new IscBizException(ResManager.loadKDString((String)"\u7f51\u7edc\u7aef\u53e3\u4e0d\u5408\u6cd5", (String)"CheckNetworkFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        } else if (OP_CHECK_CURL.equals(operateKey)) {
            if (StringUtil.isEmpty((String)url)) {
                throw new IscBizException(ResManager.loadKDString((String)"curl\u68c0\u67e5\u65f6url\u4e0d\u80fd\u4e3a\u7a7a", (String)"CheckNetworkFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        } else if (dbLinkId <= 0L && OP_SPEED_TEST.equals(operateKey)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u7f51\u901f\u68c0\u6d4b\u5fc5\u987b\u9009\u4e2d\u4e00\u4e2a\u8fde\u63a5\u914d\u7f6e", (String)"CheckNetworkFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void reset() {
        this.getView().setEnable(Boolean.FALSE, new String[]{BTN_CANCEL, BTN_OK, BTN_CURL, BTN_SPEED_TEST});
        this.getModel().setValue(CHECK_RESULT, (Object)"");
        this.getPageCache().put(CHECK_RESULT, null);
        this.getPageCache().put(COUNT, "1");
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressBar.setPercent(0, ResManager.loadKDString((String)"\u68c0\u67e5\u8fdb\u5ea6", (String)"CheckNetworkFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        progressBar.start();
    }

    public void onProgress(ProgressEvent progressEvent) {
        if (!StringUtil.isEmpty((String)this.getPageCache().get(CHECK_RESULT))) {
            progressEvent.setProgress(100);
            progressEvent.setText(ResManager.loadKDString((String)"\u6d4b\u8bd5\u5b8c\u6210", (String)"CheckNetworkFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(CHECK_RESULT, (Object)this.getPageCache().get(CHECK_RESULT));
            this.getView().setEnable(Boolean.TRUE, new String[]{BTN_CANCEL, BTN_OK, BTN_CURL, BTN_SPEED_TEST});
            progressEvent.setProgress(0);
        } else {
            int count = D.i((Object)this.getPageCache().get(COUNT)) + 1;
            int progress = Math.min(99, (int)(Math.atan((double)count / 12.0) * 105.0));
            progressEvent.setProgress(progress);
            this.getPageCache().put(COUNT, String.valueOf(count));
        }
    }
}

