/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.ReflectionUtil;

public class ConnectionTypeChooseFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
SearchEnterListener,
PagerClickListener {
    private static final String BILLLISTAP = "billlistap";
    private static final String ENTRYENTITY = "entryentity";
    private static final String DOMAIN = "domain";
    private static final String LOGO = "logo";
    private static final String LOCALHOST = "localhost";
    private static final List<String> filterList = Arrays.asList("A", "B", "C", "D", "E", "G", "H", "I", "J", "K", "L", "M");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
            billList.addPagerClickListener((PagerClickListener)this);
            Search search = (Search)this.getControl("searchap");
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        if ("show_all".equals(prop)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            this.setFilter(billList);
            this.reloadBillList(billList);
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private void setFilter(BillList billList) {
        billList.getFilterParameter().getQFilters().clear();
        billList.getFilterParameter().getQFilters().add(this.getSearchFilter());
        billList.getFilterParameter().getQFilters().add(this.getEnableFilter());
    }

    public void search(SearchEnterEvent evt) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        this.setFilter(billList);
        this.reloadBillList(billList);
        this.getView().updateView(ENTRYENTITY);
    }

    private QFilter getEnableFilter() {
        if (D.x((Object)this.getModel().getValue("show_all"))) {
            return null;
        }
        return new QFilter("enable", "=", (Object)"1");
    }

    private QFilter getSearchFilter() {
        Search search = (Search)this.getControl("searchap");
        if (search != null && StringUtils.isNotEmpty((CharSequence)search.getSearchKey())) {
            return new QFilter("name", "ilike", (Object)("%" + search.getSearchKey() + "%")).or(new QFilter("number", "ilike", (Object)("%" + search.getSearchKey() + "%")));
        }
        return null;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (evt.getRowIndex() >= 0) {
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
            String type = ((DynamicObject)collection.get(evt.getRowIndex())).getString("typenumber");
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            this.setFilter(billList);
            this.setDomainFilter(type, billList);
            this.getView().getPageCache().put("Domain", type);
            this.reloadBillList(billList);
        }
    }

    private void setDomainFilter(String type, BillList billList) {
        if (Domain.F == Domain.valueOf(type)) {
            billList.getFilterParameter().getQFilters().add(new QFilter(DOMAIN, "not in", filterList));
        } else if (Domain.SS != Domain.valueOf(type)) {
            billList.getFilterParameter().getQFilters().add(new QFilter(DOMAIN, "=", (Object)Domain.valueOf(type)));
        }
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        this.setFilter(billList);
        String type = D.s((Object)this.getView().getPageCache().get("Domain"));
        if (type != null) {
            this.setDomainFilter(type, billList);
        }
        this.reloadBillList(billList);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDomainGroup();
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.setRowSort("index", 1);
        this.doOtherSetting();
    }

    private void doOtherSetting() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (D.x(params.get("is_guide_mode"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        }
    }

    private void initDomainGroup() {
        DynamicObjectCollection entry_dc = this.getModel().getEntryEntity(ENTRYENTITY);
        entry_dc.clear();
        List<Object> list = Arrays.asList((Object[])Domain.values().clone());
        list.sort((Comparator<Object>)new Comparator<Domain>(){

            @Override
            public int compare(Domain o1, Domain o2) {
                return o1.getIndex() - o2.getIndex();
            }
        });
        for (Domain domain : list) {
            DynamicObject obj = entry_dc.addNew();
            obj.set("typename", (Object)domain.getName());
            obj.set("typenumber", (Object)domain);
        }
        this.getView().updateView(ENTRYENTITY);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        if ("next".equals(eventArgs.getOperateKey())) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection listSelectedRowCollection = billList.getSelectedRows();
            if (listSelectedRowCollection.size() == 1) {
                this.showDataBaseLinkForm(listSelectedRowCollection);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u79cd\u8fde\u63a5\u7c7b\u578b\u3002", (String)"ConnectionTypeChooseFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void reloadBillList(BillList billList) {
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)new MyListDataProvider());
        billList.setRowSort("index", 1);
        this.getView().updateView(BILLLISTAP);
    }

    private void showDataBaseLinkForm(ListSelectedRowCollection listSelectedRowCollection) {
        Object pk = listSelectedRowCollection.get(0).getPrimaryKeyValue();
        DynamicObject cnType = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (String)"id,enable,permit,factory_class", (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
        if (!this.checkConnectionType(cnType)) {
            return;
        }
        String number = listSelectedRowCollection.get(0).getNumber();
        if (!"1".equals(cnType.getString("enable"))) {
            String tips = ResManager.loadKDString((String)"\u8be5\u8fde\u63a5\u7c7b\u578b\u662f\u7981\u7528\u72b6\u6001\uff0c\u662f\u5426\u542f\u7528\uff1f", (String)"ConnectionTypeFormPlugin_37", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("enableCnType", (IFormPlugin)this);
            this.getView().showConfirm(tips, null, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, null, D.s((Object)pk));
        } else {
            this.showDataBaseLinkForm(pk, number);
        }
    }

    private void showDataBaseLinkForm(Object pk, String number) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("number", number);
        params.put("dum_link", pk);
        FormOpener.buildOpenFormParam(this.getView(), params, "source_app", "autoCreateIscxConnector", "autoCreateDataSource");
        BillShowParameter param = new BillShowParameter();
        param.setFormId(DatabaseType.getForm((String)number));
        param.getOpenStyle().setShowType(ShowType.InCurrentForm);
        param.setStatus(OperationStatus.ADDNEW);
        param.setCustomParams(params);
        param.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        this.getView().showForm((FormShowParameter)param);
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String cnTypeId;
        if ("enableCnType".equals(evt.getCallBackId()) && (cnTypeId = evt.getCustomVaule()) != null) {
            DynamicObject cnType = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)evt.getCustomVaule())});
            if (evt.getResult() == MessageBoxResult.Yes) {
                ConnectorUtil.enable((DynamicObject)cnType);
                DatabaseType.resetEnvironment();
            }
            this.showDataBaseLinkForm(cnType.getString("id"), cnType.getString("number"));
        }
    }

    private boolean checkConnectionType(DynamicObject obj) {
        if (!obj.getString("permit").contains("INSERT")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8fde\u63a5\u7c7b\u578b\u6ca1\u6709\u65b0\u589e\u7684\u6743\u9650\u3002", (String)"ConnectionTypeChooseFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        try {
            String className = D.s((Object)obj.get("factory_class"));
            ReflectionUtil.getClass((String)className);
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u79c1\u6709\u4e91\u624d\u53ef\u4ee5\u4f7f\u7528\u8be5\u8fde\u63a5\u7c7b\u578b\uff0c\u4f7f\u7528\u4e4b\u524d\u9700\u8981\u5148\u90e8\u7f72\u4f9d\u8d56\u7684\u5b89\u88c5\u5305\uff0c\u8bf7\u8054\u7cfb\u96c6\u6210\u670d\u52a1\u4e91\u4ea7\u54c1\u56e2\u961f\u83b7\u53d6\u652f\u6301\u3002", (String)"ConnectionTypeChooseFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)new MyListDataProvider());
    }

    static enum Domain {
        SS(1, new MultiLangEnumBridge("\u5168\u90e8", "ConnectionTypeChooseFormPlugin_3", "isc-iscb-platform-formplugin")),
        A(3, new MultiLangEnumBridge("\u8d22\u52a1/\u8d44\u6e90\u7ba1\u7406\uff08ERP\uff09", "ConnectionTypeChooseFormPlugin_5", "isc-iscb-platform-formplugin")),
        B(4, new MultiLangEnumBridge("\u5ba2\u6237\u5173\u7cfb\u7ba1\u7406\uff08CRM\uff09", "ConnectionTypeChooseFormPlugin_6", "isc-iscb-platform-formplugin")),
        C(7, new MultiLangEnumBridge("\u534f\u540c\u529e\u516c\u7ba1\u7406", "ConnectionTypeChooseFormPlugin_7", "isc-iscb-platform-formplugin")),
        D(6, new MultiLangEnumBridge("\u7535\u5546\u7269\u6d41", "ConnectionTypeChooseFormPlugin_8", "isc-iscb-platform-formplugin")),
        E(15, new MultiLangEnumBridge("\u793e\u4ea4\u5a92\u4f53", "ConnectionTypeChooseFormPlugin_9", "isc-iscb-platform-formplugin")),
        F(12, new MultiLangEnumBridge("\u5de5\u5177\u670d\u52a1\u8f6f\u4ef6", "ConnectionTypeChooseFormPlugin_10", "isc-iscb-platform-formplugin")),
        G(8, new MultiLangEnumBridge("\u90ae\u4ef6/\u4fe1\u606f\u6536\u53d1\u670d\u52a1", "ConnectionTypeChooseFormPlugin_11", "isc-iscb-platform-formplugin")),
        H(9, new MultiLangEnumBridge("\u4eba\u529b\u8d44\u6e90\u7ba1\u7406", "ConnectionTypeChooseFormPlugin_18", "isc-iscb-platform-formplugin")),
        I(2, new MultiLangEnumBridge("\u91d1\u8776\u4e13\u533a", "ConnectionTypeChooseFormPlugin_12", "isc-iscb-platform-formplugin")),
        J(13, new MultiLangEnumBridge("\u5f00\u53d1\u8005\u7cfb\u7edf", "ConnectionTypeChooseFormPlugin_4", "isc-iscb-platform-formplugin")),
        K(5, new MultiLangEnumBridge("\u4f9b\u5e94\u5546\u5173\u7cfb\u7ba1\u7406\uff08SRM\uff09", "ConnectionTypeChooseFormPlugin_13", "isc-iscb-platform-formplugin")),
        L(10, new MultiLangEnumBridge("AI\u4eba\u5de5\u667a\u80fd", "ConnectionTypeChooseFormPlugin_14", "isc-iscb-platform-formplugin")),
        M(11, new MultiLangEnumBridge("\u5e02\u573a\u8425\u9500\u7ba1\u7406", "ConnectionTypeChooseFormPlugin_15", "isc-iscb-platform-formplugin")),
        N(14, new MultiLangEnumBridge("\u6570\u636e\u5e93\u7ba1\u7406", "ConnectionTypeChooseFormPlugin_19", "isc-iscb-platform-formplugin"));

        private final MultiLangEnumBridge name;
        private final int index;

        private Domain(int index, MultiLangEnumBridge name) {
            this.name = name;
            this.index = index;
        }

        public String getName() {
            return this.name.loadKDString();
        }

        public int getIndex() {
            return this.index;
        }
    }

    static class MyListDataProvider
    extends ListDataProvider
    implements CreateListDataProviderListener {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty() || !((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)ConnectionTypeChooseFormPlugin.LOGO)) {
                return rows;
            }
            this.setLogoField(rows);
            return rows;
        }

        private void setLogoField(DynamicObjectCollection rows) {
            String url = UrlService.getDomainContextUrl().replace(ConnectionTypeChooseFormPlugin.LOCALHOST, NetUtil.getLocalAddress());
            for (DynamicObject row : rows) {
                String logo = D.s((Object)row.get(ConnectionTypeChooseFormPlugin.LOGO));
                logo = logo != null ? logo : "default_logo.png";
                row.set(ConnectionTypeChooseFormPlugin.LOGO, (Object)(url + "/kingdee/isc/connection_type_logo/" + logo));
                String domain = D.s((Object)row.get(ConnectionTypeChooseFormPlugin.DOMAIN));
                row.set(ConnectionTypeChooseFormPlugin.DOMAIN, domain != null ? domain : Domain.F);
            }
        }

        public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
            BillList list = (BillList)args.getSource();
            list.getEntryState().setPageRows(21);
            args.setListDataProvider((IListDataProvider)this);
        }
    }
}

