/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.isc.iscb.formplugin.dc.ConnectionTypeChooseFormPlugin;
import kd.isc.iscb.formplugin.util.ExportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.imp.JarResourceImportJob;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.solution.UpdateCloudCnTypeJob;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.misc.SystemContext;

public class ConnectionTypeListPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper = (AbstractOperate)args.getSource();
        String operateKey = oper.getOperateKey();
        String entityId = oper.getEntityId();
        if ("delete".equals(operateKey)) {
            this.delete(args, entityId);
        } else if ("enable".equals(operateKey) || "disable".equals(operateKey)) {
            List<DataRow> icMetas = this.getIcMetas(args, entityId);
            if (icMetas.size() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b2c\u4e09\u65b9\u63a5\u53e3\u53d1\u5e03\u5230\u96c6\u6210\u7ba1\u7406\u7684\u8fde\u63a5\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u542f\u7528/\u7981\u7528\u3002", (String)"ConnectionTypeListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("update_cloud_res".equals(operateKey) && SystemContext.isProcEnv()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u4ea7\u73af\u5883\u4e0d\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"ConnectionTypeListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataRow> getIcMetas(BeforeDoOperationEventArgs args, String entityId) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        Object[] pks = listSelectedData.getPrimaryKeyValues();
        QFilter filter = new QFilter("id", "in", (Object)pks);
        DynamicObject[] config_forms = BusinessDataServiceHelper.load((String)entityId, (String)"config_form", (QFilter[])new QFilter[]{filter});
        int length = config_forms.length;
        ArrayList<Object> values = new ArrayList<Object>(length);
        ArrayList<Integer> types = new ArrayList<Integer>(length);
        String sql = this.getSql(config_forms, length, values, types);
        List<Object> metas = new ArrayList<DataRow>();
        if (values.size() > 0) {
            Connection cn = TX.getConnection((String)"sys.meta", (boolean)true, (String[])new String[0]);
            try {
                metas = DbUtil.executeList((Connection)cn, (String)sql, values, types);
            }
            finally {
                DbUtil.close((Connection)cn);
            }
        }
        return metas;
    }

    private String getSql(DynamicObject[] config_forms, int length, List<Object> values, List<Integer> types) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT fid FROM t_meta_formdesign WHERE FPARENTID = (SELECT top 1 fid FROM t_meta_formdesign WHERE FNUMBER = 'isc_cn_config') AND fnumber in (");
        for (int i = 0; i < length; ++i) {
            sql.append('?');
            values.add(config_forms[i].getString("config_form"));
            types.add(12);
            if (i >= length - 1) continue;
            sql.append(',');
        }
        sql.append(')');
        return sql.toString();
    }

    private void delete(BeforeDoOperationEventArgs args, String entityId) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        Object[] pks = listSelectedData.getPrimaryKeyValues();
        QFilter filter = new QFilter("id", "in", (Object)pks).and("preset", "=", (Object)"1");
        DynamicObject[] cnTypes = BusinessDataServiceHelper.load((String)entityId, (String)"preset", (QFilter[])new QFilter[]{filter});
        if (cnTypes.length > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u8fde\u63a5\u7c7b\u578b\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ConnectionTypeListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String entityId = operate.getEntityId();
        if ("exporttype".equals(operationKey)) {
            List pkIds = evt.getOperationResult().getSuccessPkIds();
            ExportUtil.exportDts((AbstractFormPlugin)this, pkIds, entityId);
        } else if ("importtype".equals(operationKey)) {
            FormOpener.openImportForm((IFormPlugin)this, this.getView(), entityId);
        } else if ("exportzip".equals(operationKey)) {
            ExportUtil.exportZip((AbstractFormPlugin)this, evt, entityId);
        } else if ("enable".equals(operationKey)) {
            DatabaseType.resetEnvironment();
        } else if ("rebuild".equals(operationKey)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u66f4\u65b0\u6240\u6709\u7684\u9884\u7f6e\u8fde\u63a5\u7c7b\u578b\uff0c\u662f\u5426\u66f4\u65b0\uff1f", (String)"ConnectionTypeListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("updateLinkType", (IFormPlugin)this));
        } else if ("update_cloud_res".equals(operationKey)) {
            this.updateConnectionType();
        } else if ("show_history".equals(operationKey)) {
            Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, evt);
            if (id != null) {
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_connection_type", (String)"number");
                FormOpener.openBillList((AbstractFormPlugin)this, "isc_operation_log", Collections.singletonList(new QFilter("number", "=", object.get("number"))), ResManager.loadKDString((String)"\u64cd\u4f5c\u65e5\u5fd7", (String)"ConnectionTypeListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        } else if ("guide_new".equals(operationKey)) {
            FormOpener.showTabForm((AbstractFormPlugin)this, "isc_conn_guide", new HashMap());
        }
    }

    private void updateConnectionType() {
        UpdateCloudCnTypeJob updateJob = new UpdateCloudCnTypeJob(ResManager.loadKDString((String)"\u66f4\u65b0\u4e91\u7aef\u8d44\u6e90", (String)"ConnectionTypeListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "update_cloud_cn_type");
        List jobs = JobEngine.getJobsWithOwnerId((long)updateJob.getOwnerId());
        if (jobs.isEmpty()) {
            FormOpener.startJob((AbstractFormPlugin)this, (Job)updateJob, "update_cloud_cn_type");
        } else {
            FormOpener.reopenJob((AbstractFormPlugin)this, ((JobInfo)jobs.get(0)).getId(), updateJob.getTitle(), "update_cloud_cn_type");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("updateLinkType".equals(evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            JarResourceImportJob job = new JarResourceImportJob(ResManager.loadKDString((String)"\u66f4\u65b0\u9884\u7f6e\u8fde\u63a5\u7c7b\u578b", (String)"ConnectionTypeListPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "isc/iscb/connector");
            List jobs = JobEngine.getJobsWithOwnerId((long)job.getOwnerId());
            if (jobs.isEmpty()) {
                FormOpener.startJob((AbstractFormPlugin)this, (Job)job);
            } else {
                FormOpener.reopenJob((AbstractFormPlugin)this, ((JobInfo)jobs.get(0)).getId(), job.getTitle());
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        FormOpener.showTabView((AbstractFormPlugin)this, "isc_connection_type", args);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"iscExportTaskCloseCallBack")) {
            ExportUtil.iscExportTaskCallBack((AbstractFormPlugin)this, evt.getReturnData());
        }
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty() || !((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"logo")) {
                return rows;
            }
            this.setLogoField(rows);
            return rows;
        }

        private void setLogoField(DynamicObjectCollection rows) {
            String url = UrlService.getDomainContextUrl().replace("localhost", NetUtil.getLocalAddress());
            for (DynamicObject row : rows) {
                String logo = D.s((Object)row.get("logo"));
                logo = logo != null ? logo : "default_logo.png";
                row.set("logo", (Object)(url + "/kingdee/isc/connection_type_logo/" + logo));
                String domain = D.s((Object)row.get("domain"));
                row.set("domain", domain != null ? domain : ConnectionTypeChooseFormPlugin.Domain.F);
            }
        }
    }
}

