/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.CssSetter;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class ConnectorPermitFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SCHEMA = "schema";
    private static final String DB_LINK = "dblink";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object dblink = this.getView().getFormShowParameter().getCustomParam(DB_LINK);
        if (dblink != null && !StringUtil.isEmpty((String)dblink.toString())) {
            this.getPageCache().put(DB_LINK, D.s((Object)dblink));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (SCHEMA.equals(e.getProperty().getName())) {
            DynamicObject schema = (DynamicObject)this.getModel().getValue(SCHEMA);
            if (schema != null) {
                Object dataSourceId = schema.get("group_id");
                DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source", (String)"dblink.id,dblink.name,dblink.number,masterid,name,number");
                this.getModel().setValue("data_source", (Object)dataSource);
            } else {
                this.getModel().setValue("data_source", null);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit schema = (BasedataEdit)this.getView().getControl(SCHEMA);
        schema.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (SCHEMA.equals(evt.getProperty().getName())) {
            CssSetter.setF7WindowSize(evt);
            String dbLink = this.getPageCache().get(DB_LINK);
            if (!StringUtil.isEmpty((String)dbLink)) {
                QFilter filter = new QFilter("group.dblink_id", "=", (Object)D.l((Object)dbLink));
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
    }
}

