/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.formplugin.dc.DataCopyExecutionListPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.DataCopyTrigger;
import kd.isc.iscb.platform.core.connector.self.ProxyUserUtil;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.e.DataCopyDebugger;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.util.DataTypeEqualsUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.trace.TraceTask;

public class DataCopyExecutionFormPlugin
extends AbstractFormPlugin {
    private static final String OP_EXECUTE = "execute";
    private static final String ISC_DATA_COPY_EXECUTION = "isc_data_copy_execution";
    private static final String PARAMS_ENTRYENTITY = "params_entryentity";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String STATE = "state";
    private static final String OP_SHOW_LOGS = "show_logs";
    private static final String REDO = "redo";
    private static final String CREATOR_REDO = "creator_redo";
    private static final String FAILSTATE = "F";
    private static final String DATA_COPY_TRIGGER_ID = "data_copy_trigger_id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterBindData(EventObject e) {
        BillShowParameter billShowParameter;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map params = parameter.getCustomParams();
        if (params != null && params.containsKey("triggerId")) {
            DataCopyDebugger.setDebug((boolean)D.x((Object)this.getView().getFormShowParameter().getCustomParam("#DEBUG")));
            try {
                this.initModel(params);
            }
            finally {
                DataCopyDebugger.unsetDebug();
            }
        }
        if ((billShowParameter = (BillShowParameter)this.getView().getFormShowParameter()).getBillStatus().equals((Object)BillOperationStatus.EDIT) || billShowParameter.getBillStatus().equals((Object)BillOperationStatus.VIEW)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnexecute"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_refresh", OP_SHOW_LOGS, "time_analysis"});
        }
        this.setHostIp();
        this.setHidden();
        this.setShowTsLogVisible();
        super.afterBindData(e);
    }

    private void setShowTsLogVisible() {
        long triggerId = D.l((Object)this.getModel().getValue(DATA_COPY_TRIGGER_ID));
        if (triggerId > 0L) {
            DynamicObject trigger = DataCopyTrigger.get((long)triggerId);
            String timestampField = D.s((Object)trigger.get("timestamp_field"));
            this.getView().setVisible(Boolean.valueOf(timestampField != null), new String[]{"show_tslogs"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"show_tslogs"});
        }
    }

    private void setHostIp() {
        DynamicObject instance;
        String host = D.s((Object)this.getModel().getValue("host"));
        if (host != null && (instance = QueryServiceHelper.queryOne((String)"isc_server_instance", (String)"ip", (QFilter[])new QFilter[]{new QFilter("instance_id", "=", (Object)host)})) != null) {
            this.getModel().setValue("host", instance.get("ip"));
        }
    }

    private void setHidden() {
        String state = D.s((Object)this.getModel().getValue(STATE));
        if (!FAILSTATE.equals(state)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_redo"});
        }
    }

    private void initModel(Map<String, Object> params) {
        IDataModel model = this.getModel();
        DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)params.get("triggerId"), (String)"isc_data_copy_trigger");
        DynamicObject dataCopy = trigger.getDynamicObject("data_copy");
        String number = DataCopyTask.generateExecutionNumber((DynamicObject)trigger);
        model.setValue(NUMBER, (Object)number);
        model.setValue(NAME, trigger.get(NAME));
        model.setValue("data_copy_trigger", trigger.getPkValue());
        model.setValue("data_copy_schama", dataCopy.getPkValue());
        model.setValue(STATE, (Object)"C");
        model.setValue(PARAMS_ENTRYENTITY, (Object)DataCopyTask.createParams((DynamicObject)trigger, (DynamicObject)this.getModel().getDataEntity(), params));
        model.setValue("callback_info", (Object)trigger.getString("callback_info"));
        model.setValue("real_source_system", (Object)DataCopyTask.getRealSourceSystem((DynamicObject)trigger));
        model.setValue("real_target_system", (Object)DataCopyTask.getRealTargetSystem((DynamicObject)trigger));
        model.setValue("job_mutex", trigger.get("job_mutex"));
        this.getView().updateView(PARAMS_ENTRYENTITY);
        this.getModel().updateCache();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        IDataModel model;
        Long id;
        super.beforeDoOperation(e);
        if (!(e.getSource() instanceof Donothing)) {
            return;
        }
        Donothing donothing = (Donothing)e.getSource();
        if (donothing.getOperateKey().equals("refresh2") && (id = (Long)(model = this.getModel()).getValue("id")) != 0L) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_DATA_COPY_EXECUTION);
            model.setValue(STATE, obj.get(STATE));
            model.setValue("start_time", obj.get("start_time"));
            model.setValue("end_time", obj.get("end_time"));
            model.setValue("total_count", obj.get("total_count"));
            model.setValue("success_count", obj.get("success_count"));
            model.setValue("failed_count", obj.get("failed_count"));
            model.setValue("ignored_count", obj.get("ignored_count"));
            model.setValue("prepare_time", obj.get("prepare_time"));
            model.setValue("read_time", obj.get("read_time"));
            model.setValue("convert_time", obj.get("convert_time"));
            model.setValue("load_time", obj.get("load_time"));
            model.setValue("read_bytes", obj.get("read_bytes"));
            model.setValue("load_bytes", obj.get("load_bytes"));
            model.setValue("modifytime", obj.get("modifytime"));
            model.setValue("thread_count", obj.get("thread_count"));
            model.setValue("host", obj.get("host"));
            model.setValue("batch_size", obj.get("batch_size"));
            model.setValue("source_data", obj.get("source_data"));
            model.setValue("source_data_tag", obj.get("source_data_tag"));
            model.setValue("exec_time", obj.get("exec_time"));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if (StringUtils.equals((CharSequence)OP_EXECUTE, (CharSequence)operationKey)) {
            IDataModel model = this.getModel();
            model.setValue("status", (Object)"C");
            model.setValue("enable", (Object)"1");
            this.checkAndExecute();
        } else if (StringUtils.equals((CharSequence)OP_SHOW_LOGS, (CharSequence)operationKey)) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map params = parameter.getCustomParams();
            FormOpener.showListWithParam((AbstractFormPlugin)this, "isc_data_copy_exec_log", "data_copy_execution", evt, (Map<String, Object>)params);
        } else if (StringUtils.equals((CharSequence)REDO, (CharSequence)operationKey)) {
            this.redo(evt);
        } else if (StringUtils.equals((CharSequence)CREATOR_REDO, (CharSequence)operationKey)) {
            this.creatorRedo(evt);
        } else if ("time_analysis".equals(operationKey)) {
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("id", this.getModel().getValue("id"));
            FormOpener.showTabForm(this, "isc_exectime_analysis", null, param, null);
        } else if ("show_tslogs".equals(operationKey)) {
            this.showTimeStampLog(evt);
        } else if ("view_stack_trace".equals(operationKey)) {
            long id = D.l((Object)this.getModel().getValue("id"));
            QFilter filter = new QFilter("job_owner", "=", this.getModel().getValue("id"));
            DynamicObject dataEntity = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_job_inst", (String)"id", (QFilter[])new QFilter[]{filter});
            if (dataEntity == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u540e\u53f0\u4efb\u52a1id:%s\uff0c\u5df2\u7ecf\u4e22\u5931\u3002", (String)"ProcessInstListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), id));
            }
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put("view_stack_trace", Boolean.TRUE);
            FormOpener.showView((AbstractFormPlugin)this, "isc_job_inst", (Object)dataEntity.getLong("id"), params);
        }
    }

    private void showTimeStampLog(AfterDoOperationEventArgs e) {
        FormOpener.showList((AbstractFormPlugin)this, "isc_data_ts_log", "task", e);
    }

    public void checkAndExecute() {
        StringBuilder messages = new StringBuilder();
        DynamicObjectCollection c = this.getModel().getEntryEntity(PARAMS_ENTRYENTITY);
        for (DynamicObject o : c) {
            String name = o.getString("params_name");
            String dataType = o.getString("params_data_type");
            String value = o.getString("params_value");
            String label = o.getString("params_label");
            if (StringUtil.isEmpty((String)value)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53c2\u6570%1$s\u3010%2$s\u3011\u4e3a\u7a7a!", (String)"DataCopyExecutionFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), label, name));
                return;
            }
            if (value.trim().equals("*") || DataTypeEqualsUtil.isMatchType((String)value, (String)dataType)) continue;
            messages.append(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"DataCopyExecutionFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(name).append(ResManager.loadKDString((String)"\u503c\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"DataCopyExecutionFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        String valid = messages.toString();
        if (!StringUtil.isEmpty((String)valid)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(OP_EXECUTE, (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f\u5b57\u6bb5\u503c\u6216\u7c7b\u578b\u4e0d\u5339\u914d\uff1a%s", (String)"DataCopyExecutionFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), valid), MessageBoxOptions.YesNo, confirmCallBacks);
        } else {
            this.execute();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)OP_EXECUTE, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.execute();
        }
    }

    public void execute() {
        this.getModel().setValue("execute_count", (Object)0);
        TraceStack.trace((Caller)Caller.Front, (TraceTask)new TraceTask(){

            public void run() {
                DataCopyExecutionFormPlugin.this.innerExecute();
            }
        });
    }

    private void innerExecute() {
        final DynamicObject job = this.getModel().getDataEntity(true);
        job.set("id", (Object)IDService.get().genLongId());
        OperationResult result = (OperationResult)TraceStack.run((TraceType)TraceType.NEW_DCE, (DynamicObject)job, (TraceTask)new TraceTask(){

            public Object invoke() {
                return OperationServiceHelper.executeOperate((String)"save", (String)DataCopyExecutionFormPlugin.ISC_DATA_COPY_EXECUTION, (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
            }
        });
        if (result.isSuccess() && result.getSuccessPkIds().size() > 0) {
            DynamicObject execution = BusinessDataServiceHelper.loadSingle(result.getSuccessPkIds().get(0), (String)ISC_DATA_COPY_EXECUTION);
            DynamicObject trigger = execution.getDynamicObject("data_copy_trigger");
            DataCopyTask.refreshTriggerInfo((DynamicObject)trigger);
            DataCopyTask.start((DynamicObject)execution);
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_refresh", OP_SHOW_LOGS, "time_analysis"});
            if (DataCopyDebugger.isDebug((String)D.s((Object)this.getModel().getValue(NUMBER)))) {
                FormOpener.showAppIdTabForm(this, "isc_script_debugger", ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u8c03\u8bd5", (String)"DataCopyTriggerListPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new HashMap<String, Object>());
            }
        }
    }

    private void redo(AfterDoOperationEventArgs e) {
        for (Object id : e.getOperationResult().getSuccessPkIds()) {
            final DynamicObject execution = BusinessDataServiceHelper.loadSingle(id, (String)ISC_DATA_COPY_EXECUTION);
            if (DataCopyExecutionListPlugin.isTriggerRunning(execution.getLong(DATA_COPY_TRIGGER_ID))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u6709\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5.", (String)"DataCopyExecutionFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            execution.set(STATE, (Object)"C");
            execution.set("total_count", (Object)-1);
            execution.set("success_count", (Object)-1);
            execution.set("failed_count", (Object)-1);
            OperationServiceHelper.executeOperate((String)"save", (String)ISC_DATA_COPY_EXECUTION, (DynamicObject[])new DynamicObject[]{execution}, (OperateOption)OperateOption.create());
            TraceStack.trace((Caller)Caller.Front, (long)TraceStack.getTraceId((long)D.l(id)), (TraceTask)new TraceTask(){

                public void run() {
                    DataCopyTask.start((DynamicObject)execution, (boolean)false);
                }
            });
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u9875\u9762\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"DataCopyExecutionFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void creatorRedo(AfterDoOperationEventArgs e) {
        for (Object id : e.getOperationResult().getSuccessPkIds()) {
            final DynamicObject execution = BusinessDataServiceHelper.loadSingle(id, (String)ISC_DATA_COPY_EXECUTION);
            if (DataCopyExecutionListPlugin.isTriggerRunning(execution.getLong(DATA_COPY_TRIGGER_ID))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u6709\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5.", (String)"DataCopyExecutionFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            execution.set(STATE, (Object)"C");
            execution.set("total_count", (Object)-1);
            execution.set("success_count", (Object)-1);
            execution.set("failed_count", (Object)-1);
            OperationServiceHelper.executeOperate((String)"save", (String)ISC_DATA_COPY_EXECUTION, (DynamicObject[])new DynamicObject[]{execution}, (OperateOption)OperateOption.create());
            RequestContext currentContext = RequestContext.get();
            try {
                RequestContextCreator.restoreForMQ((RequestContext)ProxyUserUtil.createRequestContext((RequestContext)currentContext, (String)execution.getDynamicObject("creator").getPkValue().toString()));
                TraceStack.trace((Caller)Caller.Front, (long)TraceStack.getTraceId((long)D.l(id)), (TraceTask)new TraceTask(){

                    public void run() {
                        DataCopyTask.start((DynamicObject)execution, (boolean)false);
                    }
                });
            }
            finally {
                RequestContextCreator.restoreForMQ((RequestContext)currentContext);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u63d0\u4ea4\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u9875\u9762\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"DataCopyExecutionFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }
}

