/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.export.ExecLogTxtDownload;
import kd.isc.iscb.formplugin.export.ExecLogXlsDownload;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.PortalFilterSettingUtil;
import kd.isc.iscb.platform.core.connector.self.ProxyUserUtil;
import kd.isc.iscb.platform.core.constant.CommonConstants;
import kd.isc.iscb.platform.core.dc.e.ExecutionLogRedoJob;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class DataCopyExecutionLogListPlugin
extends AbstractListPlugin
implements FilterContainerInitListener {
    private static Log logger = LogFactory.getLog(DataCopyExecutionLogListPlugin.class);
    private static final String RETRY = "retry";
    private static final String CREATOR_REDO = "creator_redo";
    private static final String INVALID = "invalid";

    public void setFilter(SetFilterEvent e) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (null != filterContainer) {
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        PortalFilterSettingUtil.hiddenFilter(args);
        this.filterContainerInit(args.getFilterContainerInitEvent());
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object timeValue = params.get("execution_time_filter");
        if (timeValue instanceof List) {
            List defaultValues = (List)timeValue;
            List columnList = filterContainerInitEvent.getCommonFilterColumns();
            for (FilterColumn filterColumn : columnList) {
                String fieldName = filterColumn.getFieldName();
                if (!"created_time".equals(fieldName)) continue;
                filterColumn.setDefaultValues(defaultValues);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("data_copy_execution_number".equals(args.getFieldName())) {
            args.setCancel(true);
            Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
            FormOpener.showStatusBill((AbstractFormPlugin)this, "isc_data_copy_exec_log", selectedId, null, OperationStatus.VIEW, ShowType.MainNewTabPage);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            int size = args.getListSelectedData().size();
            if (INVALID.equals(operate.getOperateKey()) && size > 100) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u8d85\u8fc7100\u884c!", (String)"DataCopyExecutionLogListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if ("download_zip".equals(operate.getOperateKey()) || "download_xls".equals(operate.getOperateKey())) {
                int max = D.i((Object)System.getProperty("isc.allow.max.export", "500"));
                if (size > (max = Math.max(max, 1))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6700\u5927\u652f\u6301%s\u884c\u7684\u5bfc\u51fa\u3002", (String)"DataCopyExecutionLogListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), max));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String op = e.getOperateKey();
        if (e.getOperationResult() != null) {
            List successPkIds = e.getOperationResult().getSuccessPkIds();
            try {
                if (RETRY.equals(op)) {
                    FormOpener.startJob((AbstractFormPlugin)this, (Job)new ExecutionLogRedoJob(successPkIds), "redo_callback");
                } else if (INVALID.equals(op)) {
                    this.invalidOp(successPkIds);
                } else if (CREATOR_REDO.equals(op)) {
                    this.creatorRetry(successPkIds);
                } else if ("download_zip".equals(op)) {
                    this.getView().openUrl(new ExecLogTxtDownload(successPkIds).download());
                } else if ("download_xls".equals(op)) {
                    this.getView().openUrl(new ExecLogXlsDownload(successPkIds).download());
                }
            }
            catch (Exception ex) {
                FormOpener.showErrorMessage(this.getView(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void creatorRetry(List<Object> successPkIds) {
        List<DataRow> list = this.queryCreatorId(successPkIds);
        if (list.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6267\u884c\u65e5\u5fd7\u7684\u53d1\u8d77\u4eba\u4e0d\u552f\u4e00\u3002", (String)"DataCopyExecutionLogListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
        } else {
            RequestContext currentContext = RequestContext.get();
            try {
                RequestContextCreator.restoreForMQ((RequestContext)ProxyUserUtil.createRequestContext((RequestContext)currentContext, (String)D.s((Object)list.get(0).getValue("fcreatorid"))));
                FormOpener.startJob((AbstractFormPlugin)this, (Job)new ExecutionLogRedoJob(successPkIds), "creator_redo_callback");
            }
            finally {
                RequestContextCreator.restoreForMQ((RequestContext)currentContext);
            }
        }
    }

    private List<DataRow> queryCreatorId(List<Object> ids) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
        ArrayList<Object> values = new ArrayList<Object>(ids.size());
        ArrayList<Integer> types = new ArrayList<Integer>(ids.size());
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT E.FCREATORID FROM T_ISC_DATA_COPY_EXECUTION E ");
        sql.append(" INNER JOIN T_ISC_DATA_COPY_EXEC_LOG L ON E.FID = L.FDATA_COPY_EXECUTION WHERE L.FID IN(");
        for (int i = 0; i < ids.size(); ++i) {
            sql.append('?');
            if (i < ids.size() - 1) {
                sql.append(',');
            }
            values.add(ids.get(i));
            types.add(-5);
        }
        sql.append(')');
        return DbUtil.executeList((Connection)cn, (String)sql.toString(), values, types);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("redo_callback".equals(e.getActionId()) || "creator_redo_callback".equals(e.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void invalidOp(List<Object> successPkIds) {
        QFilter[] filters = QFilterUtil.builder().put("state", "!=", (Object)"F").put("id", "in", successPkIds).build();
        List list = QueryServiceHelper.queryPrimaryKeys((String)"isc_data_copy_exec_log", (QFilter[])filters, null, (int)1);
        if (list.size() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u6267\u884c\u72b6\u6001\u4e3a\u201c\u5931\u8d25\u201d\u7684\u6570\u636e\u505a\u5931\u6548\u5904\u7406\u3002", (String)"DataCopyExecutionLogListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder sql = new StringBuilder("UPDATE t_isc_data_copy_exec_log SET fstate='I', fmodify_time = ? WHERE fid in (");
        for (int i = 0; i < successPkIds.size(); ++i) {
            if (i == 0) {
                sql.append('?');
                continue;
            }
            sql.append(",?");
        }
        sql.append(") AND fstate='F'");
        successPkIds.add(0, new Date());
        Object[] params = successPkIds.toArray();
        DB.update((DBRoute)CommonConstants.ISC_DB_ROUTE, (String)sql.toString(), (Object[])params);
        this.getView().invokeOperation("refresh");
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5931\u6548\u6210\u529f\u3002", (String)"DataCopyExecutionLogListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }
}

