/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.common.topology.TopologyFormUtil;
import kd.isc.iscb.formplugin.dc.trigger.DataCopyTriggerListPlugin;
import kd.isc.iscb.formplugin.util.ExportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class DataCopyListPlugin
extends AbstractListPlugin {
    private static final int MAX_UPDATE_SIZE = 500;

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("show_logs".equals(operateKey)) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_data_copy_exec_log", "data_copy_schema", args);
        } else if ("show_executions".equals(operateKey)) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_data_copy_execution", "data_copy_schama", args);
        } else if ("show_taskstage".equals(operateKey)) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_data_copy_taskstage", "data_copy", args);
        } else if ("exportschema".equalsIgnoreCase(operateKey)) {
            List pkIds = args.getOperationResult().getSuccessPkIds();
            ExportUtil.exportDts((AbstractFormPlugin)this, pkIds, "isc_data_copy");
        } else if ("exportzip".equals(operateKey)) {
            ExportUtil.exportZip((AbstractFormPlugin)this, args, "isc_data_copy");
        } else if ("importschema".equalsIgnoreCase(operateKey)) {
            FormOpener.openImportForm((IFormPlugin)this, this.getView(), "isc_data_copy");
        } else if ("show_triggerlist".equalsIgnoreCase(operateKey)) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_data_copy_trigger", "data_copy", args);
        } else if ("create_trigger".equals(operateKey)) {
            Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
            if (null != id) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("data_copy_id", id);
                FormOpener.showTabBill((AbstractFormPlugin)this, "isc_data_copy_trigger", ResManager.loadKDString((String)"\u65b0\u5efa\u542f\u52a8\u65b9\u6848", (String)"DataCopyListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
            }
        } else if ("new".equals(operateKey)) {
            this.createDataCopy();
        } else if ("modify_schema_category".equals(operateKey)) {
            FormOpener.showListForSelected((AbstractFormPlugin)this, "isc_schema_category", ResManager.loadKDString((String)"\u6279\u91cf\u5206\u7c7b", (String)"DataCopyListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new Object[0], Collections.emptyMap(), "modify_schema_category");
        } else if ("topology".equals(operateKey)) {
            this.showTopologyView(args);
        } else if ("data_copy_guide".equals(operateKey)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            FormOpener.showTabForm((AbstractFormPlugin)this, "isc_dc_guide", "", param, "");
        } else if ("view_conver_rule".equals(operateKey)) {
            this.viewConverRule(args);
        } else if ("view_datacpoy_imp".equals(operateKey)) {
            QFilter filter = new QFilter("res_type", "like", (Object)"%(isc_data_copy)");
            FormOpener.openBillList((AbstractFormPlugin)this, "isc_dts_imp", Collections.singletonList(filter), ResManager.loadKDString((String)"\u8d44\u6e90\u5bfc\u5165\u8bb0\u5f55", (String)"DataCopyListPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void viewConverRule(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id != null) {
            DynamicObject datacopy = DataCopySchema.get((long)D.l((Object)id));
            DynamicObjectCollection entries = datacopy.getDynamicObjectCollection("mapping_entries");
            ArrayList<Long> ruleIdList = new ArrayList<Long>();
            for (DynamicObject entry : entries) {
                DynamicObject rule = entry.getDynamicObject("value_conver_rule");
                if (rule == null) continue;
                ruleIdList.add(rule.getLong("id"));
            }
            DynamicObject attachCreatorRule = datacopy.getDynamicObject("attach_creator_rule");
            if (attachCreatorRule != null) {
                ruleIdList.add(attachCreatorRule.getLong("id"));
            }
            if (ruleIdList.size() > 0) {
                QFilter filter = new QFilter("id", "in", ruleIdList);
                FormOpener.openBillList((AbstractFormPlugin)this, "isc_value_conver_rule", Collections.singletonList(filter));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u96c6\u6210\u65b9\u6848\u672a\u914d\u7f6e\u503c\u8f6c\u6362\u89c4\u5219\u3002", (String)"DataCopyListPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
            }
        }
    }

    private void showTopologyView(AfterDoOperationEventArgs args) {
        long id = D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, args));
        if (id > 0L) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("type", "isc_data_copy");
            params.put("id", id);
            FormOpener.showTabForm((AbstractFormPlugin)this, "isc_topology_view", TopologyFormUtil.getName("isc_data_copy," + id), params, "");
        }
    }

    private void createDataCopy() {
        Map focusNode;
        String id = null;
        Control treeviewap = this.getView().getControl("treeviewap");
        id = null == treeviewap ? "root" : ((focusNode = ((TreeView)treeviewap).getTreeState().getFocusNode()) == null ? "root" : focusNode.get("id"));
        long nodeId = id.equals("root") ? 0L : D.l((Object)id);
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("schema_category_id", nodeId);
        FormOpener.showTabBill((AbstractFormPlugin)this, "isc_data_copy", ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848", (String)"DataCopyListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"importschema")) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"modify_schema_category")) {
            Object result = evt.getReturnData();
            if (result instanceof ListSelectedRowCollection) {
                try {
                    ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)result;
                    if (!listSelectedRowCollection.isEmpty()) {
                        this.modifyDataCopyCategory(listSelectedRowCollection.get(0).getPrimaryKeyValue());
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u96c6\u6210\u65b9\u6848\u5206\u7c7b\u6210\u529f\uff0c\u96c6\u6210\u65b9\u6848\u5bf9\u5e94\u7684\u542f\u52a8\u65b9\u6848\u4e5f\u4fee\u6539\u5206\u7c7b\u6210\u529f\uff01", (String)"DataCopyListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        this.getView().invokeOperation("refresh");
                    }
                }
                catch (Exception e) {
                    FormOpener.showErrorMessage(this.getView(), e);
                }
            }
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"iscExportTaskCloseCallBack")) {
            ExportUtil.iscExportTaskCallBack((AbstractFormPlugin)this, evt.getReturnData());
        }
    }

    private void modifyDataCopyCategory(Object categoryPk) {
        String cateGoryName = BusinessDataServiceHelper.loadSingle((Object)categoryPk, (String)"isc_schema_category", (String)"name").getString("name");
        DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"isc_data_copy").getProperty("schema_category");
        if (property != null) {
            this.innerUpdateCategory(categoryPk, cateGoryName);
        }
    }

    private void innerUpdateCategory(Object categoryPk, String cateGoryName) {
        ListSelectedRowCollection selectedSchemaRows = this.getSelectedRows();
        int updateCount = selectedSchemaRows.size() >= 500 ? 500 : selectedSchemaRows.size();
        ArrayList<Integer> idTypes = new ArrayList<Integer>(updateCount);
        ArrayList<Object> idValues = new ArrayList<Object>(updateCount);
        StringBuilder selectedIds = new StringBuilder();
        for (ListSelectedRow row : selectedSchemaRows) {
            if (idValues.size() > 0) {
                selectedIds.append(',');
            }
            idTypes.add(-5);
            idValues.add(row.getPrimaryKeyValue());
            selectedIds.append('?');
            if (idValues.size() < 500) continue;
            this.modifyCateGory(categoryPk, cateGoryName, idTypes, idValues, selectedIds);
            idTypes = new ArrayList(updateCount);
            idValues = new ArrayList(updateCount);
            selectedIds = new StringBuilder();
        }
        if (selectedIds.length() > 0) {
            this.modifyCateGory(categoryPk, cateGoryName, idTypes, idValues, selectedIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyCateGory(Object categoryPk, String cateGoryName, List<Integer> idTypes, List<Object> idValues, StringBuilder selectedIds) {
        Connection cn = null;
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            this.modifyDataCopyCategory(categoryPk, idTypes, idValues, selectedIds, cn);
            this.modifyTriggerCategory(cn, selectedIds, idTypes, idValues, cateGoryName);
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)true);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)true);
    }

    private void modifyDataCopyCategory(Object categoryPk, List<Integer> idTypes, List<Object> idValues, StringBuilder selectedIds, Connection cn) {
        String sql = "UPDATE T_ISCB_DATA_COPY SET FSCHEMA_CATEGORY = ?, FMODIFIERID = ?, FMODIFYTIME = ? WHERE FID IN (" + selectedIds + ") AND FSCHEMA_CATEGORY <> ?";
        List<Object> values = this.getValues(categoryPk, idValues);
        List<Integer> types = this.getTypes(idTypes);
        DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
    }

    private List<Object> getValues(Object categoryPk, List<Object> idValues) {
        ArrayList<Object> values = new ArrayList<Object>(idValues.size() + 5);
        values.add(categoryPk);
        values.add(RequestContext.get().getUserId());
        values.add(new Timestamp(System.currentTimeMillis()));
        values.addAll(idValues);
        values.add(categoryPk);
        return values;
    }

    private List<Integer> getTypes(List<Integer> idTypes) {
        ArrayList<Integer> types = new ArrayList<Integer>(idTypes.size() + 5);
        types.add(-5);
        types.add(-5);
        types.add(93);
        types.addAll(idTypes);
        types.add(-5);
        return types;
    }

    private void modifyTriggerCategory(Connection cn, StringBuilder whereIds, List<Integer> idTypes, List<Object> idValues, String cateGoryName) {
        String sql = "UPDATE T_ISC_DATA_COPY_TRIGGER SET FSCHEMA_CATEGORY = ?, FMODIFIERID = ?, FMODIFYTIME = ? WHERE FDATA_COPY IN (" + whereIds + ")";
        ArrayList<Integer> types = new ArrayList<Integer>(idTypes.size() + 3);
        types.add(12);
        types.add(-5);
        types.add(93);
        types.addAll(idTypes);
        ArrayList<Object> values = new ArrayList<Object>(idValues.size() + 3);
        values.add(cateGoryName);
        values.add(RequestContext.get().getUserId());
        values.add(new Timestamp(System.currentTimeMillis()));
        values.addAll(idValues);
        DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operateKey = operate.getOperateKey();
        ListSelectedRowCollection dataCollection = evt.getListSelectedData();
        if ("modify".equals(operateKey)) {
            if (dataCollection.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u8981\u9009\u62e9\u591a\u884c!", (String)"DataCopyListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                evt.setCancel(true);
            } else if (dataCollection.size() == 1) {
                Object[] ids = dataCollection.getPrimaryKeyValues();
                this.checkTriggerByEnable(ids[0]);
                evt.setCancel(true);
            }
        }
    }

    private void checkTriggerByEnable(Object dataCopy) {
        if (dataCopy == null) {
            return;
        }
        QFilter[] qfs = new QFilter[]{new QFilter("data_copy", "=", dataCopy), new QFilter("enable", "=", (Object)"1")};
        DynamicObject[] triggers = BusinessDataServiceHelper.load((String)"isc_data_copy_trigger", (String)"id,enable", (QFilter[])qfs);
        if (triggers != null && triggers.length > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("disable_trigger", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7981\u7528\u542f\u52a8\u65b9\u6848\u624d\u80fd\u4fee\u6539\u96c6\u6210\u65b9\u6848\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"DataCopyListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        } else {
            FormOpener.showTabEdit((AbstractFormPlugin)this, "isc_data_copy", dataCopy);
        }
    }

    private void disableTrigger(Object dataCopyId) {
        if (D.s((Object)dataCopyId) == null) {
            return;
        }
        QFilter qFilter = new QFilter("data_copy", "=", dataCopyId);
        Object[] triggers = BusinessDataServiceHelper.load((String)"isc_data_copy_trigger", (String)"id,enable,trigger_type,job_define,job_schedule,events,data_copy_id,source_schema_id,full_name,data_source_id,new_source_system_id", (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Object[])triggers)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4e0e\u8be5\u96c6\u6210\u65b9\u6848\u76f8\u5173\u8054\u7684\u542f\u52a8\u65b9\u6848", (String)"DataCopyListPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(800));
            return;
        }
        try {
            DataCopyTriggerListPlugin.cancel((DynamicObject[])triggers);
            this.updateState((DynamicObject[])triggers);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void updateState(DynamicObject[] triggers) {
        for (DynamicObject trigger : triggers) {
            if (!"1".equals(trigger.get("enable"))) continue;
            trigger.set("enable", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])triggers);
        this.checkSetEnable(triggers);
    }

    private void checkSetEnable(DynamicObject[] triggers) {
        for (DynamicObject trigger : triggers) {
            if ("0".equals(trigger.get("enable"))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u7684\u542f\u52a8\u65b9\u6848\u7981\u7528\u5931\u8d25\u3002", (String)"DataCopyListPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u7684\u542f\u52a8\u65b9\u6848\u5df2\u5168\u90e8\u7981\u7528\u6210\u529f\u3002", (String)"DataCopyListPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String callback = evt.getCallBackId();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] pk = selectedRows.getPrimaryKeyValues();
        if (pk.length == 1 && "disable_trigger".equals(callback)) {
            this.disableTrigger(pk[0]);
            FormOpener.showTabEdit((AbstractFormPlugin)this, "isc_data_copy", pk[0]);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        FormOpener.showTabViewIfNotExist((AbstractFormPlugin)this, "isc_data_copy", selectedId);
    }
}

