/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.sql.Timestamp;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.IDService;
import kd.bos.instance.Instance;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.eas.Util;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.DataCopyTaskStage;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.trace.TraceType;
import kd.isc.iscb.platform.core.util.DataTypeEqualsUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.trace.TraceTask;

public class DataCopyTaskStageFormPlugin
extends AbstractFormPlugin {
    private static final String ISC_DATA_COPY_TASKSTAGE = "isc_data_copy_taskstage";
    private static final String PARAMS_ENTRYENTITY = "params_entryentity";
    private static final String TOTAL_FAILED = "total_failed";
    private static final String TOTAL_SUCCESS = "total_success";
    private static final String TOTAL_BATCH = "total_batch";
    private static final String TOTAL_COUNT = "total_count";
    private static final String BEGIN_TIME = "begin_time";
    private static final String MODIFYTIME = "modifytime";
    private static final String STATE = "state";
    private static final String SHOW_LOGS = "show_logs";
    private static final String BTN_REFRESH = "btn_refresh";
    private static final String BAR_SAVE = "bar_save";

    public void afterBindData(EventObject e) {
        BillShowParameter billShowParameter;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map params = parameter.getCustomParams();
        Object triggerId = params.get("triggerId");
        if (null != triggerId) {
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle(triggerId, (String)"isc_data_copy_trigger");
            this.initModel(params, trigger);
        }
        if ((billShowParameter = (BillShowParameter)this.getView().getFormShowParameter()).getBillStatus().equals((Object)BillOperationStatus.EDIT) || billShowParameter.getBillStatus().equals((Object)BillOperationStatus.VIEW)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_REFRESH, SHOW_LOGS});
        }
        super.afterBindData(e);
    }

    private void initModel(Map<String, Object> params, DynamicObject trigger) {
        IDataModel model = this.getModel();
        DynamicObject dataCopy = trigger.getDynamicObject("data_copy");
        model.setValue("number", (Object)DataCopyTask.generateExecutionNumber((DynamicObject)trigger));
        model.setValue("name", (Object)DataCopyTaskStage.generateTaskStageName((DynamicObject)trigger));
        model.setValue("data_trigger", (Object)trigger);
        model.setValue("data_copy", (Object)dataCopy);
        model.setValue(STATE, (Object)"C");
        model.setValue("status", (Object)"C");
        model.setValue(MODIFYTIME, (Object)new Timestamp(System.currentTimeMillis()));
        model.setValue(BEGIN_TIME, (Object)new Timestamp(System.currentTimeMillis()));
        model.setValue("host", (Object)Instance.getInstanceId());
        model.setValue("enable", (Object)"1");
        model.setValue("creator", (Object)RequestContext.get().getUserId());
        model.setValue("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        model.setValue(TOTAL_COUNT, (Object)-1);
        model.setValue(TOTAL_BATCH, (Object)-1);
        model.setValue(TOTAL_SUCCESS, (Object)-1);
        model.setValue(TOTAL_FAILED, (Object)-1);
        model.setValue(PARAMS_ENTRYENTITY, (Object)DataCopyTask.createParams((DynamicObject)trigger, (DynamicObject)this.getModel().getDataEntity(), params));
        this.getView().updateView(PARAMS_ENTRYENTITY);
        this.getModel().updateCache();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if (StringUtils.equals((CharSequence)BAR_SAVE, (CharSequence)operationKey)) {
            IDataModel model = this.getModel();
            model.setValue(STATE, (Object)"C");
            model.setValue("enable", (Object)"1");
            this.checkAndExecute();
        } else if (StringUtils.equals((CharSequence)SHOW_LOGS, (CharSequence)operationKey)) {
            FormOpener.openBillListByModel(this, "isc_data_copy_execution", "taskstage", evt);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        IDataModel model;
        Long id;
        super.beforeDoOperation(e);
        if (!(e.getSource() instanceof Donothing)) {
            return;
        }
        Donothing donothing = (Donothing)e.getSource();
        if (donothing.getOperateKey().equals(BTN_REFRESH) && (id = (Long)(model = this.getModel()).getValue("id")) != 0L) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_DATA_COPY_TASKSTAGE);
            model.setValue(MODIFYTIME, obj.get(MODIFYTIME));
            model.setValue(BEGIN_TIME, obj.get(BEGIN_TIME));
            model.setValue("end_time", obj.get("end_time"));
            model.setValue(STATE, obj.get(STATE));
            model.setValue("host", obj.get("host"));
            model.setValue(TOTAL_COUNT, obj.get(TOTAL_COUNT));
            model.setValue(TOTAL_BATCH, obj.get(TOTAL_BATCH));
            model.setValue(TOTAL_SUCCESS, obj.get(TOTAL_SUCCESS));
            model.setValue(TOTAL_FAILED, obj.get(TOTAL_FAILED));
            model.setValue("log", obj.get("log"));
            model.setValue("log_tag", obj.get("log_tag"));
        }
    }

    public void checkAndExecute() {
        StringBuilder mg = new StringBuilder();
        DynamicObjectCollection params_entryentity = this.getModel().getEntryEntity(PARAMS_ENTRYENTITY);
        for (DynamicObject row : params_entryentity) {
            String name = row.getString("params_name");
            String dataType = row.getString("params_data_type");
            String value = row.getString("params_value");
            if (D.s((Object)value) == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u53c2\u6570\u4e3a\u7a7a!", (String)"DataCopyTaskStageFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), name));
                return;
            }
            if (value.trim().equals("*") || DataTypeEqualsUtil.isMatchType((String)value, (String)dataType)) continue;
            mg.append(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"DataCopyTaskStageFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(name).append(ResManager.loadKDString((String)"\u503c\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"DataCopyTaskStageFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        String valid = mg.toString();
        if (D.s((Object)valid) != null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BAR_SAVE, (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f\u5b57\u6bb5\u503c\u6216\u7c7b\u578b\u4e0d\u5339\u914d\uff1a%s", (String)"DataCopyTaskStageFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), valid), MessageBoxOptions.YesNo, confirmCallBacks);
        } else {
            this.doTaskStage();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)BAR_SAVE, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.doTaskStage();
        }
    }

    private void doTaskStage() {
        TraceStack.trace((Caller)Caller.Front, (TraceTask)new TraceTask(){

            public void run() {
                DataCopyTaskStageFormPlugin.this.innerDoTaskStage();
            }
        });
    }

    private void innerDoTaskStage() {
        final DynamicObject stage = this.getModel().getDataEntity(true);
        stage.set("id", (Object)IDService.get().genLongId());
        OperationResult result = (OperationResult)TraceStack.run((TraceType)TraceType.NEW_DCB, (DynamicObject)stage, (TraceTask)new TraceTask(){

            public Object invoke() {
                return OperationServiceHelper.executeOperate((String)"save", (String)DataCopyTaskStageFormPlugin.ISC_DATA_COPY_TASKSTAGE, (DynamicObject[])new DynamicObject[]{stage}, (OperateOption)OperateOption.create());
            }
        });
        List successPkIds = result.getSuccessPkIds();
        if (result.isSuccess() && successPkIds.size() > 0) {
            Object id = successPkIds.get(0);
            TaskManager.submit((Task)new DataCopyTaskStage.taskStageThread(id));
            this.refreshTaskStageR(id);
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_REFRESH, SHOW_LOGS});
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE});
        }
    }

    private void refreshTaskStageR(Object id) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_DATA_COPY_TASKSTAGE);
        obj.set(STATE, (Object)"R");
        obj.set(MODIFYTIME, (Object)new Timestamp(System.currentTimeMillis()));
        Util.save((DynamicObject)obj);
    }
}

