/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.DataCopyParam;
import kd.isc.iscb.platform.core.dc.e.SQLUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCopyValidator {
    private static final String TABLE_NAME = "table_name";
    private static final String PROP_NAME = "prop_name";
    private static final String PROP_ENTRYENTITY = "prop_entryentity";
    private static final String CANDIDATE_KEY2 = "candidate_key";
    private static final String MAPPING_TAR_COLUMN2 = "mapping_tar_column";
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String SOURCE_SCHEMA_ID = "source_schema_id";
    private static final String TARGET_SCHEMA_ID = "target_schema_id";
    private AbstractFormPlugin form;
    private IFormView view;
    private IDataModel model;

    public DataCopyValidator(AbstractFormPlugin form, IDataModel model, IFormView view) {
        this.form = form;
        this.model = model;
        this.view = view;
    }

    private boolean integrityValidate() {
        if (D.l((Object)this.getModel().getValue(SOURCE_SCHEMA_ID)) == 0L || D.l((Object)this.getModel().getValue(TARGET_SCHEMA_ID)) == 0L) {
            this.form.getView().showMessage(ResManager.loadKDString((String)"\u65b9\u6848\u672a\u586b\u5199\u5b8c\u6574!", (String)"DataCopyValidator_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    IFormView getView() {
        return this.view;
    }

    IDataModel getModel() {
        return this.model;
    }

    AbstractFormPlugin getForm() {
        return this.form;
    }

    public boolean hasEntry() {
        long tar = (Long)this.getModel().getValue(TARGET_SCHEMA_ID);
        long src = (Long)this.getModel().getValue(SOURCE_SCHEMA_ID);
        DynamicObject tarMeta = BusinessDataServiceHelper.loadSingle((Object)tar, (String)ISC_METADATA_SCHEMA, (String)"full_name,type,group,name");
        DynamicObject srcMeta = BusinessDataServiceHelper.loadSingle((Object)src, (String)ISC_METADATA_SCHEMA, (String)"full_name,type,group,name");
        if (this.isMetaNotFound(srcMeta)) {
            return true;
        }
        return this.isMetaNotFound(tarMeta);
    }

    public boolean isMetaNotFound(DynamicObject meta) {
        try {
            DynamicObject link;
            DynamicObject dum_link;
            DynamicObject source;
            DynamicObject source_link;
            DynamicObject group = meta.getDynamicObject("group");
            if (group != null && "ENTITY".equals(meta.getString("type")) && (source_link = (source = BusinessDataServiceHelper.loadSingle((Object)group.getPkValue(), (String)"isc_data_source", (String)"dblink")).getDynamicObject("dblink")) != null && (dum_link = (link = BusinessDataServiceHelper.loadSingle((Object)source_link.getPkValue(), (String)"isc_database_link", (String)"dum_link")).getDynamicObject("dum_link")) != null && "self".equals(dum_link.getString("number"))) {
                EntityMetadataCache.getDataEntityType((String)meta.getString("full_name"));
            }
        }
        catch (Throwable e) {
            this.view.showTipNotification(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61%s\u627e\u4e0d\u5230\u5b9e\u4f53\u5143\u6570\u636e\uff0c\u53ef\u80fd\u662f\u4f7f\u7528\u4e86\u5206\u5f55(\u5206\u5f55\u5b9e\u4f53\u4e0d\u652f\u6301\u4f5c\u4e3a\u6e90\u6216\u76ee\u6807\u96c6\u6210)\u6216\u586b\u9519\u4e86\u96c6\u6210\u5bf9\u8c61\u7684\u5168\u540d", (String)"DataCopyValidator_49", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), meta.getString("name")), Integer.valueOf(5000));
            return true;
        }
        return false;
    }

    public boolean checkDeleteOp() {
        DynamicObjectCollection ops = this.getModel().getEntryEntity("target_actions");
        for (DynamicObject op : ops) {
            if (!"delete".equalsIgnoreCase(op.getString("tar_action_type"))) continue;
            if (ops.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u914d\u7f6e\u4e86\u5220\u9664\u64cd\u4f5c\u4e4b\u5916\u7684\u5176\u4ed6\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848!", (String)"DataCopyValidator_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return false;
            }
            return !this.hasUnnecessaryMappings();
        }
        return true;
    }

    public boolean hasCandidateKeys() {
        long id = (Long)this.getModel().getValue(TARGET_SCHEMA_ID);
        DynamicObject srcMeta = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA, (String)"type");
        if ("SERVICE".equals(srcMeta.getString("type"))) {
            return true;
        }
        DynamicObjectCollection mappings = this.getModel().getEntryEntity("mapping_entries");
        if (CollectionUtils.isEmpty((Collection)mappings)) {
            return true;
        }
        return mappings.stream().filter(f -> D.s((Object)f.get(MAPPING_TAR_COLUMN2)) != null && !f.getString(MAPPING_TAR_COLUMN2).contains(".")).anyMatch(f -> D.x((Object)f.get(CANDIDATE_KEY2)));
    }

    private boolean hasUnnecessaryMappings() {
        DynamicObjectCollection mappings = this.getModel().getEntryEntity("mapping_entries");
        Object tarMeta = this.getModel().getValue("target_schema");
        String pk = DataCopyValidator.getPrimaryKey((DynamicObject)tarMeta);
        for (DynamicObject item : mappings) {
            if (!this.isUnnecessary(item, pk)) continue;
            String tar = item.getString(MAPPING_TAR_COLUMN2);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u65b9\u6848\u4e2d\uff0c\u53ea\u914d\u7f6e\u4e3b\u952e\u548c\u5019\u9009\u952e, \u76ee\u6807\u5b57\u6bb5%s\u4e0d\u9700\u8981\u914d\u7f6e\u6620\u5c04\uff0c\u5efa\u8bae\u79fb\u9664!", (String)"DataCopyValidator_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tar));
            return true;
        }
        return false;
    }

    private boolean isUnnecessary(DynamicObject item, String pk) {
        if (item.getBoolean(CANDIDATE_KEY2)) {
            return false;
        }
        String src = item.getString("mapping_src_column");
        String tar = item.getString(MAPPING_TAR_COLUMN2);
        if (!(tar.equals(pk) || StringUtil.isEmpty((String)tar) || StringUtil.isEmpty((String)src))) {
            return true;
        }
        String fixedValue = item.getString("fixed_value");
        return !StringUtil.isEmpty((String)fixedValue) && !DataCopyParam.isIdentifierField((String)fixedValue);
    }

    public static String getPrimaryKey(DynamicObject object) {
        if (object == null) {
            return null;
        }
        DynamicObject meta = BusinessDataServiceHelper.loadSingleFromCache((Object)object.getPkValue(), (String)ISC_METADATA_SCHEMA);
        DynamicObjectCollection properties = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject dynamicObject : properties) {
            if (!dynamicObject.getBoolean("is_primary_key")) continue;
            return dynamicObject.getString(PROP_NAME);
        }
        return null;
    }

    public boolean checkRelationTable() {
        DynamicObjectCollection relationMapping = this.getModel().getEntryEntity("relation_mapping");
        HashSet<String> aliasSet = new HashSet<String>();
        for (DynamicObject relation : relationMapping) {
            String alias = D.s((Object)relation.getString("relation_alias"));
            if (alias == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5173\u7cfb\u6620\u5c04\u672a\u8bbe\u7f6e\u522b\u540d", (String)"DataCopyValidator_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (D.l((Object)relation.get("master_table_id")) == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u6570\u636e\u8868\u4e3a\u7a7a", (String)"DataCopyValidator_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (this.isMetaField(D.l((Object)relation.get("master_table_id")), alias)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u522b\u540d%1$s\u4e0d\u80fd\u4e0e\u4e3b\u6570\u636e\u8868%2$s\u7684\u5b57\u6bb5\u91cd\u590d", (String)"DataCopyValidator_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), alias, relation.getString("master_table.name")));
                return false;
            }
            if (aliasSet.contains(alias)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5173\u7cfb\u6620\u5c04\u5b58\u5728\u76f8\u540c\u522b\u540d%s", (String)"DataCopyValidator_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), alias));
                return false;
            }
            aliasSet.add(alias);
        }
        return true;
    }

    private boolean isMetaField(long metaId, String field) {
        DynamicObject masterTable = BusinessDataServiceHelper.loadSingleFromCache((Object)metaId, (String)ISC_METADATA_SCHEMA);
        DynamicObjectCollection properties = masterTable.getDynamicObjectCollection(PROP_ENTRYENTITY);
        return properties.stream().anyMatch(p -> p.getString(PROP_NAME).equals(field));
    }

    public boolean checkSource() {
        if (!this.integrityValidate()) {
            return false;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("filter_entries");
        HashSet<String> filters = new HashSet<String>();
        HashSet<String> set = new HashSet<String>(Arrays.asList("=", "STARTS_WITH", "in", ">", ">=", "<", "<="));
        for (DynamicObject entry : entryEntity) {
            if (!set.contains(entry.getString("filter_compare")) || D.s((Object)entry.getString("filter_column")) == null) continue;
            filters.add(entry.getString("filter_column"));
        }
        return this.checkIndex(SOURCE_SCHEMA_ID, "source", filters);
    }

    public boolean checkTarget() {
        if (!this.integrityValidate()) {
            return false;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("mapping_entries");
        Set<String> candidateKeys = entryEntity.stream().filter(c -> c.getBoolean(CANDIDATE_KEY2)).map(c -> c.getString(MAPPING_TAR_COLUMN2)).collect(Collectors.toSet());
        Set md5Columns = entryEntity.stream().filter(c -> {
            String fixedValue = c.getString("fixed_value");
            return StringUtil.isEmpty((String)fixedValue) && DataCopyParam.isIdentifierField((String)fixedValue);
        }).map(x -> x.getString(MAPPING_TAR_COLUMN2)).collect(Collectors.toSet());
        candidateKeys.addAll(md5Columns);
        return this.checkIndex(TARGET_SCHEMA_ID, "target", candidateKeys);
    }

    private boolean checkIndex(String schemaId, String tag, Set<String> fields) {
        Object id = this.getModel().getValue(schemaId);
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA, (String)"type, group, table_name");
        try {
            String type = meta.getString("type");
            if (type.equals(MetaType.TABLE.name())) {
                Set noIndexKeys = this.excludeIndexColumns(fields, meta);
                this.createIndex(meta, tag, noIndexKeys, fields);
                return noIndexKeys.isEmpty();
            }
            return true;
        }
        catch (Exception e) {
            throw new IscBizException((Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    private Set excludeIndexColumns(Set<String> fields, DynamicObject meta) {
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)meta.getLong("group_id"), (String)"isc_data_source", (String)"dblink");
        ConnectionManager.pushResLicense((boolean)true);
        try {
            try (ConnectionWrapper cn = ConnectionManager.getConnection((long)D.l((Object)dataSource.get("dblink_id")));){
                HashSet<String> noIndexKeys = new HashSet<String>(fields);
                String table_name = meta.getString(TABLE_NAME);
                Map indices = ConnectionManager.GetIndexInfo((ConnectionWrapper)cn, (String)StringUtil.toLowerCase((String)table_name));
                if (indices.isEmpty()) {
                    indices = ConnectionManager.GetIndexInfo((ConnectionWrapper)cn, (String)StringUtil.toUpperCase((String)table_name));
                }
                HashSet indexColumns = new HashSet();
                for (Index value : indices.values()) {
                    List collect = value.getColumns().stream().map(Pair::getA).collect(Collectors.toList());
                    indexColumns.addAll(collect);
                }
                for (String s : indexColumns) {
                    noIndexKeys.remove(s.toLowerCase());
                    noIndexKeys.remove(s.toUpperCase());
                }
                HashSet<String> hashSet = noIndexKeys;
                return hashSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private void createIndex(DynamicObject meta, String tag, Set<String> noIndexKeys, Set<String> fields) {
        if (!CollectionUtils.isEmpty(noIndexKeys)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("content", this.prepareIndex(meta, tag, noIndexKeys, fields));
            FormOpener.showForm(this.form, "isc_text_content_dialog", String.format(ResManager.loadKDString((String)"\u4f18\u5316\u63d0\u793a\uff1a\u4e3a\u8868%s\u6dfb\u52a0\u7d22\u5f15", (String)"DataCopyValidator_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), meta.getString(TABLE_NAME)), params, null);
        }
    }

    private String prepareIndex(DynamicObject meta, String tag, Set<String> noIndexKeys, Set<String> fields) {
        String tableName = meta.getString(TABLE_NAME);
        StringBuilder fs = new StringBuilder();
        for (String string : fields) {
            if (fs.length() > 0) {
                fs.append(',');
            }
            fs.append((Object)string);
        }
        StringBuilder compositeColumns = new StringBuilder();
        for (String string : fields) {
            if (compositeColumns.length() > 0) {
                compositeColumns.append(',');
            }
            compositeColumns.append('\'').append((Object)string).append('\'');
        }
        StringBuilder stringBuilder = this.getDescByTag(tag, noIndexKeys);
        stringBuilder.append((CharSequence)this.generateIndexName(tableName, fs).append(" on ")).append(this.getTableName(tableName)).append('(').append((CharSequence)compositeColumns).append(')').append(";\n").append('\n').append(ResManager.loadKDString((String)"\u6ce8\u610f\uff1a", (String)"DataCopyValidator_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append('\n').append(ResManager.loadKDString((String)"1.\u8bf7\u6839\u636e\u9700\u8981\u751f\u6210\u5355\u5b57\u6bb5\u7d22\u5f15\u8fd8\u662f\u7ec4\u5408\u7d22\u5f15\uff1b", (String)"DataCopyValidator_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append('\n').append(ResManager.loadKDString((String)"2.\u4e0d\u540c\u6570\u636e\u5e93\u4e3a\u89c4\u907f\u5173\u952e\u5b57\uff0c\u53ef\u80fd\u9700\u8981\u5728\u5b57\u6bb5\u52a0\u4e0a\u201c\u6216\u201d\u5b57\u7b26\u8fdb\u884c\u5305\u88f9\uff0c\u8bf7\u6839\u636e\u9700\u8981\u8fdb\u884c\u8c03\u6574\u3002", (String)"DataCopyValidator_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        return stringBuilder.toString();
    }

    private StringBuilder getDescByTag(String tag, Set<String> noIndexKeys) {
        StringBuilder sb = new StringBuilder();
        if ("source".equals(tag)) {
            sb.append(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u96c6\u6210\u65b9\u6848\u6e90\u5bf9\u8c61\u4e3a\u6570\u636e\u8868\u7c7b\u578b\uff0c\u5176\u8fc7\u6ee4\u6761\u4ef6\u5b57\u6bb5\uff1a", (String)"DataCopyValidator_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(StringUtil.join(noIndexKeys)).append(ResManager.loadKDString((String)"\u5728\u6e90\u7cfb\u7edf\u6570\u636e\u5e93\u4e2d\u6ca1\u6709\u5efa\u7acb\u7d22\u5f15\uff0c\u5728\u5927\u6570\u636e\u91cf\u6570\u636e\u540c\u6b65\u6216\u8282\u70b9\u8d44\u6e90\u53d7\u9650\u60c5\u51b5\u4e0b\u4f1a\u4e25\u91cd\u5f71\u54cd\u540c\u6b65\u6027\u80fd\uff0c\u53ef\u6839\u636e\u5b9e\u9645\u60c5\u51b5\uff0c\u6309\u9700\u53c2\u8003\u4ee5\u4e0bsql\u8bed\u53e5\u4e3a\u8fc7\u6ee4\u6761\u4ef6\u5b57\u6bb5\u5efa\u7acb\u7d22\u5f15\u4ee5\u63d0\u5347\u53d6\u6570\u6027\u80fd\u3002", (String)"DataCopyValidator_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append('\n').append("create index ");
        } else if ("target".equals(tag)) {
            sb.append(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u96c6\u6210\u65b9\u6848\u76ee\u6807\u5bf9\u8c61\u4e3a\u6570\u636e\u8868\u7c7b\u578b\uff0c\u5176\u76ee\u6807\u5019\u9009\u952e\u5b57\u6bb5\uff1a", (String)"DataCopyValidator_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(StringUtil.join(noIndexKeys)).append(ResManager.loadKDString((String)"\u5728\u76ee\u6807\u7cfb\u7edf\u6570\u636e\u5e93\u4e2d\u6ca1\u6709\u5efa\u7acb\u7d22\u5f15\uff0c\u5728\u5927\u6570\u636e\u91cf\u6570\u636e\u540c\u6b65\u6216\u8282\u70b9\u8d44\u6e90\u53d7\u9650\u60c5\u51b5\u4e0b\u4f1a\u4e25\u91cd\u5f71\u54cd\u540c\u6b65\u6027\u80fd\uff0c\u53ef\u6839\u636e\u5b9e\u9645\u60c5\u51b5\uff0c\u6309\u9700\u53c2\u8003\u4ee5\u4e0bsql\u8bed\u53e5\u5bf9\u7ec4\u5408\u5019\u9009\u952e\u5b57\u6bb5\u5efa\u7acb\u552f\u4e00\u7d22\u5f15\u4ee5\u63d0\u5347\u5199\u6570\u6027\u80fd\u548c\u4fdd\u8bc1\u6570\u636e\u552f\u4e00\u6027\u3002", (String)"DataCopyValidator_34", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append('\n').append("create unique index ");
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5224\u65ad\u6807\u8bc6\uff1a%s", (String)"DataCopyValidator_35", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tag));
        }
        return sb;
    }

    private StringBuilder generateIndexName(String table, StringBuilder indices) {
        StringBuilder sb = new StringBuilder();
        sb.append("IDX_");
        table = this.getTableName(table).toUpperCase().replaceFirst("T_", "");
        if (table.length() > 13) {
            sb.append(table, 0, 13);
        } else {
            sb.append(table);
        }
        sb.append('_');
        String s = indices.toString().toUpperCase();
        return sb.append(Hash.mur24((Object[])new Object[]{s}));
    }

    void createTableSql(long id) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_METADATA_SCHEMA);
        String type = meta.getString("type");
        if ("ENUM".equals(type) || "ENTITY".equals(type)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("content", this.prepareTableSql(meta));
        FormOpener.showForm(this.form, "isc_text_content_dialog", String.format(ResManager.loadKDString((String)"\u521b\u5efa\u8868%s", (String)"DataCopyValidator_36", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), meta.getString(TABLE_NAME)), params, null);
    }

    private String getTableName(String table) {
        int p = table.indexOf(64);
        if (p > 0) {
            table = table.substring(0, p);
        }
        return table;
    }

    private String prepareTableSql(DynamicObject meta) {
        DynamicObjectCollection fields = meta.getDynamicObjectCollection(PROP_ENTRYENTITY);
        StringBuilder builder = new StringBuilder();
        builder.append("create table ").append(this.getTableName(meta.getString(TABLE_NAME))).append("(\n");
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (DynamicObject field : fields) {
            String name = field.getString(PROP_NAME);
            String dataType = field.getString("data_type");
            boolean required = field.getBoolean("required");
            builder.append('\"').append(name).append('\"').append(' ').append(dataType);
            if (required) {
                builder.append(" not null ");
                builder.append((CharSequence)this.getDefaultValue(dataType, required));
            }
            builder.append(",\n");
            if (!field.getBoolean("is_primary_key")) continue;
            primaryKeys.add(name);
        }
        if (!primaryKeys.isEmpty()) {
            builder.append("primary key(").append(String.join((CharSequence)",", primaryKeys)).append(')').append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("\n);");
        return builder.toString();
    }

    private StringBuilder getDefaultValue(String type, boolean required) {
        StringBuilder sb = new StringBuilder();
        if (type == null || !required) {
            return sb;
        }
        if ((type = type.toLowerCase()).contains("varchar")) {
            sb.append(" default  ").append("' '");
        } else if (type.contains("int") || type.contains("long") || type.contains("decimal")) {
            sb.append(" default ").append(0);
        } else if (type.contains("datetime")) {
            sb.append("  default ").append("1970-01-01 00:00:00");
        }
        return sb;
    }

    public void checkCandidateKey(long id, Set<String> entryCandidateKeys) {
        DynamicObject targetSchema = MetaDataSchema.get((long)id);
        if ("ENTITY".equals(targetSchema.get("type"))) {
            Map<String, Object> multiLevelCandiKey = this.initEntryCandidateKeyMap(entryCandidateKeys);
            HashSet<String> errorFields = new HashSet<String>();
            this.innerCheckMultiLevelKey(targetSchema, "", multiLevelCandiKey, errorFields);
            if (errorFields.size() > 0) {
                throw new IscBizException(this.buildTipMsg(entryCandidateKeys, errorFields));
            }
        }
    }

    public Set<String> getEntryCandidateKeysByLogo(String entity, String column, String logo) {
        DynamicObjectCollection mapping_entries = this.model.getDataEntity(true).getDynamicObjectCollection(entity);
        TreeSet<String> entryCandidateKeys = new TreeSet<String>();
        for (DynamicObject object : mapping_entries) {
            String tar_column = D.s((Object)object.get(column));
            if (tar_column == null || !tar_column.contains(".") || !D.x((Object)object.get(logo))) continue;
            entryCandidateKeys.add(tar_column);
        }
        return entryCandidateKeys;
    }

    public Set<String> getEntryCandidateKeys(String entity, String column) {
        DynamicObjectCollection mapping_entries = this.model.getDataEntity(true).getDynamicObjectCollection(entity);
        TreeSet<String> entryCandidateKeys = new TreeSet<String>();
        for (DynamicObject object : mapping_entries) {
            String tar_column = D.s((Object)object.get(column));
            if (!tar_column.contains(".")) continue;
            entryCandidateKeys.add(tar_column);
        }
        return entryCandidateKeys;
    }

    private void innerCheckMultiLevelKey(DynamicObject schema, String prefix, Map<String, Object> multiLevelCandiKey, Set<String> errorFields) {
        Map<String, String> entriesSchema = this.initEntriesSchema(schema);
        for (Map.Entry<String, Object> entry : multiLevelCandiKey.entrySet()) {
            String fieldName = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Map)) continue;
            String entrySchemaNumber = entriesSchema.get(fieldName);
            String fullName = prefix + fieldName;
            if (entrySchemaNumber != null) {
                this.innerCheckMultiLevelKey(this.queryEntrySchema(schema, entrySchemaNumber, fullName), fullName + ".", (Map)value, errorFields);
                continue;
            }
            errorFields.add(fullName);
        }
    }

    private DynamicObject queryEntrySchema(DynamicObject schema, String schemaNumber, String fullName) {
        long dsId = schema.getLong("group_id");
        QFilter qFilter = new QFilter("group", "=", (Object)dsId).and("number", "=", (Object)schemaNumber);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ISC_METADATA_SCHEMA, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5206\u5f55\u5b57\u6bb5\u3010%1$s\u3011\u5bf9\u5e94\u7684\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684\u96c6\u6210\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u540c\u6b65\u5143\u6570\u636e", (String)"DataCopyValidator_37", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), fullName, schemaNumber));
        }
        return BusinessDataServiceHelper.loadSingle((Object)dynamicObject.get("id"), (String)ISC_METADATA_SCHEMA);
    }

    private Map<String, String> initEntriesSchema(DynamicObject schema) {
        DynamicObjectCollection prop_entryentity = schema.getDynamicObjectCollection(PROP_ENTRYENTITY);
        HashMap<String, String> entriesSchema = new HashMap<String, String>();
        for (DynamicObject object : prop_entryentity) {
            if (!"ENTRIES".equals(object.get("data_type"))) continue;
            entriesSchema.put(D.s((Object)object.get(PROP_NAME)), D.s((Object)object.get("data_schema")));
        }
        return entriesSchema;
    }

    private Map<String, Object> initEntryCandidateKeyMap(Set<String> entryCandidateKeys) {
        HashMap<String, Object> multiLevelCandiKey = new HashMap<String, Object>();
        for (String entryCandidateKey : entryCandidateKeys) {
            SQLUtil.addEntryProperty(multiLevelCandiKey, (String[])entryCandidateKey.split("\\."));
        }
        return multiLevelCandiKey;
    }

    private String buildTipMsg(Set<String> entryCandidateKeys, Set<String> errorFields) {
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5019\u9009\u952e\u53ef\u80fd\u5bfc\u81f4\u65b9\u6848\u5931\u8d25\uff1a", (String)"DataCopyValidator_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        for (String entryCandidateKey : entryCandidateKeys) {
            for (String errorField : errorFields) {
                if (!entryCandidateKey.startsWith(errorField)) continue;
                sb.append("\r\n");
                sb.append(entryCandidateKey);
            }
        }
        sb.append("\r\n").append(ResManager.loadKDString((String)"\u6240\u6709\u5c42\u7ea7\u9664\u4e86\u5206\u5f55\u5b57\u6bb5\uff0c\u5176\u4ed6\u5b57\u6bb5\u540e\u7f00\u5747\u4e0d\u80fd\u6709\u201c.\u201d", (String)"DataCopyValidator_38", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        return sb.toString();
    }

    public void checkCandidateKeyEntrySeq(BeforeDoOperationEventArgs args) {
        Set<String> keys = this.getEntryCandidateKeysByLogo("mapping_entries", MAPPING_TAR_COLUMN2, CANDIDATE_KEY2);
        if (keys.size() <= 0) {
            return;
        }
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            if (it.next().endsWith("seq")) continue;
            it.remove();
        }
        if (keys.isEmpty()) {
            return;
        }
        DynamicObject targetSchema = MetaDataSchema.get((long)D.l((Object)this.getModel().getValue(TARGET_SCHEMA_ID)));
        if ("ENTITY".equals(targetSchema.get("type")) && D.x((Object)this.model.getValue("record_oid_mappings"))) {
            StringBuilder sb = new StringBuilder();
            for (String k : keys) {
                sb.append(k).append('\n');
            }
            String title = ResManager.loadKDString((String)"\u5728\u5f00\u542f\u2018\u8bb0\u5f55\u6e90\u5355/\u76ee\u6807\u5355ID\u5173\u8054\u5173\u7cfb\u2019\u65f6\u4f7f\u7528\u5206\u5f55\u884c\u53f7\u4f5c\u4e3a\u5019\u9009\u952e\u53ef\u80fd\u5bfc\u81f4\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u6309\u63d0\u793a\u4fee\u6539\uff1a", (String)"DataCopyValidator_39", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            String detail = ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u4ee5\u4e0b\u5206\u5f55\u7684\u5019\u9009\u952e\u6216\u662f\u5173\u95ed\u2018\u8bb0\u5f55\u6e90\u5355/\u76ee\u6807\u5355ID\u5173\u8054\u5173\u7cfb\u2019\u3002\n%s", (String)"DataCopyValidator_40", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            detail = String.format(detail, sb);
            FormOpener.showErrorMessage(this.getView(), title, detail);
        }
    }

    public boolean checkUpsertOp() {
        DynamicObjectCollection ops = this.getModel().getEntryEntity("target_actions");
        int size = ops.size();
        if (size > 1 && this.containsUpsertOp(ops)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u914d\u7f6e\u4e86_UPSERT\u64cd\u4f5c\u540e\u4e0d\u5141\u8bb8\u518d\u9009\u62e9\u5176\u4ed6\u64cd\u4f5c\uff0c\u8bf7\u68c0\u67e5\u65b9\u6848!", (String)"DataCopyValidator_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean containsUpsertOp(DynamicObjectCollection ops) {
        for (DynamicObject op : ops) {
            if (!"_UPSERT".equals(op.get("tar_action_number"))) continue;
            return true;
        }
        return false;
    }
}

