/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;

public class DataQueryToolPlugin
extends AbstractFormPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        String dataType = D.s((Object)this.getModel().getValue("data_type"));
        DataType type = null;
        try {
            type = DataType.valueOf(dataType);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s: \u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u522b", (String)"DataQueryToolPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dataType));
            return;
        }
        String operateKey = args.getOperateKey();
        if ("query".equals(operateKey)) {
            this.doQuery(type);
        } else if ("view".equals(operateKey)) {
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            int[] rows = entry.getSelectRows();
            if (rows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u4e2d\u4e00\u884c\u6570\u636e", (String)"DataQueryToolPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            FormOpener.showList(this, type.name(), new QFilter(type.getPkField(), "in", this.getBatchSelectedRowData(rows)));
        }
    }

    private List<Object> getBatchSelectedRowData(int[] row) {
        ArrayList<Object> list = new ArrayList<Object>(row.length);
        for (int r : row) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", r);
            list.add(rowEntity.get("id"));
        }
        return list;
    }

    private void doQuery(DataType type) {
        String keywords = D.s((Object)this.getModel().getValue("keywords"));
        Set<Object> params = new HashSet(16);
        if (keywords.startsWith("[") && keywords.endsWith("]")) {
            params = (Set)JSON.parseObject((String)keywords, Set.class);
        } else if (keywords.startsWith("\"") && keywords.endsWith("\"")) {
            params.add(keywords.substring(1, keywords.length() - 1));
        } else {
            params = Arrays.stream(keywords.split(" ")).collect(Collectors.toSet());
        }
        Map<Object, Object> map = type.queryData(params);
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        collection.clear();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            DynamicObject item = collection.addNew();
            item.set("id", entry.getKey());
            item.set("content", entry.getValue());
        }
        this.getView().updateView("entryentity");
    }

    private static Map<Object, Object> getDate(Set<String> params, String tableName) {
        StringBuilder sql = new StringBuilder("select FID, FSTATE, FDATA_TAG from ").append(tableName);
        boolean isFirst = true;
        for (String param : params) {
            if (isFirst) {
                isFirst = false;
                sql.append(" WHERE ");
            } else {
                sql.append(" AND ");
            }
            sql.append("(FDATA_TAG like '%").append(param).append("%') ");
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>(16);
        ORM orm = ORM.create();
        try (DataSet ds = DB.queryDataSet((String)DataQueryToolPlugin.class.getName(), (DBRoute)DBRoute.of((String)"iscb"), (String)sql.toString());){
            DynamicObjectCollection list = orm.toPlainDynamicObjectCollection(ds, 0, 100);
            for (DynamicObject dynamicObject : list) {
                String s = "FID=" + dynamicObject.get("fid") + ", FSTATE=" + dynamicObject.get("FSTATE") + ", FDATA_TAG=" + dynamicObject.get("FDATA_TAG");
                result.put(dynamicObject.get("fid"), s.substring(0, Math.min(s.length(), 150)) + "..");
            }
        }
        return result;
    }

    static enum DataType {
        isc_mq_data_published{

            @Override
            public Map<Object, Object> queryData(Set<String> params) {
                return DataQueryToolPlugin.getDate(params, "t_iscb_mq_data_published");
            }
        }
        ,
        isc_mq_data_received{

            @Override
            public Map<Object, Object> queryData(Set<String> params) {
                return DataQueryToolPlugin.getDate(params, "t_iscb_mq_data_received");
            }
        };


        public abstract Map<Object, Object> queryData(Set<String> var1);

        public String getPkField() {
            return "id";
        }
    }
}

