/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.isc.iscb.formplugin.dc.DatabaseLinkUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ResourceIsolateUtil;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.connector.eas.Util;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.license.n.AccountInfo;
import kd.isc.iscb.platform.core.license.n.ConnectionInfo;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.NetUtil;

public class DatabaseLinkListPlugin
extends AbstractListPlugin {
    private static final String DATABASE_TYPE = "database_type";
    private static final String LICENSE_SN = "license_sn";
    private static final String LICENSE_INFO = "license_info";
    private static final String NUMBER = "number";
    private static final String LOGO = "logo";
    private static final String NAME = "name";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String field = args.getFieldName();
        if (NUMBER.equals(field) || LOGO.equals(field) || NAME.equals(field)) {
            args.setCancel(true);
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow current = billList.getCurrentSelectedRowInfo();
            Object selectedId = current.getPrimaryKeyValue();
            DynamicObject cnType = this.getCnType(selectedId);
            String type = D.s((Object)cnType.get(NUMBER));
            String permit = D.s((Object)cnType.getString("permit"));
            try {
                if (permit == null) {
                    DatabaseLinkListPlugin.showView((AbstractFormPlugin)this, DatabaseType.getForm((String)type), selectedId, false);
                } else if (permit.contains("UPDATE")) {
                    FormOpener.showEdit((AbstractFormPlugin)this, DatabaseType.getForm((String)type), selectedId);
                } else {
                    DatabaseLinkListPlugin.showView((AbstractFormPlugin)this, DatabaseType.getForm((String)type), selectedId, false);
                }
            }
            catch (Exception e) {
                this.getView().showMessage(D.s((Object)e));
            }
        }
    }

    private DynamicObject getCnType(Object selectedId) {
        DynamicObject cfg = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"isc_database_link", (String)"dum_link,database_type");
        String id = D.s((Object)cfg.getDynamicObject("dum_link").getPkValue());
        DynamicObject cnType = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (String)"permit,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (null == cnType) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u5bf9\u5e94\u7684id\u4e3a\uff1a%s\u7684\u8fde\u63a5\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"DatabaseLinkListPlugin_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), id));
        }
        return cnType;
    }

    public static void showView(AbstractFormPlugin form, String entity, Object id, boolean disable_view_trace) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId(entity);
        param.setPkId(id);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setStatus(OperationStatus.VIEW);
        param.setCustomParam("disable_view_trace", (Object)disable_view_trace);
        param.setCustomParam("update", (Object)Boolean.FALSE);
        form.getView().showForm((FormShowParameter)param);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        try {
            String operateKey = args.getOperateKey();
            if ("test".equals(operateKey)) {
                this.test(args);
            } else if ("deploy".equals(operateKey)) {
                this.deploy(args);
            } else if ("undeploy".equals(operateKey)) {
                this.undeploy(args);
            } else if ("view_permit".equals(operateKey)) {
                this.showPermit(args);
            } else if ("push_permit".equals(operateKey)) {
                this.pushPermit(args);
            } else if ("init_env".equals(operateKey)) {
                this.initEnvironment(args);
            } else if ("show_evt_que".equals(operateKey)) {
                this.showEventQueue(args);
            } else if ("evt_bind".equals(operateKey)) {
                this.showEventBinding(args);
            } else if ("delete".equals(operateKey)) {
                IscLicenseUtil.refreshCache();
            } else if ("network_test".equals(operateKey)) {
                this.networkTest(args);
            } else if ("cur_account_info".equals(operateKey)) {
                this.showContextInfo();
            } else if ("notice_config".equals(operateKey)) {
                this.showNoticeForm(args);
            } else if ("notice_manage".equals(operateKey)) {
                QFilter filter = new QFilter("id", ">", (Object)"0");
                FormOpener.showList((AbstractFormPlugin)this, "isc_link_notification", filter);
            } else if ("show_udf_event_list".equals(operateKey)) {
                QFilter filter = new QFilter("id", ">", (Object)0);
                FormOpener.showList((AbstractFormPlugin)this, "isc_user_defined_event", filter);
            } else if ("addnew".equals(operateKey)) {
                HashMap<String, Object> customParams = new HashMap<String, Object>(3);
                FormOpener.buildOpenFormParam(this.getView(), customParams, "source_app", "autoCreateIscxConnector", "autoCreateDataSource");
                FormOpener.showForm((AbstractFormPlugin)this, "isc_database_link_chose", customParams);
            } else if ("guideadd".equals(operateKey)) {
                this.showGuideForm();
            } else if ("check_deploy_info".equals(operateKey)) {
                this.showDeployInfo(args);
            } else if ("get_sp_time".equals(operateKey)) {
                this.getConnectorInfo(args);
            } else if ("callback_test".equals(operateKey)) {
                DatabaseLinkUtil.callbackTest((AbstractFormPlugin)this, args);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void getConnectorInfo(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id == null) {
            return;
        }
        DynamicObject dblink = ConnectionConfig.getConfig((long)D.l((Object)id));
        String type = dblink.getString(DATABASE_TYPE);
        if ("eas".equals(type)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("content", Util.getConnectorInfo((DynamicObject)dblink));
            FormOpener.showForm((AbstractFormPlugin)this, "isc_text_content_dialog", ResManager.loadKDString((String)"sp\u5305\u6784\u5efa\u4fe1\u606f", (String)"DatabaseLinkFormPlugin_39", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u7c7b\u578b\uff1a%1$s\uff0c\u4e0d\u652f\u6301\u67e5\u770bsp\u5305\u6784\u5efa\u65f6\u95f4\u3002", (String)"DatabaseLinkFormPlugin_38", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), type));
        }
    }

    private void showGuideForm() {
        ListSelectedRowCollection successPkIds = this.getSelectedRows();
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        if (successPkIds.size() == 1) {
            DynamicObject cnType = this.getCnType(successPkIds.get(0).getPrimaryKeyValue());
            String permit = D.s((Object)cnType.getString("permit"));
            params.put("update", "false");
            if (permit.contains("UPDATE")) {
                params.put("update", "true");
            }
            params.put("wizard_data_base_link_id", successPkIds.get(0).getPrimaryKeyValue());
            params.put("linkTypeNumber", cnType.getString(NUMBER));
            FormOpener.showTabForm((AbstractFormPlugin)this, "isc_data_link_guide", null, params, null);
        } else if (successPkIds.isEmpty()) {
            this.putSourceApp(params);
            FormOpener.showTabForm((AbstractFormPlugin)this, "isc_data_link_guide", null, params, null);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u3002", (String)"DatabaseLinkListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void putSourceApp(Map<String, Object> params) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String source_app = D.s(customParams.get("source_app"));
        if (source_app != null) {
            params.put("source_app", source_app);
        }
    }

    public void showNoticeForm(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (D.l((Object)id) > 0L) {
            QFilter[] qf = QFilterUtil.builder().put("dblink", "=", id).build();
            DynamicObject[] notices = BusinessDataServiceHelper.load((String)"isc_link_notification", (String)"id", (QFilter[])qf, (String)"modifydate desc");
            if (notices.length > 0) {
                FormOpener.showView((AbstractFormPlugin)this, "isc_link_notification", notices[0].getPkValue());
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>(2);
                params.put("link", id);
                FormOpener.showModalBill((AbstractFormPlugin)this, "isc_link_notification", ResManager.loadKDString((String)"\u8fde\u63a5\u901a\u77e5", (String)"DatabaseLinkListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
            }
        }
    }

    private void test(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id != null) {
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put("id", id);
            DatabaseLinkUtil.testConnection(params, this.getView(), null);
        }
    }

    private void deploy(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id != null) {
            this.validateOperation(id, ResManager.loadKDString((String)"\u8fdc\u7a0b\u90e8\u7f72", (String)"DatabaseLinkListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", id);
            String formNumber = this.getDeployFormNumberByConnType(id);
            FormOpener.showForm((AbstractFormPlugin)this, formNumber, ResManager.loadKDString((String)"\u8fde\u63a5\u5668\u90e8\u7f72", (String)"DatabaseLinkListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "deploy_back");
        }
    }

    private String getDatabaseTypeByDblinkId(Object id) {
        QFilter qFilter = new QFilter("id", "=", id);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"isc_database_link", (String)DATABASE_TYPE, (QFilter[])qFilter.toArray());
        String database_type = D.s((Object)dynamicObject.get(DATABASE_TYPE));
        return database_type;
    }

    private String getDeployFormNumberByConnType(Object id) {
        String database_type = this.getDatabaseTypeByDblinkId(id);
        if ("eas".equals(database_type)) {
            return "isc_eas_connector_deploy";
        }
        if ("ierp".equals(database_type)) {
            return "isc_ierp_connector_deploy";
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"%s\u8fde\u63a5\u7c7b\u578b\u4e0d\u652f\u6301\u90e8\u7f72\u3002", (String)"DatabaseLinkListPlugin_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), database_type));
    }

    private String getUnDeployFormNumberByConnType(Object id) {
        String database_type = this.getDatabaseTypeByDblinkId(id);
        if ("eas".equals(database_type)) {
            return "isc_eas_database_undeploy";
        }
        if ("ierp".equals(database_type)) {
            return "isc_ierpdatabase_undeploy";
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"%s\u8fde\u63a5\u7c7b\u578b\u4e0d\u652f\u6301\u53cd\u90e8\u7f72\u3002", (String)"DatabaseLinkListPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), database_type));
    }

    private void undeploy(AfterDoOperationEventArgs args) {
        long dblinkId = D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, args));
        if (dblinkId != 0L) {
            this.checkAvaliableUndeploy(dblinkId);
            this.validateOperation(dblinkId, ResManager.loadKDString((String)"\u8fdc\u7a0b\u53cd\u90e8\u7f72", (String)"DatabaseLinkListPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", dblinkId);
            String formNumber = this.getUnDeployFormNumberByConnType(dblinkId);
            FormOpener.showForm((AbstractFormPlugin)this, formNumber, ResManager.loadKDString((String)"\u8fde\u63a5\u5668\u53cd\u90e8\u7f72", (String)"DatabaseLinkListPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "undeploy_back");
        }
    }

    private void checkAvaliableUndeploy(long dblinkId) {
        QFilter qFilter = new QFilter("id", "=", (Object)dblinkId);
        DynamicObject dblink = QueryServiceHelper.queryOne((String)"isc_database_link", (String)"state", (QFilter[])new QFilter[]{qFilter});
        if (dblink != null && !"S".equals(dblink.getString("state"))) {
            throw new IscBizException(ResManager.loadKDString((String)"\u8fde\u63a5\u72b6\u6001\u5f02\u5e38,\u8bf7\u5148\u6d4b\u8bd5\u901a\u8fc7\u540e\u518d\u8fdb\u884c\u53cd\u90e8\u7f72", (String)"DatabaseLinkListPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("dblink", "=", (Object)dblinkId);
        DynamicObject dataSource = QueryServiceHelper.queryOne((String)"isc_data_source", (String)"id", (QFilter[])new QFilter[]{filter});
        if (dataSource != null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5b58\u5728\u6570\u636e\u6e90\u5f15\u7528\u8be5\u8fde\u63a5,\u8bf7\u5148\u5220\u9664\u6570\u636e\u6e90\u5f15\u7528\u518d\u8fdb\u884c\u53cd\u90e8\u7f72", (String)"DatabaseLinkListPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void showPermit(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id != null) {
            this.validateOperation(id, ResManager.loadKDString((String)"\u7ba1\u7406\u6388\u6743", (String)"DatabaseLinkListPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            FormOpener.showList((AbstractFormPlugin)this, "isc_connector_permit", "data_source.dblink", id);
        }
    }

    private void pushPermit(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id != null) {
            this.validateOperation(id, ResManager.loadKDString((String)"\u63a8\u9001\u6388\u6743", (String)"DatabaseLinkListPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", id);
            FormOpener.showForm((AbstractFormPlugin)this, "isc_connector_pusher", ResManager.loadKDString((String)"\u63a8\u9001\u6388\u6743", (String)"DatabaseLinkListPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateOperation(Object id, String operation) {
        ConnectionManager.pushResLicense((boolean)true);
        try (ConnectionWrapper cn = ConnectionManager.getConnection((long)D.l((Object)id));){
            if (!cn.getFactory().supportsRemoteDeploy()) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8be5\u8fde\u63a5\u4e0d\u652f\u6301%s\uff01", (String)"DatabaseLinkListPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), operation));
            }
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateInitEnv(Object id, String operation) {
        ConnectionManager.pushResLicense((boolean)true);
        try (ConnectionWrapper cn = ConnectionManager.getConnection((long)D.l((Object)id));){
            DynamicObject cfg = cn.getConfig();
            if (!cn.getFactory().supportsRemoteDeploy() && !"self".equals(cfg.get(DATABASE_TYPE))) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8be5\u8fde\u63a5\u4e0d\u652f\u6301%s\uff01", (String)"DatabaseLinkListPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), operation));
            }
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private void initEnvironment(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id != null) {
            this.validateInitEnv(id, ResManager.loadKDString((String)"\u73af\u5883\u521d\u59cb\u5316", (String)"DatabaseLinkListPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", id);
            FormOpener.showForm((AbstractFormPlugin)this, "isc_init_panel", ResManager.loadKDString((String)"\u73af\u5883\u521d\u59cb\u5316", (String)"DatabaseLinkListPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ResourceIsolateUtil.setListFilter(e, customParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showEventQueue(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id == null) {
            return;
        }
        DynamicObject dblink = ConnectionConfig.getConfig((long)D.l((Object)id));
        if ("isc_hub".equals(dblink.getString(DATABASE_TYPE))) {
            ListShowParameter param = new ListShowParameter();
            param.setBillFormId("isc_res_evt_log");
            param.setFormId("bos_list");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        } else {
            ConnectionManager.pushResLicense((boolean)true);
            try (ConnectionWrapper cn = ConnectionManager.getConnection((long)D.l((Object)id));){
                if (!cn.getFactory().supportsEvent()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8fde\u63a5\u7c7b\u578b\u4e0d\u652f\u6301\u67e5\u770b\u201c\u89e6\u53d1\u65e5\u5fd7\u201d\u3002", (String)"DatabaseLinkListPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                    return;
                }
                cn.getFactory().test(cn);
            }
            finally {
                ConnectionManager.popResLicense();
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("dblink", id);
            params.put(NAME, dblink.getString(NAME));
            params.put("frompage", "databaseLink");
            FormOpener.showTabForm((AbstractFormPlugin)this, "isc_con_evt_que", null, params, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showEventBinding(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id == null) {
            return;
        }
        DynamicObject dblink = ConnectionConfig.getConfig((long)D.l((Object)id));
        if ("isc_hub".equals(dblink.getString(DATABASE_TYPE))) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_res_evt_bnd", new QFilter("id", ">", (Object)0));
        } else {
            ConnectionManager.pushResLicense((boolean)true);
            try (ConnectionWrapper cn = ConnectionManager.getConnection((long)D.l((Object)id));){
                if (!cn.getFactory().supportsEvent()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8fde\u63a5\u7c7b\u578b\u4e0d\u652f\u6301\u67e5\u770b\u201c\u4e8b\u4ef6\u7ed1\u5b9a\u201d\u3002", (String)"DatabaseLinkListPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                    return;
                }
                cn.getFactory().test(cn);
            }
            finally {
                ConnectionManager.popResLicense();
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("dblink", id);
            FormOpener.showTabForm((AbstractFormPlugin)this, "isc_con_evt_bnd", null, params, null);
        }
    }

    private void showContextInfo() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("content", String.format(ResManager.loadKDString((String)"\u8d26\u5957ID\uff1a%s", (String)"DatabaseLinkListPlugin_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), RequestContext.get().getAccountId()) + "\n" + String.format(ResManager.loadKDString((String)"\u79df\u6237ID\uff1a%s", (String)"DatabaseLinkListPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), RequestContext.get().getTenantId()));
        FormOpener.showForm((AbstractFormPlugin)this, "isc_text_content_dialog", ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3\u5217\u8868", (String)"DatabaseLinkListPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    private void networkTest(AfterDoOperationEventArgs args) {
        Object id = FormOpener.getSelectedId((AbstractFormPlugin)this, args);
        if (id != null) {
            DynamicObject cfg = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_database_link", (String)DATABASE_TYPE);
            if ("self".equals(cfg.getString(DATABASE_TYPE))) {
                throw new IscBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5957\u4e0d\u9700\u8981\u7f51\u7edc\u6d4b\u8bd5", (String)"DatabaseLinkListPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", id);
            FormOpener.showForm((AbstractFormPlugin)this, "isc_check_network_panel", ResManager.loadKDString((String)"\u7f51\u7edc\u68c0\u67e5", (String)"DatabaseLinkListPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
        String taskId = "RefreshConnectionLicenseInfo";
        if (!TaskManager.exists((String)taskId)) {
            this.asyncRefreshLicenseInfo(taskId);
        }
    }

    private void asyncRefreshLicenseInfo(final String taskId) {
        TaskManager.submit((Task)new Task(){

            public String getId() {
                return taskId;
            }

            public void run() {
                DynamicObject[] links = BusinessDataServiceHelper.load((String)"isc_database_link", (String)"database_type, license_info,license_sn", null);
                DatabaseLinkListPlugin.this.setLicenseInfo(Arrays.asList(links));
                SaveServiceHelper.save((DynamicObject[])links);
            }
        });
    }

    private void setLicenseInfo(Collection<DynamicObject> links) {
        if (links.isEmpty()) {
            return;
        }
        AccountInfo account = LicenseCache.getTenant().getCurrentAccount();
        if (account == null) {
            account = LicenseCache.refreshTenant2().getCurrentAccount();
        }
        for (DynamicObject link : links) {
            long id = link.getLong("id");
            ConnectionInfo cn = account.getSystemConnection(id);
            if (cn == null) {
                account = LicenseCache.refreshTenant2().getCurrentAccount();
                cn = account.getSystemConnection(id);
            }
            if (cn == null) continue;
            link.set(LICENSE_INFO, (Object)cn.getStateString());
            link.set(LICENSE_SN, (Object)cn.getLicenseSN());
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        if (currentListSelectedRow == null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"init_env", "deploy", "evt_bind"});
            return;
        }
        Object primaryKeyValue = currentListSelectedRow.getPrimaryKeyValue();
        DynamicObject object = QueryServiceHelper.queryOne((String)"isc_database_link", (String)"id, database_type", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
        if (object == null) {
            return;
        }
        String type = D.s((Object)object.get(DATABASE_TYPE));
        boolean visible = "eas".equals(type);
        boolean initEnvVisible = "eas".equals(type) || "self".equals(type) || "ierp".equals(type);
        this.getView().setVisible(Boolean.valueOf(initEnvVisible), new String[]{"init_env"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"get_deploy_info", "get_sp_time", "callback_test"});
        visible = visible || "ierp".equals(type);
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"deploy"});
        this.getView().setVisible(Boolean.valueOf(visible || "db_proxy".equals(type) || "self".equals(type) || "isc_hub".equals(type)), new String[]{"evt_bind"});
        this.getView().setVisible(Boolean.valueOf(!"self".equals(type) && !"isc_hub".equals(type)), new String[]{"network_test"});
        this.getView().setVisible(Boolean.valueOf("isc_hub".equals(type)), new String[]{"show_udf_event_list"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        AbstractOperate operate;
        String operateKey;
        ListSelectedRowCollection collection = evt.getListSelectedData();
        if (evt.getSource() instanceof AbstractOperate && collection.size() > 0 && "delete".equals(operateKey = (operate = (AbstractOperate)evt.getSource()).getOperateKey())) {
            this.executeDelete(evt, collection);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("deploy_back".equals(actionId) || "undeploy_back".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDelete(BeforeDoOperationEventArgs evt, ListSelectedRowCollection collection) {
        Object[] ids = collection.getPrimaryKeyValues();
        int length = ids.length;
        ArrayList<Object> values = new ArrayList<Object>(length);
        ArrayList<Integer> types = new ArrayList<Integer>(length);
        String selectSql = this.getSelectSql(ids, length, values, types);
        if (values.size() > 0) {
            Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            try {
                List dataRows = DbUtil.executeList((Connection)cn, (String)selectSql, values, types);
                for (DataRow dataRow : dataRows) {
                    String permit = D.s((Object)dataRow.get((Object)"fpermit"));
                    if (permit == null || permit.contains("DELETE")) continue;
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a:(%s)\u7684\u8fde\u63a5\u914d\u7f6e\u6ca1\u6709\u5220\u9664\u6743\u9650\u3002", (String)"DatabaseLinkListPlugin_34", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dataRow.get((Object)"fnumber")));
                    evt.setCancel(true);
                    break;
                }
            }
            finally {
                DbUtil.close((Connection)cn);
            }
        }
    }

    private String getSelectSql(Object[] ids, int length, List<Object> values, List<Integer> types) {
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT a.fnumber,b.fpermit FROM t_isc_database_link a LEFT JOIN t_iscb_connection_type b ON a.fdatabase_type = b.fnumber WHERE A.fid IN (");
        for (int i = 0; i < length; ++i) {
            selectSql.append('?');
            values.add(ids[i]);
            types.add(-5);
            if (i >= length - 1) continue;
            selectSql.append(',');
        }
        selectSql.append(')');
        return selectSql.toString();
    }

    private void showDeployInfo(AfterDoOperationEventArgs args) {
        long dblinkId = D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, args));
        if (dblinkId != 0L) {
            this.checkIsEas(dblinkId);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", dblinkId);
            FormOpener.showForm((AbstractFormPlugin)this, "isc_connector_info", ResManager.loadKDString((String)"\u68c0\u67e5\u90e8\u7f72\u4fe1\u606f", (String)"DatabaseLinkListPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIsEas(long dblinkId) {
        ConnectionManager.pushResLicense((boolean)true);
        try {
            ConnectionWrapper connection = null;
            try {
                connection = ConnectionManager.getConnection((long)dblinkId);
                DynamicObject cfg = connection.getConfig();
                if (!"eas".equals(cfg.getString(DATABASE_TYPE))) {
                    throw new IscBizException(ResManager.loadKDString((String)"\u5f53\u524d\u8fde\u63a5\u7c7b\u578b\u4e0d\u652f\u6301\u68c0\u67e5\u90e8\u7f72\u4fe1\u606f\u3002", (String)"DatabaseLinkListPlugin_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
            }
            finally {
                ConnectorUtil.close((AutoCloseable)connection);
            }
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty() || !((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)DatabaseLinkListPlugin.LICENSE_INFO)) {
                return rows;
            }
            this.refreshConnectionType(rows);
            DatabaseLinkListPlugin.this.setLicenseInfo((Collection)rows);
            this.setLinkLogoField(rows);
            return rows;
        }

        private void refreshConnectionType(DynamicObjectCollection rows) {
            ArrayList<List<Object>> batch = new ArrayList<List<Object>>();
            for (DynamicObject row : rows) {
                String dum_link = D.s((Object)row.get("dum_link.number"));
                if (dum_link != null) continue;
                Object database_type = row.get(DatabaseLinkListPlugin.DATABASE_TYPE);
                DynamicObject conn = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (String)"number,name,id", (QFilter[])new QFilter[]{new QFilter(DatabaseLinkListPlugin.NUMBER, "=", database_type)});
                if (conn == null) continue;
                ArrayList<Object> values = new ArrayList<Object>(2);
                values.add(conn.get("id"));
                values.add(row.get("id"));
                batch.add(values);
                row.set("dum_link", (Object)conn);
            }
            if (!batch.isEmpty()) {
                this.innerRefreshType(batch);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void innerRefreshType(List<List<Object>> batch) {
            Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
            try {
                String sql = "update t_isc_database_link set fdum_link = ? where fid = ?";
                ArrayList<Integer> types = new ArrayList<Integer>(2);
                types.add(12);
                types.add(-5);
                DbUtil.executeBatch((Connection)cn, (String)sql, batch, types);
            }
            finally {
                DbUtil.close((Connection)cn, (boolean)true);
            }
        }

        private void setLinkLogoField(DynamicObjectCollection rows) {
            rows.getDynamicObjectType().getProperties().add((Object)new DynamicSimpleProperty(DatabaseLinkListPlugin.LOGO, String.class, (Object)"0"));
            String url = UrlService.getDomainContextUrl().replace("localhost", NetUtil.getLocalAddress());
            HashSet<String> idSet = new HashSet<String>();
            for (DynamicObject row : rows) {
                String id = D.s((Object)row.get("dum_link.id"));
                if (id == null) continue;
                idSet.add(id);
            }
            if (idSet.isEmpty()) {
                return;
            }
            Map<String, String> map = this.getLogoMap(url, idSet);
            for (DynamicObject row : rows) {
                row.set(DatabaseLinkListPlugin.LOGO, (Object)map.get(row.getString("dum_link.id")));
            }
        }

        private Map<String, String> getLogoMap(String url, Set<String> idSet) {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"isc_connection_type", (String)"id,number,logo", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
            HashMap<String, String> map = new HashMap<String, String>(dynamicObjects.length);
            for (DynamicObject object : dynamicObjects) {
                String logo = D.s((Object)object.get(DatabaseLinkListPlugin.LOGO));
                logo = logo != null ? logo : "default_logo.png";
                map.put(D.s((Object)object.get("id")), url + "/kingdee/isc/connection_type_logo/" + logo);
            }
            return map;
        }
    }
}

