/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.ConnectionConfig;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.dc.s.InitData;
import kd.isc.iscb.platform.core.util.InitEnvUtil;
import kd.isc.iscb.util.connector.InitResult;
import kd.isc.iscb.util.connector.InitStatus;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class InitEnvPanelFormPlugin
extends AbstractFormPlugin {
    private static final String REMOTE_SYSTEM = "remote_system";
    private static final String AUTHORITY_INIT_LOG = "authority_init_log";
    private static final String LOG_INIT_LOG = "log_init_log";
    private static final String EVENT_INIT_LOG = "event_init_log";
    private static Log logger = LogFactory.getLog(InitEnvPanelFormPlugin.class);
    private static Map<String, String> itemToCheckInitControl = new HashMap<String, String>();
    private static Map<String, String> itemToInitResultControl = new HashMap<String, String>();
    private static Map<String, String> itemToInitErrorControl = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{AUTHORITY_INIT_LOG, LOG_INIT_LOG, EVENT_INIT_LOG});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof TextEdit) {
            String key = ((TextEdit)src).getKey();
            String authority_init_error_tag = (String)this.getModel().getValue("authority_init_error_tag");
            String log_init_error_tag = (String)this.getModel().getValue("log_init_error_tag");
            String event_init_error_tag = (String)this.getModel().getValue("event_init_error_tag");
            if (AUTHORITY_INIT_LOG.equals(key) && !StringUtil.isEmpty((String)authority_init_error_tag)) {
                FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u6388\u6743\u521d\u59cb\u5316\u5f02\u5e38\u4fe1\u606f", (String)"InitEnvPanelFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), authority_init_error_tag);
            } else if (LOG_INIT_LOG.equals(key) && !StringUtil.isEmpty((String)log_init_error_tag)) {
                FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u89e6\u53d1\u65e5\u5fd7\u521d\u59cb\u5316\u5f02\u5e38\u4fe1\u606f", (String)"InitEnvPanelFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), log_init_error_tag);
            } else if (EVENT_INIT_LOG.equals(key) && !StringUtil.isEmpty((String)event_init_error_tag)) {
                FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u4e8b\u4ef6\u7ed1\u5b9a\u521d\u59cb\u5316\u5f02\u5e38\u4fe1\u606f", (String)"InitEnvPanelFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), event_init_error_tag);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u68c0\u6d4b\u9879", (String)"InitEnvPanelFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("textfield1", (Object)ResManager.loadKDString((String)"\u68c0\u67e5\u72b6\u6001", (String)"InitEnvPanelFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("textfield2", (Object)ResManager.loadKDString((String)"\u521d\u59cb\u5316\u72b6\u6001", (String)"InitEnvPanelFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("textfield3", (Object)ResManager.loadKDString((String)"\u4e8b\u4ef6\u7ed1\u5b9a\u5217\u8868", (String)"InitEnvPanelFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("textfield9", (Object)ResManager.loadKDString((String)"\u89e6\u53d1\u65e5\u5fd7\u5217\u8868", (String)"InitEnvPanelFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.getModel().setValue("textfield5", (Object)ResManager.loadKDString((String)"\u6388\u6743\u5217\u8868", (String)"InitEnvPanelFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object dblink = this.getView().getFormShowParameter().getCustomParam("id");
        IDataModel model = this.getModel();
        long dblinkId = D.l((Object)dblink);
        if (dblinkId != 0L && model.getValue(REMOTE_SYSTEM) == null) {
            this.getModel().setValue(REMOTE_SYSTEM, dblink);
            this.getView().updateView(REMOTE_SYSTEM);
            DynamicObject cn = ConnectionConfig.getConfig((long)dblinkId);
            this.getView().setVisible(Boolean.valueOf(!"self".equals(cn.get("database_type"))), new String[]{"password"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        ConnectionWrapper cn;
        block7: {
            super.afterDoOperation(args);
            cn = null;
            try {
                if (!"check_env".equals(args.getOperateKey()) && !"init_env".equals(args.getOperateKey())) break block7;
                this.getView().setEnable(Boolean.FALSE, new String[]{"btncancel", "btnok"});
                this.resetInitControl();
                String adminPassword = D.s((Object)this.getModel().getValue("password"));
                long dblinkId = D.l((Object)this.getModel().getValue("remote_system_id"));
                cn = this.getConnection(dblinkId);
                if ("check_env".equals(args.getOperateKey())) {
                    this.checkInitState(cn, adminPassword);
                } else if ("init_env".equals(args.getOperateKey())) {
                    this.initEnv(cn, adminPassword);
                }
                this.getView().updateView();
            }
            catch (Throwable e) {
                try {
                    FormOpener.showErrorMessage(this.getView(), e);
                }
                catch (Throwable throwable) {
                    ConnectorUtil.close(cn);
                    this.getView().setEnable(Boolean.TRUE, new String[]{"btncancel", "btnok"});
                    throw throwable;
                }
                ConnectorUtil.close(cn);
                this.getView().setEnable(Boolean.TRUE, new String[]{"btncancel", "btnok"});
            }
        }
        ConnectorUtil.close(cn);
        this.getView().setEnable(Boolean.TRUE, new String[]{"btncancel", "btnok"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionWrapper getConnection(long dblinkId) {
        ConnectionManager.pushResLicense((boolean)true);
        try {
            ConnectionWrapper connectionWrapper = ConnectionManager.getConnection((long)dblinkId);
            return connectionWrapper;
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private void resetInitControl() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("fc", "white");
        for (String s : itemToCheckInitControl.values()) {
            this.getModel().setValue(s, (Object)"");
            this.getView().updateControlMetadata(s, data);
        }
        for (String s : itemToInitResultControl.values()) {
            this.getModel().setValue(s, (Object)"");
            this.getView().updateControlMetadata(s, data);
        }
        for (String s : itemToInitErrorControl.values()) {
            this.getModel().setValue(s, (Object)"");
        }
    }

    private void checkInitState(ConnectionWrapper cn, String adminPassword) {
        int initType = InitData.Bindings.getValue() + InitData.EventLog.getValue() + InitData.Autoritys.getValue();
        Map prepareInitData = InitEnvUtil.prepareInitData((ConnectionWrapper)cn, (int)initType);
        Map stateMap = cn.getFactory().checkInitState(cn, prepareInitData, adminPassword);
        for (Map.Entry entry : stateMap.entrySet()) {
            String k = (String)entry.getKey();
            InitResult v = (InitResult)entry.getValue();
            this.getModel().setValue(itemToCheckInitControl.get(k), (Object)v.getStatus().getMsg());
            this.updateControl(k, v, itemToCheckInitControl);
            if (v.getErrorStack() == null) continue;
            logger.info(k + "\u9700\u8981\u521d\u59cb\u5316\uff0c\u539f\u56e0\uff1a" + v.getErrorStack());
        }
    }

    private void initEnv(ConnectionWrapper cn, String adminPassword) {
        int initType = InitData.Bindings.getValue() + InitData.EventLog.getValue() + InitData.Autoritys.getValue();
        Map prepareInitData = InitEnvUtil.prepareInitData((ConnectionWrapper)cn, (int)initType);
        Map stateMap = cn.getFactory().initEnv(cn, prepareInitData, adminPassword);
        stateMap.forEach((k, v) -> {
            this.getModel().setValue(itemToInitResultControl.get(k), (Object)v.getStatus().getMsg());
            this.updateControl((String)k, (InitResult)v, itemToInitResultControl);
            if (v.getErrorStack() != null) {
                this.getModel().setValue(itemToInitErrorControl.get(k), (Object)v.getErrorStack());
            }
        });
    }

    private void updateControl(String k, InitResult v, Map<String, String> item) {
        if (v.getStatus() == InitStatus.NEED_INIT || v.getStatus() == InitStatus.INIT_ERROR) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("fc", "red");
            this.getView().updateControlMetadata(item.get(k), data);
        } else if (v.getStatus() == InitStatus.INIT_COMPLETE) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("fc", "green");
            this.getView().updateControlMetadata(item.get(k), data);
        } else if (v.getStatus() == InitStatus.NEED_NOT_INIT) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("fc", "black");
            this.getView().updateControlMetadata(item.get(k), data);
        }
    }

    static {
        itemToCheckInitControl.put(InitData.Bindings.name(), "is_event_inited");
        itemToCheckInitControl.put(InitData.EventLog.name(), "is_log_inited");
        itemToCheckInitControl.put(InitData.Autoritys.name(), "is_authority_inited");
        itemToInitResultControl.put(InitData.Bindings.name(), EVENT_INIT_LOG);
        itemToInitResultControl.put(InitData.EventLog.name(), LOG_INIT_LOG);
        itemToInitResultControl.put(InitData.Autoritys.name(), AUTHORITY_INIT_LOG);
        itemToInitErrorControl.put(InitData.Bindings.name(), "event_init_error_tag");
        itemToInitErrorControl.put(InitData.EventLog.name(), "log_init_error_tag");
        itemToInitErrorControl.put(InitData.Autoritys.name(), "authority_init_error_tag");
    }
}

