/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.Script;

public class OpParamsSelectorFormPlugin
extends AbstractListPlugin
implements RowClickEventListener {
    public static final String ENTRYENTITY = "entryentity";
    public static final String OP_PARAM = "op_param";
    public static final String CODEEDITAP = "codeeditap";
    private static Log logger = LogFactory.getLog(OpParamsSelectorFormPlugin.class);
    private static List<Map<String, String>> op_params_list = new ArrayList<Map<String, String>>();
    private static Map<String, String> op_exp = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryentity = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryentity.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initOpParamsExp();
        String op_param = (String)this.getView().getFormShowParameter().getCustomParam(OP_PARAM);
        Map<String, Object> paramMap = this.formatInputMap(op_param);
        this.addParams(paramMap);
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        for (int i = 0; i < op_params_list.size(); ++i) {
            DynamicObject item = entryentity.addNew();
            Map<String, String> map = op_params_list.get(i);
            item.set("seq", (Object)i);
            item.set(OP_PARAM, (Object)map.get("name"));
            item.set("desc", (Object)op_exp.get(D.s((Object)map.get("name"))));
            item.set("default", (Object)map.get("default"));
        }
        this.getView().updateView(ENTRYENTITY);
        if (!paramMap.isEmpty()) {
            int[] focus = new int[paramMap.size()];
            int j = 0;
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject item = (DynamicObject)entryentity.get(i);
                if (!paramMap.containsKey(item.getString(OP_PARAM))) continue;
                focus[j++] = i;
            }
            EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
            entry.selectRows(focus, 0);
        }
        this.setMarkDown();
    }

    private void initOpParamsExp() {
        op_exp.put("autogeneratebillno", ResManager.loadKDString((String)"\u6570\u636e\u5305\u7684\u7f16\u7801\u4e3a\u7a7a\u65f6\uff0cwebapi\u81ea\u52a8\u751f\u6210\u7f16\u7801", (String)"OpParamsSelectorFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        op_exp.put("checkrefentityids", ResManager.loadKDString((String)"\u64cd\u4f5c\u53ef\u9009\u53c2\u6570\uff0c\u5220\u9664\u57fa\u7840\u8d44\u6599\uff0c\u53ea\u68c0\u67e5\u8fd9\u4e9b\u5355\u636e\u6709\u6ca1\u6709\u5f15\u7528\u5f85\u5220\u9664\u7684\u8d44\u6599\uff0c\n\u5982\u9700\u68c0\u67e5\u591a\u79cd\u5355\u636e\uff0c\u4f7f\u7528\u9017\u53f7\u9694\u5f00\uff0c\"pur_order,pur_stock\"", (String)"OpParamsSelectorFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        op_exp.put("ignorerefentityids", ResManager.loadKDString((String)"\u64cd\u4f5c\u53ef\u9009\u53c2\u6570\uff0c\u5220\u9664\u57fa\u7840\u8d44\u6599\uff0c\u4e0d\u9700\u68c0\u67e5\u8fd9\u4e9b\u5355\u636e\u6709\u6ca1\u6709\u5f15\u7528\u5f85\u5220\u9664\u7684\u8d44\u6599\uff0c\n\u5982\u679c\u9700\u6392\u9664\u591a\u79cd\u5355\u636e\uff0c\u4f7f\u7528\u9017\u53f7\u9694\u5f00\uff0c\"pur_order,pur_stock\"", (String)"OpParamsSelectorFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        op_exp.put("ishasright", ResManager.loadKDString((String)"\u64cd\u4f5c\u53ef\u9009\u53c2\u6570\uff0c\u5df2\u7ecf\u9a8c\u6743\uff0c\u6267\u884c\u64cd\u4f5c\u670d\u52a1\u65f6\uff0c\u4e0d\u9700\u8981\u518d\u6b21\u9a8c\u6743", (String)"OpParamsSelectorFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        op_exp.put("ignoreValidation", ResManager.loadKDString((String)"\u7f51\u63a7\u68c0\u67e5,\u5ffd\u7565\u7f51\u7edc\u63a7\u5236\u7684\u6821\u9a8c\u5668\uff0c\u5373\u4e0d\u8d70\u7f51\u7edc\u63a7\u5236\u6821\u9a8c\u5668", (String)"OpParamsSelectorFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        op_exp.put("orm_removeDataCache", ResManager.loadKDString((String)"\u662f\u5426\u8df3\u8fc7\u7cfb\u7edf\u9ed8\u8ba4\u7684\u6743\u9650\u6821\u9a8c\uff0c\u6570\u636e\u3001\u64cd\u4f5c\u6743\u9650\u7b49", (String)"OpParamsSelectorFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        op_exp.put("skipbillnovalidator", ResManager.loadKDString((String)"\u4fdd\u5b58\u3001\u63d0\u4ea4\u5355\u636e\u65f6\uff0c\u7565\u8fc7\u5355\u636e\u7f16\u53f7\u5b57\u6bb5\u7684\u5fc5\u5f55\u3001\u91cd\u590d\u68c0\u67e5\uff0c\n\u7531\u7f16\u7801\u89c4\u5219\u5728\u6821\u9a8c\u901a\u8fc7\u540e\u81ea\u52a8\u751f\u6210\u7f16\u7801", (String)"OpParamsSelectorFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        op_exp.put("isc_tag_of_datasource", ResManager.loadKDString((String)"\u4fdd\u5b58\u65f6\u5982\u679c\u5355\u636e\u7f16\u53f7\u6ca1\u6709\u503c\u6839\u636e\u7f16\u7801\u89c4\u5219\u751f\u6210\u7f16\u53f7\uff0c\n\u7f16\u53f7\u6709\u503c\u5219\u66f4\u65b0\u7f16\u7801\u89c4\u5219\u6700\u5927\u53f7", (String)"OpParamsSelectorFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        op_exp.put("WF", ResManager.loadKDString((String)"\u662f\u5426\u8fdb\u5165\u5de5\u4f5c\u6d41", (String)"OpParamsSelectorFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private Map<String, Object> formatInputMap(String op_param) {
        Map paramMap = new HashMap();
        try {
            paramMap = (Map)Json.toObject((String)op_param);
        }
        catch (Exception ex) {
            logger.warn("invalid json map string :" + op_param, (Throwable)ex);
        }
        return paramMap == null ? new HashMap() : paramMap;
    }

    private void addParams(Map<String, Object> paramMap) {
        if (paramMap == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
            HashMap<String, String> default_value;
            Map<String, String> to_add_map = this.getPresit(entry.getKey());
            if (to_add_map.isEmpty()) {
                to_add_map.put("name", entry.getKey());
                to_add_map.put("desc", ResManager.loadKDString((String)"\u975e\u96c6\u6210\u4e91\u63d0\u4f9b\uff0c\u7528\u6237\u624b\u52a8\u6dfb\u52a0", (String)"OpParamsSelectorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                default_value = new HashMap();
                default_value.put(entry.getKey(), D.s((Object)entry.getValue()));
                to_add_map.put("default", Json.toString(default_value, (boolean)true));
                op_params_list.add(to_add_map);
                continue;
            }
            default_value = new HashMap<String, String>();
            default_value.put(entry.getKey(), D.s((Object)entry.getValue()));
            to_add_map.put("default", Json.toString(default_value, (boolean)true));
        }
    }

    private Map<String, String> getPresit(String key) {
        for (Map<String, String> map : op_params_list) {
            if (!map.get("name").equalsIgnoreCase(key)) continue;
            return map;
        }
        return new HashMap<String, String>();
    }

    public void entryRowClick(RowClickEvent evt) {
        this.setMarkDown();
    }

    private void setMarkDown() {
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entry.getSelectRows();
        Markdown mk = (Markdown)this.getView().getControl("markdownap");
        CodeEdit codeeditap = (CodeEdit)this.getView().getControl(CODEEDITAP);
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n").append(ResManager.loadKDString((String)"#### \u5df2\u9009\u64cd\u4f5c\u53c2\u6570\uff1a", (String)"OpParamsSelectorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append('\n');
        HashMap result = new HashMap();
        for (int selectRow : selectRows) {
            DynamicObject row = (DynamicObject)this.getModel().getEntryEntity(ENTRYENTITY).get(selectRow);
            sb.append("```\n\n").append(row.getString(OP_PARAM)).append('\uff1a').append(row.get("desc")).append("\n```\n\n");
            result.putAll((Map)Json.toObject((String)row.getString("default")));
        }
        mk.setText(sb.toString());
        if (result.isEmpty()) {
            codeeditap.setText("");
        } else {
            codeeditap.setText(Json.toString(result, (boolean)true));
        }
        this.getView().updateView("markdownap, codeeditap");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcControl = (Control)evt.getSource();
        if ("btnok".equals(srcControl.getKey())) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            CodeEdit codeeditap = (CodeEdit)this.getView().getControl(CODEEDITAP);
            String expression = D.s((Object)codeeditap.getText());
            params.put(OP_PARAM, expression);
            this.getView().returnDataToParent((Object)params);
            this.getView().close();
        }
    }

    private void remove() {
        op_params_list.clear();
    }

    static {
        try (InputStream in = OpParamsSelectorFormPlugin.class.getResourceAsStream("/aggr/op_params.json");){
            String jsonStr = NetUtil.readText((InputStream)in);
            op_params_list = (List)Script.parseJson((String)jsonStr);
        }
        catch (IOException e) {
            logger.warn(ResManager.loadKDString((String)"\u64cd\u4f5c\u53c2\u6570\u5f39\u7a97\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (String)"OpParamsSelectorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

