/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.robot.SmartScriptTypeEnum;
import kd.isc.iscb.formplugin.tools.AbstractScriptEditorFormPlugin;
import kd.isc.iscb.formplugin.util.FileUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.encoding.PseudoBase64;

public class ScriptEditorPlugin
extends AbstractScriptEditorFormPlugin {
    private static final String REMARK = "remark";
    private static final String SCRIPT = "script";
    private static final String CLEAR_SCRIPT = "clear_script";
    private static final Map<String, String> TIPS_MSG = new HashMap<String, String>();

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        CodeEdit editor = (CodeEdit)this.getView().getControl(SCRIPT);
        if (editor != null) {
            editor.setText((String)params.get(SCRIPT));
        }
        this.getModel().setValue(REMARK, params.get(REMARK));
        this.getPageCache().put(REMARK, (String)params.get(REMARK));
        this.getPageCache().put(SCRIPT, (String)params.get(SCRIPT));
        if (params.get("view") != null && ((Boolean)params.get("view")).booleanValue()) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnok", "btn_clear"});
        }
        if (this.getModel().getProperty("demo") != null) {
            String demoFileName = D.s(params.get("demo_file_name"));
            if (demoFileName != null) {
                this.getModel().setValue("demo", (Object)FileUtil.loadDemoFile(demoFileName));
            } else {
                this.getModel().setValue("demo", (Object)FileUtil.loadDemoFile("script_help.txt"));
            }
        }
        if ("VIEW".equals(D.s(params.get("billStatus")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u811a\u672c\u4e3a\u67e5\u770b\u6001\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"ScriptEditorPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnok", "btn_clear"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"gen_code", "parse"});
            this.getView().setStatus(OperationStatus.VIEW);
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btnok", "btn_clear"});
            this.setAiButtonStatus();
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }

    private void setAiButtonStatus() {
        String env = (String)this.getView().getFormShowParameter().getCustomParam("env");
        String appid = (String)this.getView().getFormShowParameter().getCustomParam("appid");
        if ("data_copy_mapping_script".equals(env) && "iscb".equals(appid)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"gen_code", "parse"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"gen_code", "parse"});
        }
    }

    private boolean isSmartRobotEnabled() {
        QFilter qFilter = new QFilter("number", "=", (Object)SmartScriptTypeEnum.DataCopyTransScriptEX.getNumber());
        qFilter.and("enable", "=", (Object)"1");
        return QueryServiceHelper.exists((String)"isc_smart_robot", (QFilter[])new QFilter[]{qFilter});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btn_clear", "gen_code", "parse"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("gen_code".equals(key)) {
            if (!this.isSmartRobotEnabled()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6309tips\u94fe\u63a5\u6307\u5f15\u914d\u7f6e\u96c6\u6210\u667a\u80fd\u673a\u5668\u4eba\u3002", (String)"ScriptEditorPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex"});
            FormShowParameter p = new FormShowParameter();
            p.setFormId("isc_smart_robot_chat");
            p.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
            p.setShowClose(false);
            p.setParentPageId(this.getView().getPageId());
            p.getOpenStyle().setShowType(ShowType.InContainer);
            p.getOpenStyle().setTargetKey("splitpanelap2");
            this.getView().showForm(p);
            this.getView().setEnable(Boolean.FALSE, new String[]{"gen_code"});
        } else if ("parse".equals(key)) {
            if (!this.isSmartRobotEnabled()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6309AI\u751f\u6210tips\u94fe\u63a5\u6307\u5f15\u914d\u7f6e\u96c6\u6210\u667a\u80fd\u673a\u5668\u4eba\u3002", (String)"ScriptEditorPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("cmd", "only_get_script_data");
            data.put("id", UUID.randomUUID().toString());
            ((CustomControl)this.getControl("editor")).setData(data);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("parseScript".equals(evt.getActionId())) {
            Object returnData = evt.getReturnData();
            if (returnData == null) {
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("cmd", "set_script_data");
            data.put("id", UUID.randomUUID().toString());
            data.put(SCRIPT, returnData);
            ((CustomControl)this.getControl("editor")).setData(data);
        }
    }

    @Override
    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if ("only_return_script_data".equals(e.getEventName())) {
            String encoded = e.getEventArgs();
            String script = PseudoBase64.decode((String)encoded);
            if (StringUtil.isEmpty((String)script)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u811a\u672c", (String)"SmartRobotChatFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            Map params = this.getView().getFormShowParameter().getCustomParams();
            params.put(SCRIPT, script);
            FormOpener.showForm(this, "isc_smart_parse_report", "", params, "parseScript");
        } else if ("open".equals(e.getEventName())) {
            this.getView().openUrl("https://vip.kingdee.com/article/569200680968143872");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() == MessageBoxResult.Yes && CLEAR_SCRIPT.equals(evt.getCallBackId())) {
            this.clearScriptAndReturn();
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (operateKey.equals(CLEAR_SCRIPT)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLEAR_SCRIPT, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u8981\u6e05\u7a7a\u811a\u672c\u5e76\u8fd4\u56de\uff1f", (String)"ScriptEditorPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        } else if (evt.getOperationResult() != null && evt.getOperationResult().isSuccess() && operateKey.equals("return_script")) {
            String script = this.getScript();
            this.handleScript(script);
        }
    }

    public String getScript() {
        CodeEdit editor = (CodeEdit)this.getView().getControl(SCRIPT);
        return editor.getText() == null ? this.getPageCache().get(SCRIPT) : editor.getText();
    }

    @Override
    protected void handleScript(String script) {
        if (D.s((Object)this.getModel().getValue(REMARK)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5907\u6ce8\u201d\u3002", (String)"ScriptEditorPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.checkScriptValid(script)) {
            return;
        }
        String checkMqScriptValid = this.checkMqScriptValid(D.s((Object)this.getModel().getValue(REMARK)), script);
        if (checkMqScriptValid != null) {
            this.getView().showTipNotification(checkMqScriptValid);
            return;
        }
        Map params = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> returns = new HashMap<String, Object>(params);
        Object remark = this.getModel().getValue(REMARK);
        returns.put(SCRIPT, script);
        returns.put(REMARK, remark == null ? this.getPageCache().get(REMARK) : remark);
        this.getView().returnDataToParent(returns);
        this.getView().close();
    }

    private void clearScriptAndReturn() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> returns = new HashMap<String, Object>(params);
        returns.put(SCRIPT, null);
        returns.put(REMARK, null);
        this.getView().returnDataToParent(returns);
        this.getView().close();
    }

    private String checkMqScriptValid(String remark, String script) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String plugin_name = D.s(params.get("plugin_name"));
        String errorMsg = TIPS_MSG.get(plugin_name);
        if (errorMsg == null) {
            return errorMsg;
        }
        if (D.s((Object)script) != null) {
            return this.getReturnMsg(errorMsg, script);
        }
        return this.getReturnMsg(errorMsg, remark);
    }

    private String getReturnMsg(String msg, String str) {
        return str.contains("return") ? null : msg;
    }

    private boolean checkScriptValid(String script) {
        try {
            Script.compile((String)script);
            return true;
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u5185\u5bb9\u4e0d\u5408\u6cd5\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"ScriptEditorPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e.getMessage()), ShowStackTraceUtil.getErrorMsg(e));
            return false;
        }
    }

    static {
        TIPS_MSG.put("isc_mq_subscriber_reader", ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u811a\u672c\u5fc5\u987b\u4ee5 \u201creturn result_var; \u201d\u8bed\u53e5\u5728\u811a\u672c\u7ed3\u675f\u6267\u884c\u65f6\u660e\u786e\u8fd4\u56de\u5904\u7406\u540e\u7684\u6d88\u606f\u6570\u636e\uff1b\u5982\u679c\u4ee5\u201creturn null;\u201d \u7ed3\u675f\u811a\u672c\u7684\u6267\u884c\u5219\u53ef\u4ee5\u5ffd\u7565\u5f53\u524d\u6d88\u606f\u7684\u8ba2\u9605\uff1b\u5982\u679c\u4e0d\u4ee5 return \u8bed\u53e5\u660e\u786e\u8fd4\u56de\u5904\u7406\u7ed3\u679c\uff0c\u6d88\u606f\u8ba2\u9605\u7684\u6700\u7ec8\u7ed3\u679c\u4e0d\u53ef\u9884\u6d4b\u3002", (String)"ScriptEditorPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        TIPS_MSG.put("isc_mq_bill_data_pub_reader", ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u811a\u672c\u5fc5\u987b\u4ee5 \u201creturn result_var; \u201d\u8bed\u53e5\u5728\u811a\u672c\u7ed3\u675f\u6267\u884c\u65f6\u660e\u786e\u8fd4\u56de\u9700\u8981\u53d1\u5e03\u7684\u6d88\u606f\u6570\u636e\uff1b\u5982\u679c\u4ee5\u201creturn null;\u201d \u7ed3\u675f\u811a\u672c\u7684\u6267\u884c\u5219\u53ef\u4ee5\u5ffd\u7565\u5f53\u524d\u6d88\u606f\u7684\u53d1\u5e03\uff1b\u5982\u679c\u4e0d\u4ee5 return \u8bed\u53e5\u660e\u786e\u8fd4\u56de\u5904\u7406\u7ed3\u679c\uff0c\u6d88\u606f\u53d1\u5e03\u7684\u6700\u7ec8\u7ed3\u679c\u4e0d\u53ef\u9884\u6d4b\u3002", (String)"ScriptEditorPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        TIPS_MSG.put("isc_mq_bill_data_sub_reader", ResManager.loadKDString((String)"\u6ce8\u610f\uff1a\u811a\u672c\u5fc5\u987b\u4ee5 \u201creturn result_var; \u201d\u8bed\u53e5\u5728\u811a\u672c\u7ed3\u675f\u6267\u884c\u65f6\u660e\u786e\u8fd4\u56de\u9884\u5904\u7406\u540e\u7684\u6d88\u606f\u6570\u636e\uff1b\u5982\u679c\u4ee5\u201creturn null;\u201d \u7ed3\u675f\u811a\u672c\u7684\u6267\u884c\u5219\u53ef\u4ee5\u5ffd\u7565\u5f53\u524d\u6d88\u606f\u7684\u8ba2\u9605\uff1b\u5982\u679c\u4e0d\u4ee5 return \u8bed\u53e5\u660e\u786e\u8fd4\u56de\u5904\u7406\u7ed3\u679c\uff0c\u6d88\u606f\u8ba2\u9605\u7684\u6700\u7ec8\u7ed3\u679c\u4e0d\u53ef\u9884\u6d4b\u3002", (String)"ScriptEditorPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        Functions.init();
    }
}

