/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.SystemProperties;
import kd.isc.iscb.formplugin.dc.TempTest;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.Index;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class SqlExecuteFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ISC_SQL_EXE_LOG = "isc_sql_exe_log";
    private static final String SQL = "sql";
    private static final String DATASOURCE = "datasource";
    private static final String OPER_EXECUTE = "execute";
    private static final String OPER_SHOW_LOGS = "viewlog";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit f7 = (BasedataEdit)this.getView().getControl(DATASOURCE);
        if (f7 != null) {
            f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map params = formShowParameter.getCustomParams();
        if (params.containsKey(DATASOURCE) && params.containsKey(SQL)) {
            this.getModel().setValue(DATASOURCE, params.get(DATASOURCE));
            this.getModel().setValue(SQL, params.get(SQL));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        TempTest.doTest();
        if (StringUtils.equals((CharSequence)OPER_EXECUTE, (CharSequence)operationKey)) {
            if ((Long)this.getModel().getValue("datasource_id") == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6570\u636e\u5e93\u8fde\u63a5!", (String)"SqlExecuteFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            String sql = D.s((Object)this.getModel().getValue(SQL));
            if (sql == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"sql\u4e3a\u7a7a!", (String)"SqlExecuteFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.isDescSQL(sql)) {
                String password = D.s((Object)this.getModel().getValue("password"));
                String required_password1 = D.s((Object)SystemProperties.getWithEnv((String)"ISC_TEST_PASSWORD"));
                String required_password2 = D.s((Object)SystemProperties.getWithEnv((String)"ISC_SQL_PASSWORD"));
                if (required_password1 == null && required_password2 == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u96c6\u6210\u6d4b\u8bd5\u5bc6\u7801\u672a\u8bbe\u7f6e!", (String)"SqlExecuteFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (password == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4e3a\u7a7a!", (String)"SqlExecuteFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!password.equals(required_password1) && !password.equals(required_password2)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u6b63\u786e!", (String)"SqlExecuteFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.execute(sql);
        } else if (StringUtils.equals((CharSequence)OPER_SHOW_LOGS, (CharSequence)operationKey)) {
            FormOpener.openExistedBillList(this, ISC_SQL_EXE_LOG, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String sql) {
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("datasource_id"), (String)"isc_data_source");
        try {
            ConnectionManager.checkConnection((DynamicObject)dataSource);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff01", (String)"SqlExecuteFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ShowStackTraceUtil.getErrorMsg(e));
            return;
        }
        DynamicObject dbLink = dataSource.getDynamicObject("dblink");
        try (ConnectionWrapper cn = ConnectionManager.getConnection((long)dbLink.getLong("id"));){
            this.execute(cn, sql);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff01", (String)"SqlExecuteFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        catch (Throwable e) {
            this.getModel().setValue("result", (Object)ShowStackTraceUtil.getErrorMsg(e));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff01", (String)"SqlExecuteFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        finally {
            this.saveExecuteLog(dataSource.getString("name"), sql);
        }
    }

    private void saveExecuteLog(String dataSource, String sql) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)ISC_SQL_EXE_LOG);
        log.set("data_source", (Object)dataSource);
        log.set(SQL, (Object)sql);
        log.set("creator", (Object)RequestContext.get().getUserId());
        log.set("createtime", (Object)Timestamp.valueOf(LocalDateTime.now()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ConnectionWrapper cn, String sql) {
        if (StringUtil.isEmpty((String)sql)) {
            return;
        }
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            try (ObjectReader dataRow = cn.executeQuery(sql, Collections.emptyList(), Collections.emptyList());){
                this.showQueryResult((ObjectReader<DataRow>)dataRow);
            }
        } else {
            if (sql.startsWith("create index") || sql.startsWith("CREATE INDEX")) {
                throw new UnsupportedOperationException(sql);
            }
            if (this.isDescSQL(sql)) {
                this.showTableInfo(cn, sql);
            } else {
                throw new UnsupportedOperationException(sql);
            }
        }
    }

    private boolean isDescSQL(String sql) {
        return sql.startsWith("desc ") || sql.startsWith("DESC ");
    }

    private void showQueryResult(ObjectReader<DataRow> rows) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        sb.append("[\n");
        DataRow item = (DataRow)rows.read();
        while (item != null) {
            sb.append("    ");
            if (++i > 100) {
                sb.append("...");
                break;
            }
            sb.append(JSON.toJSONString((Object)item.toMap(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            sb.append('\n');
            item = (DataRow)rows.read();
        }
        sb.append(']');
        this.getModel().setValue("result", (Object)sb.toString());
    }

    private String getDataType(Column c) {
        int type = c.getOrginalSqlType();
        switch (type) {
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case -4: 
            case 2004: {
                return "BLOB";
            }
            case -1: 
            case 2005: {
                return "CLOB";
            }
            case -16: 
            case 2011: {
                return "NCLOB";
            }
            case -2: {
                return "BINARY(" + c.getPrecision() + ")";
            }
            case -3: {
                return "VARBINARY(" + c.getPrecision() + ")";
            }
            case 12: {
                return "VARCHAR(" + c.getPrecision() + ")";
            }
            case -9: {
                return "NVARCHAR(" + c.getPrecision() + ")";
            }
            case 1: {
                return "CHAR(" + c.getPrecision() + ")";
            }
            case -15: {
                return "NCHAR(" + c.getPrecision() + ")";
            }
            case -7: {
                return "BIT";
            }
            case 93: {
                return "DATETIME";
            }
            case 2014: {
                return "TIMESTAMP_WITH_TIMEZONE";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 2013: {
                return "TIME_WITH_TIMEZONE";
            }
            case 2: 
            case 3: {
                return "DECIMAL(" + c.getPrecision() + "," + c.getScale() + ")";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case -8: {
                return "ROWID";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
        }
        return "UNKNOWN(" + type + ")";
    }

    private void showTableInfo(ConnectionWrapper cn, String sql) {
        String tableName = sql.substring("desc ".length()).trim();
        for (int i = 0; i < tableName.length(); ++i) {
            char c = tableName.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$' || c == '#' || c == '@' || c == '.') continue;
            this.getModel().setValue("result", (Object)String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\u540d\uff08%s\uff09\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26\u3002", (String)"SqlExecuteFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tableName));
            return;
        }
        Table table = cn.getTable(tableName);
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u5b57\u6bb5\uff1a", (String)"SqlExecuteFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        for (int i = 0; i < table.getFieldCount(); ++i) {
            sb.append("\r\n    ");
            Column c = table.getField(i);
            sb.append(c.getBinding()).append(' ').append(this.getDataType(c)).append(' ').append(c.isNullable() ? "" : "NOT NULL");
            if (c.isPrimaryKey()) {
                sb.append(" PRIMARY KEY");
            }
            sb.append(';');
        }
        sb.append("\r\n").append(ResManager.loadKDString((String)"\u7d22\u5f15\uff1a", (String)"SqlExecuteFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        Map indexes = cn.getIndexInfo(tableName);
        for (Index i : indexes.values()) {
            sb.append("\r\n    ").append(i.getIndexName()).append(" (");
            int count = 0;
            for (Pair c : i.getColumns()) {
                if (++count > 1) {
                    sb.append(", ");
                }
                sb.append((String)c.getKey()).append("D".equals(c.getValue()) ? " DESC" : "");
            }
            sb.append(')');
        }
        this.getModel().setValue("result", (Object)sb.toString());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (e.getSource() instanceof BasedataEdit) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            String fieldKey = e.getProperty().getName();
            if (DATASOURCE.equals(fieldKey)) {
                e.getFormShowParameter().getCustomParams().put("source_app", params.get("source_app"));
            }
        }
    }
}

