/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.cntype;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.Tips;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.FieldAp;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class FieldControlModel {
    private final String name;
    private final boolean isRequired;
    private final int max_length;
    private final String defaultValue;
    private final String desc;
    private final String type;
    private final String pageKey;
    private final String entityType;
    private final String enum_values;

    public FieldControlModel(DynamicObject object, String prefix) {
        this.name = D.s((Object)object.get("params_name"));
        this.isRequired = D.x((Object)object.get("isrequired"));
        this.max_length = D.i((Object)object.get("param_length"));
        this.defaultValue = D.s((Object)object.get("default_value"));
        this.desc = D.s((Object)object.get("desc"));
        this.type = D.s((Object)object.get("params_type"));
        this.pageKey = prefix + D.s((Object)object.get("params_number")).toLowerCase();
        this.entityType = D.s((Object)object.get("entity_type"));
        this.enum_values = D.s((Object)object.get("enum_values"));
    }

    public String getType() {
        return this.type;
    }

    public TextField buildField() {
        TextField field = new TextField();
        field.setId(this.pageKey);
        field.setKey(this.pageKey);
        field.setMaxLength(this.max_length);
        field.setDefValue(this.defaultValue);
        field.setPassword("password".equals(this.type));
        field.setMustInput(this.isRequired);
        return field;
    }

    public CheckBoxField buildCheckBoxField() {
        CheckBoxField field = new CheckBoxField();
        field.setId(this.pageKey);
        field.setKey(this.pageKey);
        field.setDefValue(D.x((Object)this.defaultValue));
        field.setMustInput(this.isRequired);
        return field;
    }

    public ComboField buildComboField() {
        ComboField field = new ComboField();
        field.setId(this.pageKey);
        field.setKey(this.pageKey);
        Map values = (Map)Json.toObject((String)this.enum_values);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(values.size());
        for (Map.Entry entry : values.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(value));
            item.setValue(key);
            items.add(item);
        }
        field.setItems(items);
        if (items.size() > 0) {
            field.setDefValue(((ComboItem)items.get(0)).getValue());
        }
        field.setMustInput(this.isRequired);
        return field;
    }

    public BasedataField buildBasedataField() {
        BasedataField field = new BasedataField();
        field.setBaseEntityNumber(this.entityType);
        field.setId(this.pageKey);
        field.setKey(this.pageKey);
        field.setViewDetail(true);
        field.setMustInput(this.isRequired);
        field.setCacheLookUpList(false);
        field.setIgnoreRefCheck(true);
        field.setBizBasedata(true);
        return field;
    }

    public FieldAp buildFieldAp() {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setId(this.pageKey);
        fieldAp.setKey(this.pageKey);
        fieldAp.setName(new LocaleString(this.name));
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setFireUpdEvt(true);
        if (this.desc != null) {
            fieldAp.setShowAttachmentTips(true);
            Tips tips = new Tips("text", null);
            tips.setContent(new LocaleString(this.desc));
            fieldAp.setCtlTips(tips);
        }
        if ("checkbox".equals(this.type)) {
            fieldAp.setField((Field)this.buildCheckBoxField());
            fieldAp.setFieldBackColor("B2B2B2");
        } else if ("combo".equals(this.type)) {
            fieldAp.setField((Field)this.buildComboField());
        } else if ("ref".equals(this.type)) {
            fieldAp.setField((Field)this.buildBasedataField());
        } else {
            fieldAp.setField((Field)this.buildField());
        }
        return fieldAp;
    }

    public DynamicProperty buildFieldProp() {
        if ("checkbox".equals(this.type)) {
            return this.newBooleanProp();
        }
        if ("ref".equals(this.type)) {
            return this.newBasedataProp();
        }
        return this.newTextProp();
    }

    private TextProp newTextProp() {
        TextProp textProp = new TextProp();
        textProp.setName(this.pageKey);
        textProp.setMustInput(this.isRequired);
        textProp.setMaxLenth(this.max_length);
        textProp.setDisplayName(new LocaleString(this.name));
        textProp.setDefaultValue((Object)this.defaultValue);
        textProp.setDbIgnore(true);
        textProp.setAlias("");
        textProp.setPassword("password".equals(this.type));
        return textProp;
    }

    private BasedataProp newBasedataProp() {
        BasedataProp basedataProp = new BasedataProp();
        basedataProp.setName(this.pageKey);
        basedataProp.setMustInput(this.isRequired);
        basedataProp.setDisplayName(new LocaleString(this.name));
        basedataProp.setBaseEntityId(this.entityType);
        basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.entityType));
        basedataProp.setDisplayProp("name");
        basedataProp.setDbIgnore(true);
        basedataProp.setAlias("");
        basedataProp.setIgnoreRefCheck(true);
        return basedataProp;
    }

    private BooleanProp newBooleanProp() {
        BooleanProp booleanProp = new BooleanProp();
        booleanProp.setName(this.pageKey);
        booleanProp.setMustInput(this.isRequired);
        booleanProp.setDisplayName(new LocaleString(this.name));
        booleanProp.setDefValue((Object)D.x((Object)this.defaultValue));
        booleanProp.setDbIgnore(true);
        booleanProp.setAlias("");
        return booleanProp;
    }

    public BasedataProp buildRefFieldProp() {
        BasedataProp basedataProp = new BasedataProp();
        basedataProp.setName(this.pageKey);
        basedataProp.setMustInput(this.isRequired);
        basedataProp.setDisplayName(new LocaleString(this.name));
        basedataProp.setBaseEntityId(this.entityType);
        basedataProp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)this.entityType));
        basedataProp.setDisplayProp("name");
        basedataProp.setDbIgnore(true);
        basedataProp.setAlias("");
        DynamicSimpleProperty pRefId = this.buildRefIdFieldProp(basedataProp);
        basedataProp.setRefIdPropName(this.entityType + "_id");
        basedataProp.setRefIdProp((IDataEntityProperty)pRefId);
        return basedataProp;
    }

    public DynamicSimpleProperty buildRefIdFieldProp(BasedataProp basedataProp) {
        DynamicSimpleProperty pRefId = basedataProp.createRefIDProp();
        pRefId.setPrimaryKey(false);
        pRefId.setDbIgnore(true);
        pRefId.setPrivacyType(0L);
        pRefId.setName(this.entityType + "_id");
        basedataProp.setRefIdPropName(this.entityType + "_id");
        basedataProp.setRefIdProp((IDataEntityProperty)pRefId);
        return pRefId;
    }

    public FieldEdit buildFieldEdit() {
        if ("combo".equals(this.type)) {
            ComboEdit fieldEdit = new ComboEdit();
            fieldEdit.setKey(this.pageKey);
            fieldEdit.setFieldKey(this.pageKey);
            return fieldEdit;
        }
        if ("ref".equals(this.type)) {
            BasedataEdit fieldEdit = new BasedataEdit();
            fieldEdit.setKey(this.pageKey);
            fieldEdit.setFieldKey(this.pageKey);
            return fieldEdit;
        }
        TextEdit fieldEdit = new TextEdit();
        fieldEdit.setKey(this.pageKey);
        fieldEdit.setFieldKey(this.pageKey);
        return fieldEdit;
    }
}

