/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.dataset;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class DataSetSchemaEditerPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String NODE_COUNT = "$ISC";
    private static final String CURRENT_NODE_ID = "current_node_id";
    private static final String CURRENT_NODE_TEXT = "current_node_text";
    private static final String CURRENT_NODE_PARENTID = "current_node_parentid";
    private static final String CONFIRM = "Confirm";
    private static final String CANCEL = "Cancel";
    private static final String NUMBER = "number";
    private static final String DATA_TYPE = "data_type";
    private static final String ROOT_NODE = "ROOTNODE";
    private static final String STRUCT_TYPE = "STRUCT";
    private static final String ENUM_ENTITY_NAME = "enum_values";
    private static final String KEY_DATATYPE = "dataType";
    private static final String IS_MULTIPLE = "is_multiple";
    private static final String IS_DISTINCT = "is_distinct";
    private static final String FLEX_ENUM = "flex_enum";
    private static final String CLOSE_EVT = "closeEvt";
    private static final String CLICKNODE_ID = "clickNodeID";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"contentpanel"});
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.initTree(params);
    }

    private void initTree(Map<String, Object> params) {
        TreeNode rootNode;
        String number = D.s((Object)params.get(NUMBER));
        String name = D.s((Object)params.get("name"));
        String metaType = D.s((Object)params.get("meta_type"));
        String jsonEditer = D.s((Object)params.get("jsonEditer"));
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        this.getModel().setValue(NUMBER, (Object)number);
        this.getModel().setValue("name", (Object)name);
        if (STRUCT_TYPE.equals(metaType)) {
            this.getModel().setValue(DATA_TYPE, (Object)metaType);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER});
        this.getView().setEnable(Boolean.FALSE, new String[]{DATA_TYPE});
        if (jsonEditer == null) {
            rootNode = new TreeNode("", number, name);
            Map<String, Object> rootNodeData = this.setDataFromEntity();
            rootNode.setData(rootNodeData);
        } else {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)jsonEditer, TreeNode.class);
            if (!number.equals(rootNode.getId())) {
                DataSetSchemaEditerPlugin.updateFromParent(rootNode, number);
            }
            rootNode.setId(number);
            rootNode.setText(name);
            Object data = rootNode.getData();
            if (data instanceof Map) {
                ((Map)data).put(NUMBER, number);
                ((Map)data).put("name", name);
                ((Map)data).put(KEY_DATATYPE, metaType);
            }
        }
        this.getPageCache().put(ROOT_NODE, SerializationUtils.toJsonString((Object)rootNode));
        this.getPageCache().put("CANCEL", SerializationUtils.toJsonString((Object)rootNode));
        tree.addNode(rootNode);
        this.expandAllParentNodes(rootNode, tree);
        tree.focusNode(rootNode);
        this.getPageCache().put(CLICKNODE_ID, rootNode.getId());
        this.getPageCache().put("rootNodeID", rootNode.getId());
        this.getPageCache().put(CURRENT_NODE_ID, rootNode.getId());
        this.setEnumFlexVisible(this.getModel().getValue(DATA_TYPE));
    }

    public static void updateFromParent(TreeNode rootNode, String number) {
        rootNode.setId(number);
        List children = rootNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                child.setParentid(number);
                Object data = child.getData();
                if (data instanceof Map) {
                    Object oldNum = ((Map)data).get(NUMBER);
                    child.setId(number + "." + oldNum);
                }
                DataSetSchemaEditerPlugin.updateFromParent(child, child.getId());
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeNode currentNode;
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        Object nodeId = evt.getNodeId();
        String number = D.s((Object)this.getView().getModel().getValue(NUMBER));
        String name = D.s((Object)this.getView().getModel().getValue("name"));
        String dataType = D.s((Object)this.getModel().getValue(DATA_TYPE));
        TreeNode rootnode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROOT_NODE), TreeNode.class);
        String s = this.getPageCache().get(CURRENT_NODE_ID);
        if (s != null && s.contains(NODE_COUNT)) {
            TreeNode clickNode = this.getNodeById(rootnode, this.getPageCache().get(CURRENT_NODE_ID));
            if (!rootnode.getId().equals(this.getPageCache().get(CURRENT_NODE_ID)) && this.isLegal(number, name, dataType)) {
                this.showTipMsg(tree, rootnode);
                return;
            }
            if (clickNode != null) {
                if (D.s((Object)nodeId).contains(D.s((Object)NODE_COUNT))) {
                    tree.focusNode(clickNode);
                    return;
                }
                if (this.isNodeExists(rootnode, clickNode)) {
                    return;
                }
                this.setAndSaveNode(tree, rootnode, clickNode);
            }
            tree.focusNode(this.getNodeById(rootnode, nodeId));
            this.getPageCache().put(ROOT_NODE, SerializationUtils.toJsonString((Object)rootnode));
        }
        if ((currentNode = this.getNodeById(rootnode, this.getPageCache().get(CURRENT_NODE_ID))) != null) {
            if (!currentNode.getId().equals(rootnode.getId()) && DataSetSchemaEditerPlugin.isNodeIllegal(name, dataType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u540d\u79f0\u3001\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u8bf7\u4fee\u6539\uff01", (String)"DataSetSchemaEditerPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                tree.focusNode(currentNode);
                return;
            }
            this.setAndSaveNode(tree, rootnode, currentNode);
        }
        tree.focusNode(this.getNodeById(rootnode, nodeId));
        rootnode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROOT_NODE), TreeNode.class);
        TreeNode clickNode = this.getNodeById(rootnode, nodeId);
        if (clickNode != null) {
            this.getPageCache().put(CLICKNODE_ID, clickNode.getId());
            this.showNodeData(nodeId, rootnode, clickNode);
        }
        this.setDistinctVisible();
    }

    public static boolean isNodeIllegal(String name, String dataType) {
        return StringUtil.isEmpty((String)name) || StringUtil.isEmpty((String)dataType);
    }

    private void showNodeData(Object nodeId, TreeNode rootnode, TreeNode clickNode) {
        Object data = clickNode.getData();
        if (data instanceof Map) {
            Object fields;
            this.setUnmodify(nodeId, rootnode);
            this.getView().getModel().setValue(NUMBER, ((Map)data).get(NUMBER));
            this.getView().getModel().setValue("name", ((Map)data).get("name"));
            Object clickNodeDataType = ((Map)data).get(KEY_DATATYPE);
            this.getView().getModel().setValue(DATA_TYPE, clickNodeDataType);
            this.getView().getModel().setValue(IS_MULTIPLE, ((Map)data).get(IS_MULTIPLE));
            this.getView().getModel().setValue(IS_DISTINCT, ((Map)data).get(IS_DISTINCT));
            this.setEnumFlexVisible(clickNodeDataType);
            if ("ENUM".equals(D.s(clickNodeDataType)) && (fields = ((Map)data).get("fields")) instanceof Map) {
                this.showEntryData((Map)fields);
                this.getView().updateView(ENUM_ENTITY_NAME);
            }
        }
        this.getPageCache().put(CURRENT_NODE_ID, clickNode.getId());
        this.getPageCache().put(CURRENT_NODE_TEXT, clickNode.getText());
        this.getPageCache().put(CURRENT_NODE_PARENTID, clickNode.getParentid());
        if (this.getModel().getValue(NUMBER) != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{NUMBER});
        }
        this.getView().updateView();
    }

    private void showEntryData(Map fields) {
        ArrayList<String> textFields = new ArrayList<String>(fields.size());
        for (Object a : fields.keySet()) {
            textFields.add(D.s(a));
        }
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("value", new Object[0]);
        vs.addField("text", new Object[0]);
        for (String textField : textFields) {
            vs.addRow(new Object[]{textField, fields.get(textField)});
        }
        model.deleteEntryData(ENUM_ENTITY_NAME);
        model.batchCreateNewEntryRow(ENUM_ENTITY_NAME, vs);
        model.endInit();
    }

    private void setUnmodify(Object nodeId, TreeNode rootnode) {
        if (nodeId.equals(rootnode.getId())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{DATA_TYPE});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{DATA_TYPE});
        }
    }

    private TreeNode getNodeById(TreeNode rootnode, Object nodeId) {
        List children = rootnode.getChildren();
        if (nodeId.equals(rootnode.getId())) {
            return rootnode;
        }
        if (children != null) {
            for (TreeNode child : children) {
                TreeNode node = this.getNodeById(child, nodeId);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        this.getPageCache().put(CLICKNODE_ID, null);
        if ("new_node".equalsIgnoreCase(operateKey)) {
            TreeNode parentNode;
            Object data;
            TreeNode rootnode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROOT_NODE), TreeNode.class);
            if (this.checkModifyNode(tree, rootnode)) {
                return;
            }
            TreeNode currentNode = this.getNodeById(rootnode, this.getPageCache().get(CURRENT_NODE_ID));
            if (currentNode != null && !currentNode.getId().equals(rootnode.getId()) && (data = currentNode.getData()) instanceof Map && !STRUCT_TYPE.equals(((Map)data).get(KEY_DATATYPE)) && (parentNode = this.getNodeById(rootnode, this.getPageCache().get(CURRENT_NODE_PARENTID))) != null) {
                this.getPageCache().put(CURRENT_NODE_ID, parentNode.getId());
                this.getPageCache().put(CURRENT_NODE_TEXT, parentNode.getText());
                this.getPageCache().put(CURRENT_NODE_PARENTID, parentNode.getParentid());
            }
            this.resetPropertyFields();
            this.newTempNode(tree, rootnode);
        }
        if ("delete_node".equalsIgnoreCase(operateKey)) {
            TreeNode rootnode;
            String focusNodeId = this.getPageCache().get(CURRENT_NODE_ID);
            if (focusNodeId.equals((rootnode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROOT_NODE), TreeNode.class)).getId())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6811\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664", (String)"DataSetSchemaEditerPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            this.deleteNodeData(rootnode, focusNodeId);
            tree.updateNode(rootnode);
            this.expandAllParentNodes(rootnode, tree);
            tree.focusNode(rootnode);
            this.showNodeData(rootnode.getId(), rootnode, rootnode);
            this.getPageCache().put(CURRENT_NODE_ID, this.getPageCache().get("rootNodeID"));
            this.getPageCache().put(CURRENT_NODE_TEXT, rootnode.getText());
            this.getPageCache().put(CURRENT_NODE_PARENTID, rootnode.getParentid());
            this.getPageCache().put(ROOT_NODE, SerializationUtils.toJsonString((Object)rootnode));
        }
    }

    private boolean checkModifyNode(TreeView tree, TreeNode rootnode) {
        TreeNode currentNode;
        TreeNode clickNode;
        String number = D.s((Object)this.getView().getModel().getValue(NUMBER));
        String name = D.s((Object)this.getView().getModel().getValue("name"));
        String dataType = D.s((Object)this.getView().getModel().getValue(DATA_TYPE));
        String currentId = this.getPageCache().get(CURRENT_NODE_ID);
        if (!rootnode.getId().equals(currentId) && this.isLegal(number, name, dataType)) {
            this.showTipMsg(tree, rootnode);
            return true;
        }
        if (currentId == null) {
            return true;
        }
        if (currentId.contains(NODE_COUNT) && (clickNode = this.getNodeById(rootnode, currentId)) != null) {
            if (this.isNodeExists(rootnode, clickNode)) {
                return true;
            }
            this.setAndSaveNode(tree, rootnode, clickNode);
        }
        if ((currentNode = this.getNodeById(rootnode, currentId)) != null) {
            this.setAndSaveNode(tree, rootnode, currentNode);
        }
        return false;
    }

    private void newTempNode(TreeView tree, TreeNode rootnode) {
        String newNodeID = this.getPageCache().get(CURRENT_NODE_ID) + "." + D.s((Object)NODE_COUNT);
        TreeNode newTempNode = new TreeNode(this.getPageCache().get(CURRENT_NODE_ID), newNodeID, ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"DataSetSchemaEditerPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.getView().setEnable(Boolean.TRUE, new String[]{NUMBER});
        this.saveNewNode(rootnode, newTempNode);
        tree.updateNode(rootnode);
        this.expandAllParentNodes(rootnode, tree);
        tree.expand(rootnode.getId());
        tree.focusNode(newTempNode);
        this.getView().setEnable(Boolean.TRUE, new String[]{DATA_TYPE});
        this.getPageCache().put(ROOT_NODE, SerializationUtils.toJsonString((Object)rootnode));
        this.getPageCache().put(CURRENT_NODE_ID, newTempNode.getId());
        this.getPageCache().put(CURRENT_NODE_TEXT, newTempNode.getText());
        this.getPageCache().put(CURRENT_NODE_PARENTID, newTempNode.getParentid());
    }

    private void showTipMsg(TreeView tree, TreeNode rootnode) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6570\u636e\u8282\u70b9\u7f16\u7801\u3001\u540d\u79f0\u53ca\u6570\u636e\u7c7b\u578b", (String)"DataSetSchemaEditerPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        tree.focusNode(this.getNodeById(rootnode, this.getPageCache().get(CURRENT_NODE_ID)));
    }

    private boolean isNodeExists(TreeNode rootnode, TreeNode clickNode) {
        List children;
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        TreeNode parentNode = this.getNodeById(rootnode, clickNode.getParentid());
        List list = children = parentNode != null ? parentNode.getChildren() : null;
        if (children != null) {
            for (TreeNode child : children) {
                if (!child.getId().equals(this.getPageCache().get(CURRENT_NODE_PARENTID) + "." + D.s((Object)this.getModel().getValue(NUMBER)))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u7f16\u7801\u5728\u540c\u7ea7\u8282\u70b9\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5f53\u524d\u8282\u70b9\u7f16\u7801", (String)"DataSetSchemaEditerPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                tree.focusNode(clickNode);
                return true;
            }
        }
        return false;
    }

    private void setAndSaveNode(TreeView tree, TreeNode rootnode, TreeNode clickNode) {
        Object data;
        String name = D.s((Object)this.getModel().getValue("name"));
        List children = clickNode.getChildren();
        String dataType = D.s((Object)this.getModel().getValue(DATA_TYPE));
        if ("ENUM".equals(dataType)) {
            this.getModel().clearNoDataRow();
        }
        if (children != null && (data = clickNode.getData()) instanceof Map && this.isChangeFromStruct((Map)data)) {
            ArrayList<String> nodeIdLists = new ArrayList<String>(children.size());
            for (TreeNode child : children) {
                nodeIdLists.add(child.getId());
            }
            for (String nodeIdList : nodeIdLists) {
                clickNode.deleteChildNode(nodeIdList);
            }
        }
        if (!rootnode.getId().equals(clickNode.getId())) {
            String nodeNewID = this.getPageCache().get(CURRENT_NODE_PARENTID) + "." + D.s((Object)this.getModel().getValue(NUMBER));
            clickNode.setId(nodeNewID);
        }
        clickNode.setText(name);
        clickNode.setData(this.setDataFromEntity());
        tree.updateNode(rootnode);
        this.expandAllParentNodes(rootnode, tree);
        tree.focusNode(clickNode);
        this.getPageCache().put(ROOT_NODE, SerializationUtils.toJsonString((Object)rootnode));
        this.getPageCache().put(CURRENT_NODE_ID, clickNode.getId());
        this.getPageCache().put(CURRENT_NODE_TEXT, clickNode.getText());
        this.getPageCache().put(CURRENT_NODE_PARENTID, clickNode.getParentid());
    }

    private boolean isChangeFromStruct(Map data) {
        return STRUCT_TYPE.equals(data.get(KEY_DATATYPE)) && !STRUCT_TYPE.equals(this.getModel().getValue(DATA_TYPE));
    }

    private void expandAllParentNodes(TreeNode rootnode, TreeView tree) {
        List children = rootnode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                this.expandAllParentNodes(child, tree);
            }
            tree.expand(rootnode.getId());
        }
    }

    private void saveNewNode(TreeNode rootNode, TreeNode newNode) {
        if (rootNode.getId().equals(newNode.getParentid())) {
            rootNode.addChild(newNode);
        } else {
            List children = rootNode.getChildren();
            if (children != null) {
                for (TreeNode child : children) {
                    this.saveNewNode(child, newNode);
                }
            }
        }
    }

    private void deleteNodeData(TreeNode rootnode, String focusNodeId) {
        List children = rootnode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                if (focusNodeId.equals(child.getId())) {
                    rootnode.deleteChildNode(focusNodeId);
                    return;
                }
                this.deleteNodeData(child, focusNodeId);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Button) {
            if ("btnok".equals(((Button)src).getKey())) {
                TreeNode rootnode;
                TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
                if (this.finalCheckAll(tree, rootnode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROOT_NODE), TreeNode.class))) {
                    return;
                }
                this.getPageCache().put(CLOSE_EVT, CONFIRM);
            }
            if ("btncancel".equals(((Button)src).getKey())) {
                this.getPageCache().put(CLOSE_EVT, CANCEL);
            }
            this.getView().close();
        }
    }

    private boolean finalCheckAll(TreeView tree, TreeNode rootnode) {
        TreeNode errorNode;
        TreeNode currentNode;
        String number = D.s((Object)this.getView().getModel().getValue(NUMBER));
        String name = D.s((Object)this.getView().getModel().getValue("name"));
        String dataType = D.s((Object)this.getModel().getValue(DATA_TYPE));
        String currentId = this.getPageCache().get(CURRENT_NODE_ID);
        if (currentId == null) {
            return true;
        }
        if (currentId.contains(NODE_COUNT)) {
            if (!rootnode.getId().equals(currentId) && this.isLegal(number, name, dataType)) {
                this.showTipMsg(tree, rootnode);
                return true;
            }
            TreeNode clickNode = this.getNodeById(rootnode, currentId);
            if (clickNode != null) {
                if (this.isNodeExists(rootnode, clickNode)) {
                    return true;
                }
                this.setAndSaveNode(tree, rootnode, clickNode);
            }
        }
        if ((currentNode = this.getNodeById(rootnode, currentId)) != null) {
            if (!currentNode.getId().equals(rootnode.getId()) && DataSetSchemaEditerPlugin.isNodeIllegal(name, dataType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u540d\u79f0\u3001\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u8bf7\u4fee\u6539\uff01", (String)"DataSetSchemaEditerPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                tree.focusNode(currentNode);
                return true;
            }
            this.setAndSaveNode(tree, rootnode, currentNode);
        }
        if ((errorNode = DataSetSchemaEditerPlugin.checkNonstandardNode(rootnode)) != null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u65b9\u6848\u5b9a\u4e49\u4e2d\u8282\u70b9: %s \u672a\u586b\u5199\u540d\u79f0\u6216\u6570\u636e\u7c7b\u578b\u8bf7\u4fee\u6539\uff01", (String)"DataSetSchemaEditerPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), errorNode.getId()));
            return true;
        }
        return false;
    }

    public static TreeNode checkNonstandardNode(TreeNode rootnode) {
        List children = rootnode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                Object data = child.getData();
                if (!(data instanceof Map)) continue;
                Object checkType = ((Map)data).get(KEY_DATATYPE);
                Object checkName = ((Map)data).get("name");
                if (!DataSetSchemaEditerPlugin.isNodeIllegal(D.s(checkName), D.s(checkType))) continue;
                return child;
            }
        }
        return null;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        HashMap<String, String> returns = new HashMap<String, String>();
        if (CONFIRM.equals(this.getPageCache().get(CLOSE_EVT))) {
            returns.put("dataResult", this.getPageCache().get(ROOT_NODE));
        } else {
            returns.put("dataResult", this.getPageCache().get("CANCEL"));
        }
        this.getView().returnDataToParent(returns);
    }

    private Map<String, Object> setDataFromEntity() {
        String number = D.s((Object)this.getView().getModel().getValue(NUMBER));
        String name = D.s((Object)this.getView().getModel().getValue("name"));
        String type = D.s((Object)this.getView().getModel().getValue(DATA_TYPE));
        Object isMultiple = this.getModel().getValue(IS_MULTIPLE);
        Object isDistinct = this.getModel().getValue(IS_DISTINCT);
        HashMap<String, Object> cacheMap = new HashMap<String, Object>();
        cacheMap.put(NUMBER, number);
        cacheMap.put("name", name);
        cacheMap.put(KEY_DATATYPE, type);
        cacheMap.put(IS_MULTIPLE, isMultiple);
        cacheMap.put(IS_DISTINCT, isDistinct);
        if ("ENUM".equals(type)) {
            DynamicObjectCollection enumValues = this.getModel().getEntryEntity(ENUM_ENTITY_NAME);
            HashMap<String, String> map = new HashMap<String, String>();
            for (DynamicObject enum_value : enumValues) {
                map.put(D.s((Object)enum_value.get("value")), D.s((Object)enum_value.get("text")));
            }
            cacheMap.put("fields", map);
        }
        return cacheMap;
    }

    private boolean isLegal(String number, String name, String dataType) {
        return number == null || name == null || dataType == null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        if (DATA_TYPE.equals(propertyName)) {
            this.setEnumFlexVisible(this.getModel().getValue(DATA_TYPE));
        }
        if (IS_MULTIPLE.equalsIgnoreCase(propertyName)) {
            this.setDistinctVisible();
            if (!D.x((Object)this.getModel().getValue(IS_MULTIPLE))) {
                this.getModel().setValue(IS_DISTINCT, (Object)Boolean.FALSE);
            }
        }
    }

    private void setEnumFlexVisible(Object dataType) {
        TreeNode rootnode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROOT_NODE), TreeNode.class);
        this.getView().setVisible(Boolean.TRUE, new String[]{IS_MULTIPLE});
        this.getView().setVisible(Boolean.TRUE, new String[]{IS_DISTINCT});
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ENUM});
        if (STRUCT_TYPE.equals(dataType) || StringUtil.isEmpty((String)D.s((Object)dataType))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{IS_DISTINCT});
        } else if ("ENUM".equals(dataType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ENUM});
        }
        if (rootnode.getId().equals(this.getPageCache().get(CLICKNODE_ID))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{IS_MULTIPLE});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{IS_DISTINCT});
    }

    private void resetPropertyFields() {
        this.getModel().setValue(NUMBER, (Object)"");
        this.getModel().setValue("name", (Object)"");
        this.getModel().setValue(DATA_TYPE, (Object)"");
        this.getModel().setValue(IS_MULTIPLE, (Object)Boolean.FALSE);
        this.getModel().setValue(IS_DISTINCT, (Object)Boolean.FALSE);
        DynamicObjectCollection enumValues = this.getModel().getEntryEntity(ENUM_ENTITY_NAME);
        enumValues.clear();
        this.getView().setEnable(Boolean.TRUE, new String[]{"flex_data"});
        this.getView().setEnable(Boolean.TRUE, new String[]{FLEX_ENUM});
        this.getView().updateView();
    }

    private void setDistinctVisible() {
        this.getView().setEnable(Boolean.valueOf(D.x((Object)this.getModel().getValue(IS_MULTIPLE))), new String[]{IS_DISTINCT});
        this.getView().updateView();
    }
}

