/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.dataset;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.dc.dataset.DataSetSchemaEditerPlugin;
import kd.isc.iscb.formplugin.dc.dataset.DataSetUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.meta.MetaSchemaUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;

public class DataSetSchemaPlugin
extends AbstractFormPlugin {
    private static final String ROOT_NODE_FULL_NAME = "rootNodeFullName";
    private static final String ROOT_NODE_NUM = "rootNodeNum";
    private static final String FDEFINE_JSON_EDITER = "fdefine_json_editer";
    private static final String FDEFINE_JSON_TAG = "fdefine_json_tag";
    private static final String NUMBER = "number";
    private static final String METADATA_SCHEMA = "isc_metadata_schema";
    private static final String DATASET_SCHEMA = "isc_dataset_schema";
    private static final String DATA_TYPE = "dataType";
    private static final String META_TYPE = "meta_type";
    private static final String DATA_SOURCE = "data_source";
    private static final String STATE = "state";
    private static final String ENABLE = "enable";
    private static final String TYPE_OF_STRUCT = "STRUCT";
    private static final String FULL_NAME = "full_name";
    private static final String GROUP = "group";
    private static final String JSONEDITER_TAG = "jsonEditerTag";

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Map params = (Map)evt.getReturnData();
        if ("returns".equals(actionId)) {
            Object data;
            Object dataResult = params.get("dataResult");
            String s = D.s(dataResult);
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)s, TreeNode.class);
            if (rootNode != null && (data = rootNode.getData()) instanceof Map) {
                this.getModel().setValue("name", ((Map)data).get("name"));
            }
            if (dataResult != null) {
                this.getView().getModel().setValue(FDEFINE_JSON_TAG, dataResult);
                this.getView().getModel().setValue(FDEFINE_JSON_EDITER, (Object)(s.length() > 255 ? s.substring(0, 255) : s));
            }
        }
        this.getView().updateView();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{FDEFINE_JSON_EDITER});
        this.addClickListeners(new String[]{"bar_save"});
        this.addClickListeners(new String[]{"program_define"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)FDEFINE_JSON_EDITER, (CharSequence)key)) {
            this.showDefineForm();
        }
    }

    private void showDefineForm() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String number = D.s((Object)this.getView().getModel().getValue(NUMBER));
        String name = D.s((Object)this.getView().getModel().getValue("name"));
        String metaType = D.s((Object)this.getView().getModel().getValue(META_TYPE));
        String jsonEditer = D.s((Object)this.getView().getModel().getValue(FDEFINE_JSON_TAG));
        if (number != null && name != null && metaType != null) {
            params.put(NUMBER, number);
            params.put("name", name);
            params.put(META_TYPE, metaType);
            params.put("jsonEditer", jsonEditer);
            if (jsonEditer != null && this.checkJsonParse(jsonEditer)) {
                return;
            }
            FormOpener.showForm(this, "isc_dataset_schema_editor", null, params, "returns");
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6570\u636e\u96c6\u7f16\u7801\u3001\u540d\u79f0\u53ca\u8be5\u96c6\u6210\u5bf9\u8c61\u7c7b\u578b", (String)"DataSetSchemaPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        int dataCopyId = D.i((Object)this.getModel().getValue("id"));
        if (args.getSource() instanceof Save) {
            this.saveNewCheck(args, dataCopyId);
        }
    }

    private void saveNewCheck(BeforeDoOperationEventArgs args, int dataCopyId) {
        String jsonValue = D.s((Object)this.getModel().getValue(FDEFINE_JSON_TAG));
        if (dataCopyId == 0) {
            String number = D.s((Object)this.getModel().getValue(NUMBER));
            String fullName = D.s((Object)this.getModel().getValue(FULL_NAME));
            Object dataSource = this.getModel().getValue(DATA_SOURCE);
            if (number == null || fullName == null || dataSource == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\uff0c\u8bf7\u586b\u5199\u540e\u4fdd\u5b58\u3002", (String)"DataSetSchemaPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            for (int i = 0; i < fullName.length(); ++i) {
                char ch = fullName.charAt(i);
                if (ch >= '!' && ch <= '\u007f') continue;
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u5168\u540d\u53ea\u5141\u8bb8\u4ee5ASCII\u7801\u572833-127\u8303\u56f4\u5185\u7684\u5b57\u7b26\u6784\u6210, \u4e0d\u5141\u8bb8\u4f7f\u7528\u5176\u4ed6\u7279\u6b8a\u5185\u5bb9\u3002", (String)"DataSetSchemaPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter filter = new QFilter(NUMBER, "=", (Object)number).and("data_source_id", "=", ((DynamicObject)dataSource).getPkValue());
            DynamicObject dataset = BusinessDataServiceHelper.loadSingle((String)DATASET_SCHEMA, (String)"id", (QFilter[])new QFilter[]{filter});
            if (dataset != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"DataSetSchemaPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            filter = new QFilter(FULL_NAME, "=", (Object)fullName).and("data_source_id", "=", ((DynamicObject)dataSource).getPkValue());
            dataset = BusinessDataServiceHelper.loadSingle((String)DATASET_SCHEMA, (String)"id", (QFilter[])new QFilter[]{filter});
            if (dataset != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5168\u540d\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"DataSetSchemaPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (jsonValue == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u96c6\u7684\u201c\u6570\u636e\u7ed3\u6784\u5b9a\u4e49\u201d\u4e3a\u7a7a\u3002", (String)"DataSetSchemaPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (this.checkJsonParse(jsonValue)) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        Object dataCopyId = this.getModel().getValue("id");
        if ("bar_publish".equals(operateKey)) {
            this.publish(dataCopyId);
        } else if ("save".equals(operateKey)) {
            this.save(dataCopyId);
        } else if ("program_define".equals(operateKey)) {
            this.showDefineForm();
        }
        this.setButtonStatus();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String s = D.s((Object)this.getView().getModel().getValue(FDEFINE_JSON_TAG));
        this.getView().getModel().setValue(FDEFINE_JSON_EDITER, (Object)(s != null && s.length() > 255 ? s.substring(0, 255) : s));
        this.setButtonStatus();
        this.getModel().setDataChanged(false);
    }

    private void setButtonStatus() {
        long id = D.l((Object)this.getView().getModel().getValue("id"));
        this.getView().setVisible(Boolean.valueOf(id > 0L), new String[]{"bar_publish"});
    }

    private void publish(Object dataCopyId) {
        DynamicObject datasetSchema = BusinessDataServiceHelper.loadSingle((Object)dataCopyId, (String)DATASET_SCHEMA);
        DynamicObject dataSource = datasetSchema.getDynamicObject(DATA_SOURCE);
        String jsonEditer = D.s((Object)datasetSchema.get(FDEFINE_JSON_TAG));
        String fullName = D.s((Object)datasetSchema.get(FULL_NAME));
        if (jsonEditer == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u96c6\u65b9\u6848\u672a\u8fdb\u884c\u5b9a\u4e49\u65b9\u6848\uff0c\u8bf7\u7f16\u8f91", (String)"DataSetSchemaPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.checkJsonParse(jsonEditer)) {
            return;
        }
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)jsonEditer, TreeNode.class);
        if (rootNode != null) {
            if (this.isIllegal(rootNode)) {
                return;
            }
            HashMap<String, String> rootNodeMap = new HashMap<String, String>(2);
            String metaType = D.s((Object)datasetSchema.get(META_TYPE));
            try {
                rootNodeMap.put(ROOT_NODE_NUM, rootNode.getId());
                rootNodeMap.put(ROOT_NODE_FULL_NAME, fullName);
                DataSetSchemaPlugin.publishDataSetSchema(rootNode, dataSource, metaType, fullName, true, rootNodeMap);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\uff01", (String)"DataSetSchemaPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                datasetSchema.set(ENABLE, (Object)"2");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datasetSchema});
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    private boolean checkJsonParse(String jsonEditer) {
        try {
            SerializationUtils.fromJsonString((String)jsonEditer, TreeNode.class);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), String.format(ResManager.loadKDString((String)"\u6570\u636e\u7ed3\u6784\u5b9a\u4e49\u89e3\u6790\u5931\u8d25\uff0c\u539f\u56e0\u4e3a\uff1a%s", (String)"DataSetSchemaPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e.getMessage()), ShowStackTraceUtil.getErrorMsg(e));
            return true;
        }
        return false;
    }

    private boolean isIllegal(TreeNode rootNode) {
        TreeNode checkErrorNode = DataSetSchemaEditerPlugin.checkNonstandardNode(rootNode);
        if (checkErrorNode != null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u65b9\u6848\u5b9a\u4e49\u4e2d\u8282\u70b9: %s \u672a\u586b\u5199\u540d\u79f0\u6216\u6570\u636e\u7c7b\u578b\u8bf7\u4fee\u6539\uff01", (String)"DataSetSchemaPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), checkErrorNode.getId()));
            return true;
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        if (NUMBER.equals(property) || "name".equals(property) || META_TYPE.equals(property)) {
            String number = D.s((Object)this.getModel().getValue(NUMBER));
            String name = D.s((Object)this.getModel().getValue("name"));
            String metaType = D.s((Object)this.getModel().getValue(META_TYPE));
            String jsonValue = D.s((Object)this.getModel().getValue(FDEFINE_JSON_TAG));
            if (jsonValue == null) {
                return;
            }
            if (this.checkJsonParse(jsonValue)) {
                return;
            }
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)jsonValue, TreeNode.class);
            if (rootNode != null && number != null && !number.equals(rootNode.getId())) {
                DataSetSchemaEditerPlugin.updateFromParent(rootNode, number);
            }
            if (rootNode != null) {
                Object data = rootNode.getData();
                rootNode.setText(name);
                if (data instanceof Map) {
                    ((Map)data).put(DATA_TYPE, TYPE_OF_STRUCT.equals(metaType) ? metaType : null);
                    ((Map)data).put(NUMBER, number);
                    ((Map)data).put("name", name);
                }
            }
            String updateJson = SerializationUtils.toJsonString((Object)rootNode);
            this.getModel().setValue(FDEFINE_JSON_TAG, (Object)updateJson);
        }
    }

    private void save(Object dataCopyId) {
        DynamicObject datasetSchema = BusinessDataServiceHelper.loadSingle((Object)dataCopyId, (String)DATASET_SCHEMA);
        String jsonValue = D.s((Object)this.getModel().getValue(FDEFINE_JSON_TAG));
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)jsonValue, TreeNode.class);
        TreeNode checkErrorNode = DataSetUtil.checkAllParentNode(rootNode);
        if (checkErrorNode != null) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6570\u636e\u96c6\u65b9\u6848\u5b9a\u4e49\u4e2d\u7ed3\u6784\u7c7b\u578b\u8282\u70b9: %s \u672a\u5b9a\u4e49\u5b50\u8282\u70b9\uff0c\u8bf7\u6dfb\u52a0\u76f8\u5e94\u5b50\u8282\u70b9\u6216\u5220\u9664\u8be5\u8282\u70b9\uff01", (String)"DataSetSchemaPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), checkErrorNode.getId()));
        }
        datasetSchema.set(ENABLE, (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datasetSchema});
    }

    public static void publishDataSetSchema(TreeNode rootNode, DynamicObject dataSource, String metaType, String fullName, boolean isRoot, Map<String, String> rootNodeMap) {
        Object data = rootNode.getData();
        if (data instanceof Map) {
            String getType = ((Map)data).get(DATA_TYPE) != null ? D.s(((Map)data).get(DATA_TYPE)) : metaType;
            String name = fullName == null ? D.s(((Map)data).get(NUMBER)) : fullName;
            Long metaId = MetaSchemaUtil.getHashId((MetaType)MetaType.valueOf((String)getType), (long)D.l((Object)dataSource.getPkValue()), (String)name);
            boolean isExists = QueryServiceHelper.exists((String)METADATA_SCHEMA, (Object)metaId);
            DynamicObject metadataSchema = isExists ? BusinessDataServiceHelper.loadSingle((Object)metaId, (String)METADATA_SCHEMA) : BusinessDataServiceHelper.newDynamicObject((String)METADATA_SCHEMA);
            DataSetSchemaPlugin.setMetaDataSchema(dataSource, (Map)data, metaId, metadataSchema, metaType, name, isExists, isRoot, rootNodeMap);
            DataSetSchemaPlugin.setCreatetime(isExists, metadataSchema);
            DynamicObjectCollection propEntryentity = metadataSchema.getDynamicObjectCollection("prop_entryentity");
            propEntryentity.clear();
            int size = 1;
            List children = rootNode.getChildren();
            if (children != null) {
                for (TreeNode child : children) {
                    if (child.getChildren() != null || TYPE_OF_STRUCT.equals(((Map)child.getData()).get(DATA_TYPE))) {
                        DataSetSchemaPlugin.publishDataSetSchema(child, dataSource, metaType, child.getId(), false, rootNodeMap);
                    }
                    DynamicObject object = propEntryentity.addNew();
                    Object childData = child.getData();
                    if (childData instanceof Map) {
                        DataSetSchemaPlugin.setEntryentity(dataSource, child, object, (Map)childData, size, rootNodeMap);
                    }
                    ++size;
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{metadataSchema});
        }
    }

    private static void setCreatetime(boolean isExists, DynamicObject metadataSchema) {
        if (!isExists) {
            metadataSchema.set("creator", (Object)D.l((Object)RequestContext.get().getUserId()));
            metadataSchema.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        }
        metadataSchema.set("modifier", (Object)D.l((Object)RequestContext.get().getUserId()));
        metadataSchema.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
    }

    private static void setMetaDataSchema(Object dataSource, Map data, long metaId, DynamicObject metadataSchema, String metaType, String name, boolean isExists, boolean isRoot, Map<String, String> rootNodeMap) {
        metadataSchema.set("id", (Object)metaId);
        metadataSchema.set("type", data.get(DATA_TYPE) != null ? data.get(DATA_TYPE) : metaType);
        if (!isRoot) {
            int length = rootNodeMap.get(ROOT_NODE_NUM).length();
            String substring = name.substring(length);
            metadataSchema.set(FULL_NAME, (Object)(rootNodeMap.get(ROOT_NODE_FULL_NAME) + substring));
        } else {
            metadataSchema.set(FULL_NAME, (Object)name);
        }
        metadataSchema.set("name", data.get("name"));
        metadataSchema.set(NUMBER, isExists ? metadataSchema.get(NUMBER) : (isRoot ? data.get(NUMBER) : Hash.mur32((Object[])new Object[]{name})));
        metadataSchema.set(GROUP, dataSource);
        metadataSchema.set("status", (Object)"A");
        if ("QUERY".equals(metadataSchema.get("type"))) {
            metadataSchema.set(STATE, (Object)"Z");
        } else {
            metadataSchema.set(STATE, (Object)"S");
        }
        metadataSchema.set(ENABLE, (Object)1);
    }

    private static void setEntryentity(DynamicObject dataSource, TreeNode child, DynamicObject object, Map childData, int count, Map<String, String> rootNodeMap) {
        object.set("seq", (Object)count);
        object.set("prop_index", (Object)count);
        object.set("prop_name", childData.get(NUMBER));
        object.set("prop_label", childData.get("name"));
        String dataType = D.s(childData.get(DATA_TYPE));
        boolean isMultiple = D.x(childData.get("is_multiple"));
        boolean isDistinct = D.x(childData.get("is_distinct"));
        DataSetSchemaPlugin.setFieldType(object, dataType, isMultiple, isDistinct);
        if ("SERVICE".equals(dataType) || TYPE_OF_STRUCT.equals(dataType) || "QUERY".equals(dataType) || "ENTRIES".equals(dataType) || "ENUM".equals(dataType)) {
            object.set("data_schema", (Object)Hash.mur32((Object[])new Object[]{child.getId()}));
        } else if (isMultiple) {
            object.set("prop_remark", (Object)dataType);
        }
        if ("ENUM".equals(dataType)) {
            DataSetSchemaPlugin.createEnumMetadata(child, dataSource, rootNodeMap);
        }
    }

    private static void setFieldType(DynamicObject object, String dataType, boolean isMultiple, boolean isDistinct) {
        if (isMultiple) {
            if (TYPE_OF_STRUCT.equals(dataType)) {
                object.set("data_type", (Object)"ENTRIES");
            } else if (isDistinct) {
                object.set("data_type", (Object)("Set(" + dataType + ")"));
            } else {
                object.set("data_type", (Object)("List(" + dataType + ")"));
            }
        } else {
            object.set("data_type", (Object)dataType);
        }
    }

    public static void createEnumMetadata(TreeNode node, DynamicObject dataSource, Map<String, String> rootNodeMap) {
        Object data = node.getData();
        if (data instanceof Map) {
            long metaId = MetaSchemaUtil.getHashId((MetaType)MetaType.ENUM, (long)D.l((Object)dataSource.getPkValue()), (String)node.getId());
            boolean isExists = QueryServiceHelper.exists((String)METADATA_SCHEMA, (Object)metaId);
            DynamicObject metadataSchema = isExists ? BusinessDataServiceHelper.loadSingle((Object)metaId, (String)METADATA_SCHEMA) : BusinessDataServiceHelper.newDynamicObject((String)METADATA_SCHEMA);
            metadataSchema.set("id", (Object)metaId);
            metadataSchema.set("type", ((Map)data).get(DATA_TYPE));
            String sub = node.getId().substring(rootNodeMap.get(ROOT_NODE_NUM).length());
            metadataSchema.set(FULL_NAME, (Object)(rootNodeMap.get(ROOT_NODE_FULL_NAME) + sub));
            metadataSchema.set("name", ((Map)data).get("name"));
            metadataSchema.set(NUMBER, (Object)Hash.mur32((Object[])new Object[]{node.getId()}));
            metadataSchema.set(GROUP, (Object)dataSource);
            metadataSchema.set("status", (Object)"A");
            metadataSchema.set(STATE, (Object)"S");
            metadataSchema.set(ENABLE, (Object)1);
            DataSetSchemaPlugin.setCreatetime(isExists, metadataSchema);
            DynamicObjectCollection enumValues = metadataSchema.getDynamicObjectCollection("consts_entryentity");
            enumValues.clear();
            Object fields = ((Map)data).get("fields");
            if (fields instanceof Map) {
                ArrayList<String> textFields = new ArrayList<String>(((Map)fields).size());
                for (Object a : ((Map)fields).keySet()) {
                    textFields.add(D.s(a));
                }
                for (int i = 0; i < textFields.size(); ++i) {
                    DynamicObject enumEntry = enumValues.addNew();
                    enumEntry.set("seq", (Object)(i + 1));
                    enumEntry.set("const_index", (Object)(i + 1));
                    enumEntry.set("const_value", textFields.get(i));
                    enumEntry.set("const_label", ((Map)fields).get(textFields.get(i)));
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{metadataSchema});
        }
    }

    public void afterCreateNewData(EventObject evt) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params == null) {
            return;
        }
        if (params.get(JSONEDITER_TAG) != null) {
            this.newDataSetFromJson(params);
        } else if (params.get("source_id") != null) {
            String nodeId = D.s(params.get("source_id"));
            DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)"isc_data_source");
            IDataModel model = this.getModel();
            model.setValue(DATA_SOURCE, (Object)dataSource);
        }
    }

    private void newDataSetFromJson(Map<String, Object> params) {
        String jsonString = D.s((Object)params.get(JSONEDITER_TAG));
        try {
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)jsonString, TreeNode.class);
            IDataModel model = this.getModel();
            model.setValue("id", (Object)0);
            model.setValue(NUMBER, (Object)rootNode.getId());
            model.setValue("name", (Object)rootNode.getText());
            model.setValue(DATA_SOURCE, params.get(GROUP));
            model.setValue(FULL_NAME, params.get(FULL_NAME));
            Object data = rootNode.getData();
            if (data instanceof Map) {
                model.setValue(META_TYPE, ((Map)data).get(DATA_TYPE));
            }
            model.setValue(FDEFINE_JSON_TAG, (Object)jsonString);
        }
        catch (Exception e) {
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6839\u636e\u4f20\u5165json\u6587\u4ef6\u89e3\u6790\u5931\u8d25:%s\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91!", (String)"DataSetSchemaPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e));
            this.getView().close();
        }
        params.remove(JSONEDITER_TAG);
    }
}

