/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.dataset;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.entity.tree.TreeNode;

public class DataSetUtil {
    private static final String DOUBLE = "double";
    private static final String DECIMAL = "decimal";
    private static final String DATETIME = "datetime";
    private static final String BOOLEAN = "boolean";
    private static final String LONG = "long";
    private static final String STRING = "string";
    private static final String INTEGER = "integer";
    private static final String LIST = "list";
    private static final String SET = "set";
    private static final String UNKNOWN = "unknown";

    public static String formatDataSetType(String type) {
        String transType;
        if (type == null) {
            return UNKNOWN;
        }
        String lowerCaseType = type.trim().toLowerCase(Locale.ENGLISH);
        if (lowerCaseType.startsWith(LIST)) {
            return LIST;
        }
        if (lowerCaseType.startsWith(SET)) {
            return SET;
        }
        switch (lowerCaseType) {
            case "string": {
                transType = STRING;
                break;
            }
            case "int": {
                transType = INTEGER;
                break;
            }
            case "integer": {
                transType = INTEGER;
                break;
            }
            case "long": {
                transType = LONG;
                break;
            }
            case "boolean": {
                transType = BOOLEAN;
                break;
            }
            case "date": {
                transType = DATETIME;
                break;
            }
            case "datetime": {
                transType = DATETIME;
                break;
            }
            case "bigdecimal": {
                transType = DECIMAL;
                break;
            }
            case "decimal": {
                transType = DECIMAL;
                break;
            }
            case "double": {
                transType = DOUBLE;
                break;
            }
            default: {
                transType = UNKNOWN;
            }
        }
        return transType;
    }

    public static TreeNode checkAllParentNode(TreeNode rootnode) {
        List children = rootnode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                Object data = child.getData();
                if (data instanceof Map && "STRUCT".equals(((Map)data).get("dataType")) && child.getChildren() == null) {
                    return child;
                }
                if (DataSetUtil.checkAllParentNode(child) == null) continue;
                return DataSetUtil.checkAllParentNode(child);
            }
        }
        return null;
    }
}

