/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.dataset;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.api.DownLoadUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class ImportJsonToDatasetPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String IS_MULTIPLE = "is_multiple";
    private static final String DATATYPE = "dataType";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"view"});
        this.addClickListeners(new String[]{"upload"});
        this.addClickListeners(new String[]{"buttonap"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        String jsonEditer;
        ArrayList<String> fileUrls = new ArrayList<String>(1);
        for (Object url : evt.getUrls()) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        try {
            jsonEditer = this.getJsonData((String)fileUrls.get(0));
        }
        catch (IOException e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u4eceredis\u7f13\u5b58%s\u4e2d\u4e0b\u8f7d\u5931\u8d25\uff0c\u65e0\u6cd5\u5bfc\u5165\uff01", (String)"ImportJsonToDatasetPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), fileUrls.get(0)), (Throwable)e);
        }
        CodeEdit codeEdit = (CodeEdit)this.getView().getControl("codeeditap");
        codeEdit.setText(jsonEditer);
    }

    private String getJsonData(String fileUrl) throws IOException {
        return DownLoadUtil.getData((String)fileUrl);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            Map returns = this.getView().getFormShowParameter().getCustomParams();
            String entityName = D.s(returns.get("entityName"));
            if ("buttonap".equals(operateKey) && "isc_body_import_editor".equals(entityName)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("ok", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5bfc\u5165\u7684Json\u6587\u4ef6\u5c06\u8986\u76d6\u539f\u53c2\u6570\u5185\u5bb9\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ImportJsonToDatasetPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() == MessageBoxResult.Yes) {
            this.returnDataToParent();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operationKey = args.getOperateKey();
        if ("buttonap".equalsIgnoreCase(operationKey)) {
            this.returnDataToParent();
        }
    }

    private void returnDataToParent() {
        Map jsonDataMap;
        Map returns = this.getView().getFormShowParameter().getCustomParams();
        String entityName = D.s(returns.get("entityName"));
        CodeEdit control = (CodeEdit)this.getView().getControl("codeeditap");
        String jsonStr = D.s((Object)control.getText());
        if (StringUtil.isEmpty((String)jsonStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165json\u6570\u636e", (String)"ImportJsonToDatasetPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            jsonDataMap = (Map)Script.parseJson((String)jsonStr);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u89e3\u6790json\u5185\u5bb9\u51fa\u9519\uff0c\u8bf7\u6821\u9a8c\uff01", (String)"ImportJsonToDatasetPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ShowStackTraceUtil.getErrorMsg(e));
            return;
        }
        switch (entityName) {
            case "isc_dataset_schema": {
                this.formatDataToDataSet(jsonDataMap);
                break;
            }
            case "isc_body_import_editor": {
                this.formatDataToApiFields(jsonDataMap);
                break;
            }
        }
    }

    private void formatDataToApiFields(Map<String, Object> jsonDataMap) {
        TreeNode root = new TreeNode("", "$ISC", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ImportJsonToDatasetPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        HashMap<String, Object> rootData = new HashMap<String, Object>();
        rootData.put("name", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ImportJsonToDatasetPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        rootData.put("type", "STRUCT");
        rootData.put("isArray", Boolean.FALSE);
        rootData.put("required", Boolean.FALSE);
        rootData.put("description", ResManager.loadKDString((String)"\u865a\u62df\u6839\u8282\u70b9", (String)"ImportJsonToDatasetPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        rootData.put("default_value", "");
        root.setData(rootData);
        try {
            this.jsonMapToApiTreeNode(jsonDataMap, root);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
            return;
        }
        String jsonString = SerializationUtils.toJsonString((Object)root);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jsonEditerTag", jsonString);
        this.getView().returnDataToParent(params);
        this.getView().close();
    }

    private void formatDataToDataSet(Map<String, Object> jsonDataMap) {
        TreeNode rootNode = new TreeNode("", "TempNodeId", ResManager.loadKDString((String)"\u5bfc\u5165Json\u6587\u4ef6", (String)"ImportJsonToDatasetPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        HashMap<String, Object> nodeData = new HashMap<String, Object>();
        nodeData.put("number", "TempNodeId");
        nodeData.put("name", ResManager.loadKDString((String)"\u5bfc\u5165Json\u6587\u4ef6", (String)"ImportJsonToDatasetPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        nodeData.put(DATATYPE, null);
        nodeData.put(IS_MULTIPLE, Boolean.FALSE);
        nodeData.put("is_distinct", Boolean.FALSE);
        rootNode.setData(nodeData);
        try {
            this.jsonMapToTreeNode(jsonDataMap, rootNode);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
            return;
        }
        String jsonString = SerializationUtils.toJsonString((Object)rootNode);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("jsonEditerTag", jsonString);
        params.put("group", null);
        params.put("full_name", null);
        FormOpener.showAddNew(this, "isc_dataset_schema", params, "dataset_close");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("dataset_close".equals(action)) {
            this.getView().close();
        }
    }

    private void jsonMapToTreeNode(Map<String, Object> jsonDataMap, TreeNode rootNode) {
        if (jsonDataMap != null) {
            for (String jsonKey : jsonDataMap.keySet()) {
                if (jsonKey.contains("$")) continue;
                TreeNode node = new TreeNode(rootNode.getId(), rootNode.getId() + "." + jsonKey, jsonKey);
                HashMap<String, Object> nodeData = new HashMap<String, Object>();
                nodeData.put("number", jsonKey);
                nodeData.put("name", jsonKey);
                nodeData.put(IS_MULTIPLE, Boolean.FALSE);
                nodeData.put("is_distinct", Boolean.FALSE);
                this.innerSetNodeData(jsonDataMap, jsonKey, node, nodeData, DATATYPE);
                rootNode.addChild(node);
                node.setData(nodeData);
            }
        }
    }

    private void jsonMapToApiTreeNode(Map<String, Object> jsonDataMap, TreeNode rootNode) {
        if (jsonDataMap != null) {
            for (String jsonKey : jsonDataMap.keySet()) {
                TreeNode node = new TreeNode(rootNode.getId(), rootNode.getId() + "." + jsonKey, jsonKey);
                HashMap<String, Object> nodeData = new HashMap<String, Object>();
                nodeData.put("name", jsonKey);
                nodeData.put("description", jsonKey);
                nodeData.put("required", Boolean.FALSE);
                nodeData.put("default_value", null);
                this.innerSetNodeData(jsonDataMap, jsonKey, node, nodeData, "type");
                rootNode.addChild(node);
                node.setData(nodeData);
            }
        }
    }

    private void innerSetNodeData(Map<String, Object> jsonDataMap, String jsonKey, TreeNode node, Map<String, Object> nodeData, String typeField) {
        Object o = jsonDataMap.get(jsonKey);
        if (o instanceof Map) {
            nodeData.put(typeField, "STRUCT");
            Map childMap = (Map)jsonDataMap.get(jsonKey);
            this.parseNodeFromStruct(node, typeField, childMap);
        } else if (o instanceof List) {
            List entrylists = (List)o;
            nodeData.put(typeField, "STRUCT");
            this.setDataFromList(node, nodeData, entrylists, typeField, jsonKey);
        } else {
            this.setDefaultType(jsonKey, nodeData, typeField, o);
        }
    }

    private void parseNodeFromStruct(TreeNode node, String typeField, Map<String, Object> childMap) {
        if (DATATYPE.equals(typeField)) {
            this.jsonMapToTreeNode(childMap, node);
        } else if ("type".equals(typeField)) {
            this.jsonMapToApiTreeNode(childMap, node);
        }
    }

    private void setDefaultType(String jsonKey, Map<String, Object> nodeData, String typeField, Object o) {
        if (o instanceof Integer) {
            if (DATATYPE.equals(typeField)) {
                nodeData.put(typeField, "integer");
            } else if ("type".equals(typeField)) {
                nodeData.put(typeField, "int");
            }
        } else if (o instanceof Boolean) {
            nodeData.put(typeField, "boolean");
        } else if (o == null || o instanceof String) {
            nodeData.put(typeField, "string");
        } else if (o instanceof Long) {
            nodeData.put(typeField, "long");
        } else if (o instanceof Double) {
            nodeData.put(typeField, "double");
        } else if (o instanceof BigDecimal) {
            nodeData.put(typeField, "decimal");
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8be5json\u6570\u636e\u89e3\u6790\u540e\u65e0\u6cd5\u8fdb\u884c\u5339\u914d\uff0c\u5b57\u6bb5%1$s:%2$s\u5185\u5bb9\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\uff01", (String)"ImportJsonToDatasetPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), jsonKey, o));
        }
    }

    private void setDataFromList(TreeNode node, Map<String, Object> nodeData, List entrylists, String typeField, String jsonKey) {
        this.setArrayByType(nodeData, typeField);
        if (!entrylists.isEmpty()) {
            Object list = entrylists.get(0);
            if (list instanceof Map) {
                this.parseNodeFromStruct(node, typeField, (Map)list);
            } else {
                this.setDefaultType(jsonKey, nodeData, typeField, list);
            }
        }
    }

    private void setArrayByType(Map<String, Object> nodeData, String typeField) {
        if (DATATYPE.equals(typeField)) {
            nodeData.put(IS_MULTIPLE, Boolean.TRUE);
        } else if ("type".equals(typeField)) {
            nodeData.put("isArray", Boolean.TRUE);
        }
    }
}

