/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.event;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.dc.event.EventUtils;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class EventBindFormPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String DB_LINK = "dblink";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object dblink = params.get(DB_LINK);
        if (dblink != null) {
            this.getPageCache().put(DB_LINK, D.s(dblink));
            this.queryByDatabaseLink(D.s(dblink));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("refresh".equals(e.getOperateKey())) {
            this.queryByDatabaseLink(this.getPageCache().get(DB_LINK));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryByDatabaseLink(Object dblink) {
        DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)dblink, (String)"isc_database_link");
        String iscHub = ConnectorUtil.getIscHub((DynamicObject)link);
        String type = link.getString("database_type");
        ConnectionManager.pushResLicense((boolean)true);
        try (ConnectionWrapper cn = ConnectionManager.getConnection((long)D.l((Object)dblink));){
            ArrayList<String> values = new ArrayList<String>(1);
            ArrayList<Integer> types = new ArrayList<Integer>(1);
            if ("self".equals(type)) {
                iscHub = "{self}";
            }
            values.add(iscHub);
            types.add(12);
            String sql = "select fid,fcreated_time,fisc_hub,fentity,ftrigger_type, ftrigger_id,fevents,frequired_fields from T_ISCB_CON_EVT_BND  where fisc_hub = ?  order by fcreated_time desc ";
            String topSql = cn.topSQL(sql, 500);
            try (ObjectReader reader = cn.executeQuery(topSql, values, types);){
                this.showEntryData((ObjectReader<DataRow>)reader);
            }
        }
        catch (Throwable e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private void showEntryData(ObjectReader<DataRow> reader) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        DataRow data = (DataRow)reader.read();
        while (data != null) {
            DynamicObject row = entryentity.addNew();
            this.setRowValues(row, data);
            data = (DataRow)reader.read();
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void setRowValues(DynamicObject row, DataRow data) {
        row.set("id", data.getValue("fid"));
        row.set("created_time", data.getValue("fcreated_time") == null ? null : D.t((Object)data.getValue("fcreated_time")));
        row.set("isc_hub", (Object)data.getValue("fisc_hub").equals("{self}"));
        row.set("entity", data.getValue("fentity"));
        row.set("trigger_type", data.getValue("ftrigger_type"));
        row.set("trigger_id", (Object)EventUtils.getTriggerName(data.getValue("ftrigger_id"), D.s((Object)data.getValue("ftrigger_type"))));
        row.set("events", data.getValue("fevents"));
        row.set("frequired_fields", data.getValue("frequired_fields"));
    }
}

