/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.event;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.dc.event.EventUtils;
import kd.isc.iscb.formplugin.log.SchemaEncryptDataUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Json;

public class EventQueueFormPlugin
extends AbstractFormPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null && params.get("database_link_id") != null) {
            ObjectReader<DataRow> reader = null;
            try {
                reader = this.queryData(params.get("database_link_id"), params.get("id").toString());
                this.setValue(reader);
            }
            catch (Throwable throwable) {
                FormOpener.showErrorMessage(this.getView(), throwable);
            }
            finally {
                DbUtil.close(reader);
            }
        }
    }

    private void setValue(ObjectReader<DataRow> reader) {
        try {
            DataRow dataRow = (DataRow)reader.read();
            IDataModel model = this.getModel();
            if (dataRow != null) {
                String error;
                Object triggerId = dataRow.getValue("ftrigger_id");
                String ftrigger_type = D.s((Object)dataRow.getValue("ftrigger_type"));
                model.setValue("entity", dataRow.getValue("fentity"));
                model.setValue("event", dataRow.getValue("fevent"));
                model.setValue("boid", dataRow.getValue("fboid"));
                model.setValue("isc_hub", dataRow.getValue("fisc_hub"));
                model.setValue("trigger_type", (Object)ftrigger_type);
                model.setValue("trigger_id", (Object)EventUtils.getTriggerName(triggerId, D.s((Object)dataRow.getValue("ftrigger_type"))));
                model.setValue("state", dataRow.getValue("fstate"));
                model.setValue("created_time", dataRow.getValue("fcreated_time") == null ? null : D.t((Object)dataRow.getValue("fcreated_time")));
                model.setValue("modified_time", dataRow.getValue("fmodified_time") == null ? null : D.t((Object)dataRow.getValue("fmodified_time")));
                Object data = dataRow.getValue("fdata");
                if (data != null) {
                    String en = this.getEncryptData(data, triggerId, ftrigger_type);
                    model.setValue("data_tag", SchemaEncryptDataUtil.getVarTag(en));
                    model.setValue("data", (Object)(en.length() > 255 ? en.substring(0, 255) : en));
                }
                if ((error = D.s((Object)dataRow.getValue("ferror"))) != null) {
                    model.setValue("error_tag", (Object)error);
                    model.setValue("error", (Object)(error.length() > 255 ? error.substring(0, 255) : error));
                }
            }
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    public String getEncryptData(Object data, Object triggerId, String ftrigger_type) {
        try {
            long metaDataId = this.getMetaDataId(triggerId, ftrigger_type);
            String en = D.s((Object)SchemaEncryptDataUtil.getEncryptData(metaDataId, data));
            return en == null ? D.s((Object)data) : en;
        }
        catch (Exception e) {
            return D.s((Object)data);
        }
    }

    private long getMetaDataId(Object triggerId, String ftrigger_type) {
        long schemaId = 0L;
        switch (ftrigger_type) {
            case "D": {
                DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_data_copy_trigger");
                DynamicObject data_copy = BusinessDataServiceHelper.loadSingle((Object)trigger.getLong("data_copy_id"), (String)"isc_data_copy");
                schemaId = D.l((Object)data_copy.getDynamicObject("source_schema").getPkValue());
                break;
            }
            case "E": {
                DynamicObject pubData = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_mq_bill_data_pub");
                schemaId = D.l((Object)pubData.getDynamicObject("meta_data").getPkValue());
                break;
            }
            case "S": {
                DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_service_flow");
                Map o = (Map)Json.toObject((String)D.s((Object)flow.get("define_json_tag")));
                Map nodes = (Map)o.get("nodes");
                Map node = (Map)nodes.get("1");
                schemaId = D.l(node.get("data_schema"));
                break;
            }
            case "A": {
                DynamicObject api = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_call_api_by_evt");
                schemaId = D.l((Object)api.getDynamicObject("metaschema").getPkValue());
                break;
            }
        }
        return schemaId;
    }

    private ObjectReader<DataRow> queryData(Object dblink, String id) {
        ObjectReader dataRowObjectReader = null;
        ConnectionManager.pushResLicense((boolean)true);
        try (ConnectionWrapper cn = ConnectionManager.getConnection((long)D.l((Object)dblink));){
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<Integer> types = new ArrayList<Integer>();
            values.add(id);
            types.add(12);
            dataRowObjectReader = cn.executeQuery("select FID,FCREATED_TIME,FENTITY,FEVENT,FBOID,FISC_HUB,FTRIGGER_TYPE,FTRIGGER_ID,FSTATE,FMODIFIED_TIME,FDATA,FERROR from T_ISCB_CON_EVT_QUE where fid = ?", values, types);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            ConnectionManager.popResLicense();
        }
        return dataRowObjectReader;
    }
}

