/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.ext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.dc.ext.AccountGroupsResp;
import kd.isc.iscb.formplugin.dc.ext.LinkConst;
import kd.isc.iscb.formplugin.dc.ext.Util;
import kd.isc.iscb.formplugin.dc.ext.YjxcAccountResp;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.NetUtil;

public class JdyDevFormPlugin
extends AbstractFormPlugin
implements LinkConst {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        if (D.s((Object)model.getValue("server_ip")) == null) {
            model.setValue("server_ip", (Object)"api.kingdee.com");
        }
        if (D.i((Object)model.getValue("server_port")) <= 0) {
            model.setValue("server_port", (Object)443);
        }
        if (D.s((Object)model.getValue("http_protocal")) == null) {
            model.setValue("http_protocal", (Object)"https");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("get_account_groups".equals(e.getOperateKey())) {
            try {
                List<Map<String, Object>> accountGroups;
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String databaseType = D.s((Object)dataEntity.get("database_type"));
                String mainUrl = Util.getMainUrl(dataEntity);
                String accessToken = Util.getAccessToken(mainUrl, dataEntity);
                if ("YXC_API".equals(databaseType)) {
                    accountGroups = this.queryAccountListForYxc(mainUrl, accessToken);
                } else if ("JDY_YJXC".equals(databaseType)) {
                    accountGroups = this.queryAccountListForJdy(mainUrl, accessToken);
                } else {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u7c7b\u578b\u3010%s\u3011\u6682\u4e0d\u652f\u6301\u83b7\u53d6\u8d26\u5957\u5206\u7ec4\u529f\u80fd", (String)"JdyDevFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), databaseType));
                }
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                params.put("accountGroups", accountGroups);
                FormOpener.showForm(this, "isc_jdy_dc_list", null, params, "select_account");
            }
            catch (Throwable ex) {
                FormOpener.showErrorMessage(this.getView(), ex);
            }
        }
    }

    private List<Map<String, Object>> queryAccountListForJdy(String mainUrl, String accessToken) {
        String url = mainUrl + "/jdyscm/service/list?access_token=" + accessToken;
        String respString = this.getJdyAccount(url);
        YjxcAccountResp yjxcAccountResp = (YjxcAccountResp)JSON.parseObject((String)respString, (TypeReference)new TypeReference<YjxcAccountResp>(){}, (Feature[])new Feature[0]);
        if (yjxcAccountResp.getCode() == 0) {
            return this.makeAccountListForJdy(yjxcAccountResp);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bbf\u95ee\u4e91\u8fdb\u9500\u5b58%1$s\u83b7\u53d6\u8d26\u5957\u5217\u8868,\u8fd4\u56de\u5931\u8d25\u7ed3\u679c\uff1a code : %2$s, message : %3$s", (String)"JdyDevFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), url, yjxcAccountResp.getCode(), yjxcAccountResp.getMsg()));
    }

    private List<Map<String, Object>> makeAccountListForJdy(YjxcAccountResp yjxcAccountResp) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        for (YjxcAccountResp.ItemsDTO item : yjxcAccountResp.getItems()) {
            HashMap<String, Object> account = new HashMap<String, Object>(4);
            account.put("account_id", item.getDbId());
            account.put("account_name", item.getName());
            account.put("group_name", item.getDomain());
            list.add(account);
        }
        return list;
    }

    private String getJdyAccount(String url) {
        Reader reader = NetUtil.httpGet((String)url, (String)"UTF-8");
        try {
            String string = NetUtil.readText((Reader)reader);
            return string;
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bbf\u95ee%s\u83b7\u53d6\u7cbe\u6597\u4e91\u8d26\u5957\u5217\u8868\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"JdyDevFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), url), (Throwable)e);
        }
        finally {
            DbUtil.close((Reader)reader);
        }
    }

    private List<Map<String, Object>> queryAccountListForYxc(String mainUrl, String accessToken) {
        String url = mainUrl + "/jdy/sys/accountGroup?access_token=" + accessToken;
        String respString = this.getYxcAccountGroup(url);
        AccountGroupsResp accountGroupsResp = (AccountGroupsResp)JSON.parseObject((String)respString, (TypeReference)new TypeReference<AccountGroupsResp>(){}, (Feature[])new Feature[0]);
        if (accountGroupsResp.isSuccess()) {
            return this.makeAccountListForYxc(accountGroupsResp);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bbf\u95ee%1$s\u83b7\u53d6\u8d26\u5957\u5217\u8868,\u8fd4\u56de\u5931\u8d25\u7ed3\u679c\uff1a errorCode : %2$s, message : %3$s", (String)"JdyDevFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), url, accountGroupsResp.getErrorCode(), accountGroupsResp.getMessage()));
    }

    private List<Map<String, Object>> makeAccountListForYxc(AccountGroupsResp accountGroupsResp) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        for (AccountGroupsResp.DataDTO dataDTO : accountGroupsResp.getData()) {
            List<AccountGroupsResp.DataDTO.AccountGroupsDTO> accountGroups = dataDTO.getAccountGroups();
            for (AccountGroupsResp.DataDTO.AccountGroupsDTO accountGroup : accountGroups) {
                if (!D.x((Object)accountGroup.getEnable())) continue;
                HashMap<String, String> item = new HashMap<String, String>(4);
                item.put("account_id", accountGroup.getAccountId());
                item.put("account_name", accountGroup.getAccountName());
                item.put("group_id", accountGroup.getGroupId());
                item.put("group_name", accountGroup.getGroupName());
                list.add(item);
            }
        }
        return list;
    }

    private String getYxcAccountGroup(String accountGroupUrl) {
        Reader reader = NetUtil.httpAccess((String)accountGroupUrl, null, (String)"UTF-8", null, (String)"POST");
        try {
            String string = NetUtil.readText((Reader)reader);
            return string;
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bbf\u95ee%s\u83b7\u53d6\u4e91\u661f\u8fb0\u8d26\u5957\u5217\u8868\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (String)"JdyDevFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), accountGroupUrl), (Throwable)e);
        }
        finally {
            DbUtil.close((Reader)reader);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object data = evt.getReturnData();
        if (action.equals("select_account") && data instanceof Map) {
            Map map = (Map)data;
            this.getModel().setValue("attr1", map.get("group_name"));
            this.getModel().setValue("attr2", map.get("account_id"));
        }
    }
}

