/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.util.DataTypeEqualsUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class CommonPluginUtil {
    private static final String PARAMS_ENTRYENTITY = "params_entryentity";
    private static final String PARAMS_NAME = "params_name";
    private static final String PARAMS_LABEL = "params_label";
    private static final String PARAMS_DATA_TYPE = "params_data_type";

    public static void setParamsEntry(DynamicObject srcObj, IDataModel model, IFormView view) {
        model.getDataEntity(true);
        DynamicObjectCollection schemaCollection = srcObj.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        DynamicObjectCollection triggerCollection = model.getEntryEntity(PARAMS_ENTRYENTITY);
        triggerCollection.clear();
        for (DynamicObject obj : schemaCollection) {
            DynamicObject param = triggerCollection.addNew();
            param.set(PARAMS_NAME, obj.get(PARAMS_NAME));
            param.set(PARAMS_LABEL, obj.get(PARAMS_LABEL));
            param.set(PARAMS_DATA_TYPE, obj.get(PARAMS_DATA_TYPE));
            param.set("params_value", obj.get("params_value"));
        }
        model.getEntryEntity(PARAMS_ENTRYENTITY);
        view.updateView(PARAMS_ENTRYENTITY);
        model.updateCache();
    }

    public static void setParamsEntryWithoutValue(DynamicObject schema, IDataModel model, IFormView view) {
        model.getDataEntity(true);
        DynamicObjectCollection schema_entry = schema.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        DynamicObjectCollection cur_entry = model.getEntryEntity(PARAMS_ENTRYENTITY);
        Map<String, Object> lastValue = CommonPluginUtil.getLastValue(cur_entry);
        cur_entry.clear();
        for (DynamicObject schema_param : schema_entry) {
            DynamicObject param = cur_entry.addNew();
            String name = schema_param.getString(PARAMS_NAME);
            param.set(PARAMS_NAME, (Object)name);
            param.set(PARAMS_LABEL, (Object)schema_param.getString(PARAMS_LABEL));
            param.set(PARAMS_DATA_TYPE, (Object)schema_param.getString(PARAMS_DATA_TYPE));
            if (lastValue.get(name) == null) continue;
            param.set("params_value", lastValue.get(name));
        }
        view.updateView(PARAMS_ENTRYENTITY);
    }

    private static Map<String, Object> getLastValue(DynamicObjectCollection cur_entry) {
        HashMap<String, Object> lastValue = new HashMap<String, Object>(cur_entry.size());
        for (DynamicObject object : cur_entry) {
            lastValue.put(D.s((Object)object.get(PARAMS_NAME)), object.get("params_value"));
        }
        return lastValue;
    }

    public static boolean checkParamEntry(IFormPlugin plugin, IDataModel model, IFormView view) {
        StringBuilder messages = new StringBuilder();
        DynamicObjectCollection c = model.getEntryEntity(PARAMS_ENTRYENTITY);
        for (DynamicObject o : c) {
            String name = o.getString(PARAMS_NAME);
            String dataType = o.getString(PARAMS_DATA_TYPE);
            String value = o.getString("params_value");
            if (StringUtil.isEmpty((String)value)) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u53c2\u6570\u4e3a\u7a7a!", (String)"CommonPluginUtil_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), name));
                return false;
            }
            if (value.trim().equals("*") || DataTypeEqualsUtil.isMatchType((String)value, (String)dataType)) continue;
            messages.append(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"CommonPluginUtil_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(name).append(ResManager.loadKDString((String)"\u503c\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"CommonPluginUtil_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        String valid = messages.toString();
        if (!StringUtil.isEmpty((String)valid)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("execute_callback", plugin);
            view.showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f\u5b57\u6bb5\u503c\u6216\u7c7b\u578b\u4e0d\u5339\u914d\uff1a%s", (String)"CommonPluginUtil_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), valid), MessageBoxOptions.YesNo, confirmCallBacks);
            return false;
        }
        return true;
    }

    public static Map<String, Object> buildParamMap(DynamicObjectCollection entry) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (DynamicObject o : entry) {
            String name = o.getString(PARAMS_NAME);
            String value = o.getString("params_value");
            params.put(name, value);
        }
        return params;
    }

    public static void setReturnListValuesToFields(List<Map<String, Object>> returnData, IDataModel model, IFormView view, Map<String, String> properties) {
        String tips;
        DynamicObjectCollection retrieverEntries = model.getDataEntity(true).getDynamicObjectCollection("fields");
        HashSet<String> repeatFields = new HashSet<String>();
        HashSet<String> entryFields = new HashSet<String>();
        for (int i = 0; i < returnData.size(); ++i) {
            Map<String, Object> map = returnData.get(i);
            int index = D.i((Object)map.get("$row")) + i;
            String field = D.s((Object)map.get("full_number"));
            String dataType = D.s((Object)map.get("data_type"));
            if (dataType != null && dataType.contains("ENTRIES")) {
                entryFields.add(field);
                continue;
            }
            if (CommonPluginUtil.hasField(retrieverEntries, field, "field")) {
                repeatFields.add(field);
                continue;
            }
            DynamicObject entry = index >= retrieverEntries.size() ? retrieverEntries.addNew() : (DynamicObject)retrieverEntries.get(index);
            entry.set("field", (Object)field);
            entry.set("description", map.get("full_name"));
            entry.set("data_type", (Object)dataType);
            if (properties == null || properties.isEmpty()) continue;
            for (Map.Entry<String, String> prop : properties.entrySet()) {
                entry.set(prop.getKey(), map.get(prop.getValue()));
            }
        }
        ArrayList<String> tipList = new ArrayList<String>();
        if (!repeatFields.isEmpty()) {
            tips = StringUtil.join(repeatFields, (String)",");
            tipList.add(String.format(ResManager.loadKDString((String)"\u5982\u4e0b\u5b57\u6bb5\u91cd\u590d\uff0c\u5df2\u88ab\u5ffd\u7565\uff1a%s", (String)"CommonPluginUtil_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tips));
        }
        if (!entryFields.isEmpty()) {
            tips = StringUtil.join(entryFields, (String)",");
            tipList.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u5b57\u6bb5\u4e0d\u80fd\u76f4\u63a5\u9009\u62e9\uff0c\u8bf7\u9009\u62e9\u4e0b\u5c42\u5b57\u6bb5\uff1a%s", (String)"CommonPluginUtil_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tips));
        }
        if (!tipList.isEmpty()) {
            if (tipList.size() == 1) {
                view.showTipNotification((String)tipList.get(0), Integer.valueOf(4000));
            } else {
                StringBuilder sb = new StringBuilder();
                for (int i = 1; i <= tipList.size(); ++i) {
                    sb.append(i).append(". ").append((String)tipList.get(i - 1)).append('\uff1b');
                }
                view.showTipNotification(sb.toString(), Integer.valueOf(4000));
            }
        }
        view.updateView("fields");
    }

    private static boolean hasField(DynamicObjectCollection entries, String field, String fieldColumn) {
        for (DynamicObject item : entries) {
            if (!field.equals(item.getString(fieldColumn))) continue;
            return true;
        }
        return false;
    }

    public static void initVariableEntryCombo(IDataModel model, IFormView view, String comboName) {
        DynamicObjectCollection param_entries = model.getEntryEntity(PARAMS_ENTRYENTITY);
        ComboEdit filter_value_var = (ComboEdit)view.getControl(comboName);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (DynamicObject param_entry : param_entries) {
            ComboItem comboItem = new ComboItem();
            String paramsName = param_entry.getString(PARAMS_NAME);
            if (StringUtil.isEmpty((String)paramsName)) continue;
            comboItem.setValue(paramsName);
            comboItem.setCaption(new LocaleString(paramsName));
            items.add(comboItem);
        }
        filter_value_var.setComboItems(items);
    }

    public static boolean checkParams(Object schemaId, DynamicObject trigger) {
        DynamicObjectCollection trigger_entry = trigger.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        HashSet<String> trigger_entry_name = new HashSet<String>(trigger_entry.size());
        for (DynamicObject obj : trigger_entry) {
            trigger_entry_name.add(obj.getString(PARAMS_NAME));
        }
        DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)"isc_export_file", (String)"id,params_name");
        DynamicObjectCollection schema_entry = schema.getDynamicObjectCollection(PARAMS_ENTRYENTITY);
        if (trigger_entry_name.size() != schema_entry.size()) {
            return false;
        }
        for (DynamicObject obj : schema_entry) {
            if (trigger_entry_name.contains(obj.getString(PARAMS_NAME))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkFilterEntries(IFormView view, IDataModel model) {
        DynamicObjectCollection filterEntries = model.getEntryEntity("filter_entries");
        if (CommonPluginUtil.checkFilterValue(filterEntries, view)) {
            return true;
        }
        if (CommonPluginUtil.validateFilterBracket(filterEntries)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u3010\u8fc7\u6ee4\u6761\u4ef6\u3011\u5206\u5f55\u4e2d\u62ec\u53f7\u672a\u6b63\u786e\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CommonPluginUtil_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return true;
        }
        return false;
    }

    private static boolean checkFilterValue(DynamicObjectCollection filterEntries, IFormView view) {
        for (int i = 0; i < filterEntries.size(); ++i) {
            DynamicObject filter = (DynamicObject)filterEntries.get(i);
            String filterCompare = filter.getString("filter_compare");
            if (StringUtil.isEmpty((String)filterCompare)) continue;
            String filter_value_var = D.s((Object)filter.get("filter_value_var"));
            String filter_value_fixed = D.s((Object)filter.get("filter_value_fixed"));
            if (filter_value_fixed == null && filter_value_var == null) {
                if ("IS_NULL".equals(filterCompare) || "IS_NOT_NULL".equals(filterCompare)) continue;
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u3010\u8fc7\u6ee4\u6761\u4ef6\u3011\u5206\u5f55\u4e2d\u7b2c%s\u884c\uff1a\u672a\u586b\u5199\u6bd4\u8f83\u503c\uff0c\u8bf7\u5728\u201c\u56fa\u5b9a\u6bd4\u8f83\u503c\u201d\u4e0e\u201c\u6bd4\u8f83\u503c\u53d8\u91cf\u201d\u4e2d\u9009\u586b\u4e00\u9879\u3002", (String)"CommonPluginUtil_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), i + 1), Integer.valueOf(3000));
                return true;
            }
            if (!"IS_NULL".equals(filterCompare) && !"IS_NOT_NULL".equals(filterCompare)) continue;
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u3010\u8fc7\u6ee4\u6761\u4ef6\u3011\u5206\u5f55\u4e2d\u7b2c%s\u884c\uff1a\u6bd4\u8f83\u6761\u4ef6\u662f\u201c\u4e3a\u7a7a\u201d\u6216\u201c\u4e0d\u4e3a\u7a7a\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u586b\u5199\u6bd4\u8f83\u503c\u3002", (String)"CommonPluginUtil_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), i + 1), Integer.valueOf(3000));
            return true;
        }
        return false;
    }

    private static boolean validateFilterBracket(DynamicObjectCollection filterEntries) {
        int count = 0;
        for (DynamicObject filter : filterEntries) {
            String right_bracket;
            int right;
            String left_bracket = filter.getString("filter_left_bracket");
            int left = left_bracket == null ? 0 : left_bracket.length();
            if ((count = count + left - (right = (right_bracket = filter.getString("filter_right_bracket")) == null ? 0 : right_bracket.length())) >= 0) continue;
            return true;
        }
        return count != 0;
    }
}

