/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.file;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.dc.f.DataFileAction;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.util.QFilterUtil;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.StringUtil;

public abstract class DataFileFormPlugin
extends AbstractFormPlugin {
    protected DataFileAction action;
    private static final String DISABLE_CALLBACK = "disable_callback";
    private static final Set<String> STATUS_ENTITY_IDS = new HashSet<String>();
    private static final String ACTION_KEY = "datafile_action";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getPageCache().put(ACTION_KEY, DataFileAction.getActionByObj((DynamicObject)this.getModel().getDataEntity()).name());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate operate = (AbstractOperate)e.getSource();
        String operationKey = operate.getOperateKey();
        String entityName = this.getModel().getDataEntityType().getName();
        if (e.getSource() instanceof Save) {
            this.disableBeforeDoOperation(e, entityName, ResManager.loadKDString((String)"\u7981\u7528\u540e\u624d\u80fd\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"DataFileFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if ("modify".equals(operationKey)) {
            this.disableBeforeDoOperation(e, entityName, ResManager.loadKDString((String)"\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"DataFileFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        if ("modify".equals(key)) {
            this.getView().setStatus(OperationStatus.EDIT);
        } else if ("save".equals(key) && !IscLicenseUtil.getTenantLicenseInfo().hasValidLicense()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u8bb8\u53ef\u6570\u91cf\u4e3a\u96f6\u6216\u8bb8\u53ef\u5df2\u8fc7\u671f\uff0c\u65e0\u6cd5\u4f7f\u7528\u5f53\u524d\u529f\u80fd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4e3a\u96c6\u6210\u4e91\u6dfb\u52a0\u8bb8\u53ef\u3002", (String)"DataFileFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void disableBeforeDoOperation(BeforeDoOperationEventArgs e, String entityId, String tips) {
        QFilter[] qfs;
        if (STATUS_ENTITY_IDS.contains(entityId) && QueryServiceHelper.exists((String)entityId, (QFilter[])(qfs = QFilterUtil.builder().put("id", "=", this.getModel().getValue("id")).put("enable", "=", (Object)"1").build()))) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DISABLE_CALLBACK, (IFormPlugin)this);
            this.getView().showConfirm(tips, MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        if (DISABLE_CALLBACK.equals(evt.getCallBackId())) {
            this.getView().invokeOperation("disable");
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }

    protected void setDefaultValue(DynamicObject meta) {
        if (StringUtil.isEmpty((String)this.getModel().getValue("number").toString())) {
            this.getModel().setValue("number", (Object)this.getRandNumber(this.getAction().getTag()));
        }
        if (StringUtil.isEmpty((String)this.getModel().getValue("name").toString())) {
            String name = meta.getString("name");
            if (name != null && !name.startsWith(this.getAction().getName())) {
                name = this.getAction().getName() + "_" + meta.getString("name");
            }
            this.getModel().setValue("name", (Object)name);
        }
    }

    private String getRandNumber(String tag) {
        long id = IDService.get().genLongId();
        String number = tag + "_" + Hash.longToDigital32((long)id);
        if (number.length() > 30) {
            number = number.substring(0, 30);
        }
        return number;
    }

    protected DataFileAction getAction() {
        return DataFileAction.valueOf((String)this.getPageCache().get(ACTION_KEY));
    }

    static {
        STATUS_ENTITY_IDS.add("isc_export_file_trigger");
        STATUS_ENTITY_IDS.add("isc_import_file_trigger");
    }
}

