/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.file;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.dc.file.CommonPluginUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.f.DataFileAction;
import kd.isc.iscb.platform.core.dc.f.DataFileType;
import kd.isc.iscb.platform.core.dc.f.DataFileUtils;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;

public class DataFileParamPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String URL_LIST = "url_list";
    private static final String ACTION = "dataFileAction";
    private static final String TRIGGER_ID = "triggerId";
    private static final String EXECUTE_CALLBACK = "execute_callback";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (!params.isEmpty()) {
            DataFileAction action = DataFileAction.valueOf((String)D.s(params.get(ACTION)));
            if (DataFileAction.EXPORT == action) {
                DynamicObject trigger = BusinessDataServiceHelper.loadSingle(params.get(TRIGGER_ID), (String)action.getTriggerFormId());
                this.getModel().setValue("params_entryentity", (Object)DataCopyTask.createParams((DynamicObject)trigger, (DynamicObject)this.getModel().getDataEntity(), (Map)params));
                this.getView().updateView("params_entryentity");
                this.getView().setVisible(Boolean.valueOf(!this.getModel().getEntryEntity("params_entryentity").isEmpty()), new String[]{"params_pane"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"filecontainer"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"template_pane"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"params_pane"});
                if ("json".equals(D.s(params.get("type")))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"import_xlsx_pane", "import_csv_pane", "import_xls_pane"});
                } else if ("xlsx".equals(D.s(params.get("type")))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"import_json_pane", "import_csv_pane", "import_xls_pane"});
                } else if ("csv".equals(D.s(params.get("type")))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"import_xlsx_pane", "import_json_pane", "import_xls_pane"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"import_xlsx_pane", "import_csv_pane", "import_json_pane"});
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel jsonPanel = (AttachmentPanel)this.getView().getControl("import_json_pane");
        jsonPanel.addUploadListener((UploadListener)this);
        AttachmentPanel excelPanel = (AttachmentPanel)this.getView().getControl("import_xlsx_pane");
        excelPanel.addUploadListener((UploadListener)this);
        AttachmentPanel csvPanel = (AttachmentPanel)this.getView().getControl("import_csv_pane");
        csvPanel.addUploadListener((UploadListener)this);
        AttachmentPanel xlsPanel = (AttachmentPanel)this.getView().getControl("import_xls_pane");
        xlsPanel.addUploadListener((UploadListener)this);
        this.addClickListeners(new String[]{"download_template"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operationKey = operate.getOperateKey();
        if (operationKey.equalsIgnoreCase("execute")) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            DataFileAction action = DataFileAction.valueOf((String)D.s(params.get(ACTION)));
            if (!CommonPluginUtil.checkParamEntry((IFormPlugin)this, this.getModel(), this.getView())) {
                evt.setCancel(true);
                return;
            }
            if (action == DataFileAction.IMPORT) {
                String urlStr = D.s((Object)this.getPageCache().get(URL_LIST));
                if (urlStr == null || "([])".equals(urlStr)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6587\u4ef6\u6216\u8005\u7b49\u5f85\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210\u3002", (String)"DataFileParamPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List url_list = (List)Json.toObject((String)urlStr);
                if (!this.isSystemSuitable(url_list)) {
                    evt.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if (operationKey.equalsIgnoreCase("execute")) {
            this.execute();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (EXECUTE_CALLBACK.equals(evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.execute();
        }
    }

    private void execute() {
        try {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            DataFileAction action = DataFileAction.valueOf((String)D.s(params.get(ACTION)));
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle(params.get(TRIGGER_ID), (String)action.getTriggerFormId());
            DynamicObject job = DataFileUtils.createDataFileJob((DynamicObject)trigger, CommonPluginUtil.buildParamMap(this.getModel().getEntryEntity("params_entryentity")), (DataFileUtils.InitType)DataFileUtils.InitType.MANUAL, (DataFileAction)action);
            if (job == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672c%s\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u5fc5\u987b\u7ed3\u675f\u540e\u624d\u80fd\u518d\u6b21\u6267\u884c\u3002", (String)"DataFileParamPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), action.getName()), Integer.valueOf(2000));
                return;
            }
            if (action == DataFileAction.IMPORT) {
                String urlStr = D.s((Object)this.getPageCache().get(URL_LIST));
                List url_list = (List)Json.toObject((String)urlStr);
                this.uploadFiles(url_list);
                DataFileUtils.bindingAttachments((List)url_list, (Object)job.getPkValue());
            }
            action.startJob(job);
            BillShowParameter param = new BillShowParameter();
            param.setFormId(action.getJobFormId());
            param.setPkId((Object)D.s((Object)job.getPkValue()));
            param.getOpenStyle().setShowType(ShowType.InCurrentForm);
            param.setStatus(OperationStatus.VIEW);
            param.setCustomParam("disable_view_trace", (Object)Boolean.FALSE);
            param.setParentPageId(this.getView().getParentView().getPageId());
            this.getView().showForm((FormShowParameter)param);
            this.getView().close();
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e.getMessage(), ShowStackTraceUtil.getErrorMsg(e));
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            List url_list = this.getPageCache().get(URL_LIST) == null ? new ArrayList(urls.length) : (List)Json.toObject((String)this.getPageCache().get(URL_LIST));
            for (Object urlObj : urls) {
                Map map = (Map)urlObj;
                HashMap<String, String> urlMap = new HashMap<String, String>();
                urlMap.put("file_url", D.s(map.get("url")));
                urlMap.put("file_size", D.s(map.get("size")));
                urlMap.put("file_name", D.s(map.get("name")));
                urlMap.put("file_type", D.s(map.get("type")));
                url_list.add(urlMap);
            }
            this.getPageCache().put(URL_LIST, Json.toString(url_list));
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            if (this.getPageCache().get(URL_LIST) == null) {
                return;
            }
            List url_list = (List)Json.toObject((String)this.getPageCache().get(URL_LIST));
            HashSet<String> removeUrls = new HashSet<String>(urls.length);
            for (Object urlObj : urls) {
                Map map = (Map)urlObj;
                removeUrls.add(D.s(map.get("url")));
            }
            url_list.removeIf(urlMap -> removeUrls.contains(urlMap.get("file_url")));
            this.getPageCache().put(URL_LIST, Json.toString((Object)url_list));
        }
    }

    public void click(EventObject evt) {
        Map params;
        DataFileAction action;
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Label && "download_template".equals(((Label)src).getKey()) && (action = DataFileAction.valueOf((String)D.s((params = this.getView().getFormShowParameter().getCustomParams()).get(ACTION)))) == DataFileAction.IMPORT) {
            DataFileType type = DataFileType.valueOf((String)D.s(params.get("type")).toUpperCase());
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle(params.get(TRIGGER_ID), (String)action.getTriggerFormId(), (String)"id,file_schema");
            Object schemaId = trigger.get("file_schema_id");
            DynamicObject fileSchema = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)action.getFormId());
            try {
                DataFileUtils.downloadTemplate((IFormView)this.getView(), (DataFileType)type, (DynamicObject)fileSchema);
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u6a21\u677f\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"DataFileParamPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ShowStackTraceUtil.getErrorMsg(e));
            }
        }
    }

    private void uploadFiles(List<Map<String, String>> url_list) {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u4e0a\u4f20\u6587\u4ef6...", (String)"DataFileParamPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
        TempFileCache downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
        for (Map<String, String> urlMap : url_list) {
            try {
                InputStream input = downLoad.getInputStream(urlMap.get("file_url"));
                Throwable throwable = null;
                try {
                    String url = DataFileUtils.uploadFileToServer((InputStream)input, (String)urlMap.get("file_name"));
                    urlMap.put("upload_url", url);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    input.close();
                }
            }
            catch (Exception e) {
                this.getView().hideLoading();
                throw new IscBizException(ResManager.loadKDString((String)"\u5c06\u7f13\u5b58\u6587\u4ef6\u6301\u4e45\u5316\u5230\u6587\u4ef6\u670d\u52a1\u5668\u5931\u8d25", (String)"DataFileParamPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Throwable)e);
            }
        }
        this.getView().hideLoading();
    }

    private boolean isSystemSuitable(List<Map<String, String>> url_list) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        DataFileAction action = DataFileAction.valueOf((String)D.s(params.get(ACTION)));
        String type = D.s(params.get("type"));
        DynamicObject trigger = BusinessDataServiceHelper.loadSingle(params.get(TRIGGER_ID), (String)action.getTriggerFormId(), (String)"id,file_schema");
        DynamicObject fileSchema = trigger.getDynamicObject("file_schema");
        StringBuilder mes = new StringBuilder();
        for (Map<String, String> urlMap : url_list) {
            String file_url = urlMap.get("file_url");
            try {
                DataFileType.valueOf((String)type.toUpperCase()).validateFile(fileSchema.get("group_id"), file_url);
            }
            catch (Exception e) {
                mes.append(urlMap.get("file_name")).append(" \uff1a ").append(e.getMessage()).append("\r\n");
            }
        }
        if (mes.length() > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5bfc\u5165\u6587\u4ef6\u7684\u7cfb\u7edf\u7c7b\u578b\u4e0e\u6570\u636e\u6e90\u5bf9\u5e94\u8fde\u63a5\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6ce8\u610f\u53ef\u80fd\u4f7f\u5bfc\u5165\u5bf9\u8c61\u6570\u636e\u4ea7\u751f\u9519\u8bef\u6216\u5e26\u6765\u5176\u4ed6\u4e0d\u826f\u5f71\u54cd\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DataFileParamPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), mes.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(EXECUTE_CALLBACK));
            return false;
        }
        return true;
    }
}

