/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.file.e;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.dc.file.AbstractDataFileSchemaPlugin;
import kd.isc.iscb.formplugin.dc.file.CommonPluginUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;

public class ExportFileSchemaPlugin
extends AbstractDataFileSchemaPlugin
implements CellClickListener {
    private static final Map<String, String> UN_SUPPORTED_MAP = new HashMap<String, String>();
    private static final String ISC_META_PROPERTIES = "isc_meta_properties";
    private static final String SORT_ENTRIES = "sort_entries";
    private static final String SORT_FIELD = "sort_field";
    private static final String GET_SORT = "get_sort";
    private static final String SCRIPT_PANEL = "script_panel";
    private static final String SORT_PANEL = "sort_pane";
    private static final String SRC_RETRIEVE_SCRIPT = "src_retrieve_script";
    private static final String PARAMS_ENTRYENTITY = "params_entryentity";
    private static final String FILTER_VALUE_VAR = "filter_value_var";
    private static final String FILTER_ENTRY = "filter_entries";
    private static final String GET_FILTER_COL = "get_filter_col";
    private static final String FILTER_COL = "filter_column";
    private static final String FILTER_PANEL = "filter_pane";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid sort_entries = (EntryGrid)this.getView().getControl(SORT_ENTRIES);
        sort_entries.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{"edit_src_retrieve_script"});
        EntryGrid filter_entries = (EntryGrid)this.getView().getControl(FILTER_ENTRY);
        filter_entries.addCellClickListener((CellClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CommonPluginUtil.initVariableEntryCombo(this.getModel(), this.getView(), FILTER_VALUE_VAR);
        DynamicObject meta = this.getCurrentMeta();
        if (meta != null) {
            this.controlPaneVisible(meta);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("obj".equals(name) && e.getChangeSet().length > 0) {
            this.doWhileObjChanged();
        } else if ("params_name".equals(name)) {
            CommonPluginUtil.initVariableEntryCombo(this.getModel(), this.getView(), FILTER_VALUE_VAR);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        AbstractOperate operate = (AbstractOperate)e.getSource();
        String operationKey = operate.getOperateKey();
        if ("save".equals(operationKey)) {
            boolean hasRepeatField = this.hasRepeatField();
            if (hasRepeatField) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53c2\u6570\u5206\u5f55\u4e0d\u80fd\u5305\u542b\u91cd\u590d\u540d\u79f0\u3002", (String)"ExportFileSchemaPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            if (CommonPluginUtil.checkFilterEntries(this.getView(), this.getModel())) {
                e.setCancel(true);
                return;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs avt) {
        super.afterDoOperation(avt);
        String operateKey = avt.getOperateKey();
        if ("save".equals(operateKey)) {
            int index = 0;
            StringBuilder tips = new StringBuilder();
            String lostFieldTip = this.validateField();
            if (lostFieldTip != null) {
                tips.append(++index).append('.').append(lostFieldTip).append("\r\n");
            }
            if (tips.length() > 0) {
                FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u65b9\u6848\u4fdd\u5b58\u6210\u529f\uff0c\u4f46\u6709\u5982\u4e0b\u914d\u7f6e\u9879\u53ef\u80fd\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"ExportFileSchemaPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tips.toString());
            }
        }
    }

    private boolean hasRepeatField() {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(PARAMS_ENTRYENTITY);
        HashSet<String> fields = new HashSet<String>();
        for (DynamicObject field : entry) {
            String name = field.getString("params_name");
            if (fields.contains(name)) {
                return true;
            }
            fields.add(name);
        }
        return false;
    }

    private String validateField() {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue("obj_id"), (String)"isc_metadata_schema");
        DynamicObjectCollection propEntry = meta.getDynamicObjectCollection("prop_entryentity");
        HashSet<String> propSet = new HashSet<String>();
        for (DynamicObject prop : propEntry) {
            propSet.add(prop.getString("prop_name"));
        }
        DynamicObjectCollection fields = this.getModel().getEntryEntity("fields");
        StringBuilder lostFields = new StringBuilder();
        for (DynamicObject field : fields) {
            String fieldStr = field.getString("field");
            if (fieldStr.contains(".")) {
                fieldStr = fieldStr.split("\\.")[0];
            }
            if (propSet.contains(fieldStr)) continue;
            lostFields.append(field.getString("field")).append(',');
        }
        if (lostFields.length() > 0) {
            return String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5b57\u6bb5\u4e2d\u6709%s \u5728\u96c6\u6210\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"ExportFileSchemaPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), lostFields.substring(0, lostFields.lastIndexOf(",")));
        }
        return null;
    }

    @Override
    protected void controlPaneVisible(DynamicObject meta) {
        String type = D.s((Object)meta.get("type"));
        String typeName = UN_SUPPORTED_MAP.get(type);
        if (typeName != null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301%s\u7c7b\u578b\u7684\u96c6\u6210\u5bf9\u8c61\u5bfc\u51fa\u3002", (String)"ExportFileSchemaPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), typeName));
            this.getModel().setValue("obj", null);
            this.getModel().setValue("group", null);
        } else {
            if ("STRUCT".equals(type)) {
                this.loadSrcIsStructCtrlSetting();
            } else if ("QUERY".equals(type)) {
                this.loadSrcIsQueryCtrlSetting();
            } else {
                this.loadDefaultVisbleSetting();
            }
            this.getModel().setValue("group", meta.get("group_id"));
        }
    }

    private void loadSrcIsQueryCtrlSetting() {
        this.getView().setVisible(Boolean.FALSE, new String[]{SCRIPT_PANEL});
        this.getView().setVisible(Boolean.FALSE, new String[]{SORT_PANEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{FILTER_PANEL});
    }

    private void loadSrcIsStructCtrlSetting() {
        this.getView().setVisible(Boolean.TRUE, new String[]{SCRIPT_PANEL});
        this.getView().setVisible(Boolean.FALSE, new String[]{SORT_PANEL});
        this.getView().setVisible(Boolean.FALSE, new String[]{FILTER_PANEL});
    }

    private void loadDefaultVisbleSetting() {
        this.getView().setVisible(Boolean.FALSE, new String[]{SCRIPT_PANEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{SORT_PANEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{FILTER_PANEL});
    }

    @Override
    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        super.cellDoubleClick(cellClickEvent);
        String fieldKey = cellClickEvent.getFieldKey();
        long id = D.l((Object)this.getModel().getValue("obj_id"));
        if (id <= 0L) {
            return;
        }
        if (fieldKey.equals(SORT_FIELD)) {
            this.openMetaFieldsSelectForm(id, cellClickEvent.getRow(), GET_SORT);
        } else if (fieldKey.equals(FILTER_COL)) {
            this.openMetaFieldsSelectForm(id, cellClickEvent.getRow(), GET_FILTER_COL);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (PARAMS_ENTRYENTITY.equals(e.getEntryProp().getName())) {
            CommonPluginUtil.initVariableEntryCombo(this.getModel(), this.getView(), FILTER_VALUE_VAR);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (GET_SORT.equals(action)) {
            this.dealEntryCallBack(evt, SORT_ENTRIES, SORT_FIELD, "sort_field_label");
        } else if ("get_script".equals(action)) {
            this.setScript(SRC_RETRIEVE_SCRIPT, evt);
        } else if (GET_FILTER_COL.equals(action)) {
            this.dealEntryCallBack(evt, FILTER_ENTRY, FILTER_COL, "filter_label");
        }
    }

    private void dealEntryCallBack(ClosedCallBackEvent evt, String entry, String field, String lable) {
        Map map;
        int index;
        Object data = evt.getReturnData();
        if (data instanceof Map && (index = D.i((map = (Map)data).get("$row"))) >= 0) {
            this.setFieldColumnValues((Map)data, index, entry, field, lable);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Button && "edit_src_retrieve_script".equals(((Button)src).getKey())) {
            this.openScriptEditor(SRC_RETRIEVE_SCRIPT, ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u83b7\u53d6\u811a\u672c", (String)"ExportFileSchemaPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void openMetaFieldsSelectForm(long id, int row, String callback) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        param.put("$row", row);
        FormOpener.showForm(this, ISC_META_PROPERTIES, ResManager.loadKDString((String)"\u9009\u62e9\u5143\u6570\u636e\u5c5e\u6027", (String)"ExportFileSchemaPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, callback);
    }

    @Override
    protected void setReturnListValues(List<Map<String, Object>> returnData) {
        CommonPluginUtil.setReturnListValuesToFields(returnData, this.getModel(), this.getView(), null);
    }

    private void setFieldColumnValues(Map<?, ?> data, int index, String entry, String field, String label) {
        DynamicObject row = this.getModel().getEntryRowEntity(entry, index);
        row.set(field, data.get("number"));
        row.set(label, data.get("name"));
        this.getView().updateView(entry);
    }

    static {
        UN_SUPPORTED_MAP.put("SERVICE", ResManager.loadKDString((String)"\u52a0\u8f7d\u670d\u52a1", (String)"ExportFileSchemaPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        UN_SUPPORTED_MAP.put("ELEMENT", ResManager.loadKDString((String)"\u5143\u7d20", (String)"ExportFileSchemaPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }
}

