/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.file.i;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.dc.DataCopyFormPlugin;
import kd.isc.iscb.formplugin.dc.file.AbstractDataFileSchemaPlugin;
import kd.isc.iscb.formplugin.dc.file.CommonPluginUtil;
import kd.isc.iscb.util.dt.D;

public class ImportFileSchemaPlugin
extends AbstractDataFileSchemaPlugin {
    private static final String TARGET_SCRIPT = "tar_script";
    private static final Map<String, String> UN_SUPPORTED_MAP = new HashMap<String, String>();

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"edit_tar_script"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject meta = this.getCurrentMeta();
        if (meta != null) {
            this.controlPaneVisible(meta);
        }
        this.initActionCombo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        boolean affected = false;
        if ("obj".equals(propertyName) && e.getChangeSet().length > 0) {
            this.doWhileObjChanged();
            this.initActionCombo();
        } else if ("tar_action_label".equals(propertyName)) {
            affected = this.setTargetActionInfo(e);
        }
        if (affected) {
            this.getView().updateView();
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        int count;
        String key;
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save) {
            if (this.checkJudgeFields() || this.checkF7Filed()) {
                e.setCancel(true);
            }
        } else if (e.getSource() instanceof AbstractOperate && "add_target_action".equals(key = ((AbstractOperate)e.getSource()).getOperateKey()) && (count = this.getModel().getEntryRowCount("target_actions")) >= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5217\u8868\u81f3\u591a\u53ea\u80fd\u6dfb\u52a0\u4e00\u6761\u3002", (String)"ImportFileSchemaPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Button && "edit_tar_script".equals(((Button)src).getKey())) {
            this.openScriptEditor(TARGET_SCRIPT, ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5904\u7406\u811a\u672c", (String)"ImportFileSchemaPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("get_script".equals(action)) {
            this.setScript(TARGET_SCRIPT, evt);
        }
    }

    private boolean checkJudgeFields() {
        DynamicObjectCollection fields = this.getModel().getEntryEntity("fields");
        for (DynamicObject field : fields) {
            if (!field.getBoolean("is_judge_key")) continue;
            return false;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5b57\u6bb5\u7f3a\u5c11\u5019\u9009\u952e\uff01\u82e5\u5bfc\u5165\u5b57\u6bb5\u6709\u5206\u5f55\u5b57\u6bb5\uff0c\u5206\u5f55\u4e5f\u5fc5\u987b\u8bbe\u7f6e\u5019\u9009\u952e\u3002", (String)"ImportFileSchemaPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        return true;
    }

    private boolean checkF7Filed() {
        if (!"xlsx".equals(this.getModel().getValue("filetype"))) {
            return false;
        }
        DynamicObjectCollection field_entry = this.getModel().getEntryEntity("fields");
        for (int i = 0; i < field_entry.size(); ++i) {
            if (!"REF".equals(((DynamicObject)field_entry.get(i)).get("data_type"))) continue;
            String fieldTmp = D.s((Object)((DynamicObject)field_entry.get(i)).get("field"));
            for (DynamicObject dynamicObject : field_entry) {
                String field = D.s((Object)dynamicObject.get("field"));
                if (!field.startsWith(fieldTmp + ".")) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8c03\u6574\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u3010%1$s\u3011,\u9009\u62e9\u4e0b\u7ea7\u5b57\u6bb5\u3010%2$s.id\u3011", (String)"ImportFileSchemaPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), fieldTmp, fieldTmp));
                return true;
            }
        }
        return false;
    }

    @Override
    protected void controlPaneVisible(DynamicObject meta) {
        String typeName = UN_SUPPORTED_MAP.get(D.s((Object)meta.get("type")));
        if (typeName != null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301%s\u7c7b\u578b\u7684\u96c6\u6210\u5bf9\u8c61\u5bfc\u51fa\u3002", (String)"ImportFileSchemaPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), typeName));
            this.getModel().setValue("obj", null);
            this.getModel().setValue("group", null);
        } else {
            this.getView().setVisible(Boolean.valueOf("STRUCT".equals(meta.getString("type"))), new String[]{"script_panel"});
            this.getModel().setValue("group", meta.get("group_id"));
        }
    }

    @Override
    protected void setReturnListValues(List<Map<String, Object>> returnData) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("is_pk", "is_primary_key");
        properties.put("is_required", "required");
        CommonPluginUtil.setReturnListValuesToFields(returnData, this.getModel(), this.getView(), properties);
    }

    private void initActionCombo() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long target_schema_id = dataEntity.getLong("obj_id");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"isc_metadata_schema");
        if (target_schema_id > 0L) {
            DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)target_schema_id, (DynamicObjectType)entityType);
            ComboEdit tar_action_label = (ComboEdit)this.getView().getControl("tar_action_label");
            if (tar_action_label != null) {
                tar_action_label.setComboItems(DataCopyFormPlugin.getActionComboItems(schema));
            }
        }
    }

    private boolean setTargetActionInfo(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length > 0) {
            String value = (String)changeSet[0].getNewValue();
            int i = value.indexOf(47);
            changeSet[0].getDataEntity().set("tar_action_number", (Object)value.substring(0, i));
            changeSet[0].getDataEntity().set("tar_action_type", (Object)value.substring(i + 1));
            return true;
        }
        return false;
    }

    static {
        UN_SUPPORTED_MAP.put("VIEW", ResManager.loadKDString((String)"\u89c6\u56fe", (String)"ImportFileSchemaPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        UN_SUPPORTED_MAP.put("QUERY", ResManager.loadKDString((String)"\u67e5\u8be2\u670d\u52a1", (String)"ImportFileSchemaPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        UN_SUPPORTED_MAP.put("ELEMENT", ResManager.loadKDString((String)"\u5143\u7d20", (String)"ImportFileSchemaPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }
}

