/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.function;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.Button;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ScriptCommonUtil;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.Script;

public class CustomFunctionFormPlugin
extends AbstractFormPlugin {
    private static final String PATTERN = "^[a-zA-Z][a-zA-Z0-9_]*$";
    private static final String FUNCTION_ENTRIES = "function_entries";
    private static final String RESULT_ENTRIES = "result_entries";
    private static final String SCRIPT_JSP_TAG = "script_jst_tag";
    private static final String NUMBER = "number";
    private static final String SCRIPT_BTN = "script_btn";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SCRIPT_BTN});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Button && SCRIPT_BTN.equals(((Button)src).getKey())) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("remark", this.getModel().getValue("script_jst"));
            params.put("script", this.getModel().getValue(SCRIPT_JSP_TAG));
            this.setBillStatus(params);
            params.put("env", "user_defined_function");
            params.put("context_variables", this.getInnerVars());
            params.put("dynamic_tips", this.getInnerVarsTip());
            params.put("id", this.getView().getModel().getValue("id"));
            ScriptCommonUtil.showEditor(this, ResManager.loadKDString((String)"\u811a\u672c\u7f16\u8f91", (String)"CustomFunctionFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "get_script");
        }
    }

    private List<String> getInnerVars() {
        String field;
        int i;
        int paramSize = this.getView().getModel().getEntryRowCount(FUNCTION_ENTRIES);
        int resultSize = this.getView().getModel().getEntryRowCount(RESULT_ENTRIES);
        ArrayList<String> innerVars = new ArrayList<String>(paramSize + resultSize);
        for (i = 0; i < paramSize; ++i) {
            field = this.getView().getModel().getEntryRowEntity(FUNCTION_ENTRIES, i).getString("function_name");
            innerVars.add(field);
        }
        for (i = 0; i < resultSize; ++i) {
            field = this.getView().getModel().getEntryRowEntity(RESULT_ENTRIES, i).getString("result_name");
            innerVars.add(field);
        }
        return innerVars;
    }

    private List<Map<String, Object>> getInnerVarsTip() {
        String fieldDesc;
        String field;
        HashMap<String, String> tip;
        int i;
        int paramSize = this.getView().getModel().getEntryRowCount(FUNCTION_ENTRIES);
        int resultSize = this.getView().getModel().getEntryRowCount(RESULT_ENTRIES);
        ArrayList<Map<String, Object>> inneTips = new ArrayList<Map<String, Object>>(paramSize + resultSize);
        for (i = 0; i < paramSize; ++i) {
            tip = new HashMap<String, String>();
            field = this.getView().getModel().getEntryRowEntity(FUNCTION_ENTRIES, i).getString("function_name");
            fieldDesc = this.getView().getModel().getEntryRowEntity(FUNCTION_ENTRIES, i).getString("function_title");
            tip.put("title", field + " // " + fieldDesc);
            tip.put("text", field);
            inneTips.add(tip);
        }
        for (i = 0; i < resultSize; ++i) {
            tip = new HashMap();
            field = this.getView().getModel().getEntryRowEntity(RESULT_ENTRIES, i).getString("result_name");
            fieldDesc = this.getView().getModel().getEntryRowEntity(RESULT_ENTRIES, i).getString("result_title");
            tip.put("title", field + " // " + fieldDesc);
            tip.put("text", field);
            inneTips.add(tip);
        }
        return inneTips;
    }

    private void setBillStatus(HashMap<String, Object> params) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        params.put("billStatus", billShowParameter.getBillStatus());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map params;
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (action.equals("get_script") && (params = (Map)evt.getReturnData()) != null) {
            if ("new_tab".equals(params.get("operate"))) {
                String caption = (String)params.get("caption");
                String actionId = (String)params.get("actionId");
                ScriptCommonUtil.showTabEditor(this, caption, params, actionId);
            } else {
                this.getModel().setValue("script_jst", params.get("remark"));
                this.getModel().setValue(SCRIPT_JSP_TAG, params.get("script"));
                this.getView().updateView();
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save) {
            String number = String.valueOf(this.getModel().getValue(NUMBER));
            if (!number.matches(PATTERN)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51fd\u6570\u540d\u5fc5\u987b\u4ee5\u5b57\u6bcd\u5f00\u5934\uff0c\u4ec5\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf.", (String)"CustomFunctionFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String script = D.s((Object)this.getModel().getValue(SCRIPT_JSP_TAG));
            if (!this.checkScriptValid(script)) {
                e.setCancel(true);
                return;
            }
        }
    }

    private boolean checkScriptValid(String script) {
        if (ObjectUtils.isEmpty((Object)script)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u811a\u672c\u4fe1\u606f.", (String)"CustomFunctionFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            try {
                Script.compile((String)script);
                return true;
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u5185\u5bb9\u4e0d\u5408\u6cd5\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"CustomFunctionFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if (operationKey.equalsIgnoreCase("test")) {
            this.customFunctionTest(evt);
        }
    }

    private void customFunctionTest(AfterDoOperationEventArgs evt) {
        List successPkIds = evt.getOperationResult().getSuccessPkIds();
        if (successPkIds.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e.", (String)"CustomFunctionFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            QFilter qFilter = new QFilter("id", "=", successPkIds.get(0));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_custom_function", (String)"name,number,remark,function_entries.function_name,function_entries.function_title,function_entries.function_type,result_entries.result_name,result_entries.result_type", (QFilter[])new QFilter[]{qFilter});
            if (null == dynamicObject) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e.", (String)"CustomFunctionFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            String script = D.s((Object)this.getModel().getValue(SCRIPT_JSP_TAG));
            HashMap<String, Object> params = new HashMap<String, Object>(6);
            params.put("name", dynamicObject.getString("name"));
            params.put(NUMBER, dynamicObject.getString(NUMBER));
            params.put("remark", dynamicObject.getString("remark"));
            params.put("script", script);
            params.put(FUNCTION_ENTRIES, this.getFunctionEntry(dynamicObject));
            params.put(RESULT_ENTRIES, this.getResultEntries(dynamicObject));
            FormOpener.showForm(this, "isc_function_test", ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u51fd\u6570\u6d4b\u8bd5", (String)"CustomFunctionFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        }
    }

    private List<List<Object>> getFunctionEntry(DynamicObject dynamicObject) {
        DynamicObjectCollection function_entries = dynamicObject.getDynamicObjectCollection(FUNCTION_ENTRIES);
        ArrayList<List<Object>> entry = new ArrayList<List<Object>>(function_entries.size());
        for (DynamicObject dy : function_entries) {
            ArrayList<String> row = new ArrayList<String>(3);
            row.add(dy.getString("function_name"));
            row.add(dy.getString("function_title"));
            row.add(dy.getString("function_type"));
            entry.add(row);
        }
        return entry;
    }

    private Map<String, Object> getResultEntries(DynamicObject dynamicObject) {
        DynamicObjectCollection result_entries = dynamicObject.getDynamicObjectCollection(RESULT_ENTRIES);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(result_entries.size());
        for (DynamicObject dy : result_entries) {
            map.put(dy.getString("result_name"), dy.getString("result_type"));
        }
        return map;
    }

    static {
        Functions.init();
    }
}

