/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.home;

import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.util.dt.D;

public class LinkStateCardPlugin
extends AbstractFormPlugin {
    public static final String ISC_DATABASE_LINK = "isc_database_link";
    public static final String LINK_NUMBER = "link_number";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"refresh", "link_number0", "link_number1", "link_number2", "link_number3", "link_number4", "more"});
    }

    public void afterBindData(EventObject ev) {
        super.afterBindData(ev);
        this.initData();
    }

    private void initData() {
        DynamicObject[] links = BusinessDataServiceHelper.load((String)ISC_DATABASE_LINK, (String)"id,name,number,state", (QFilter[])new QFilter[0], (String)"modifytime DESC", (int)6);
        for (int i = 0; i < 5; ++i) {
            if (i < links.length) {
                DynamicObject obj = links[i];
                if ("S".equals(obj.getString("state"))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"link_suc_state" + i});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"link_error_state" + i});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"link_suc_state" + i});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"link_error_state" + i});
                }
                ((Label)this.getControl("link_name" + i)).setText(obj.getString("name") + "/");
                ((Label)this.getControl(LINK_NUMBER + i)).setText(obj.getString("number"));
                this.getPageCache().put(LINK_NUMBER + i, D.s((Object)obj.getPkValue()));
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"wrapper" + i});
        }
        if (links.length <= 5) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"more"});
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("refresh".equals(c.getKey())) {
            this.initData();
        } else if ("more".equals(c.getKey())) {
            FormOpener.openBillList(this, ISC_DATABASE_LINK, Collections.singletonList(null));
        } else if (c.getKey().startsWith(LINK_NUMBER)) {
            String num = c.getKey().substring(11);
            if (this.getPageCache().get(LINK_NUMBER + num) != null) {
                String id = this.getPageCache().get(LINK_NUMBER + num);
                DynamicObject cfg = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_DATABASE_LINK, (String)"database_type");
                String type = D.s((Object)cfg.get("database_type"));
                FormOpener.showView(this, DatabaseType.getForm((String)type), id);
            }
        }
    }
}

