/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.home;

import java.sql.Connection;
import java.util.Collections;
import java.util.EventObject;
import kd.bos.db.tx.TX;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class OverallCardPlugin
extends AbstractFormPlugin {
    private static final String STATE = "state";
    private static final String TRIGGER_TIMES = "trigger_times";
    private static final String SCHEMA_COUNT = "schema_count";
    private static final String SUCCESS_COUNT = "success_count";
    private static final String FAILED_COUNT = "failed_count";
    private static final String FAILED_LOG = "failed_log";
    private static final String REFRESH = "refresh";

    public void afterBindData(EventObject ev) {
        super.afterBindData(ev);
        this.initStatistics();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{TRIGGER_TIMES, SCHEMA_COUNT, SUCCESS_COUNT, FAILED_COUNT, FAILED_LOG, REFRESH});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        QFilter filter = null;
        switch (c.getKey()) {
            case "trigger_times": {
                FormOpener.showTreeForm(this, "isc_trigger_schema", "isc_data_copy_trigger", Collections.singletonList(filter));
                break;
            }
            case "schema_count": {
                FormOpener.showTreeForm(this, "isc_integration_schema", "isc_data_copy", Collections.singletonList(filter));
                break;
            }
            case "success_count": {
                filter = new QFilter(STATE, "=", (Object)"S");
                FormOpener.openBillList(this, "isc_data_copy_execution", Collections.singletonList(filter));
                break;
            }
            case "failed_count": {
                filter = new QFilter(STATE, "=", (Object)"F");
                FormOpener.openBillList(this, "isc_data_copy_execution", Collections.singletonList(filter));
                break;
            }
            case "failed_log": {
                filter = new QFilter(STATE, "=", (Object)"F");
                FormOpener.openBillList(this, "isc_data_copy_exec_log", Collections.singletonList(filter));
                break;
            }
            case "refresh": {
                this.initStatistics();
                break;
            }
        }
    }

    private void initStatistics() {
        Connection cn = null;
        try {
            cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
            int triggerTimes = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)"select sum(ftotal_count) from T_ISC_DATA_COPY_TRIGGER"));
            ((Label)this.getView().getControl(TRIGGER_TIMES)).setText(D.s((Object)triggerTimes));
            int schemaCount = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)"select count(*) from T_ISCB_DATA_COPY"));
            ((Label)this.getView().getControl(SCHEMA_COUNT)).setText(D.s((Object)schemaCount));
            int successCount = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)"select count(*) from T_ISC_DATA_COPY_EXECUTION where fstate = 'S'"));
            ((Label)this.getView().getControl(SUCCESS_COUNT)).setText(D.s((Object)successCount));
            int failedCount = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)"select count(*) from T_ISC_DATA_COPY_EXECUTION where fstate = 'F'"));
            ((Label)this.getView().getControl(FAILED_COUNT)).setText(D.s((Object)failedCount));
            int failedLogCount = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)"select count(*) from T_ISC_DATA_COPY_EXEC_LOG where fstate = 'F'"));
            ((Label)this.getView().getControl(FAILED_LOG)).setText(D.s((Object)failedLogCount));
        }
        catch (Exception e) {
            try {
                throw new IscBizException((Throwable)e);
            }
            catch (Throwable throwable) {
                DbUtil.close(cn, (boolean)false);
                throw throwable;
            }
        }
        DbUtil.close((Connection)cn, (boolean)false);
    }
}

