/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.home.newpage;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class FocusJobCardFormPlugin
extends AbstractFormPlugin
implements TabSelectListener,
HyperLinkClickListener {
    private static final String MORE = "more";
    private static final String DATACOPY = "datacopy";
    private static final String SERVICEFLOW = "serviceflow";
    private static final String API_INTEGRATE = "api_integrate";
    private static final String MESSAGE = "message";
    private static final String TABAP = "tabap";
    private static final String entry_dc = "entry_dc";
    private static final String entry_sf = "entry_sf";
    private static final String entry_api = "entry_api";
    private static final String entry_msg = "entry_msg";
    private static final String exec_number = "exec_number";
    private static final String flow_number = "flow_inst";
    private static final String api_number = "api_number";
    private static final String msg_number = "msg_number";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{MORE});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entry_dc);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entry_s = (EntryGrid)this.getView().getControl(entry_sf);
        entry_s.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entry_ap = (EntryGrid)this.getView().getControl(entry_api);
        entry_ap.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entry_ms = (EntryGrid)this.getView().getControl(entry_msg);
        entry_ms.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"refreshview"});
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (evt.getRowIndex() >= 0) {
            if ("trigger_number".equals(evt.getFieldName())) {
                DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry_dc);
                long id = ((DynamicObject)collection.get(evt.getRowIndex())).getLong("trigger_id");
                FormOpener.showView(this, "isc_data_copy_trigger", id);
            } else if ("flow_number".equals(evt.getFieldName())) {
                DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry_sf);
                long id = ((DynamicObject)collection.get(evt.getRowIndex())).getLong("flow_id");
                FormOpener.showView(this, "isc_service_flow", id);
            } else if ("trigger_execute_count".equals(evt.getFieldName())) {
                DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry_dc);
                long id = ((DynamicObject)collection.get(evt.getRowIndex())).getLong("trigger_id");
                FormOpener.openBillListAddAppId(this, "isc_data_copy_execution", null, Collections.singletonList(new QFilter("data_copy_trigger_id", "=", (Object)id)));
            } else if ("flow_execute_count".equals(evt.getFieldName())) {
                DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry_sf);
                long id = ((DynamicObject)collection.get(evt.getRowIndex())).getLong("flow_id");
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"isc_service_flow_r", (String)"id,flow", (QFilter[])new QFilter[]{new QFilter("flow", "=", (Object)id)});
                ArrayList<Long> ids = new ArrayList<Long>(dynamicObjects.length);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    ids.add(dynamicObject.getLong("id"));
                }
                FormOpener.openBillListAddAppId(this, "isc_sf_proc_inst", null, Collections.singletonList(new QFilter("flow_id", "in", ids)));
            } else if (api_number.equals(evt.getFieldName())) {
                DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry_api);
                String api_number = ((DynamicObject)collection.get(evt.getRowIndex())).getString(api_number);
                String type = ((DynamicObject)collection.get(evt.getRowIndex())).getString("api_type");
                String api_state = ((DynamicObject)collection.get(evt.getRowIndex())).getString("api_state");
                if (api_state.equals("0")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff0c\u7f16\u7801\u4e3a\uff1a%2$s\u7684\u5bf9\u8c61\u5df2\u5220\u9664\u3002", (String)"FocusJobCardFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getName(type), api_number));
                    return;
                }
                DynamicObject s = BusinessDataServiceHelper.loadSingle((String)type, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)api_number)});
                if (s == null) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff0c\u7f16\u7801\u4e3a\uff1a%2$s\u7684\u5bf9\u8c61\u5df2\u5220\u9664\u3002", (String)"FocusJobCardFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getName(type), api_number));
                    return;
                }
                FormOpener.showView(this, type, s.getLong("id"));
            } else if (msg_number.equals(evt.getFieldName())) {
                DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry_msg);
                String number = ((DynamicObject)collection.get(evt.getRowIndex())).getString(msg_number);
                QFilter filter = new QFilter("number", "=", (Object)number);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"isc_mq_bill_data_task", (String)"id", (QFilter[])new QFilter[]{filter});
                FormOpener.openBillAddAppId(this, "isc_mq_bill_data_task", "", dynamicObject.getPkValue(), ShowType.Modal);
            } else if ("api_invoke_count".equals(evt.getFieldName())) {
                DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry_api);
                String api_number = ((DynamicObject)collection.get(evt.getRowIndex())).getString(api_number);
                String type = ((DynamicObject)collection.get(evt.getRowIndex())).getString("api_type");
                QFilter filter = new QFilter(api_number, "=", (Object)api_number).and("api_type", "=", (Object)type);
                FormOpener.openBillListAddAppId(this, "isc_api_invoke_stat", null, Collections.singletonList(filter));
            }
        }
    }

    private String getName(String entityName) {
        String name = null;
        switch (entityName) {
            case "isc_apic_by_dc_trigger": {
                name = ResManager.loadKDString((String)"\u542f\u52a8\u65b9\u6848\u8f6cAPI", (String)"FocusJobCardFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                break;
            }
            case "isc_apic_by_dc_schema": {
                name = ResManager.loadKDString((String)"\u6570\u636e\u96c6\u6210\u65b9\u6848\u8f6cAPI", (String)"FocusJobCardFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                break;
            }
            case "isc_apic_by_vc": {
                name = ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u89c4\u5219\u8f6cAPI", (String)"FocusJobCardFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                break;
            }
            case "isc_apic_by_meta_schema": {
                name = ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u8f6cAPI", (String)"FocusJobCardFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                break;
            }
            case "isc_apic_for_external_api": {
                name = ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edfAPI\u767b\u8bb0", (String)"FocusJobCardFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                break;
            }
            case "isc_apic_mservice": {
                name = ResManager.loadKDString((String)"\u82cd\u7a79\u5fae\u670d\u52a1\u767b\u8bb0", (String)"FocusJobCardFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                break;
            }
            case "isc_apic_script": {
                name = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49API", (String)"FocusJobCardFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                break;
            }
            case "isc_apic_by_sf": {
                name = ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u8f6cAPI", (String)"FocusJobCardFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                break;
            }
            default: {
                name = entityName;
            }
        }
        return name;
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("refreshview".equals(key)) {
            this.refreshEntryPane(this.getPageCache().get("type"));
        } else if (MORE.equals(key)) {
            QFilter filter = new QFilter("state", "=", (Object)"F");
            String type = this.getPageCache().get("type");
            if (SERVICEFLOW.equals(type)) {
                FormOpener.openBillListAddAppId(this, "isc_sf_proc_inst", null, Collections.singletonList(new QFilter("state", "=", (Object)"Failed")));
            } else if (API_INTEGRATE.equals(type)) {
                FormOpener.openBillListAddAppId(this, "isc_apic_log", null, null);
            } else if (MESSAGE.equals(type)) {
                FormOpener.openBillListAddAppId(this, "isc_mq_bill_data_task", null, Collections.singletonList(filter));
            } else {
                FormOpener.openBillListAddAppId(this, "isc_data_copy_execution", null, Collections.singletonList(filter.or(new QFilter("state", "=", (Object)"P"))));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.refreshEntryPane(DATACOPY);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String subTabKey = tabSelectEvent.getTabKey();
        this.refreshEntryPane(subTabKey);
    }

    private void refreshEntryPane(String subTabKey) {
        ArrayList<Object> valuesDay = new ArrayList<Object>(2);
        ArrayList<Integer> typesDay = new ArrayList<Integer>(2);
        typesDay.add(93);
        Timestamp start_time = this.getStartTime();
        valuesDay.add(start_time);
        switch (subTabKey) {
            case "datacopy": {
                this.getPageCache().put("type", DATACOPY);
                this.refreshDataCopyEntry(valuesDay, typesDay);
                break;
            }
            case "serviceflow": {
                this.getPageCache().put("type", SERVICEFLOW);
                this.refreshServiceFlowEntry(valuesDay, typesDay);
                break;
            }
            case "api_integrate": {
                this.getPageCache().put("type", API_INTEGRATE);
                this.refreshApiEntry(valuesDay, typesDay);
                break;
            }
            case "message": {
                this.getPageCache().put("type", MESSAGE);
                this.refreshMQEntry(Collections.emptyList(), Collections.emptyList());
                break;
            }
        }
        this.refreshTimeLabel();
    }

    private void refreshTimeLabel() {
        Label label = (Label)this.getView().getControl("refreshtimelabel");
        label.setText(D.format((Date)this.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss") + "~" + D.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshServiceFlowEntry(List<Object> valuesDay, List<Integer> typesDay) {
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            String sql = "select sum(fexec_time) as exec_time,freleased_flow,count(*) as exec_count  from t_isc_sf_proc_inst  where fcreated_time>? group by freleased_flow ;  ";
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, valuesDay, typesDay);
            List<Map<String, Object>> list = this.setServiceFlowFailInfo(dataRows, cn, valuesDay, typesDay);
            this.refreshServiceFlowEntry(list);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private List<Map<String, Object>> setServiceFlowFailInfo(List<DataRow> rowList, Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select count(*) as fail_exec_count,freleased_flow  from t_isc_sf_proc_inst where  fstate='Failed' and fcreated_time>? group by freleased_flow;";
        List dataRows = DbUtil.executeList((Connection)cn, (String)sql, valuesDay, typesDay);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(rowList.size());
        for (DataRow row : rowList) {
            Map map = row.toMap();
            for (DataRow dataRow : dataRows) {
                long id = D.l((Object)dataRow.get((Object)"freleased_flow"));
                if (D.l((Object)row.get((Object)"freleased_flow")) != id) continue;
                map.put("fail_exec_count", dataRow.get((Object)"fail_exec_count"));
                break;
            }
            list.add(map);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshApiEntry(List<Object> valuesDay, List<Integer> typesDay) {
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            String sql = "select top 50 fapi_type,fapi_number,fapi_name,fapi_state,finvoke_count,ffailed_count,flast_invoke_time from t_isc_api_invoke_stat where fupdate_time>? and ffailed_count>0 order by ffailed_count desc;";
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, valuesDay, typesDay);
            this.bindDataToApiEntry(dataRows);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void bindDataToApiEntry(List<DataRow> dataRows) {
        DynamicObjectCollection entry_dc = this.getModel().getEntryEntity(entry_api);
        entry_dc.clear();
        for (DataRow dataRow : dataRows) {
            DynamicObject obj = entry_dc.addNew();
            obj.set("api_type", dataRow.get((Object)"fapi_type"));
            obj.set(api_number, dataRow.get((Object)"fapi_number"));
            obj.set("api_name", dataRow.get((Object)"fapi_name"));
            obj.set("api_state", dataRow.get((Object)"fapi_state"));
            obj.set("api_invoke_count", (Object)D.i((Object)dataRow.get((Object)"finvoke_count")));
            obj.set("api_failed_count", (Object)D.i((Object)dataRow.get((Object)"ffailed_count")));
            obj.set("dispatch_time", dataRow.get((Object)"flast_invoke_time"));
        }
        this.getModel().updateEntryCache(entry_dc);
        this.getView().updateView(entry_api);
    }

    private void refreshServiceFlowEntry(List<Map<String, Object>> dataRows) {
        HashSet<Long> ids = new HashSet<Long>(dataRows.size());
        for (Map<String, Object> dataRow : dataRows) {
            ids.add(D.l((Object)dataRow.get("freleased_flow")));
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"isc_service_flow_r", (String)"id,flow,number,name,init_mode,version", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        Map<String, DynamicObject> maxVersionObj = this.getMaxVersionFlow(dynamicObjects);
        HashMap<Long, HashMap<String, Integer>> flowMap = new HashMap<Long, HashMap<String, Integer>>();
        block1: for (Map<String, Object> map : dataRows) {
            long l = D.l((Object)map.get("freleased_flow"));
            for (DynamicObject dynamicObject : maxVersionObj.values()) {
                long released_flow = D.l((Object)dynamicObject.get("id"));
                if (l != released_flow || released_flow == 0L) continue;
                long id = D.l((Object)dynamicObject.get("flow"));
                HashMap<String, Integer> tempMap = (HashMap<String, Integer>)flowMap.get(id);
                if (tempMap == null) {
                    tempMap = new HashMap<String, Integer>(6);
                    tempMap.put("flow_id", (Integer)id);
                    tempMap.put("number", (Integer)((Object)dynamicObject.getString("number")));
                    tempMap.put("name", (Integer)((Object)dynamicObject.getString("name")));
                    tempMap.put("init_mode", (Integer)((Object)dynamicObject.getString("init_mode")));
                    flowMap.put(id, tempMap);
                }
                tempMap.put("exec_time", D.i((Object)map.get("exec_time")));
                tempMap.put("exec_count", D.i((Object)map.get("exec_count")));
                tempMap.put("fail_exec_count", D.i((Object)map.get("fail_exec_count")));
                continue block1;
            }
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(flowMap.size());
        for (Map.Entry entry : flowMap.entrySet()) {
            Map temp = (Map)entry.getValue();
            int exec_count = D.i(temp.get("exec_count"));
            if (exec_count == 0) continue;
            int exec_time = D.i(temp.get("exec_time"));
            int avg_exec_time = exec_time / exec_count;
            temp.put("avg_exec_time", avg_exec_time);
            list.add((Map<String, Object>)entry.getValue());
        }
        Map<Long, Map<String, Object>> map = this.sortFlowProcList(list);
        this.bindDataToServiceFlowEntry(map);
    }

    private Map<String, DynamicObject> getMaxVersionFlow(DynamicObject[] dynamicObjects) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String flow = D.s((Object)dynamicObject.getString("flow"));
            if (flow == null) continue;
            DynamicObject temp = (DynamicObject)map.get(flow);
            if (temp == null) {
                map.put(flow, dynamicObject);
                continue;
            }
            int v2 = D.i((Object)temp.get("version"));
            int v1 = D.i((Object)dynamicObject.get("version"));
            if (v1 <= v2) continue;
            map.put(flow, dynamicObject);
        }
        return map;
    }

    private void bindDataToServiceFlowEntry(Map<Long, Map<String, Object>> flowProcMap) {
        DynamicObjectCollection entry_sf = this.getModel().getEntryEntity(entry_sf);
        entry_sf.clear();
        for (Map.Entry<Long, Map<String, Object>> entry : flowProcMap.entrySet()) {
            DynamicObject obj = entry_sf.addNew();
            Map<String, Object> values = entry.getValue();
            obj.set("flow_id", values.get("flow_id"));
            obj.set("flow_name", values.get("number"));
            obj.set("flow_number", values.get("name"));
            obj.set("flow_type", values.get("init_mode"));
            obj.set("flow_execute_count", values.get("exec_count"));
            obj.set("flow_err_count", (Object)D.i((Object)values.get("fail_exec_count")));
            obj.set("flow_avg_time", (Object)D.i((Object)values.get("avg_exec_time")));
            obj.set("flow_desc", values.get("flow_desc"));
        }
        this.getModel().updateEntryCache(entry_sf);
        this.getView().updateView(entry_sf);
    }

    private Map<Long, Map<String, Object>> sortFlowProcList(List<Map<String, Object>> list) {
        LinkedHashMap<Long, Map<String, Object>> map = new LinkedHashMap<Long, Map<String, Object>>();
        list.sort(new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                if (D.i((Object)o2.get("fail_exec_count")) > 0 && D.i((Object)o1.get("fail_exec_count")) > 0) {
                    return D.i((Object)o2.get("fail_exec_count")) - D.i((Object)o1.get("fail_exec_count"));
                }
                if (D.i((Object)o2.get("fail_exec_count")) > 0) {
                    return 1;
                }
                if (D.i((Object)o1.get("fail_exec_count")) > 0) {
                    return -1;
                }
                if (D.i((Object)o2.get("exec_count")) > 0 && D.i((Object)o1.get("exec_count")) > 0) {
                    return D.i((Object)o2.get("exec_count")) - D.i((Object)o1.get("exec_count"));
                }
                if (D.i((Object)o2.get("exec_count")) > 0) {
                    return 1;
                }
                if (D.i((Object)o1.get("exec_count")) > 0) {
                    return -1;
                }
                return -999;
            }
        });
        for (Map<String, Object> objectMap : list) {
            long flow_id = D.l((Object)objectMap.get("flow_id"));
            StringBuilder a = new StringBuilder();
            if (D.i((Object)objectMap.get("fail_exec_count")) > 0) {
                a.append(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25%1$s\u6b21\uff0c\u8bf7\u70b9\u51fb\u6267\u884c\u6b21\u6570\u6570\u5b57\uff0c\u67e5\u770b\u6d41\u7a0b\u5b9e\u4f8b\u5206\u6790\u5931\u8d25\u539f\u56e0\u3002", (String)"FocusJobCardFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), D.i((Object)objectMap.get("fail_exec_count"))));
            }
            if (D.i((Object)objectMap.get("exec_count")) > this.getCompareExecCount() && "TIMER".equals(D.s((Object)objectMap.get("init_mode")))) {
                a.append(ResManager.loadKDString((String)"\u8c03\u7528\u9891\u7387\u9ad8\u4e8e\u5e73\u5747\u6bcf\u5c0f\u65f62\u6b21\uff0c\u4e0d\u5efa\u8bae\u8fc7\u4e8e\u9891\u7e41\u4ee5\u514d\u5360\u7528\u5176\u4ed6\u4efb\u52a1\u8d44\u6e90\uff0c\u8bf7\u68c0\u67e5\u6267\u884c\u8ba1\u5212\u914d\u7f6e\u3002", (String)"FocusJobCardFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            if (a.length() == 0) continue;
            objectMap.put("flow_desc", a);
            map.put(flow_id, objectMap);
        }
        return map;
    }

    private int getCompareExecCount() {
        return 72;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDataCopyEntry(List<Object> valuesDay, List<Integer> typesDay) {
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            this.refreshDataCopyEntry(cn, valuesDay, typesDay);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void refreshDataCopyEntry(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        Map<Long, Map<String, Object>> map = this.queryDataCopyExecInfo(cn, valuesDay, typesDay);
        this.setDataCopyExecFailInfo(map, cn, valuesDay, typesDay);
        Map<Long, Map<String, Object>> valueMap = this.calculateAvgExecTime(map);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"isc_data_copy_trigger", (String)"id,trigger_type,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", valueMap.keySet())});
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long id = D.l((Object)dynamicObject.get("id"));
            Map<String, Object> temp = valueMap.get(id);
            temp.put("trigger_type", D.s((Object)dynamicObject.getString("trigger_type")));
            temp.put("trigger_number", D.s((Object)dynamicObject.getString("number")));
            temp.put("trigger_name", D.s((Object)dynamicObject.getString("name")));
            list.add(temp);
        }
        Map<Long, Map<String, Object>> dataTriggerMap = this.sortDataCopyList(list);
        this.bindDataToDataCopyEntry(dataTriggerMap);
    }

    private void setDataCopyExecFailInfo(Map<Long, Map<String, Object>> map, Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select count(*) as num,fdata_copy_trigger  from  t_isc_data_copy_execution where fstate='F' and fmodifytime > ? group by fdata_copy_trigger";
        List dataRows = DbUtil.executeList((Connection)cn, (String)sql, valuesDay, typesDay);
        for (DataRow dataRow : dataRows) {
            long id = D.l((Object)dataRow.get((Object)"fdata_copy_trigger"));
            Map<String, Object> execMap = map.get(id);
            if (execMap == null) continue;
            execMap.put("err_count", dataRow.get((Object)"num"));
        }
    }

    private Map<Long, Map<String, Object>> queryDataCopyExecInfo(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select sum(fexecute_count) as  execute_count,sum(fexec_time) as  exec_time,sum(ftotal_count) as  total_count,fdata_copy_trigger  from   t_isc_data_copy_execution where fmodifytime > ? group by fdata_copy_trigger";
        List dataRows = DbUtil.executeList((Connection)cn, (String)sql, valuesDay, typesDay);
        HashMap<Long, Map<String, Object>> map = new HashMap<Long, Map<String, Object>>();
        for (DataRow dataRow : dataRows) {
            long id = D.l((Object)dataRow.get((Object)"fdata_copy_trigger"));
            if (id == 0L) continue;
            HashMap<String, Number> execMap = (HashMap<String, Number>)map.get(id);
            if (execMap == null) {
                execMap = new HashMap<String, Number>(6);
                execMap.put("trigger_id", id);
                map.put(id, execMap);
            }
            int executeCount = D.i(execMap.get("execute_count"));
            execMap.put("execute_count", executeCount + D.i((Object)dataRow.get((Object)"execute_count")));
            int exec_time = D.i(execMap.get("exec_time"));
            execMap.put("exec_time", exec_time + D.i((Object)dataRow.get((Object)"exec_time")));
            int total_count = D.i(execMap.get("total_count"));
            execMap.put("total_count", total_count + D.i((Object)dataRow.get((Object)"total_count")));
        }
        return map;
    }

    private Map<Long, Map<String, Object>> calculateAvgExecTime(Map<Long, Map<String, Object>> map) {
        HashMap<Long, Map<String, Object>> valueMap = new HashMap<Long, Map<String, Object>>();
        for (Map.Entry<Long, Map<String, Object>> entry : map.entrySet()) {
            Map<String, Object> temp = entry.getValue();
            int total_count = D.i((Object)temp.get("total_count"));
            if (total_count == 0) continue;
            int exec_time = D.i((Object)temp.get("exec_time"));
            int avg_exec_time = exec_time / total_count;
            temp.put("avg_exec_time", avg_exec_time);
            valueMap.put(entry.getKey(), entry.getValue());
        }
        return valueMap;
    }

    private void bindDataToDataCopyEntry(Map<Long, Map<String, Object>> dataTriggerMap) {
        DynamicObjectCollection entry_dc = this.getModel().getEntryEntity(entry_dc);
        entry_dc.clear();
        for (Map.Entry<Long, Map<String, Object>> entry : dataTriggerMap.entrySet()) {
            DynamicObject obj = entry_dc.addNew();
            Map<String, Object> values = entry.getValue();
            obj.set("trigger_id", values.get("trigger_id"));
            obj.set("trigger_number", values.get("trigger_number"));
            obj.set("trigger_name", values.get("trigger_name"));
            obj.set("trigger_type", values.get("trigger_type"));
            if (D.l((Object)values.get("avg_exec_time")) > 0L) {
                obj.set("trigger_avg_exec_time", values.get("avg_exec_time"));
            }
            obj.set("trigger_err_count", (Object)D.i((Object)values.get("err_count")));
            obj.set("trigger_execute_count", (Object)D.i((Object)values.get("execute_count")));
            obj.set("trigger_desc", values.get("trigger_desc"));
        }
        this.getModel().updateEntryCache(entry_dc);
        this.getView().updateView(entry_dc);
    }

    private Map<Long, Map<String, Object>> sortDataCopyList(List<Map<String, Object>> list) {
        LinkedHashMap<Long, Map<String, Object>> map = new LinkedHashMap<Long, Map<String, Object>>();
        list.sort(new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                int avg_exec_time2 = D.i((Object)o2.get("avg_exec_time"));
                int avg_exec_time1 = D.i((Object)o1.get("avg_exec_time"));
                if (avg_exec_time2 > 3000 && avg_exec_time1 > 3000) {
                    return avg_exec_time2 - avg_exec_time1;
                }
                if (avg_exec_time2 > 3000) {
                    return 1;
                }
                if (avg_exec_time1 > 3000) {
                    return -1;
                }
                int err_count2 = D.i((Object)o2.get("err_count"));
                int err_count1 = D.i((Object)o1.get("err_count"));
                if (err_count1 > 0 && err_count2 > 0) {
                    return err_count2 - err_count1;
                }
                if (err_count2 > 0) {
                    return 1;
                }
                if (err_count1 > 0) {
                    return -1;
                }
                int execute_count2 = D.i((Object)o2.get("execute_count"));
                int execute_count1 = D.i((Object)o1.get("execute_count"));
                if (execute_count2 > 0 && execute_count1 > 0) {
                    return execute_count2 - execute_count1;
                }
                if (execute_count2 > 0) {
                    return 1;
                }
                if (execute_count1 > 0) {
                    return -1;
                }
                return -999;
            }
        });
        for (Map<String, Object> temp : list) {
            long trigger_id = D.l((Object)temp.get("trigger_id"));
            StringBuilder a = new StringBuilder();
            if (D.i((Object)temp.get("avg_exec_time")) >= 3000) {
                a.append(ResManager.loadKDString((String)"\u5355\u884c\u6267\u884c\u5e73\u5747\u8017\u65f6\u5927\u4e8e3\u79d2\uff0c\u8bf7\u67e5\u770b\u6267\u884c\u7ed3\u679c\u5206\u6790\u8017\u65f6\u3002", (String)"FocusJobCardFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else if (D.i((Object)temp.get("err_count")) > 0) {
                a.append(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25%1$s\u6b21\uff0c\u8bf7\u70b9\u51fb\u6267\u884c\u6b21\u6570\u6570\u5b57\uff0c\u67e5\u770b\u6267\u884c\u7ed3\u679c\u5e76\u5206\u6790\u5931\u8d25\u539f\u56e0\u3002", (String)"FocusJobCardFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), D.i((Object)temp.get("err_count"))));
            } else if (D.i((Object)temp.get("execute_count")) > this.getCompareExecCount() && "auto".equals(D.s((Object)temp.get("trigger_type")))) {
                a.append(ResManager.loadKDString((String)"\u8c03\u7528\u9891\u7387\u9ad8\u4e8e\u5e73\u5747\u6bcf\u5c0f\u65f62\u6b21\uff0c\u4e0d\u5efa\u8bae\u8fc7\u4e8e\u9891\u7e41\u4ee5\u514d\u5360\u7528\u5176\u4ed6\u4efb\u52a1\u8d44\u6e90\uff0c\u8bf7\u68c0\u67e5\u6267\u884c\u8ba1\u5212\u914d\u7f6e\u3002", (String)"FocusJobCardFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            if (a.length() == 0) continue;
            temp.put("trigger_desc", a);
            map.put(trigger_id, temp);
        }
        return map;
    }

    private Timestamp getStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(11, -36);
        return D.t((Object)calendar.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshMQEntry(List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "SELECT top 50 FNUMBER,FSUBSCRIBER,FSTATE,FJUDGEFIELDS,FDATA_SOURCE,FCREATED_TIME \nFROM t_iscb_biz_execution \nwhere  FSTATE = 'F' \norder by FCREATED_TIME";
        DynamicObjectCollection entry_dc = this.getModel().getEntryEntity(entry_msg);
        entry_dc.clear();
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        List dataRows = DbUtil.executeList((Connection)cn, (String)sql, valuesDay, typesDay);
        try {
            Collection mapList;
            String number;
            ArrayList<Object> list = new ArrayList<Object>(dataRows.size());
            ArrayList<Object> dslist = new ArrayList<Object>(dataRows.size());
            LinkedHashMap tmp = new LinkedHashMap(dataRows.size());
            LinkedHashMap dsMap = new LinkedHashMap(dataRows.size());
            for (Object map : dataRows) {
                Object fsubscriber = map.get((Object)"fsubscriber");
                list.add(fsubscriber);
                List maps = (List)tmp.get(fsubscriber);
                if (maps == null) {
                    ArrayList<Map> tmplist = new ArrayList<Map>(dataRows.size());
                    tmplist.add(map.toMap());
                    tmp.put(fsubscriber, tmplist);
                } else {
                    maps.add(map.toMap());
                }
                Object fdataSource = map.get((Object)"fdata_source");
                Set ds = (Set)dsMap.get(fdataSource);
                if (ds == null) {
                    HashSet<Object> dstmp = new HashSet<Object>(dataRows.size());
                    dstmp.add(fsubscriber);
                    dsMap.put(fdataSource, dstmp);
                } else {
                    ds.add(fsubscriber);
                }
                dslist.add(fdataSource);
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"isc_mq_bill_data_sub", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", list)});
            for (DynamicObject row : dynamicObjects) {
                Object id = row.get("id");
                String name = row.getString("name");
                number = row.getString("number");
                mapList = (List)tmp.get(id);
                if (mapList == null) continue;
                for (Map map : mapList) {
                    map.put("sub_number", number);
                    map.put("sub_name", name);
                }
            }
            DynamicObjectCollection sources = QueryServiceHelper.query((String)"isc_data_source", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", dslist)});
            for (DynamicObject row : sources) {
                Object id = row.get("id");
                number = row.getString("number");
                mapList = (Set)dsMap.get(id);
                if (mapList == null) continue;
                for (Object subid : mapList) {
                    List mapList2 = (List)tmp.get(subid);
                    if (mapList2 == null) continue;
                    for (Map map : mapList2) {
                        map.put("tar_sys", number);
                    }
                }
            }
            for (Map.Entry entry : tmp.entrySet()) {
                List mapList2 = (List)entry.getValue();
                if (mapList2 == null) continue;
                for (Map map : mapList2) {
                    this.setMqEntry(entry_dc, map);
                }
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        this.getModel().getDataEntity(true).set(entry_msg, (Object)entry_dc);
        this.getModel().updateEntryCache(entry_dc);
        this.getView().updateView(entry_msg);
    }

    private void setMqEntry(DynamicObjectCollection entry_dc, Map<String, Object> map) {
        DynamicObject obj = entry_dc.addNew();
        obj.set(msg_number, map.get("fnumber"));
        obj.set("sub_number", map.get("sub_number"));
        obj.set("sub_name", map.get("sub_name"));
        obj.set("sub_state", (Object)("F".equals(map.get("fstate")) ? ResManager.loadKDString((String)"\u5931\u8d25", (String)"FocusJobCardFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6210\u529f", (String)"FocusJobCardFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
        obj.set("sub_key", map.get("fjudgefields"));
        obj.set("tar_sys", map.get("tar_sys"));
        obj.set("sub_time", map.get("fcreated_time"));
    }
}

