/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.home.newpage;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.tools.check.HealthReportData;
import kd.isc.iscb.formplugin.tools.check.HealthReportUtil;
import kd.isc.iscb.platform.core.rc.CheckItem;
import kd.isc.iscb.platform.core.rc.RiskHandler;
import kd.isc.iscb.platform.core.rc.RiskInfo;
import kd.isc.iscb.platform.core.rc.RiskItem;
import kd.isc.iscb.platform.core.rc.Util;
import kd.isc.iscb.platform.core.util.TimeUtil;
import kd.isc.iscb.util.dt.D;

public class HealthReportCardFormPlugin
extends AbstractFormPlugin {
    private static final String HIGH_RISK_TITLE = "high_risk_title";
    private static final String MEDIUM_RISK_TITLE = "medium_risk_title";
    private static final String LOW_RISK_TITLE = "low_risk_title";
    private static final String NO_RISK_TITLE = "no_risk_title";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"view_report", "refreshview"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showReportViews();
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("view_report".equals(key)) {
            FormShowParameter p = new FormShowParameter();
            p.setFormId("isc_check_item");
            p.setAppId("iscb");
            p.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(p);
        } else if ("refreshview".equals(key)) {
            this.showReportViews();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
    }

    private void showReportViews() {
        String time = D.s((Object)Util.getRecordValue((String)"checktime"));
        if (time != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap11", "flexpanelap2"});
            HealthReportData reportData = new HealthReportData();
            this.calculate(reportData);
            this.setCountLabel(reportData);
            this.drawChart(reportData);
            this.setRankTitle(reportData);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap11", "flexpanelap2"});
            this.initCountLabel();
            HealthReportData data = new HealthReportData();
            this.setRankTitle(data);
        }
        Vector label = (Vector)this.getView().getControl("refreshtimelabel");
        Tips tips = new Tips();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        tips.setContent(new LocaleString(TimeUtil.getInteTime((Date)D.t((Object)time), (SimpleDateFormat)sdf)));
        tips.setType("text");
        tips.setShowIcon(false);
        label.addTips(tips);
    }

    private void setRankTitle(HealthReportData reportData) {
        this.getView().setVisible(Boolean.FALSE, new String[]{HIGH_RISK_TITLE});
        this.getView().setVisible(Boolean.FALSE, new String[]{MEDIUM_RISK_TITLE});
        this.getView().setVisible(Boolean.FALSE, new String[]{LOW_RISK_TITLE});
        this.getView().setVisible(Boolean.FALSE, new String[]{NO_RISK_TITLE});
        this.getView().setVisible(Boolean.FALSE, new String[]{"no_report"});
        if (reportData.higNum > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{HIGH_RISK_TITLE});
        } else if (reportData.medNum > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{MEDIUM_RISK_TITLE});
        } else if (reportData.lowNum > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{LOW_RISK_TITLE});
        } else if (reportData.normalNum > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{NO_RISK_TITLE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"no_report"});
        }
    }

    private void drawChart(HealthReportData reportData) {
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        PieSeries a = pieChart.createSeries(ResManager.loadKDString((String)"\u767e\u5206\u6bd4", (String)"HealthReportCardFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        ItemValue[] itemValues = new ItemValue[6];
        itemValues[0] = new ItemValue(ResManager.loadKDString((String)"\u9ad8\u98ce\u9669", (String)"HealthReportCardFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)reportData.higNum, "#F57582");
        itemValues[1] = new ItemValue(ResManager.loadKDString((String)"\u4e2d\u98ce\u9669", (String)"HealthReportCardFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)reportData.medNum, "#FFC53D");
        itemValues[2] = new ItemValue(ResManager.loadKDString((String)"\u4f4e\u98ce\u9669", (String)"HealthReportCardFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)reportData.lowNum, "#999999");
        itemValues[3] = new ItemValue(ResManager.loadKDString((String)"\u5065\u5eb7", (String)"HealthReportCardFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)reportData.normalNum, "#26C9C3");
        itemValues[4] = new ItemValue(ResManager.loadKDString((String)"\u5173\u6ce8", (String)"HealthReportCardFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)reportData.careNum, "#40A9FF");
        if (reportData.higNum != 0) {
            a.addData(itemValues[0]);
        }
        if (reportData.medNum != 0) {
            a.addData(itemValues[1]);
        }
        if (reportData.lowNum != 0) {
            a.addData(itemValues[2]);
        }
        if (reportData.normalNum != 0) {
            a.addData(itemValues[3]);
        }
        if (reportData.careNum != 0) {
            a.addData(itemValues[4]);
        }
        if (reportData.getSum() == 0) {
            itemValues[5] = new ItemValue(ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"HealthReportCardFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)0, "#999999");
            a.addData(itemValues[5]);
        }
        Label label = new Label();
        label.setShow(false);
        label.setPosition(Position.inside);
        a.setLabel(label);
        this.setChartStyle(pieChart, a, reportData);
        pieChart.refresh();
    }

    private void setChartStyle(PieChart pieChart, PieSeries a, HealthReportData reportData) {
        pieChart.setShowTitle(true);
        pieChart.setTitleAlign(XAlign.center, YAlign.center);
        if (reportData.getSum() != 0) {
            String s = ResManager.loadKDString((String)"\u5171\u68c0\u6d4b", (String)"HealthReportCardFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\n" + String.format(ResManager.loadKDString((String)"%s\u9879", (String)"HealthReportCardFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), reportData.getSum());
            pieChart.setName(new LocaleString(s));
        } else {
            pieChart.setName(new LocaleString(""));
        }
        HashMap<String, Object> label = new HashMap<String, Object>();
        label.put("show", Boolean.TRUE);
        label.put("fontSize", 40);
        label.put("fontWeight", "bold");
        a.setPropValue("emphasis", label);
        a.setPropValue("borderRadius", (Object)10);
        HashMap<String, Object> normal = new HashMap<String, Object>();
        normal.put("borderRadius", 20);
        normal.put("borderColor", "#fff");
        normal.put("borderWidth", 2);
        HashMap<String, Serializable> itemStyle = new HashMap<String, Serializable>();
        itemStyle.put("normal", normal);
        itemStyle.put("borderRadius", Integer.valueOf(10));
        a.setPropValue("itemStyle", itemStyle);
        a.setRadius("40%", "70%");
        pieChart.setShowTooltip(true);
        pieChart.setLegendAlign(XAlign.center, YAlign.top);
        pieChart.setShowLegend(false);
    }

    private void setCountLabel(HealthReportData reportData) {
        this.initCountLabel();
        this.getModel().setValue("high_risk_num", (Object)reportData.higNum);
        this.getModel().setValue("medium_risk_num", (Object)reportData.medNum);
        this.getModel().setValue("low_risk_num", (Object)reportData.lowNum);
        this.getModel().setValue("no_risk_num", (Object)reportData.normalNum);
        this.getModel().setValue("point_num", (Object)reportData.careNum);
    }

    private void initCountLabel() {
        this.getModel().setValue("high_risk_num", (Object)0);
        this.getModel().setValue("medium_risk_num", (Object)0);
        this.getModel().setValue("low_risk_num", (Object)0);
        this.getModel().setValue("no_risk_num", (Object)0);
        this.getModel().setValue("point_num", (Object)0);
    }

    private void calculate(HealthReportData reportData) {
        Map<String, Integer> metaDataCountMap = HealthReportUtil.queryResourceTotalCount();
        Map<String, Integer> riskCountMap = HealthReportUtil.queryRiskCount();
        List<String> selectedCheckItems = HealthReportUtil.queryCheckItemNumBer();
        List checkItemList = Util.getAllCheckItems();
        for (CheckItem checkItem : checkItemList) {
            if (!selectedCheckItems.contains(checkItem.getNumber())) continue;
            this.handleCheckItem(metaDataCountMap, riskCountMap, checkItem, reportData);
        }
    }

    private void handleCheckItem(Map<String, Integer> metaDataCountMap, Map<String, Integer> riskCountMap, CheckItem checkItem, HealthReportData reportData) {
        for (RiskItem riskItem : checkItem.getRiskItemList()) {
            RiskHandler riskHandler = Util.getRiskHandler((String)riskItem.number);
            RiskInfo riskInfo = riskHandler.calcRiskInfo(D.i((Object)metaDataCountMap.get(checkItem.getEntityName().name())), D.i((Object)riskCountMap.get(riskItem.getNumber())));
            if (riskInfo.getRiskRank() == null) continue;
            this.recordRiskRankNum(riskInfo, reportData);
        }
    }

    private void recordRiskRankNum(RiskInfo riskInfo, HealthReportData reportData) {
        switch (riskInfo.getRiskRank()) {
            case Critical: {
                ++reportData.higNum;
                break;
            }
            case Warn: {
                ++reportData.medNum;
                break;
            }
            case Recommend: {
                ++reportData.lowNum;
                break;
            }
            case NoSuggestion: {
                ++reportData.careNum;
                break;
            }
            case Normal: {
                ++reportData.normalNum;
            }
        }
    }
}

