/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.home.newpage;

import java.io.Serializable;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.Tips;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.util.TimeUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class LinkInfoCardFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"refreshview"});
        Container linkinfopane = (Container)this.getView().getControl("linkinfopane");
        linkinfopane.addClickListener((ClickListener)this);
    }

    private void refreshTimeLabel() {
        Vector label = (Vector)this.getView().getControl("refreshtimelabel");
        Tips tips = new Tips();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        tips.setContent(new LocaleString(TimeUtil.getInteTime((Date)new Date(), (SimpleDateFormat)sdf)));
        tips.setType("text");
        tips.setShowIcon(false);
        label.addTips(tips);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showLinkInfoViews();
        this.refreshTimeLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showLinkInfoViews() {
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            String sql = "select  fstate, count(*) as num  from t_isc_database_link group by fstate;";
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            this.showLinkInfoViews(dataRows);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void showLinkInfoViews(List<DataRow> dataRows) {
        int successCount = 0;
        int failCount = 0;
        int unknowCount = 0;
        for (DataRow dataRow : dataRows) {
            String state = D.s((Object)dataRow.get((Object)"fstate"));
            if ("S".equals(state) || "F".equals(state)) {
                if ("S".equals(state)) {
                    successCount = D.i((Object)dataRow.get((Object)"num"));
                    continue;
                }
                failCount = D.i((Object)dataRow.get((Object)"num"));
                continue;
            }
            unknowCount = D.i((Object)dataRow.get((Object)"num"));
        }
        if (successCount == 0 && failCount == 0 && unknowCount == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"linkinfopane"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"linkinfopane"});
        }
        this.getModel().setValue("successcount", (Object)successCount);
        this.getModel().setValue("failcount", (Object)failCount);
        this.getModel().setValue("unknowcount", (Object)unknowCount);
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        PieSeries a = pieChart.createSeries(ResManager.loadKDString((String)"\u767e\u5206\u6bd4", (String)"LinkInfoCardFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        ItemValue[] itemValues = new ItemValue[]{new ItemValue(ResManager.loadKDString((String)"\u8fde\u63a5\u5f02\u5e38", (String)"LinkInfoCardFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)failCount, "#F57582"), new ItemValue(ResManager.loadKDString((String)"\u6d3b\u8dc3", (String)"LinkInfoCardFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)successCount, "#40A9FF"), new ItemValue(ResManager.loadKDString((String)"\u72b6\u6001\u672a\u77e5", (String)"LinkInfoCardFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)unknowCount, "#999999")};
        if (failCount != 0) {
            a.addData(itemValues[0]);
        }
        if (successCount != 0) {
            a.addData(itemValues[1]);
        }
        if (unknowCount != 0) {
            a.addData(itemValues[2]);
        }
        Label label = new Label();
        label.setShow(false);
        label.setPosition(Position.inside);
        a.setLabel(label);
        this.setChartStyle(pieChart, a);
        pieChart.refresh();
    }

    private void setChartStyle(PieChart pieChart, PieSeries a) {
        pieChart.setShowTitle(false);
        HashMap<String, Object> label = new HashMap<String, Object>();
        label.put("show", Boolean.TRUE);
        label.put("fontSize", 40);
        label.put("fontWeight", "bold");
        a.setPropValue("emphasis", label);
        a.setPropValue("borderRadius", (Object)10);
        HashMap<String, Object> normal = new HashMap<String, Object>();
        normal.put("borderRadius", 20);
        normal.put("borderColor", "#fff");
        normal.put("borderWidth", 2);
        HashMap<String, Serializable> itemStyle = new HashMap<String, Serializable>();
        itemStyle.put("normal", normal);
        itemStyle.put("borderRadius", Integer.valueOf(10));
        a.setPropValue("itemStyle", itemStyle);
        a.setRadius("40%", "70%");
        pieChart.setShowTooltip(true);
        pieChart.setLegendAlign(XAlign.center, YAlign.top);
        pieChart.setShowLegend(false);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("refreshview".equals(key)) {
            this.showLinkInfoViews();
            this.refreshTimeLabel();
        } else if ("linkinfopane".equals(key)) {
            FormOpener.openBillListAddAppId(this, "isc_database_link", null, null);
        }
    }
}

