/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.home.newpage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class OperatingConditionFormPlugin
extends AbstractFormPlugin {
    private static final String DATAFIELD = "datefield";
    private static final String INST_TYPE = "inst_type";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{DATAFIELD, INST_TYPE});
    }

    public void afterCreateNewData(EventObject e) {
        Control barchartap = this.getControl("barchartap");
        if (barchartap instanceof BarChart) {
            BarChart barChart = this.getBarChart((BarChart)barchartap);
            String sql = "SELECT TOP 5 FDATA_COPY_SCHAMA schemaId , count(FDATA_COPY_SCHAMA) errcount FROM t_isc_data_copy_execution where  FSTATE = 'F' group by FDATA_COPY_SCHAMA order by errcount desc;";
            this.showBarChart(barChart, sql, "isc_data_copy", ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848", (String)"OperatingConditionFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void showBarChart(BarChart barChart, String sql, String entity, String title) {
        BarSeries errSeries = barChart.createSeries(ResManager.loadKDString((String)"\u5931\u8d25\u6570\u91cfTOP5", (String)"OperatingConditionFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        Map<Object, Object> top5Map = this.getTOP5ErrCount(sql);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)entity, (String)"name,id", (QFilter[])new QFilter[]{new QFilter("id", "in", top5Map.keySet())});
        ArrayList<Pair> array = new ArrayList<Pair>();
        for (DynamicObject object : objects) {
            Object count = top5Map.remove(object.get("id"));
            if (count == null) continue;
            String name = StringUtil.trim((Object)object.get("name"), (int)15);
            array.add(new Pair((Object)D.l((Object)count), (Object)name));
        }
        Collections.sort(array, new Comparator<Pair<Long, String>>(){

            @Override
            public int compare(Pair<Long, String> a, Pair<Long, String> b) {
                return Long.compare((Long)a.getKey(), (Long)b.getKey());
            }
        });
        ArrayList<String> list = new ArrayList<String>(array.size());
        Number[] numbers = new Number[array.size()];
        int i = -1;
        for (Pair p : array) {
            list.add((String)p.getValue());
            numbers[++i] = (Number)p.getKey();
        }
        this.setChartProp(barChart, title, errSeries, list, numbers);
    }

    private void showBarChartApi(BarChart barChart, String sql, String title) {
        BarSeries errSeries = barChart.createSeries(ResManager.loadKDString((String)"\u5931\u8d25\u5b9e\u4f8bTOP5", (String)"OperatingConditionFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        Map<Object, Object> top5Map = this.getTOP5ErrCount(sql);
        Map<Object, Object> top5MapApi = this.getTOP5ApiErrType(sql);
        ArrayList<Pair> array = new ArrayList<Pair>(top5Map.size());
        for (Map.Entry<Object, Object> entry : top5Map.entrySet()) {
            Object key = entry.getKey();
            String entity = D.s((Object)top5MapApi.get(key));
            long count = D.l((Object)top5Map.get(key));
            DynamicObject object = QueryServiceHelper.queryOne((String)entity, (String)"name,id", (QFilter[])new QFilter[]{new QFilter("id", "=", key)});
            String name = StringUtil.trim((Object)object.get("name"), (int)15);
            array.add(new Pair((Object)count, (Object)name));
        }
        Collections.sort(array, new Comparator<Pair<Long, String>>(){

            @Override
            public int compare(Pair<Long, String> a, Pair<Long, String> b) {
                return Long.compare((Long)a.getKey(), (Long)b.getKey());
            }
        });
        ArrayList<String> list = new ArrayList<String>(array.size());
        Number[] numbers = new Number[array.size()];
        int i = -1;
        for (Pair p : array) {
            list.add((String)p.getValue());
            numbers[++i] = (Number)p.getKey();
        }
        this.setChartProp(barChart, title, errSeries, list, numbers);
    }

    private void setChartProp(BarChart barChart, String title, BarSeries errSeries, List<String> list, Number[] numbers) {
        Axis yAxis = barChart.createYAxis(title, list);
        HashMap<String, Serializable> showy = new HashMap<String, Serializable>(3);
        showy.put("show", Boolean.TRUE);
        HashMap<String, String> style = new HashMap<String, String>(2);
        style.put("color", "#000000");
        showy.put("lineStyle", style);
        yAxis.setPropValue("axisLine", showy);
        Axis xAxis = barChart.createXAxis(ResManager.loadKDString((String)"\u6570\u91cf/\u6761", (String)"OperatingConditionFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        HashMap<String, Boolean> show = new HashMap<String, Boolean>(2);
        show.put("show", Boolean.TRUE);
        xAxis.setPropValue("axisLine", show);
        barChart.setMargin(Position.left, "40px");
        this.setProperties(errSeries, numbers);
        barChart.refresh();
    }

    private Map<Object, Object> getTOP5ErrCount(String sql) {
        return this.getObjectMap(sql, 1);
    }

    private Map<Object, Object> getTOP5ApiErrType(String sql) {
        return this.getObjectMap(sql, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, Object> getObjectMap(String sql, int i) {
        try (DataSet ds = DB.queryDataSet((String)"Query_getErrorCount", (DBRoute)DBRoute.of((String)"iscb"), (String)sql);){
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(5);
            for (Row r : ds) {
                Object schemaId = r.get(0);
                Object errtype = r.get(i);
                map.put(schemaId, errtype);
            }
            LinkedHashMap<Object, Object> linkedHashMap = map;
            return linkedHashMap;
        }
    }

    private void setProperties(BarSeries sucSeries, Number[] sucNumbers) {
        sucSeries.setData(sucNumbers);
        sucSeries.setColor("#b3433e");
        sucSeries.setType(ChartType.bar);
        sucSeries.setStack("total");
        sucSeries.setBarWidth("16px");
        HashMap itemStyle = new HashMap(2);
        HashMap<String, Object> normal = new HashMap<String, Object>(3);
        normal.put("position", "right");
        normal.put("show", Boolean.TRUE);
        itemStyle.put("normal", normal);
        sucSeries.setPropValue("label", itemStyle);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (DATAFIELD.equals(name)) {
            Control barchartap = this.getControl("barchartap");
            if (barchartap instanceof BarChart) {
                BarChart barChart = (BarChart)barchartap;
                barChart.setMargin(Position.right, "60px");
            }
        } else if (INST_TYPE.equals(name)) {
            this.changeView(e);
        }
    }

    private void changeView(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null) {
            String newValue;
            Control barchartap = this.getControl("barchartap");
            BarChart barChart = this.getBarChart((BarChart)barchartap);
            String sql = "";
            switch (newValue = D.s((Object)changeSet[0].getNewValue())) {
                case "data_schema": {
                    sql = "SELECT TOP 5 FDATA_COPY_SCHAMA schemaId , count(FDATA_COPY_SCHAMA) errcount FROM t_isc_data_copy_execution where  FSTATE = 'F' group by FDATA_COPY_SCHAMA order by errcount desc;";
                    this.showBarChart(barChart, sql, "isc_data_copy", ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848", (String)"OperatingConditionFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "service_flow": {
                    sql = "SELECT TOP 5 T.FFLOW_ID schemaId , count(T.FFLOW_ID) errcount FROM\n  (SELECT T2.FFLOW_ID,T1.FSTATE FROM t_isc_sf_proc_inst T1\n                   RIGHT JOIN T_ISC_SERVICE_FLOW_R T2 ON T1.FRELEASED_FLOW = T2.FID) T\nwhere  T.FSTATE = 'Failed' group by T.FFLOW_ID order by errcount desc;";
                    this.showBarChart(barChart, sql, "isc_service_flow", ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b", (String)"OperatingConditionFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "api_integrate": {
                    sql = "SELECT TOP 5 fapi_ref schemaId , count(fapi_ref) errcount,FAPI_TYPE type FROM t_iscb_apic_log where  FSTATE = 'F' group by fapi_ref,FAPI_TYPE order by errcount desc;\n";
                    this.showBarChartApi(barChart, sql, "API");
                    break;
                }
                case "message": {
                    sql = "SELECT TOP 5 fsubscriber schemaId , count(fsubscriber) errcount FROM t_iscb_biz_execution where  FSTATE = 'F' group by fsubscriber order by errcount desc;";
                    this.showBarChart(barChart, sql, "isc_mq_bill_data_sub", ResManager.loadKDString((String)"\u5355\u636e\u6d88\u606f\u4efb\u52a1", (String)"OperatingConditionFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
        }
    }

    private BarChart getBarChart(BarChart barchartap) {
        barchartap.setMargin(Position.right, "60px");
        barchartap.setShowLegend(true);
        barchartap.setLegendAlign(XAlign.right, YAlign.top);
        barchartap.setShowTooltip(true);
        return barchartap;
    }
}

