/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.home.newpage;

import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.tx.TX;
import kd.bos.entity.Tips;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.util.TimeUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class ServerNumCardFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        Container pane1 = (Container)this.getView().getControl("onlineserver_pane1");
        pane1.addClickListener((ClickListener)this);
        Container pane2 = (Container)this.getView().getControl("onlineserver_pane2");
        pane2.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"refreshview"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("refreshview".equals(key)) {
            this.showServerViews();
            this.refreshTimeLabel();
        } else if ("onlineserver_pane2".equals(key) || "onlineserver_pane1".equals(key)) {
            FormOpener.openBillListAddAppId(this, "isc_server_instance", null, null);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showServerViews();
        this.refreshTimeLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showServerViews() {
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            String sql = "select fis_online,fstart_time  from t_iscb_server_instance;";
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            this.setServerView(dataRows);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void setServerView(List<DataRow> dataRows) {
        int onlineCount = 0;
        int latestHourStartCount = 0;
        long mills = System.currentTimeMillis() - 3600000L;
        for (DataRow dataRow : dataRows) {
            if (!D.x((Object)dataRow.get((Object)"fis_online"))) continue;
            ++onlineCount;
            Timestamp date = D.t((Object)dataRow.get((Object)"fstart_time"));
            if (date.getTime() - mills < 0L) continue;
            ++latestHourStartCount;
        }
        this.getModel().setValue("latest_hour_online", (Object)latestHourStartCount);
        this.getModel().setValue("total_online", (Object)onlineCount);
    }

    private void refreshTimeLabel() {
        Vector label = (Vector)this.getView().getControl("refreshtimelabel");
        Tips tips = new Tips();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        tips.setContent(new LocaleString(TimeUtil.getInteTime((Date)new Date(), (SimpleDateFormat)sdf)));
        tips.setType("text");
        tips.setShowIcon(false);
        label.addTips(tips);
    }
}

