/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.license;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.license.UpdateCloudWhiteListJob;
import kd.isc.iscb.platform.core.license.n.AccountInfo;
import kd.isc.iscb.platform.core.license.n.GroupCategory;
import kd.isc.iscb.platform.core.license.n.GroupInfo;
import kd.isc.iscb.platform.core.license.n.TenantInfo;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class IscLicenseInfoFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String RED = "red";
    private static final String GREEN = "green";
    private static final String FREE_COUNT = "free_count";
    private static final String DISABLED_COUNT = "disabled_count";
    private static final String ENABLED_COUNT = "enabled_count";
    private static final String CONNECTION_COUNT = "connection_count";
    private static final String LICENSE_USED_COUNT = "license_used_count";
    private static final String ACCOUNT_NAME = "account_name";
    private static final String ACCOUNT_ID = "account_id";
    private static final String LICENSE_CATAGORY = "license_catagory";
    private static final String LICENSE_USED_COUNT_SUB = "license_used_count_sub";
    private static final String FREE_COUNT_SUB = "free_count_sub";
    private static final String DISABLED_COUNT_SUB = "disabled_count_sub";
    private static final String ENABLED_COUNT_SUB = "enabled_count_sub";
    private static final String CONNECTION_COUNT_SUB = "connection_count_sub";
    private static final String ENTRY_ENTITY = "entryentity";
    private int connection_count;
    private int enabled_count;
    private int disabled_count;
    private int free_count;
    private int license_used_count;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showLicenseList();
    }

    private void showLicenseList() {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        TenantInfo tenantLicenseInfo = IscLicenseUtil.getTenantLicenseInfo();
        this.showBaseInfo(tenantLicenseInfo);
        boolean flag = true;
        Map accounts = tenantLicenseInfo.getAccounts();
        HashMap<String, Integer> coutnMap = new HashMap<String, Integer>();
        ArrayList<String> treeNodeFilterList = new ArrayList<String>(accounts.size());
        for (AccountInfo licenseInfo : accounts.values()) {
            String accountId = licenseInfo.getAccountId();
            if (treeNodeFilterList.contains(accountId)) continue;
            treeNodeFilterList.add(accountId);
            Map groups = licenseInfo.getGroups();
            coutnMap.put(CONNECTION_COUNT_SUB, 0);
            coutnMap.put(ENABLED_COUNT_SUB, 0);
            coutnMap.put(DISABLED_COUNT_SUB, 0);
            coutnMap.put(FREE_COUNT_SUB, 0);
            coutnMap.put(LICENSE_USED_COUNT_SUB, 0);
            for (Map.Entry entry : groups.entrySet()) {
                GroupInfo value = (GroupInfo)entry.getValue();
                if (flag) {
                    DynamicObject object = entries.addNew();
                    this.setEntryValues(value, object, coutnMap);
                    EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
                    grid.setRowBackcolor("#eff3fd", new int[]{0});
                    flag = false;
                    continue;
                }
                DynamicObject row = entries.addNew();
                this.setEntryValues(value, row, coutnMap);
            }
        }
        String expiredDate = tenantLicenseInfo.getExpiredDate();
        this.mergeEntry(entries);
        this.setFontColor(entries, expiredDate);
        this.addTotalEntry(tenantLicenseInfo, entries);
        this.getView().updateView(ENTRY_ENTITY);
        if (tenantLicenseInfo.getTotalLicenseCount() == 0) {
            this.getView().showTipNotification(IscLicenseInfoFormPlugin.getZeroLicenseTips());
        }
    }

    private void mergeEntry(DynamicObjectCollection entries) {
        ArrayList<String> accountNameList = new ArrayList<String>(entries.size());
        for (DynamicObject entry : entries) {
            String string = entry.getString(ACCOUNT_NAME);
            if (StringUtil.isEmpty((String)string) || !accountNameList.contains(string)) {
                accountNameList.add(string);
                continue;
            }
            entry.set(ACCOUNT_NAME, (Object)"");
        }
    }

    private void addTotalEntry(TenantInfo tenantLicenseInfo, DynamicObjectCollection entries) {
        DynamicObject totalEntry = entries.addNew();
        totalEntry.set(ACCOUNT_NAME, (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"IscLicenseInfoFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        totalEntry.set(LICENSE_USED_COUNT, (Object)this.license_used_count);
        totalEntry.set(CONNECTION_COUNT, (Object)this.connection_count);
        totalEntry.set(ENABLED_COUNT, (Object)this.enabled_count);
        totalEntry.set(DISABLED_COUNT, (Object)this.disabled_count);
        totalEntry.set(FREE_COUNT, (Object)this.free_count);
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>();
        long daysBetween = this.getDaysBetween(tenantLicenseInfo.getExpiredDate());
        CellStyle cellStyle = new CellStyle();
        cellStyle.setRow(entries.size() - 1);
        cellStyle.setFieldKey(ENABLED_COUNT);
        if (daysBetween >= 0L) {
            cellStyle.setForeColor(GREEN);
        } else {
            cellStyle.setForeColor(RED);
        }
        styles.add(cellStyle);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.setCellStyle(styles);
    }

    private void setEntryValues(GroupInfo groupInfo, DynamicObject row, HashMap<String, Integer> coutnMap) {
        String category = this.getCatagoryName(groupInfo);
        String accountIdStr = groupInfo.getAccount().getAccountId();
        row.set(ACCOUNT_ID, (Object)accountIdStr);
        row.set(ACCOUNT_NAME, (Object)groupInfo.getAccount().getAccountName());
        row.set(LICENSE_CATAGORY, (Object)category);
        int usedCount = groupInfo.getUsedLicenseCount();
        int connectionCount = groupInfo.getConnectionCount();
        int withCount = groupInfo.getWithLicenseConnectionCount();
        int withoutCount = groupInfo.getWithoutLicenseConnectionCount();
        int freeCount = groupInfo.getFreeConnectionCount();
        row.set(LICENSE_USED_COUNT, (Object)usedCount);
        row.set(CONNECTION_COUNT, (Object)connectionCount);
        row.set(ENABLED_COUNT, (Object)withCount);
        row.set(DISABLED_COUNT, (Object)withoutCount);
        row.set(FREE_COUNT, (Object)freeCount);
        this.license_used_count += usedCount;
        this.connection_count += connectionCount;
        this.enabled_count += withCount;
        this.disabled_count += withoutCount;
        this.free_count += freeCount;
        coutnMap.put(CONNECTION_COUNT_SUB, coutnMap.get(CONNECTION_COUNT_SUB) + connectionCount);
        coutnMap.put(ENABLED_COUNT_SUB, coutnMap.get(ENABLED_COUNT_SUB) + withCount);
        coutnMap.put(DISABLED_COUNT_SUB, coutnMap.get(DISABLED_COUNT_SUB) + withoutCount);
        coutnMap.put(FREE_COUNT_SUB, coutnMap.get(FREE_COUNT_SUB) + freeCount);
        coutnMap.put(LICENSE_USED_COUNT_SUB, coutnMap.get(LICENSE_USED_COUNT_SUB) + usedCount);
    }

    private String getCatagoryName(GroupInfo groupInfo) {
        return groupInfo.getCategory().name();
    }

    private void showBaseInfo(TenantInfo licInfo) {
        this.getModel().setValue("group_number", (Object)licInfo.getGroupNumber());
        this.getModel().setValue("group_name", (Object)licInfo.getGroupName());
        this.getModel().setValue("price_mode", (Object)licInfo.getCalcType());
        this.getModel().setValue("file_type", (Object)(D.s((Object)licInfo.getFileType()) == null ? "-" : licInfo.getFileType()));
        this.getModel().setValue("domain", (Object)licInfo.getRegion());
        this.getModel().setValue("total_count", (Object)licInfo.getTotalLicenseCount());
        this.getModel().setValue("used_count", (Object)licInfo.getUsedLicenseCount());
        this.getModel().setValue("unused_count", (Object)licInfo.getUnusedLicenseCount());
        this.getModel().setValue("expired_date", (Object)licInfo.getExpiredDate());
        this.getModel().setValue("license_version", (Object)licInfo.getLicenseVersion());
        this.getModel().setValue("iscx_enabled_n", (Object)licInfo.iscxEnabled());
        this.getModel().setValue("iscb_enabled_n", (Object)licInfo.iscbEnabled());
        this.setFieldForeColor("iscx_enabled_n", licInfo.iscxEnabled() ? GREEN : RED);
        this.setFieldForeColor("iscb_enabled_n", licInfo.iscbEnabled() ? GREEN : RED);
        this.getModel().setValue("link_license", (Object)(licInfo.getUnusedLicenseCount() + "/" + licInfo.getTotalLicenseCount()));
        this.getView().setVisible(Boolean.valueOf(licInfo.getLicenseMode() == 3 && licInfo.getLicenseMainVersion() == 7), new String[]{"flex_iscb_enabled"});
        this.judgeLicense(licInfo.getExpiredDate());
    }

    private void setFieldForeColor(String field, String color) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("fc", color);
        this.getView().updateControlMetadata(field, fieldMap);
    }

    public void judgeLicense(String expiredDate) {
        long daysBetween;
        if (D.getDateFormat((String)expiredDate).equals("yyyy-MM-dd")) {
            expiredDate = expiredDate + " 23:59:59";
        }
        if ((daysBetween = this.getDaysBetween(expiredDate)) <= 30L) {
            if (daysBetween >= 0L) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u7684\u8bb8\u53ef\u8fd8\u6709%s\u5929\u5230\u671f\uff0c\u8bf7\u5c3d\u5feb\u7eed\u8d39\u3002", (String)"IscLicenseInfoFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), daysBetween));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u7684\u8bb8\u53ef\u5df2\u5230\u671f\uff0c\u5df2\u4e0d\u80fd\u4f7f\u7528\u96c6\u6210\u670d\u52a1\u4e91\uff0c\u8bf7\u53ca\u65f6\u8d2d\u4e70\u3002", (String)"IscLicenseInfoFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private long getDaysBetween(String expiredDate) {
        return (D.t((Object)expiredDate).getTime() - System.currentTimeMillis()) / 86400000L;
    }

    private void setFontColor(DynamicObjectCollection entries, String expiredDate) {
        ArrayList<CellStyle> styles = new ArrayList<CellStyle>(entries.size());
        long daysBetween = this.getDaysBetween(expiredDate);
        for (int i = 0; i < entries.size(); ++i) {
            CellStyle cellStyle = new CellStyle();
            cellStyle.setRow(i);
            cellStyle.setFieldKey(ENABLED_COUNT);
            if (daysBetween >= 0L) {
                cellStyle.setForeColor(GREEN);
            } else {
                cellStyle.setForeColor(RED);
            }
            styles.add(cellStyle);
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        grid.setCellStyle(styles);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        final IscLicenseInfoFormPlugin view = this;
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent event) {
                event.getRowIndex();
                Object id = ((BillListHyperLinkClickEvent)event).getCurrentRow().getPrimaryKeyValue();
                FormOpener.openBillAddAppId(view, "isc_white_list", null, id, ShowType.Modal);
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if ("refresh".equals(operationKey)) {
            IscLicenseUtil.refreshCache();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.showLicenseList();
        } else if ("syn_license".equals(operationKey)) {
            IscLicenseUtil.refreshCache();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u53d1\u8d77\u540c\u6b65\u5e73\u53f0\u8bb8\u53ef\u6570\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u8bb8\u53ef\u4fe1\u606f", (String)"IscLicenseInfoFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if ("update_white_list".equals(operationKey)) {
            this.updateWhiteList();
        } else if ("view_more".equals(operationKey)) {
            FormOpener.openBillList(this, "isc_white_list", null, "");
        } else if ("view_res_license".equals(operationKey)) {
            FormOpener.showList(this, "isc_lic_resource", null);
        } else if ("res_license_detail".equals(operationKey)) {
            FormOpener.showTabForm(this, "isc_resource_license", null, null, null);
        }
    }

    private void updateWhiteList() {
        UpdateCloudWhiteListJob updateJob = new UpdateCloudWhiteListJob(ResManager.loadKDString((String)"\u66f4\u65b0\u4e91\u7aef\u767d\u540d\u5355", (String)"IscWhiteListListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Json.toString(Collections.emptyMap()));
        List jobs = JobEngine.getJobsWithOwnerId((long)updateJob.getOwnerId());
        if (jobs.isEmpty()) {
            FormOpener.startJob(this, (Job)updateJob, "update_white_list");
        } else {
            FormOpener.reopenJob(this, ((JobInfo)jobs.get(0)).getId(), updateJob.getTitle(), "update_white_list");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (CONNECTION_COUNT.equals(evt.getFieldName()) && evt.getRowIndex() >= 0) {
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            String acId = ((DynamicObject)collection.get(evt.getRowIndex())).getString(ACCOUNT_ID);
            String licenseCatagory = ((DynamicObject)collection.get(evt.getRowIndex())).getString(LICENSE_CATAGORY);
            HashMap<String, Object> params = new HashMap<String, Object>();
            StringBuilder catagorysb = new StringBuilder(collection.size());
            StringBuilder accountsb = new StringBuilder(collection.size());
            for (DynamicObject doc : collection) {
                String accountId = doc.getString(ACCOUNT_ID);
                String catagory = doc.getString(LICENSE_CATAGORY);
                if (StringUtil.isEmpty((String)catagory)) continue;
                String cg = "";
                cg = catagory.equals("TOTAL") ? GroupCategory.BIZ_OTHER.name() : GroupCategory.valueOf((String)catagory).name();
                if (!catagorysb.toString().contains(cg)) {
                    catagorysb.append(cg).append(',');
                }
                if (accountsb.toString().contains(accountId)) continue;
                accountsb.append(accountId).append(',');
            }
            params.put("acId", acId);
            params.put("licenseCatagory", licenseCatagory == null || licenseCatagory.equals("TOTAL") ? "" : licenseCatagory);
            params.put("accountId", accountsb.toString());
            params.put(LICENSE_CATAGORY, catagorysb.toString());
            FormOpener.showForm(this, "isc_license_schema", ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u8be6\u60c5", (String)"IscLicenseInfoFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
        }
    }

    private static String getZeroLicenseTips() {
        return ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5e73\u53f0\u8fd4\u56de\u7684\u96c6\u6210\u670d\u52a1\u4e91\u5206\u7ec4\u8bb8\u53ef\u6570\u91cf\u4e3a0\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u670d\u52a1\u4e91-\u5b89\u5168\u7ba1\u7406-\u8bb8\u53ef\u7ba1\u7406-\u8bb8\u53ef\u5206\u914d\u7528\u6237\u5217\u8868\u9875\u70b9\u51fb\u66f4\u65b0\u8bb8\u53ef\uff0c\u5728\u8bb8\u53ef\u5206\u7ec4\u660e\u7ec6\u5217\u8868\u9875\u786e\u8ba4\u6709\u96c6\u6210\u670d\u52a1\u4e91\u5206\u7ec4\u7684\u8bb8\u53ef\u6570\u91cf\u540e\uff0c\u518d\u70b9\u51fb\u96c6\u6210\u7ba1\u7406-\u76d1\u63a7\u7edf\u8ba1-\u8bb8\u53ef\u4fe1\u606f\u9875\u9762\u7684\u540c\u6b65\u8bb8\u53ef\u6309\u94ae", (String)"IscLicenseInfoFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }
}

