/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.mapping;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.IDService;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.mapping.AutoMapProcess;
import kd.isc.iscb.platform.core.mapping.bean.FieldMappingItem;
import kd.isc.iscb.platform.core.mapping.bean.PropertyModel;
import kd.isc.iscb.platform.core.mapping.util.PropertyUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class AutoMappingFormPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String SOURCE_SCHEMA = "source_schema";
    private static final String SOURCE_SCHEMA_ID = "source_schema_id";
    private static final String TARGET_SCHEMA = "target_schema";
    private static final String TARGET_SCHEMA_ID = "target_schema_id";
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String MAPPING_ENTRIES = "mapping_entries";
    private static final String MAPPING_TAR_COLUMN = "mapping_tar_column";
    private static final String TAR_DESC = "tar_desc";
    private static final String MAPPING_SRC_COLUMN = "mapping_src_column";
    private static final String SRC_DESC = "src_desc";
    private static final String SIMILAR = "similar";
    private static final String TAR_MODEL = "tar_model";
    private static final String SRC_MODEL = "src_model";
    private static final String TAR_IS_ENTRY = "tar_is_entry";
    private static final String SRC_IS_ENTRY = "src_is_entry";
    private static final String TAR_COLUMN = "tar_column";
    private static final String TAR_LABEL = "tar_label";
    private static final String SRC_COLUMN = "src_column";
    private static final String SRC_LABEL = "src_label";
    private static final String ALGORITHM = "algorithm";
    private static final String RATIO = "ratio";
    private static final String DATA_SOURCE = "data_source";
    private static final String DATA_TARGET = "data_target";
    private static final String DATA_SOURCE_ID = "data_source_id";
    private static final String DATA_TARGET_ID = "data_target_id";
    private static final String SRC_DETAILED_LABEL = "src_detailed_label";
    private static final String TAR_DETAILED_LABEL = "tar_detailed_label";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue(SOURCE_SCHEMA, (Object)D.l(params.get(SOURCE_SCHEMA_ID)));
        this.getModel().setValue(TARGET_SCHEMA, (Object)D.l(params.get(TARGET_SCHEMA_ID)));
        this.getModel().setValue(DATA_SOURCE, (Object)D.l(params.get(DATA_SOURCE_ID)));
        this.getModel().setValue(DATA_TARGET, (Object)D.l(params.get(DATA_TARGET_ID)));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid mappingEntries = (EntryGrid)this.getView().getControl(MAPPING_ENTRIES);
        mappingEntries.addCellClickListener((CellClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propertyName = property.getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ((SRC_COLUMN.equals(propertyName) || TAR_COLUMN.equals(propertyName)) && changeSet.length == 1) {
            this.innerHandleChange(propertyName, changeSet[0]);
        }
    }

    private void innerHandleChange(String propertyName, ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        DynamicObject row = this.getModel().getEntryRowEntity(MAPPING_ENTRIES, rowIndex);
        if (D.s((Object)changeData.getNewValue()) == null) {
            this.clearColumn(propertyName, row);
        } else {
            this.resetFullname(propertyName, rowIndex, row);
        }
    }

    private void resetFullname(String propertyName, int rowIndex, DynamicObject row) {
        if (SRC_COLUMN.equals(propertyName)) {
            this.resetSrcColumns(row.getString(SRC_COLUMN), row.getString(SRC_COLUMN), "UNKNOWN", "", rowIndex, row);
        } else if (TAR_COLUMN.equals(propertyName)) {
            this.resetTarColumns(row.getString(TAR_COLUMN), row.getString(TAR_COLUMN), "UNKNOWN", "", rowIndex, row);
        }
        this.getView().updateView(MAPPING_ENTRIES);
    }

    private void clearColumn(String propertyName, DynamicObject row) {
        if (SRC_COLUMN.equals(propertyName)) {
            this.clearSrcColumns(row);
        } else if (TAR_COLUMN.equals(propertyName)) {
            this.clearTarColumns(row);
        }
        this.getView().updateView(MAPPING_ENTRIES);
    }

    private void clearTarColumns(DynamicObject row) {
        row.set(TAR_DESC, (Object)"");
        row.set(TAR_LABEL, (Object)"");
        row.set(TAR_DETAILED_LABEL, (Object)"");
        row.set(TAR_IS_ENTRY, (Object)Boolean.FALSE);
        row.set(TAR_MODEL, null);
        row.set(SIMILAR, null);
    }

    private void clearSrcColumns(DynamicObject row) {
        row.set(SRC_DESC, (Object)"");
        row.set(SRC_LABEL, (Object)"");
        row.set(SRC_DETAILED_LABEL, (Object)"");
        row.set(SRC_IS_ENTRY, (Object)Boolean.FALSE);
        row.set(SRC_MODEL, null);
        row.set(SIMILAR, null);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        try {
            if ("auto_map".equals(args.getOperateKey())) {
                this.autoMap();
            } else if ("write_mapping".equals(args.getOperateKey())) {
                this.getView().returnDataToParent(this.getModel().getValue(MAPPING_ENTRIES));
                this.getView().close();
            } else if ("deleteentry".equals(args.getOperateKey())) {
                this.resetIsGroupAfterDeleteEntry();
            }
        }
        catch (Throwable e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void resetIsGroupAfterDeleteEntry() {
        DynamicObjectCollection mappingEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection(MAPPING_ENTRIES);
        Set<Long> groupNodeIds = this.findGroupIds(mappingEntries);
        this.resetIsGroupAttr(mappingEntries, groupNodeIds);
        this.getView().updateView(MAPPING_ENTRIES);
    }

    private void resetIsGroupAttr(DynamicObjectCollection mappingEntries, Set<Long> groupNodeIds) {
        for (DynamicObject mappingEntry : mappingEntries) {
            if (!this.isGroupAndHaveNoChildNow(groupNodeIds, mappingEntry)) continue;
            mappingEntry.set("isGroupNode", (Object)Boolean.FALSE);
        }
    }

    private boolean isGroupAndHaveNoChildNow(Set<Long> groupNodeIds, DynamicObject mappingEntry) {
        return mappingEntry.getBoolean("isGroupNode") && !groupNodeIds.contains(mappingEntry.getLong("id"));
    }

    private Set<Long> findGroupIds(DynamicObjectCollection mappingEntries) {
        HashSet<Long> groupNodeIds = new HashSet<Long>(mappingEntries.size());
        for (DynamicObject mappingEntry : mappingEntries) {
            long pid = mappingEntry.getLong("pid");
            if (pid <= 0L) continue;
            groupNodeIds.add(pid);
        }
        return groupNodeIds;
    }

    private void autoMap() {
        long sourceSchemaId = D.l((Object)this.getModel().getValue(SOURCE_SCHEMA_ID));
        long targetSchemaId = D.l((Object)this.getModel().getValue(TARGET_SCHEMA_ID));
        String algorithm = D.s((Object)this.getModel().getValue(ALGORITHM));
        String s = D.s((Object)this.getModel().getValue(RATIO));
        double ratio = s == null ? 0.5 : Double.parseDouble(s);
        DynamicObjectCollection mappingEntries = this.initMappingEntries(sourceSchemaId, targetSchemaId, algorithm, ratio);
        this.getModel().setValue(MAPPING_ENTRIES, (Object)mappingEntries);
        this.getView().updateView(MAPPING_ENTRIES);
    }

    private DynamicObjectCollection initMappingEntries(long sourceSchemaId, long targetSchemaId, String algorithm, double ratio) {
        List mappingItems = new AutoMapProcess(sourceSchemaId, targetSchemaId, algorithm, ratio).handle();
        DynamicObjectCollection mappingEntries = this.getModel().getDataEntity().getDynamicObjectCollection(MAPPING_ENTRIES);
        mappingEntries.clear();
        this.addEntry(0L, mappingEntries, mappingItems);
        return mappingEntries;
    }

    private void addEntry(long parentId, DynamicObjectCollection mappingEntries, List<FieldMappingItem> mappingItems) {
        for (FieldMappingItem mappingItem : mappingItems) {
            PropertyModel tarProp = mappingItem.getTarProp();
            if (tarProp.isPrimaryKey() && "ENTITY".equals(tarProp.getMetaType()) || tarProp.isAttachmentField()) continue;
            this.newEntry(parentId, mappingEntries, mappingItem, tarProp);
        }
    }

    private void newEntry(long parentId, DynamicObjectCollection mappingEntries, FieldMappingItem mappingItem, PropertyModel tarProp) {
        List childMappingItems;
        DynamicObject entry = mappingEntries.addNew();
        long id = IDService.get().genLongId();
        entry.set("id", (Object)id);
        entry.set("pid", (Object)parentId);
        this.setTarColumnsFromProp(tarProp, entry);
        PropertyModel srcProp = mappingItem.getSrcProp();
        if (srcProp != null) {
            this.setSrcColumnsFromProp(mappingItem, entry, srcProp);
        }
        if ((childMappingItems = mappingItem.getChildMappingItems()) != null) {
            this.addEntry(id, mappingEntries, childMappingItems);
        }
    }

    private void setTarColumnsFromProp(PropertyModel tarProp, DynamicObject entry) {
        entry.set(TAR_COLUMN, (Object)tarProp.getName());
        entry.set(TAR_LABEL, (Object)tarProp.getLabel());
        entry.set(MAPPING_TAR_COLUMN, (Object)tarProp.getFullname());
        entry.set(TAR_DESC, (Object)tarProp.getDetailedDesc());
        entry.set(TAR_MODEL, (Object)tarProp.getMetaId());
        entry.set(TAR_IS_ENTRY, (Object)tarProp.isEntry());
        entry.set(TAR_DETAILED_LABEL, (Object)tarProp.getDetailedLabel());
    }

    private void setSrcColumnsFromProp(FieldMappingItem mappingItem, DynamicObject entry, PropertyModel srcProp) {
        entry.set(SRC_COLUMN, (Object)srcProp.getName());
        entry.set(SRC_LABEL, (Object)srcProp.getLabel());
        entry.set(SRC_DETAILED_LABEL, (Object)srcProp.getDetailedLabel());
        entry.set(MAPPING_SRC_COLUMN, (Object)srcProp.getFullname());
        entry.set(SRC_DESC, (Object)srcProp.getDetailedDesc());
        entry.set(SRC_MODEL, (Object)srcProp.getMetaId());
        entry.set(SRC_IS_ENTRY, (Object)srcProp.isEntry());
        entry.set(SIMILAR, (Object)mappingItem.getSimilar());
    }

    public void cellClick(CellClickEvent evt) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
        String fieldKey = evt.getFieldKey();
        if (TAR_COLUMN.equals(fieldKey) || SRC_COLUMN.equals(fieldKey)) {
            this.selectField(evt, fieldKey);
        }
    }

    private void selectField(CellClickEvent evt, String fieldKey) {
        long srcMetaId;
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(MAPPING_ENTRIES);
        int row = evt.getRow();
        if (TAR_COLUMN.equals(fieldKey)) {
            long tarMetaId = this.getMetaId(entries, row, TARGET_SCHEMA_ID, TAR_MODEL);
            if (tarMetaId > 0L) {
                this.selectTarField(row, tarMetaId);
            }
        } else if (SRC_COLUMN.equals(fieldKey) && (srcMetaId = this.getMetaId(entries, row, SOURCE_SCHEMA_ID, SRC_MODEL)) > 0L) {
            this.selectSrcField(row, srcMetaId);
        }
    }

    private long getMetaId(DynamicObjectCollection entries, int row, String schemaField, String entrySchemaField) {
        long metaId = D.l((Object)this.getModel().getValue(schemaField));
        DynamicObject currentEntry = (DynamicObject)entries.get(row);
        long pid = currentEntry.getLong("pid");
        if (pid > 0L) {
            metaId = this.getMetaId(entries, entrySchemaField, metaId, pid);
        }
        return metaId;
    }

    private long getMetaId(DynamicObjectCollection entries, String entrySchemaField, long metaId, long pid) {
        for (DynamicObject entry : entries) {
            if (pid != entry.getLong("id")) continue;
            metaId = entry.getLong(entrySchemaField);
        }
        return metaId;
    }

    private void selectSrcField(int row, long srcMetaId) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("id", srcMetaId);
        param.put("$type", "src");
        param.put("$row", row);
        param.put("$group_id", this.getModel().getValue(DATA_SOURCE_ID));
        FormOpener.showForm(this, "isc_meta_property_tree", ResManager.loadKDString((String)"\u9009\u62e9\u6e90\u5bf9\u8c61\u5c5e\u6027", (String)"AutoMappingFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "set_property");
    }

    private void selectTarField(int row, long tarMetaId) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("id", tarMetaId);
        param.put("$type", "tar");
        param.put("$row", row);
        param.put("$group_id", this.getModel().getValue(DATA_TARGET_ID));
        FormOpener.showForm(this, "isc_meta_property_tree", ResManager.loadKDString((String)"\u9009\u62e9\u76ee\u6807\u5bf9\u8c61\u5c5e\u6027", (String)"AutoMappingFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "set_property");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("set_property".equals(action)) {
            try {
                this.setProp(evt);
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    private void setProp(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData instanceof Map) {
            this.updateRow((Map)returnData);
        }
    }

    private void updateRow(Map<String, Object> data) {
        Object rowValue = data.get("$row");
        if (rowValue != null) {
            int index = D.i((Object)rowValue);
            DynamicObject row = this.getModel().getEntryRowEntity(MAPPING_ENTRIES, index);
            String type = D.s((Object)data.get("$type"));
            if ("src".equals(type)) {
                this.handleSrcPropChange(data, index, row);
            } else if ("tar".equals(type)) {
                this.handleTarPropChange(data, index, row);
            }
            this.getView().updateView(MAPPING_ENTRIES);
        }
    }

    private void handleTarPropChange(Map<String, Object> data, int index, DynamicObject row) {
        boolean srcIsEntry = row.getBoolean(SRC_IS_ENTRY);
        boolean tarIsEntryNow = "ENTRIES".equals(data.get("data_type"));
        if (srcIsEntry && tarIsEntryNow) {
            this.remappingByNewTarModel(data, index, row);
        } else {
            if (srcIsEntry) {
                throw new IscBizException(ResManager.loadKDString((String)"\u56e0\u6e90\u5b57\u6bb5\u662f\u5206\u5f55\u7c7b\u578b\uff0c\u76ee\u6807\u5b57\u6bb5\u9700\u9009\u62e9\u5206\u5f55\u7c7b\u578b\u3002", (String)"AutoMappingFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            if (tarIsEntryNow && D.s((Object)row.get(SRC_COLUMN)) != null) {
                throw new IscBizException(ResManager.loadKDString((String)"\u56e0\u6e90\u5b57\u6bb5\u4e0d\u662f\u5206\u5f55\u7c7b\u578b\uff0c\u76ee\u6807\u5b57\u6bb5\u4e0d\u80fd\u9009\u62e9\u5206\u5f55\u7c7b\u578b\u3002", (String)"AutoMappingFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            this.resetTarColumns(data, index, row);
        }
    }

    private void remappingByNewTarModel(Map<String, Object> data, int index, DynamicObject row) {
        long srcModelId = row.getLong(SRC_MODEL);
        long dataTargetId = D.l((Object)this.getModel().getValue(DATA_TARGET_ID));
        long tarModelId = PropertyUtil.getMetaIdByNumber((long)dataTargetId, (String)D.s((Object)data.get("data_schema")));
        String algorithm = D.s((Object)this.getModel().getValue(ALGORITHM));
        String s = D.s((Object)this.getModel().getValue(RATIO));
        double ratio = s == null ? 0.5 : Double.parseDouble(s);
        String oldTarNamePrefix = row.getString(MAPPING_TAR_COLUMN) + ".";
        this.resetTarColumns(data, index, row);
        String srcNamePrefix = row.getString(MAPPING_SRC_COLUMN) + ".";
        String srcLabelPrefix = row.getString(SRC_DETAILED_LABEL) + ".";
        String tarNamePrefix = row.getString(MAPPING_TAR_COLUMN) + ".";
        String tarLabelPrefix = row.getString(TAR_DETAILED_LABEL) + ".";
        List mappingItems = new AutoMapProcess(srcModelId, tarModelId, srcNamePrefix, srcLabelPrefix, tarNamePrefix, tarLabelPrefix, algorithm, ratio).handle();
        DynamicObjectCollection mappingEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection(MAPPING_ENTRIES);
        mappingEntries.removeIf(e -> e.getString(MAPPING_TAR_COLUMN).startsWith(oldTarNamePrefix));
        this.addEntry(row.getLong("id"), mappingEntries, mappingItems);
    }

    private void handleSrcPropChange(Map<String, Object> data, int index, DynamicObject row) {
        boolean tarIsEntry = row.getBoolean(TAR_IS_ENTRY);
        boolean srcIsEntryNow = "ENTRIES".equals(data.get("data_type"));
        if (tarIsEntry && srcIsEntryNow) {
            this.remappingRowByNewSrcModel(data, index, row);
        } else {
            if (tarIsEntry) {
                throw new IscBizException(ResManager.loadKDString((String)"\u56e0\u76ee\u6807\u5b57\u6bb5\u662f\u5206\u5f55\u7c7b\u578b\uff0c\u6e90\u5b57\u6bb5\u9700\u9009\u62e9\u5206\u5f55\u7c7b\u578b\u3002", (String)"AutoMappingFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            if (srcIsEntryNow && D.s((Object)row.get(TAR_COLUMN)) != null) {
                throw new IscBizException(ResManager.loadKDString((String)"\u56e0\u76ee\u6807\u5b57\u6bb5\u4e0d\u662f\u5206\u5f55\u7c7b\u578b\uff0c\u6e90\u5b57\u6bb5\u4e0d\u80fd\u9009\u62e9\u5206\u5f55\u7c7b\u578b\u3002", (String)"AutoMappingFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
            this.resetSrcColumns(data, index, row);
        }
    }

    private void remappingRowByNewSrcModel(Map<String, Object> data, int index, DynamicObject row) {
        long tarModelId = row.getLong(TAR_MODEL);
        long dataSourceId = D.l((Object)this.getModel().getValue(DATA_SOURCE_ID));
        long srcModelId = PropertyUtil.getMetaIdByNumber((long)dataSourceId, (String)D.s((Object)data.get("data_schema")));
        String algorithm = D.s((Object)this.getModel().getValue(ALGORITHM));
        String s = D.s((Object)this.getModel().getValue(RATIO));
        double ratio = s == null ? 0.5 : Double.parseDouble(s);
        this.resetSrcColumns(data, index, row);
        String srcNamePrefix = row.getString(MAPPING_SRC_COLUMN) + ".";
        String srcLabelPrefix = row.getString(SRC_DETAILED_LABEL) + ".";
        String tarNamePrefix = row.getString(MAPPING_TAR_COLUMN) + ".";
        String tarLabelPrefix = row.getString(TAR_DETAILED_LABEL) + ".";
        List mappingItems = new AutoMapProcess(srcModelId, tarModelId, srcNamePrefix, srcLabelPrefix, tarNamePrefix, tarLabelPrefix, algorithm, ratio).handle();
        DynamicObjectCollection mappingEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection(MAPPING_ENTRIES);
        mappingEntries.removeIf(e -> e.getString(MAPPING_TAR_COLUMN).startsWith(tarNamePrefix));
        this.addEntry(row.getLong("id"), mappingEntries, mappingItems);
    }

    private void resetTarColumns(Map<String, Object> data, int index, DynamicObject row) {
        this.resetTarColumns(D.s((Object)data.get("full_number")), D.s((Object)data.get("full_name")), D.s((Object)data.get("data_type")), D.s((Object)data.get("data_schema")), index, row);
    }

    private void resetTarColumns(String number, String label, String dataType, String dataSchema, int index, DynamicObject row) {
        String detailedLabel;
        String fullnumber;
        DynamicObjectCollection mappingEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection(MAPPING_ENTRIES);
        DynamicObject parentEntry = this.findEntryById(row.getLong("pid"), mappingEntries);
        if (parentEntry != null) {
            fullnumber = parentEntry.getString(MAPPING_TAR_COLUMN) + "." + number;
            detailedLabel = parentEntry.getString(TAR_DETAILED_LABEL) + "." + label;
        } else {
            fullnumber = number;
            detailedLabel = label;
        }
        row.set(TAR_COLUMN, (Object)number);
        row.set(TAR_LABEL, (Object)label);
        row.set(MAPPING_TAR_COLUMN, (Object)fullnumber);
        row.set(TAR_DETAILED_LABEL, (Object)detailedLabel);
        row.set(TAR_DESC, (Object)(detailedLabel + " - " + dataType));
        boolean tarIsEntry = "ENTRIES".equals(dataType);
        row.set(TAR_IS_ENTRY, (Object)tarIsEntry);
        this.setTarModel(dataSchema, row, tarIsEntry);
        row.set(SIMILAR, null);
        mappingEntries.set(index, (Object)row);
    }

    private void setTarModel(String dataSchema, DynamicObject row, boolean tarIsEntry) {
        if (tarIsEntry) {
            long dataTargetId = D.l((Object)this.getModel().getValue(DATA_TARGET_ID));
            row.set(TAR_MODEL, (Object)PropertyUtil.getMetaIdByNumber((long)dataTargetId, (String)dataSchema));
        } else {
            row.set(TAR_MODEL, null);
        }
    }

    private void resetSrcColumns(String number, String label, String dataType, String dataSchema, int index, DynamicObject row) {
        String detailedLabel;
        String fullnumber;
        DynamicObjectCollection mappingEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection(MAPPING_ENTRIES);
        DynamicObject parentEntry = this.findEntryById(row.getLong("pid"), mappingEntries);
        if (parentEntry != null) {
            fullnumber = parentEntry.getString(MAPPING_SRC_COLUMN) + "." + number;
            detailedLabel = parentEntry.getString(SRC_DETAILED_LABEL) + "." + label;
        } else {
            fullnumber = number;
            detailedLabel = label;
        }
        row.set(SRC_COLUMN, (Object)number);
        row.set(SRC_LABEL, (Object)label);
        row.set(MAPPING_SRC_COLUMN, (Object)fullnumber);
        row.set(SRC_DETAILED_LABEL, (Object)detailedLabel);
        row.set(SRC_DESC, (Object)(detailedLabel + " - " + dataType));
        boolean srcIsEntry = "ENTRIES".equals(dataType);
        row.set(SRC_IS_ENTRY, (Object)srcIsEntry);
        this.setSrcModel(dataSchema, row, srcIsEntry);
        row.set(SIMILAR, null);
        mappingEntries.set(index, (Object)row);
    }

    private void setSrcModel(String dataSchema, DynamicObject row, boolean srcIsEntry) {
        if (srcIsEntry) {
            long dataSourceId = D.l((Object)this.getModel().getValue(DATA_SOURCE_ID));
            row.set(SRC_MODEL, (Object)PropertyUtil.getMetaIdByNumber((long)dataSourceId, (String)dataSchema));
        } else {
            row.set(SRC_MODEL, null);
        }
    }

    private void resetSrcColumns(Map<String, Object> data, int index, DynamicObject row) {
        this.resetSrcColumns(D.s((Object)data.get("full_number")), D.s((Object)data.get("full_name")), D.s((Object)data.get("data_type")), D.s((Object)data.get("data_schema")), index, row);
    }

    private DynamicObject findEntryById(long id, DynamicObjectCollection entries) {
        if (id > 0L) {
            for (DynamicObject entry : entries) {
                if (id != entry.getLong("id")) continue;
                return entry;
            }
        }
        return null;
    }
}

